/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.fromplugin.web.otapplybill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OtImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(OtImportPlugin.class);

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            IFormView formView = (IFormView)view.get(ctx);
            formView.setEnable(Boolean.FALSE, new String[]{"radiofield1", "radiofield2"});
            ctx.addOption("appid", (Object)formView.getFormShowParameter().getAppId());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.warn("OtImportPlugin setContext error={}", (Object)e.getMessage());
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        for (ImportBillData billdata : billdatas) {
            JSONObject data = billdata.getData();
            if (data == null) continue;
            String otApplyTypeName = data.getString("otapplytype");
            otApplyTypeName = otApplyTypeName == null ? "" : otApplyTypeName.trim();
            this.cleanDataByOtApplyType(data, this.getOtApplyType(billdata, otApplyTypeName.trim()));
        }
        super.beforeSave(billdatas, logger);
    }

    private void cleanDataByOtApplyType(JSONObject data, String otApplyType) {
        if (data == null) {
            return;
        }
        if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SC.getNum())) {
            Set<Integer> sdIndex = this.getEntryRowIndex(data, OtApplyTypeEnum.OT_SD);
            Set<Integer> scIndex = this.getEntryRowIndex(data, OtApplyTypeEnum.OT_SC);
            sdIndex.removeAll(scIndex);
            this.suppleNullEntry(data, OtApplyTypeEnum.OT_SC, sdIndex);
            data.remove((Object)OtApplyTypeEnum.OT_SD.getCode());
        } else if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SD.getNum())) {
            Set<Integer> scIndex = this.getEntryRowIndex(data, OtApplyTypeEnum.OT_SC);
            Set<Integer> sdIndex = this.getEntryRowIndex(data, OtApplyTypeEnum.OT_SD);
            scIndex.removeAll(sdIndex);
            this.suppleNullEntry(data, OtApplyTypeEnum.OT_SD, scIndex);
            data.remove((Object)OtApplyTypeEnum.OT_SC.getCode());
        }
    }

    private void suppleNullEntry(JSONObject data, OtApplyTypeEnum otApplyTypeEnum, Set<Integer> needSuppleData) {
        JSONArray jsonArray = (JSONArray)data.get((Object)otApplyTypeEnum.getCode());
        if (jsonArray == null) {
            jsonArray = new JSONArray();
            data.put(otApplyTypeEnum.getCode(), (Object)jsonArray);
        }
        for (Integer needSuppleDatum : needSuppleData) {
            JSONObject entryData = new JSONObject();
            entryData.put("rowNum", (Object)needSuppleDatum);
            jsonArray.add((Object)entryData);
        }
    }

    private Set<Integer> getEntryRowIndex(JSONObject data, OtApplyTypeEnum otApplyTypeEnum) {
        HashSet<Integer> result = new HashSet<Integer>(16);
        JSONArray jsonArray = (JSONArray)data.get((Object)otApplyTypeEnum.getCode());
        if (jsonArray != null) {
            for (Object jsonObject : jsonArray) {
                Integer rowNum;
                JSONObject entryData = (JSONObject)jsonObject;
                if (entryData == null || (rowNum = entryData.getInteger("rowNum")) == null) continue;
                result.add(rowNum);
            }
        }
        return result;
    }

    private String getOtApplyType(ImportBillData importBillData, String showVal) {
        ImportEntityMapping entityMapping = importBillData.getEntityMapping();
        String applyName = "";
        if (entityMapping == null) {
            return applyName;
        }
        Map cols = entityMapping.getCols();
        if (CollectionUtils.isEmpty((Map)cols)) {
            return applyName;
        }
        ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)cols.get("otapplytype");
        if (colInfo == null) {
            return applyName;
        }
        ComboProp property = (ComboProp)colInfo.getProperty();
        if (property == null) {
            return applyName;
        }
        List comboItems = property.getComboItems();
        if (CollectionUtils.isEmpty((Collection)comboItems)) {
            return applyName;
        }
        for (ValueMapItem comboItem : comboItems) {
            LocaleString name = comboItem.getName();
            if (name == null || !StringUtils.equalsAny((CharSequence)showVal, (CharSequence[])new CharSequence[]{name.getLocaleValue_en(), name.getLocaleValue_zh_CN(), name.getLocaleValue_zh_TW(), name.getLocaleValue()})) continue;
            applyName = comboItem.getValue();
        }
        return applyName;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (CollectionUtils.isEmpty(rowdatas)) {
            return super.save(rowdatas, logger);
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            int failIndex = -1;
            ImportBillData billdata = it.next();
            JSONObject data = billdata.getData();
            if (data == null) continue;
            String tip = null;
            OtApplyTypeEnum otSc = OtApplyTypeEnum.OT_SC;
            if (data.containsKey((Object)otSc.getCode())) {
                JSONArray entryData = (JSONArray)data.get((Object)otSc.getCode());
                if (entryData == null) continue;
                ArrayList<Integer> successIndex = new ArrayList<Integer>(10);
                for (int index = 0; index < entryData.size(); ++index) {
                    int realIndex = billdata.getStartIndex() + index;
                    Object entryDatum = entryData.get(index);
                    String time = (String)((JSONObject)entryDatum).get((Object)"otdtime");
                    if (HRStringUtils.isEmpty((String)time)) continue;
                    Integer otDTime = this.convertOtDTime(time);
                    if (otDTime != null) {
                        ((JSONObject)entryDatum).put("otdtime", (Object)(otDTime + ""));
                        successIndex.add(realIndex);
                        continue;
                    }
                    tip = ResManager.loadKDString((String)"\u7533\u8bf7\u52a0\u73ed\u65f6\u957f\uff1a{0}\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\u3002", (String)"OtImportPlugin_0", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                    String validMsg = MessageFormat.format(tip, time);
                    logger.log(Integer.valueOf(realIndex), validMsg).fail();
                    failIndex = failIndex == -1 ? realIndex : failIndex;
                }
                if (failIndex != -1) {
                    String otherFail = ResManager.loadKDString((String)"\u4e0e\u7b2c{0}\u884c\u5c5e\u4e8e\u540c\u4e00\u52a0\u73ed\u5355\uff0c\u56e0\u7b2c{1}\u884c\u7533\u8bf7\u52a0\u73ed\u65f6\u957f\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u4e0d\u5b58\u5728\uff0c\u8be5\u6570\u636e\u5165\u5e93\u5931\u8d25\u3002", (String)"OtImportPlugin_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]);
                    String otherFailFormat = MessageFormat.format(otherFail, failIndex + 1, failIndex + 1);
                    for (Integer index : successIndex) {
                        logger.log(index, otherFailFormat);
                    }
                }
            }
            if (tip == null) continue;
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private Integer convertOtDTime(String ot) {
        if (HRStringUtils.isEmpty((String)ot)) {
            return null;
        }
        if (!Pattern.matches("[0-2]\\d\\:\\d\\d", ot) && !Pattern.matches("[0-2]\\d\\:\\d\\d\\:\\d\\d", ot)) {
            return null;
        }
        if (Pattern.matches("[0-2]\\d\\:\\d\\d\\:\\d\\d", ot) && !ot.endsWith("00")) {
            return null;
        }
        String[] split = ot.split(":");
        if (split.length < 2) {
            return null;
        }
        BigDecimal splitSec = new BigDecimal(split[1]);
        if (splitSec.compareTo(new BigDecimal("60")) >= 0) {
            return null;
        }
        BigDecimal hour2Min = new BigDecimal(split[0]).multiply(new BigDecimal("60"));
        BigDecimal min = hour2Min.add(splitSec);
        BigDecimal min2Sec = min.multiply(new BigDecimal("60"));
        int secSum = min2Sec.intValue();
        BigDecimal allDateSec = new BigDecimal("60").multiply(new BigDecimal("60")).multiply(new BigDecimal("24"));
        if (new BigDecimal(secSum + "").compareTo(allDateSec) > 0) {
            return null;
        }
        return secSum;
    }
}

