/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.opplugin.web.overworkapply.ot;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.opplugin.web.overworkapply.ot.validator.OtApplyAllValidator;
import kd.wtc.wtom.opplugin.web.overworkapply.ot.validator.OtApplyIntegrityValidator;
import kd.wtc.wtom.opplugin.web.overworkapply.ot.validator.OtApplySingleValidator;

public class OtApplyOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(OtApplyOp.class);
    private Map<Long, AtomicBoolean> pkIdAndContinue = new HashMap<Long, AtomicBoolean>(16);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        MainEntityType billEntityType = this.billEntityType;
        DataEntityPropertyCollection properties = billEntityType.getProperties();
        List fieldList = properties.stream().map(IMetadata::getName).collect(Collectors.toList());
        EntryProp sdProperty = (EntryProp)properties.get((Object)OtApplyTypeEnum.OT_SD.getCode());
        fieldList.addAll(this.getEntryEntityProp(sdProperty));
        EntryProp scProperty = (EntryProp)properties.get((Object)OtApplyTypeEnum.OT_SC.getCode());
        fieldList.addAll(this.getEntryEntityProp(scProperty));
        args.getFieldKeys().addAll(fieldList);
    }

    private List<String> getEntryEntityProp(EntryProp property) {
        if (property == null) {
            return new ArrayList<String>(0);
        }
        IDataEntityType itemType = property.getItemType();
        return itemType.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        Map variables = this.getOption().getVariables();
        OtApplyIntegrityValidator otApplyIntegrityValidator = new OtApplyIntegrityValidator(this.pkIdAndContinue);
        otApplyIntegrityValidator.setSeq(1);
        args.addValidator((AbstractValidator)otApplyIntegrityValidator);
        OtApplyAllValidator otApplyAllValidator = new OtApplyAllValidator(this.pkIdAndContinue, variables);
        otApplyAllValidator.setSeq(2);
        args.addValidator((AbstractValidator)otApplyAllValidator);
        args.addValidator((AbstractValidator)new OtApplySingleValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Date now = new Date();
        long userId = RequestContext.get().getCurrUserId();
        for (DynamicObject dataEntity : dataEntities) {
            this.resetCommitMessage(args.getOperationKey(), dataEntity, now, userId);
            boolean isChange = dataEntity.getBoolean("ischange");
            if (isChange) continue;
            this.cleanDataByOtApplyType(dataEntity);
            this.getOwTypes(dataEntity);
            BigDecimal vaTime = this.getVaTime(dataEntity);
            dataEntity.set("vatime", (Object)vaTime);
            dataEntity.set("vatimetext", (Object)OTBillHelper.getTimeStr((BigDecimal)vaTime));
            DynamicObject personDy = dataEntity.getDynamicObject("personid");
            DynamicObjectCollection scEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            for (DynamicObject scDy : scEntry) {
                scDy.set("derson", (Object)personDy);
            }
            DynamicObjectCollection sdEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
            for (DynamicObject sdDy : sdEntry) {
                sdDy.set("dperson", (Object)personDy);
            }
        }
    }

    private void cleanDataByOtApplyType(DynamicObject dataEntity) {
        if (dataEntity == null) {
            return;
        }
        String otApplyType = dataEntity.getString("otapplytype");
        if (HRStringUtils.isBlank((CharSequence)otApplyType)) {
            return;
        }
        if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SC.getNum())) {
            dataEntity.set(OtApplyTypeEnum.OT_SD.getCode(), null);
        } else if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SD.getNum())) {
            dataEntity.set(OtApplyTypeEnum.OT_SC.getCode(), null);
        }
    }

    private void resetCommitMessage(String operateKey, DynamicObject formEntity, Date now, long userId) {
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"submit", "submiteffect"})) {
            formEntity.set("submitter", (Object)userId);
            formEntity.set("submitdate", (Object)now);
        }
    }

    private BigDecimal getVaTime(DynamicObject billDy) {
        BigDecimal vaTime = BigDecimal.ZERO;
        Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)billDy);
        DynamicObjectCollection entrys = billDy.getDynamicObjectCollection((String)entryInfo.get("ENTRY_NAME"));
        String applyType = billDy.getString("otapplytype");
        for (DynamicObject entryDy : entrys) {
            Date startTime = entryDy.getDate((String)entryInfo.get("START_TIME_NAME"));
            Date endTime = entryDy.getDate((String)entryInfo.get("END_TIME_NAME"));
            logger.info("OtApplyOp.getVaTime startTime = {},endTime = {}");
            if ((startTime == null || endTime == null) && HRStringUtils.equals((String)OtApplyTypeEnum.OT_SC.getNum(), (String)applyType)) {
                logger.info("OtApplyOp.getVaTime off\u73ed\u65e0\u65f6\u6bb5\u65f6\u957f\u7edf\u8ba1");
                Object intTime = entryDy.get("otdtime");
                BigDecimal offVaTime = intTime == null ? BigDecimal.ZERO : BigDecimal.valueOf(((Integer)intTime).intValue());
                offVaTime = offVaTime.multiply(BigDecimal.valueOf(1000L));
                vaTime = vaTime.add(offVaTime);
                continue;
            }
            if (HRStringUtils.equals((String)OtApplyTypeEnum.OT_SC.getNum(), (String)applyType)) {
                Date startDate = this.filterSec(startTime);
                Date endDate = this.filterSec(endTime);
                long startTimeNum = startDate.getTime();
                long endTimeNum = endDate.getTime();
                vaTime = vaTime.add(BigDecimal.valueOf(endTimeNum).subtract(BigDecimal.valueOf(startTimeNum)));
                continue;
            }
            if (!HRStringUtils.equals((String)OtApplyTypeEnum.OT_SD.getNum(), (String)applyType)) continue;
            vaTime = vaTime.add(new BigDecimal(entryDy.getInt("intottime")).multiply(new BigDecimal("1000")));
        }
        logger.info("OtApplyOp.getVaTime intTime = {}", (Object)vaTime.intValue());
        return vaTime;
    }

    private Date filterSec(Date startDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        instance.set(13, 0);
        return instance.getTime();
    }

    private void getOwTypes(DynamicObject billDy) {
        Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)billDy);
        DynamicObjectCollection types = billDy.getDynamicObjectCollection("overworktypes");
        types.clear();
        DynamicObjectCollection entrys = billDy.getDynamicObjectCollection((String)entryInfo.get("ENTRY_NAME"));
        if (CollectionUtils.isEmpty((Collection)entrys)) {
            return;
        }
        for (DynamicObject entry : entrys) {
            DynamicObject type = entry.getDynamicObject((String)entryInfo.get("OT_TYPE_NAME"));
            if (type == null) continue;
            DynamicObject newType = types.addNew();
            newType.set("fbasedataid_id", type.getPkValue());
        }
    }
}

