/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.opplugin.web.overworkapply.ot.validator;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTApplyValidateAndUpdateHelper;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTBillVerifyAllHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OtUnUsedInfo;

public class OtApplyAllValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillUnifyService.class);
    private Map<Long, AtomicBoolean> pkIdAndContinueProcess;
    private final List<Map<Long, BillCheckResult>> allErrorInfo = new ArrayList<Map<Long, BillCheckResult>>(10);
    private final Map<String, String> variables;

    public OtApplyAllValidator(Map<Long, AtomicBoolean> pkIdAndContinueProcess, Map<String, String> variables) {
        this.pkIdAndContinueProcess = pkIdAndContinueProcess;
        if (this.pkIdAndContinueProcess == null) {
            this.pkIdAndContinueProcess = new HashMap<Long, AtomicBoolean>();
        }
        this.variables = variables;
    }

    public void validate() {
        this.validateProcess();
        boolean isImport = this.isImport();
        if (isImport) {
            this.supplementImportError();
        }
        HashMap afterGroup = Maps.newHashMapWithExpectedSize((int)10);
        for (Map<Long, BillCheckResult> resultMap : this.allErrorInfo) {
            for (Map.Entry<Long, BillCheckResult> billIdAndInfo : resultMap.entrySet()) {
                Long billId = billIdAndInfo.getKey();
                BillCheckResult failInfo = billIdAndInfo.getValue();
                BillCheckResult result = (BillCheckResult)afterGroup.get(billId);
                if (result == null && failInfo != null) {
                    afterGroup.put(billId, failInfo);
                    continue;
                }
                BillCheckResult afterMergeResult = OTApplyBillAssemblyResultService.mergeBillCheckResult((BillCheckResult[])new BillCheckResult[]{result, failInfo});
                afterGroup.put(billId, afterMergeResult);
            }
        }
        this.outputResultByJoinStr(afterGroup);
    }

    private void supplementImportError() {
        HashMap<Long, Set> pkIdAndFailIndex = new HashMap<Long, Set>(16);
        for (Map<Long, BillCheckResult> resultMap : this.allErrorInfo) {
            for (Map.Entry<Long, BillCheckResult> idAndResult : resultMap.entrySet()) {
                Long id = idAndResult.getKey();
                BillCheckResult billCheckResult = idAndResult.getValue();
                Set errorIndex = pkIdAndFailIndex.computeIfAbsent(id, key -> new HashSet(16));
                if (billCheckResult.isVerifyResult()) continue;
                errorIndex.addAll(billCheckResult.getFailEntryIndexList());
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long pkId = dataEntity.getDataEntity().getLong("id");
            Set failIndex = (Set)pkIdAndFailIndex.get(pkId);
            if (CollectionUtils.isEmpty((Collection)failIndex)) continue;
            this.allErrorInfo.addAll(this.supplementImportErrorForOne(dataEntity, failIndex));
        }
    }

    private List<Map<Long, BillCheckResult>> supplementImportErrorForOne(ExtendedDataEntity dataEntity, Set<Integer> failIndex) {
        ArrayList<Map<Long, BillCheckResult>> result = new ArrayList<Map<Long, BillCheckResult>>(10);
        long pkId = dataEntity.getDataEntity().getLong("id");
        int scSize = dataEntity.getDataEntity().getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode()).size();
        int sdSize = dataEntity.getDataEntity().getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode()).size();
        int returnSize = Math.max(scSize, sdSize);
        for (int i = 0; i < returnSize; ++i) {
            if (failIndex.contains(i)) continue;
            HashMap<Long, BillCheckResult> resultMap = new HashMap<Long, BillCheckResult>(16);
            String tip = ResManager.loadKDString((String)"\u5206\u5f55{0}\u884c\uff1a\u56e0\u5176\u4ed6\u5206\u5f55\u5bfc\u5165\u5931\u8d25\u3002", (String)"OtApplyAllValidator_3", (String)"wtc-wtom-opplugin", (Object[])new Object[0]);
            resultMap.put(pkId, BillCheckResult.fail((Integer)i, (String)MessageFormat.format(tip, i + 1), (String)OTCheckTypeEnum.FAIL_BY_OTHER_DATA.getCheckType()));
            result.add(resultMap);
        }
        return result;
    }

    private void outputResultByJoinStr(Map<Long, BillCheckResult> afterGroup) {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            BillCheckResult billCheckResult = afterGroup.get(dataEntity.getDataEntity().getLong("id"));
            if (billCheckResult == null || billCheckResult.isVerifyResult()) continue;
            List msg = billCheckResult.getMsg();
            for (String errorInfo : msg) {
                this.addErrorMessage(dataEntity, errorInfo);
            }
        }
    }

    public void validateProcess() {
        HashMap<Long, OtUnUsedInfo> pkIdAndUnCheckInfo = new HashMap<Long, OtUnUsedInfo>(16);
        String attFileF7AuthEntity = "";
        if (this.getDataEntities().length > 0) {
            attFileF7AuthEntity = this.getDataEntities()[0].getDataEntity().getDataEntityType().getName();
        }
        ArrayList billDyList = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 0; i < this.getDataEntities().length; ++i) {
            Long billPkId;
            AtomicBoolean atomicBoolean;
            DynamicObject billDy = this.getDataEntities()[i].getDataEntity();
            boolean isChange = billDy.getBoolean("ischange");
            if (isChange || (atomicBoolean = this.pkIdAndContinueProcess.get(billPkId = (Long)this.getDataEntities()[i].getBillPkId())) != null && !atomicBoolean.get()) continue;
            billDyList.add(billDy);
        }
        DynamicObject[] billArr = billDyList.toArray(new DynamicObject[0]);
        OTApplyValidateAndUpdateHelper.initId((DynamicObject[])billArr);
        OTApplyValidateAndUpdateHelper.updateTimeToZeroSec((DynamicObject[])billArr);
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        String appId = BillCommonService.getInstance().getAppIdFromOp(this.getOption());
        logger.info("OtApplyAllValidator_validateProcess appId = {}", (Object)appId);
        attr.setAttFileF7AuthAppId(appId);
        attr.setAttFileF7AuthEntity(attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        OTBillVerifyAllHelper billHelper = new OTBillVerifyAllHelper(billArr, Collections.emptyList(), attr);
        Map beforeDutyCheckMap = billHelper.checkBeforeDutyDate(false, pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(beforeDutyCheckMap, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess beforeDutyCheckMap = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)beforeDutyCheckMap), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        OTApplyValidateAndUpdateHelper.updateDutyInfo((DynamicObject[])billArr, (OTBillHelper)billHelper, pkIdAndUnCheckInfo);
        this.validateAndUpdateTimeInfo(billArr, attr, pkIdAndUnCheckInfo);
        Map beforeRuleInfo = billHelper.checkBeforeBaseInfo(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(beforeRuleInfo, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess beforeRuleInfo = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)beforeRuleInfo), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        Map afterRuleInfo = billHelper.checkAfterBaseInfo(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(afterRuleInfo, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess afterRuleInfo = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)afterRuleInfo), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        Map dataRangeResult = billHelper.checkDateRange(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(dataRangeResult, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess dataRangeResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)dataRangeResult), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        boolean isImport = this.isImport();
        logger.info("OtApplyAllValidator_validateProcess isImport = {} ", (Object)isImport);
        Map compendResult = OTApplyValidateAndUpdateHelper.updateCompensate((DynamicObject[])billArr, (OTBillHelper)billHelper, (!isImport ? 1 : 0) != 0, pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(compendResult, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess compendResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)compendResult), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        if (this.variables != null && !isImport) {
            boolean isFromList = HRStringUtils.equals((String)this.variables.get("LIST_OP"), (String)"LIST_OP_TRUE");
            String billAttachmentStr = this.variables.get("wtc_bill_attachment");
            List billAttachments = null;
            if (HRStringUtils.isNotEmpty((String)billAttachmentStr)) {
                billAttachments = SerializationUtils.fromJsonStringToList((String)billAttachmentStr, Map.class);
            }
            this.saveFailReasonAndFailData(billHelper.checkAttachmentFile(isFromList, billAttachments), pkIdAndUnCheckInfo);
        }
    }

    private void validateAndUpdateTimeInfo(DynamicObject[] billDys, UnifyBillApplyAttr attr, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        boolean isImport = false;
        if (this.getOption().containsVariable("importtag_of_datasource")) {
            isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getOption().getVariableValue("importtag_of_datasource"));
        }
        OTBillVerifyAllHelper timeBucketCheckHelper = new OTBillVerifyAllHelper(billDys, Collections.emptyList(), attr);
        Map timeBucket = timeBucketCheckHelper.checkAllTimeBucket(!isImport, unCheckInfoMap);
        this.saveFailReasonAndFailData(timeBucket, unCheckInfoMap);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess timeBucket = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)timeBucket), (Object)JSON.toJSONString(unCheckInfoMap));
        }
        OTApplyValidateAndUpdateHelper.updateOtBucket((DynamicObject[])billDys, (OTBillHelper)timeBucketCheckHelper, unCheckInfoMap, (!isImport ? 1 : 0) != 0);
        OTBillVerifyAllHelper timeCheckHelper = new OTBillVerifyAllHelper(billDys, Collections.emptyList(), attr);
        Map timeResult = timeCheckHelper.checkAllTime(!isImport, unCheckInfoMap);
        this.saveFailReasonAndFailData(timeResult, unCheckInfoMap);
        if (logger.isDebugEnabled()) {
            logger.debug("OtApplyAllValidator_validateProcess timeResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString((Object)timeResult), (Object)JSON.toJSONString(unCheckInfoMap));
        }
    }

    private void saveFailReasonAndFailData(Map<Long, BillCheckResult> checkResultMap, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        if (CollectionUtils.isEmpty(checkResultMap)) {
            return;
        }
        this.allErrorInfo.add(checkResultMap);
        for (Map.Entry<Long, BillCheckResult> checkResult : checkResultMap.entrySet()) {
            Set failEntryIndexList;
            Long billId = checkResult.getKey();
            OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.computeIfAbsent(billId, key -> new OtUnUsedInfo());
            BillCheckResult value = checkResult.getValue();
            if (value == null || value.isVerifyResult() || CollectionUtils.isEmpty((Collection)(failEntryIndexList = value.getFailEntryIndexList()))) continue;
            if (otUnUsedInfo.isNeedCheck() && failEntryIndexList.contains(-1)) {
                otUnUsedInfo.setNeedCheck(false);
            }
            for (Integer failIndex : failEntryIndexList) {
                if (failIndex == -1) continue;
                otUnUsedInfo.getUnCheckIndex().add(failIndex);
            }
        }
    }

    private boolean isImport() {
        boolean isImport = false;
        if (this.getOption().containsVariable("importtag_of_datasource")) {
            isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getOption().getVariableValue("importtag_of_datasource"));
        }
        return isImport;
    }
}

