/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.opplugin.web.overworkapply.ot.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.common.enums.ApplyBillCheckMsgEnum;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OtApplyIntegrityValidator
extends AbstractValidator {
    private Map<Long, AtomicBoolean> pkIdAndInterrupt;

    private Map<String, String> getScEntryMustInput(DynamicObject checkDy) {
        boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(checkDy);
        HashMap<String, String> scEntryMustInput = new HashMap<String, String>(16);
        if (openSingleStyle) {
            scEntryMustInput.put("scottype", ApplyBillCheckMsgEnum.EMPTYTYPE_SINGLE.getMsg());
            scEntryMustInput.put("otdate", ApplyBillCheckMsgEnum.EMPTYDATE_SINGLE.getMsg());
            scEntryMustInput.put("otdtime", ApplyBillCheckMsgEnum.EMPTYOTDTIME_SINGLE.getMsg());
        } else {
            scEntryMustInput.put("scottype", ApplyBillCheckMsgEnum.EMPTYTYPE.getMsg());
            scEntryMustInput.put("otdate", ApplyBillCheckMsgEnum.EMPTYDATE.getMsg());
            scEntryMustInput.put("otdtime", ApplyBillCheckMsgEnum.EMPTYOTDTIME.getMsg());
        }
        return scEntryMustInput;
    }

    private Map<String, String> getSdEntryMustInput(DynamicObject checkDy) {
        boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(checkDy);
        HashMap<String, String> sdEntryMustInput = new HashMap<String, String>(16);
        if (openSingleStyle) {
            sdEntryMustInput.put("sdottype", ApplyBillCheckMsgEnum.EMPTYTYPE_SINGLE.getMsg());
            sdEntryMustInput.put("otstartdate", ApplyBillCheckMsgEnum.EMPTYSTARTTIME_SINGLE.getMsg());
            sdEntryMustInput.put("otenddate", ApplyBillCheckMsgEnum.EMPTYENDTIME_SINGLE.getMsg());
        } else {
            sdEntryMustInput.put("sdottype", ApplyBillCheckMsgEnum.EMPTYTYPE.getMsg());
            sdEntryMustInput.put("otstartdate", ApplyBillCheckMsgEnum.EMPTYSTARTTIME.getMsg());
            sdEntryMustInput.put("otenddate", ApplyBillCheckMsgEnum.EMPTYENDTIME.getMsg());
        }
        return sdEntryMustInput;
    }

    public OtApplyIntegrityValidator(Map<Long, AtomicBoolean> pkIdAndInterrupt) {
        this.pkIdAndInterrupt = pkIdAndInterrupt;
        if (this.pkIdAndInterrupt == null) {
            this.pkIdAndInterrupt = new HashMap<Long, AtomicBoolean>(16);
        }
    }

    public void validate() {
        Map discardAttFileBoIdMap = BillCommonService.getInstance().getDiscardAttFileBoId(this.getDataEntities());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String attFileNumber;
            DynamicObject billDy = dataEntity.getDataEntity();
            DynamicObject attFile = billDy.getDynamicObject("attfile");
            if (attFile != null && HRStringUtils.isNotEmpty((String)(attFileNumber = (String)discardAttFileBoIdMap.get(attFile.getLong("id"))))) {
                this.addErrorMessage(dataEntity, BillUnifyKDStringHelper.notEffAttFile((String)BillTypeEnum.OVERTIMEBILL.getBillName(), (String)attFileNumber));
                this.setFalseInfo(dataEntity);
                continue;
            }
            boolean isChange = billDy.getBoolean("ischange");
            if (isChange) continue;
            Map entryInfo = OTApplyBillAssemblyResultService.getEntryInfo((DynamicObject)billDy);
            DynamicObjectCollection entry = billDy.getDynamicObjectCollection((String)entryInfo.get("ENTRY_NAME"));
            if (CollectionUtils.isEmpty((Collection)entry)) {
                if (OtApplyTypeEnum.OT_SC.getNum().equals(dataEntity.getValue("otapplytype"))) {
                    this.addErrorMessage(dataEntity, ApplyBillCheckMsgEnum.NOOTINFO_SC.getMsg());
                } else {
                    this.addErrorMessage(dataEntity, ApplyBillCheckMsgEnum.NOOTINFO_SD.getMsg());
                }
                this.setFalseInfo(dataEntity);
            }
            for (int i = 0; i < entry.size(); ++i) {
                this.entryFieldMustInput(dataEntity, (DynamicObject)entry.get(i), i + 1);
            }
        }
    }

    private void entryFieldMustInput(ExtendedDataEntity dataEntity, DynamicObject entryDy, Integer index) {
        if (OtApplyTypeEnum.OT_SC.getNum().equals(dataEntity.getValue("otapplytype"))) {
            this.checkEntryFieldMustInput(dataEntity, entryDy, this.getScEntryMustInput(dataEntity.getDataEntity()), index);
        } else {
            this.checkEntryFieldMustInput(dataEntity, entryDy, this.getSdEntryMustInput(dataEntity.getDataEntity()), index);
        }
    }

    private void checkEntryFieldMustInput(ExtendedDataEntity dataEntity, DynamicObject entryDy, Map<String, String> fieldKeyAndInfo, Integer index) {
        boolean isImport = false;
        if (this.getOption().containsVariable("importtag_of_datasource")) {
            isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.getOption().getVariableValue("importtag_of_datasource"));
        }
        for (Map.Entry<String, String> entry : fieldKeyAndInfo.entrySet()) {
            Object value = entryDy.get(entry.getKey());
            String key = entry.getKey();
            String msg = MessageFormat.format(entry.getValue(), index);
            if (HRStringUtils.equals((String)"otdtime", (String)key) && Integer.valueOf(-1).equals(value)) {
                if (isImport) {
                    this.addErrorMessage(dataEntity, msg);
                }
                this.setFalseInfo(dataEntity);
            }
            if (value != null) continue;
            if (isImport) {
                this.addErrorMessage(dataEntity, msg);
            }
            this.setFalseInfo(dataEntity);
        }
    }

    private void setFalseInfo(ExtendedDataEntity dataEntity) {
        Long pkId = (Long)dataEntity.getDataEntity().getPkValue();
        AtomicBoolean atomicBoolean = this.pkIdAndInterrupt.get(pkId);
        if (atomicBoolean == null) {
            atomicBoolean = new AtomicBoolean();
        }
        atomicBoolean.set(false);
        this.pkIdAndInterrupt.put(pkId, atomicBoolean);
    }
}

