/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtom.business.validate.OtBillValidateErrorInfo;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucketResult;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeRepeated;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.service.AdvanceAfterValidateUtil;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.business.web.billservice.baseset.BillBaseStateLessService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckMsgEnum;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterEnum;
import kd.wtc.wtbs.common.enums.bill.BillAdvanceAfterFieldEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.overwork.OtTimeBucketResultEnum;
import kd.wtc.wtbs.common.model.TimeInterval;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyAdvanceAndAfterDetail;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAdvanceAfterInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyServiceEntryInitInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillAttachmentInfo;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillInfoContext;
import kd.wtc.wtbs.common.model.billservice.BillPeriodInfoResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceAdvAfterResp;
import kd.wtc.wtbs.common.model.billservice.BillServiceBaseNewSetInfo;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtabm.common.entity.VaValidateTimeRspModel;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.business.OtHandleShiftHelper;
import kd.wtc.wtom.business.check.OtCalculateBucketReqInfo;
import kd.wtc.wtom.business.check.OtCalculateRepeatReqInfo;
import kd.wtc.wtom.business.check.OtCalculateTwentyFourReqInfo;
import kd.wtc.wtom.business.check.OtTimeBucketService;
import kd.wtc.wtom.business.check.OtTimeRepeatedService;
import kd.wtc.wtom.business.check.TwentyFourCheck;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.business.unifybill.operatecore.OTApplyBillOperator;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.constants.TimeUnitEnum;
import kd.wtc.wtom.common.model.otapply.AttFileDutyDateShift;
import kd.wtc.wtom.common.model.otapply.OTBillServiceResult;
import kd.wtc.wtom.common.model.otapply.OverTwentyFourVo;

public class OTApplyBillAssemblyResultService {
    private static final Log logger = LogFactory.getLog(OTApplyBillAssemblyResultService.class);
    private DynamicObject[] billDys;
    private OTApplyBillOperator otApplyBillOperator;
    private DynamicObject checkingBillDy;
    private String checkingOtApplyType;
    private Integer checkingShowIndex;
    private DynamicObject checkingEntryDy;
    private Date checkQueryStartTime;
    private Date checkQueryEndTime;
    private String checkingTimeInfo;
    private Long needCheckBucketId = -1L;
    private Long needCheck24Id = -1L;
    private Long needCheckRepeatId = -1L;
    private List<OtTimeBucketResult> otTimeBucketResult;
    private List<OverTwentyFourVo> belongAndPersonDuration;
    private Map<Long, List<OtTimeRepeated>> respectBill;
    private List<BillServiceAdvAfterResp> maxLimitInfo;
    private Map<Long, List<VaValidateTimeRspModel>> vaInfoMap;
    private OTApplyBillInitData applyBillInitDataContext;
    private static final int SEC_IN_MIN = 60;
    private static final int SEC_IN_HOUR = 3600;
    public static final String ENTRY_NAME = "ENTRY_NAME";
    public static final String OT_TYPE_NAME = "OT_TYPE_NAME";
    public static final String START_TIME_NAME = "START_TIME_NAME";
    public static final String END_TIME_NAME = "END_TIME_NAME";
    public static final String DUTY_DAY_NAME = "DUTY_DAY_NAME";
    public static final String COMPENSATE_NAME = "COMPENSATE_NAME";
    public static final String OT_TIME_NAME = "OT_TIME_NAME";
    public static final BigDecimal DAY_MILLISECOND = BigDecimal.valueOf(86400000L);
    public static final BigDecimal DAY_SECOND = BigDecimal.valueOf(86400L);

    @Deprecated
    public OTApplyBillAssemblyResultService(DynamicObject[] billDys, String attFileF7AuthEntity) {
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId("wtam");
        attr.setAttFileF7AuthEntity(attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        this.init(billDys, attr);
    }

    public OTApplyBillAssemblyResultService(DynamicObject[] billDys, UnifyBillApplyAttr attr) {
        this.init(billDys, attr);
    }

    private void init(DynamicObject[] billDys, UnifyBillApplyAttr attr) {
        ArrayList initInfos = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject billDy : billDys) {
            initInfos.add(this.getTimePairInfo(billDy, null));
        }
        UnifyBillInfoContext context = new UnifyBillInfoContext((List)initInfos, attr);
        this.otApplyBillOperator = new OTApplyBillOperator(context, Lists.newArrayList((Object[])billDys));
        this.billDys = billDys;
    }

    @Deprecated
    public OTApplyBillAssemblyResultService(DynamicObject billDy, Integer checkIndex, String attFileF7AuthEntity) {
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId("wtam");
        attr.setAttFileF7AuthEntity(attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        this.initEntryData(billDy, checkIndex, attr);
    }

    public OTApplyBillAssemblyResultService(DynamicObject billDy, Integer checkIndex, UnifyBillApplyAttr applyAttr) {
        this.initEntryData(billDy, checkIndex, applyAttr);
    }

    private void initEntryData(DynamicObject billDy, Integer checkIndex, UnifyBillApplyAttr applyAttr) {
        this.checkingOtApplyType = billDy.getString("otapplytype");
        this.billDys = new DynamicObject[]{billDy};
        ArrayList initInfos = Lists.newArrayListWithExpectedSize((int)10);
        initInfos.add(this.getTimePairInfo(billDy, checkIndex));
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        attr.setAttFileF7AuthAppId("wtam");
        attr.setAttFileAuthField("attfilebasef7");
        UnifyBillInfoContext context = new UnifyBillInfoContext((List)initInfos, applyAttr);
        this.otApplyBillOperator = new OTApplyBillOperator(context, Lists.newArrayList((Object[])new DynamicObject[]{billDy}));
        this.billDys = new DynamicObject[]{billDy};
    }

    private void initCheckingInfo(DynamicObject billDy, Integer checkIndex) {
        String applyType = billDy.getString("otapplytype");
        this.checkingBillDy = billDy;
        this.checkingOtApplyType = applyType;
        if (checkIndex != null) {
            DynamicObject entryDy;
            this.checkingShowIndex = checkIndex + 1;
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
            this.checkingEntryDy = entryDy = (DynamicObject)billDy.getDynamicObjectCollection(entryInfo.get(ENTRY_NAME)).get(checkIndex.intValue());
            Tuple<Date, Date> initStartTimeAndEndTime = this.getContextStartTimeAndEndTime(entryDy, applyType);
            if (initStartTimeAndEndTime == null) {
                return;
            }
            this.checkQueryStartTime = (Date)initStartTimeAndEndTime.item1;
            this.checkQueryEndTime = (Date)initStartTimeAndEndTime.item2;
            if (this.checkQueryStartTime != null && this.checkQueryEndTime != null) {
                String end;
                String start = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)this.checkQueryStartTime);
                this.checkingTimeInfo = HRStringUtils.equals((String)start, (String)(end = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)this.checkQueryEndTime))) ? start : start + OTKdStringHelper.to() + end;
            }
        }
    }

    public static BillCheckResult mergeBillCheckResult(BillCheckResult ... billCheckResults) {
        BillCheckResult all = BillCheckResult.success();
        TreeMap<Integer, List> failEnumAndReasonMap = new TreeMap<Integer, List>();
        for (BillCheckResult checkResult : billCheckResults) {
            if (checkResult == null || checkResult.isVerifyResult()) continue;
            all.setVerifyResult(false);
            TreeMap indexAndFailMap = checkResult.getFailEnumAndReasonMap();
            if (indexAndFailMap == null || indexAndFailMap.size() == 0) continue;
            for (Map.Entry indexAndFail : indexAndFailMap.entrySet()) {
                Integer index = (Integer)indexAndFail.getKey();
                List needMergeFailInfoList = (List)indexAndFail.getValue();
                List allFailInfoList = failEnumAndReasonMap.computeIfAbsent(index, k -> new ArrayList(10));
                for (OtBillValidateErrorInfo otBillValidateErrorInfo : needMergeFailInfoList) {
                    List mergeFail = otBillValidateErrorInfo.getFailReasonList();
                    mergeFail.removeIf(HRStringUtils::isEmpty);
                    String checkCode = otBillValidateErrorInfo.getFailCode();
                    if (HRStringUtils.isEmpty((String)checkCode) || WTCCollections.isEmpty((Collection)mergeFail)) continue;
                    List<String> allFail = OTApplyBillAssemblyResultService.getFailReasonAndInit(allFailInfoList, checkCode);
                    allFail.addAll(mergeFail);
                }
            }
        }
        all.setFailEnumAndReasonMap(failEnumAndReasonMap);
        OTApplyBillAssemblyResultService.handleFailInfoMap(all);
        return all;
    }

    private static void handleFailInfoMap(BillCheckResult all) {
        if (all == null) {
            return;
        }
        TreeMap failInfoMap = new TreeMap();
        if (WTCCollections.isEmpty((Map)all.getFailEnumAndReasonMap())) {
            all.setFailInfoMap(failInfoMap);
            return;
        }
        for (Map.Entry indexAndFail : all.getFailEnumAndReasonMap().entrySet()) {
            Integer key = (Integer)indexAndFail.getKey();
            ArrayList failReason = new ArrayList(10);
            List value = (List)indexAndFail.getValue();
            if (WTCCollections.isNotEmpty((Collection)value)) {
                for (OtBillValidateErrorInfo otBillValidateErrorInfo : value) {
                    List failReasonList = otBillValidateErrorInfo.getFailReasonList();
                    if (WTCCollections.isEmpty((Collection)failReasonList)) continue;
                    failReasonList.removeIf(HRStringUtils::isEmpty);
                    if (WTCCollections.isEmpty((Collection)failReasonList)) continue;
                    failReason.addAll(failReasonList);
                }
            }
            if (!WTCCollections.isNotEmpty(failReason)) continue;
            failInfoMap.put(key, failReason);
        }
        all.setFailInfoMap(failInfoMap);
    }

    private static List<String> getFailReasonAndInit(List<OtBillValidateErrorInfo> failEnumAndReasonList, String checkCode) {
        if (failEnumAndReasonList == null || HRStringUtils.isEmpty((String)checkCode)) {
            return new ArrayList<String>(10);
        }
        boolean match = false;
        ArrayList failReason = null;
        for (OtBillValidateErrorInfo otBillValidateErrorInfo : failEnumAndReasonList) {
            if (!HRStringUtils.equals((String)otBillValidateErrorInfo.getFailCode(), (String)checkCode)) continue;
            ArrayList failReasonList = otBillValidateErrorInfo.getFailReasonList();
            if (failReasonList == null) {
                failReasonList = new ArrayList(10);
                otBillValidateErrorInfo.setFailReasonList(failReasonList);
            }
            failReason = failReasonList;
            match = true;
        }
        if (!match) {
            failReason = new ArrayList(10);
            OtBillValidateErrorInfo otBillValidateErrorInfo = new OtBillValidateErrorInfo();
            otBillValidateErrorInfo.setFailCode(checkCode);
            otBillValidateErrorInfo.setFailReasonList(failReason);
            failEnumAndReasonList.add(otBillValidateErrorInfo);
        }
        return failReason;
    }

    public BillCheckResult verifyFlxOtResult(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.FLXOT_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.FLXOT.getMsg(), this.checkingShowIndex);
        Map<Date, Boolean> flxOtResult = this.otApplyBillOperator.getFlxOtResult(billId, checkIndex);
        for (Map.Entry<Date, Boolean> entry : flxOtResult.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.FLXS.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyFlxOtResultSc(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.FLXOT_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.FLXOT.getMsg(), this.checkingShowIndex);
        List<Tuple<DutyShift, Shift>> dutyShiftsRange = this.otApplyBillOperator.getDutyShiftsRange(billId, checkIndex);
        BillCheckResult dutyDate = this.getDutyDate(checkingBillDy, checkIndex);
        if (dutyDate.getData() != null) {
            Date endTime;
            Date duty = (Date)dutyDate.getData();
            DutyShift dutyShift = null;
            Shift shift = null;
            Map<Date, DynamicObject> baseDyMap = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
            DynamicObject baseDy = baseDyMap.get(duty);
            for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : dutyShiftsRange) {
                String dutyShiftStr;
                DutyShift dutyShiftInList = (DutyShift)dutyShiftShiftTuple.item1;
                Date rosterDate = dutyShiftInList.getRosterDate();
                String dutyStr = HRDateTimeUtils.format((Date)((Date)dutyDate.getData()), (String)"yyyy-MM-dd");
                if (!HRStringUtils.equalsIgnoreCase((String)dutyStr, (String)(dutyShiftStr = HRDateTimeUtils.format((Date)rosterDate, (String)"yyyy-MM-dd")))) continue;
                dutyShift = dutyShiftInList;
                shift = (Shift)dutyShiftShiftTuple.item2;
            }
            if (baseDy == null || dutyShift == null || shift == null) {
                return BillCheckResult.success();
            }
            Date startTime = this.checkingEntryDy.getDate("otdstarttime");
            boolean flxResult = OtUnifyBillCommonHelper.checkFlx(startTime, endTime = this.checkingEntryDy.getDate("otdendtime"), baseDy, dutyShift, shift);
            if (!flxResult) {
                return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.FLXS.getCheckType());
            }
        }
        return BillCheckResult.success();
    }

    /*
     * WARNING - void declaration
     */
    public BillCheckResult verifyInShift(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.INSHIFT_SINGLE.getMsg(), this.checkingTimeInfo) : MessageFormat.format(ApplyBillCheckMsgEnum.INSHIFT.getMsg(), this.checkingShowIndex, this.checkingTimeInfo);
        boolean result = this.otApplyBillOperator.getInShiftOtResult(billId, checkIndex);
        if (!result) {
            Date endTime;
            List<Tuple<DutyShift, Shift>> dutyShiftsRange = this.otApplyBillOperator.getDutyShiftsRange(billId, checkIndex);
            Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(checkingBillDy.getString("otapplytype"));
            Date startTime = this.checkingEntryDy.getDate(entryInfoByType.get(START_TIME_NAME));
            List<Tuples.Tuple2<Date, Date>> crossLineByShiftInfo = OtHandleShiftHelper.getCrossLineByShiftInfo((Tuples.Tuple2<Date, Date>)new Tuples.Tuple2((Object)startTime, (Object)(endTime = this.checkingEntryDy.getDate(entryInfoByType.get(END_TIME_NAME)))), this.transTuple2(dutyShiftsRange));
            if (CollectionUtils.isNotEmpty(crossLineByShiftInfo)) {
                void var15_18;
                TreeMap<String, List> dateAndBucket = new TreeMap<String, List>((o1, o2) -> {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    try {
                        return HRDateTimeUtils.parseDate((String)o1, (String)"yyyy-MM-dd").compareTo(HRDateTimeUtils.parseDate((String)o2, (String)"yyyy-MM-dd"));
                    }
                    catch (Exception ex) {
                        logger.warn("error parse date,o1 = {},o2 = {}", o1, o2);
                        return 0;
                    }
                });
                List<Tuples.Tuple2<Date, Date>> mergeAndSplitTimeList = OTApplyUtil.mergeAndSplitContinuousTime(crossLineByShiftInfo);
                for (Tuples.Tuple2<Date, Date> tuple2 : mergeAndSplitTimeList) {
                    String string = HRDateTimeUtils.format((Date)((Date)tuple2.item1), (String)"yyyy-MM-dd");
                    List detailInfo = dateAndBucket.computeIfAbsent(string, key -> Lists.newArrayListWithExpectedSize((int)10));
                    detailInfo.add(HRDateTimeUtils.format((Date)((Date)tuple2.item1), (String)"HH:mm") + "-" + HRDateTimeUtils.format((Date)((Date)tuple2.item2), (String)"HH:mm"));
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entry : dateAndBucket.entrySet()) {
                    stringBuilder.append(WTCSymbolMultiLanguageUtil.getCommonSymbol()).append((String)entry.getKey()).append(' ').append(String.join((CharSequence)"\u3001", (Iterable)entry.getValue()));
                }
                String string = stringBuilder.toString();
                if (string.startsWith(WTCSymbolMultiLanguageUtil.getCommonSymbol())) {
                    String string2 = string.substring(1);
                }
                msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.INSHIFTBUCKET_SINGLE.getMsg(), var15_18) : MessageFormat.format(ApplyBillCheckMsgEnum.INSHIFTBUCKET.getMsg(), this.checkingShowIndex, var15_18);
            }
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.INSHIF.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyWorkExperience(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        long attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)checkingBillDy, (String)"attfile");
        List attFileAllVersion = this.otApplyBillOperator.getAttFileAllVersion(attFileBoId);
        if (WTCCollections.isEmpty((Collection)attFileAllVersion)) {
            return BillCheckResult.success();
        }
        BillCheckResult dutyDateResult = this.getDutyDate(checkingBillDy, checkIndex);
        if (!dutyDateResult.isVerifyResult()) {
            return BillCheckResult.success();
        }
        Date dutyDate = (Date)dutyDateResult.getData();
        if (dutyDate == null) {
            return BillCheckResult.success();
        }
        BillAttFileService attFileService = new BillAttFileService();
        List crossDate = attFileService.missWorkExperience(WTCDateUtils.toLocalDate((Date)dutyDate), WTCDateUtils.toLocalDate((Date)dutyDate), attFileAllVersion);
        if (WTCCollections.isEmpty((Collection)crossDate)) {
            return BillCheckResult.success();
        }
        Optional crossDateOptional = WTCCollectionIndexUtil.getEleFromList((List)crossDate, (int)0);
        if (!crossDateOptional.isPresent()) {
            return BillCheckResult.success();
        }
        Tuples.Tuple2 crossResult = (Tuples.Tuple2)crossDateOptional.get();
        String fixPre = "";
        fixPre = ((LocalDate)crossResult.item1).isEqual((ChronoLocalDate)crossResult.item2) ? WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)((LocalDate)crossResult.item1))) : WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)((LocalDate)crossResult.item1))) + OTKdStringHelper.to() + WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.toDate((LocalDate)((LocalDate)crossResult.item2)));
        boolean singleStyle = this.isSingleStyle(checkingBillDy);
        String finalTip = "";
        fixPre = singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.WORK_EXPERIENCE_SINGLE.getMsg(), finalTip) : MessageFormat.format(ApplyBillCheckMsgEnum.WORK_EXPERIENCE.getMsg(), this.checkingShowIndex, fixPre);
        return BillCheckResult.fail((Integer)checkIndex, (String)fixPre, (String)OTCheckTypeEnum.WORK_EXPERIENCE.getCheckType());
    }

    public BillCheckResult verifyApplySpan(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, DynamicObject> baseSetDys = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
        if (WTCCollections.isEmpty(baseSetDys)) {
            return BillCheckResult.success();
        }
        DynamicObject baseSet = baseSetDys.values().iterator().next();
        if (baseSet == null) {
            return BillCheckResult.success();
        }
        boolean isApplySpan = baseSet.getBoolean("isapplyspan");
        if (!isApplySpan) {
            return BillCheckResult.success();
        }
        String appSpanStr = baseSet.getString("applyspan");
        if (HRStringUtils.isEmpty((String)appSpanStr)) {
            return BillCheckResult.success();
        }
        String spanInfo = this.spanInfo(appSpanStr);
        appSpanStr = appSpanStr.trim();
        Integer timeMin = null;
        try {
            timeMin = Integer.valueOf(appSpanStr);
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u73ed\u57fa\u7840\u914d\u7f6e\u5355\u4f4d\u65f6\u957f\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u8bbe\u7f6e\u4e3a\u5206\u949f\u4e3a\u5355\u4f4d\u7684\u6574\u6570\u503c\u3002", (String)"OTApplyBillAssemblyResultService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        if (timeMin == 0) {
            return BillCheckResult.success();
        }
        int appSpanSec = this.getBaeSetApplySpanSec(timeMin);
        String applyType = checkingBillDy.getString("otapplytype");
        DynamicObject entryDy = this.checkingEntryDy;
        int otTime = -1;
        if (OtApplyTypeEnum.OT_SD.getNum().equals(applyType)) {
            otTime = entryDy.getInt("intottime");
            otTime = Math.max(otTime, 0);
        } else if (OtApplyTypeEnum.OT_SC.getNum().equals(applyType)) {
            otTime = entryDy.getInt("otdtime");
            otTime = Math.max(otTime, 0);
        }
        if (otTime < 0) {
            return BillCheckResult.success();
        }
        if (!this.verifyApplySpanMultiple(otTime, appSpanSec)) {
            String tip = MessageFormat.format(ApplyBillCheckMsgEnum.APPLY_SPAN.getMsg(), this.checkingShowIndex, spanInfo);
            String tipSingle = MessageFormat.format(ApplyBillCheckMsgEnum.APPLY_SPAN_SINGLE.getMsg(), spanInfo);
            String msg = this.isSingleStyle(checkingBillDy) ? tipSingle : tip;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.APPLY_SPAN.getCheckType());
        }
        return BillCheckResult.success();
    }

    private String spanInfo(String spanValStr) {
        BasedataEntityType basedataEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"wtp_otbaseset");
        ComboProp comboProp = (ComboProp)basedataEntityType.getProperty("applyspan");
        List comboItems = comboProp.getComboItems();
        if (WTCCollections.isEmpty((Collection)comboItems)) {
            return "";
        }
        for (ValueMapItem comboItem : comboItems) {
            String value = comboItem.getValue();
            if (!HRStringUtils.equals((String)value, (String)spanValStr)) continue;
            return comboItem.getName().getLocaleValue();
        }
        return "";
    }

    private int getBaeSetApplySpanSec(int appSpanMin) {
        return BigDecimal.valueOf(appSpanMin).multiply(BigDecimal.valueOf(60L)).intValue();
    }

    private boolean verifyApplySpanMultiple(int billTime, int baseSetTimeSpan) {
        BigDecimal[] hourAndMin = new BigDecimal(billTime).divideAndRemainder(new BigDecimal(baseSetTimeSpan));
        return hourAndMin[1].compareTo(BigDecimal.ZERO) == 0;
    }

    private List<Tuples.Tuple2<DutyShift, Shift>> transTuple2(List<Tuple<DutyShift, Shift>> dutyShiftsRange) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dutyShiftsRange.size());
        dutyShiftsRange.forEach(dr -> result.add(new Tuples.Tuple2(dr.item1, dr.item2)));
        return result;
    }

    public BillCheckResult verifyLargerZero(DynamicObject checkingBillDy, Integer checkIndex) {
        String msg;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        String string = msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.BIGGERZERO_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.BIGGERZERO.getMsg(), this.checkingShowIndex);
        if (this.checkingOtApplyType.equals(OtApplyTypeEnum.OT_SC.getNum())) {
            int anInt = this.checkingEntryDy.getInt("otdtime");
            if (anInt <= 0) {
                return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.LARGETZERO.getCheckType());
            }
            return BillCheckResult.success();
        }
        return BillCheckResult.success();
    }

    @Deprecated
    public DynamicObject getCalDy(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Shift> shiftMap = this.otApplyBillOperator.getShift(billId, checkIndex);
        Map<Date, DutyShift> dutyShiftMap = this.otApplyBillOperator.getDutyShift(billId, checkIndex);
        Map<Date, DynamicObject> ruleCalDys = this.otApplyBillOperator.getRuleCalDy(billId, checkIndex);
        DynamicObject matchRuleCalDy = null;
        Shift shift = null;
        DutyShift dutyShift = null;
        DynamicObject successCalDy = null;
        for (Map.Entry<Date, DynamicObject> entry : ruleCalDys.entrySet()) {
            matchRuleCalDy = entry.getValue();
        }
        for (Map.Entry<Date, DynamicObject> entry : shiftMap.entrySet()) {
            shift = (Shift)entry.getValue();
        }
        for (Map.Entry<Date, DynamicObject> entry : dutyShiftMap.entrySet()) {
            dutyShift = (DutyShift)entry.getValue();
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(checkingBillDy);
        Date date = this.checkingEntryDy.getDate(entryInfo.get(START_TIME_NAME));
        Date otEndTime = this.checkingEntryDy.getDate(entryInfo.get(END_TIME_NAME));
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        logger.info("OTApplyBillAssemblyResultService.getCalDy matchRuleCalDy is null?{}", (Object)(matchRuleCalDy == null ? 1 : 0));
        if (matchRuleCalDy != null) {
            logger.info("OTApplyBillAssemblyResultService.getCalDy ruleDyPKId={}", matchRuleCalDy.getPkValue());
            TimeInterval interval = OTApplyBillAssemblyResultService.getTimeInterval(dutyShift, shift, date, otEndTime);
            Boolean satisfyDateRange = dateRangeService.isSatisfyDateRange("2", interval, matchRuleCalDy.getString("daterangecondition"));
            logger.info("OTApplyBillAssemblyResultService.getCalDy pkid={},match={}", matchRuleCalDy.getPkValue(), (Object)satisfyDateRange);
            if (satisfyDateRange.booleanValue()) {
                successCalDy = matchRuleCalDy;
            }
        }
        return successCalDy;
    }

    public DynamicObject getCalDy(DynamicObject checkingBillDy, Integer checkIndex, List<RuleConditionRetrieval> retrievals) {
        Map retrievalResultMap = RuleConditionCommonService.groupByRetrievalResult(retrievals);
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(checkingBillDy);
        String entryName = entryInfo.get(ENTRY_NAME);
        String billEntrySeqKey = RuleConditionCommonService.getBillEntrySeqKey((DynamicObject)checkingBillDy, (String)entryName, (int)checkIndex);
        DynamicObject matchRuleCalDy = null;
        long billId = checkingBillDy.getLong("id");
        Map<Date, DynamicObject> ruleCalDys = this.otApplyBillOperator.getRuleCalDy(billId, checkIndex);
        for (Map.Entry<Date, DynamicObject> entry : ruleCalDys.entrySet()) {
            matchRuleCalDy = entry.getValue();
        }
        DynamicObject successCalDy = null;
        if (matchRuleCalDy != null) {
            List retrievalList = (List)retrievalResultMap.get(billEntrySeqKey);
            logger.info("OTApplyBillAssemblyResultService.getCalDy ruleDyPKId={}", matchRuleCalDy.getPkValue());
            if (WTCCollections.isNotEmpty((Collection)retrievalList)) {
                for (RuleConditionRetrieval retrieval : retrievalList) {
                    if (!retrieval.isMatchResult()) continue;
                    successCalDy = matchRuleCalDy;
                    break;
                }
            } else {
                successCalDy = matchRuleCalDy;
            }
        }
        return successCalDy;
    }

    public static TimeInterval getTimeInterval(DutyShift dutyShift, Shift shift, Date otStartTime, Date otEndTime) {
        TimeInterval interval = new TimeInterval();
        String dateAttribute = null;
        Long dateType = null;
        LocalDate localRosterDate = null;
        Long dutyShiftId = null;
        Date rosterDate = null;
        if (dutyShift != null) {
            dateAttribute = dutyShift.getDateAttribute() == null ? null : dutyShift.getDateAttribute().getCode();
            dateType = dutyShift.getDateTypeModel() == null ? null : dutyShift.getDateTypeModel().getId();
            rosterDate = dutyShift.getRosterDate();
            if (rosterDate != null) {
                localRosterDate = WTCDateUtils.toLocalDate((Date)rosterDate);
            }
            dutyShiftId = dutyShift.getId();
        }
        interval.setDateAttribute(dateAttribute);
        interval.setDateType(dateType);
        interval.setRosterDate(WTCDateUtils.toDate(localRosterDate));
        LocalDateTime localStartDate = otStartTime == null ? null : WTCDateUtils.toLocalDateTime((Date)otStartTime);
        interval.setOtStartDate(WTCDateUtils.toDate((LocalDateTime)localStartDate));
        LocalDateTime localEndDate = otStartTime == null ? null : WTCDateUtils.toLocalDateTime((Date)otEndTime);
        interval.setOtEndDate(WTCDateUtils.toDate((LocalDateTime)localEndDate));
        interval.setRosterId(dutyShiftId);
        interval.setShiftSpec(shift);
        List shiftDetailList = Collections.emptyList();
        if (shift != null) {
            shiftDetailList = shift.getShiftDetailList();
        }
        if (!CollectionUtils.isEmpty(shiftDetailList)) {
            ShiftDetail firstShiftDetail = (ShiftDetail)shiftDetailList.get(0);
            ShiftDetail lastShiftDetail = (ShiftDetail)shiftDetailList.get(shiftDetailList.size() - 1);
            firstShiftDetail.setCheckDate(rosterDate);
            interval.setStartDate(firstShiftDetail.getAbsoluteShiftStartDate());
            interval.setEndDate(lastShiftDetail.getAbsoluteShiftEndDate());
        }
        logger.info("OTApplyBillAssemblyResultService.getTimeInterval dateAttribute={},dateType={},localRosterDate={},rosterId={},rosterDate={},OtStartDate={},OtEndDate={},StartDate={},EndDate={}", new Object[]{interval.getDateAttribute(), interval.getDateType(), interval.getRosterDate(), interval.getRosterId(), interval.getRosterDate(), interval.getOtStartDate(), interval.getOtEndDate(), interval.getStartDate(), interval.getEndDate()});
        return interval;
    }

    public BillCheckResult verifyEachDateShift(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        List<Date> eachDateWithShift = this.otApplyBillOperator.getEachDateWithNoShift(billId, checkIndex);
        List<Object> eachDateWithShiftNew = Lists.newArrayList(eachDateWithShift);
        logger.info("OTApplyBillAssemblyResultService.verifyEachDateShift noShiftDate = {}", (Object)JSON.toJSONString((Object)eachDateWithShiftNew));
        ArrayList noShiftDate = Lists.newArrayListWithExpectedSize((int)eachDateWithShiftNew.size());
        boolean singleStyle = this.isSingleStyle(checkingBillDy);
        Iterator iterator = eachDateWithShiftNew.iterator();
        while (iterator.hasNext()) {
            Date next = (Date)iterator.next();
            if (!next.before(WTCDateUtils.getDayStartTime((Date)this.checkQueryStartTime)) && !next.after(WTCDateUtils.getDayStartTime((Date)this.checkQueryEndTime))) continue;
            iterator.remove();
        }
        eachDateWithShiftNew = this.filterOutBoDate((List<Date>)eachDateWithShiftNew, checkingBillDy);
        String noShiftDateStr = "";
        if (!eachDateWithShiftNew.isEmpty()) {
            for (Date date : eachDateWithShiftNew) {
                noShiftDate.add(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date));
            }
            noShiftDateStr = String.join((CharSequence)",", noShiftDate);
            String noShiftInfo = singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.NOSCH_SINGLE.getMsg(), noShiftDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NOSCH.getMsg(), this.checkingShowIndex, noShiftDateStr);
            return BillCheckResult.fail((Integer)checkIndex, (String)noShiftInfo, (String)OTCheckTypeEnum.EACHDATESHIFT.getCheckType());
        }
        return BillCheckResult.success();
    }

    private List<Date> filterOutBoDate(List<Date> eachDateWithShiftNew, DynamicObject checkingBillDy) {
        if (WTCCollections.isEmpty(eachDateWithShiftNew)) {
            return eachDateWithShiftNew;
        }
        List attFileAllVersion = this.otApplyBillOperator.getAttFileAllVersion(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)checkingBillDy, (String)"attfile"));
        Optional attFileVersionDy = WTCCollectionIndexUtil.getEleFromList((List)attFileAllVersion, (int)0);
        if (!attFileVersionDy.isPresent()) {
            return eachDateWithShiftNew;
        }
        DynamicObject attFileVersion = (DynamicObject)attFileVersionDy.get();
        Date startDate = attFileVersion.getDate("startdate");
        Date endDate = attFileVersion.getDate("enddate");
        if (startDate == null || endDate == null) {
            return eachDateWithShiftNew;
        }
        ArrayList<Date> result = new ArrayList<Date>(10);
        for (Date date : eachDateWithShiftNew) {
            if (date == null || !WTCDateUtils.betweenTimeEquals((Date)date, (Date)startDate, (Date)endDate)) continue;
            result.add(date);
        }
        return result;
    }

    @Deprecated
    public BillCheckResult verifyBaseDateRange(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Shift> shiftMap = this.otApplyBillOperator.getShift(billId, checkIndex);
        Map<Date, DutyShift> dutyShiftMap = this.otApplyBillOperator.getDutyShift(billId, checkIndex);
        Map<Date, DynamicObject> baseDys = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
        DynamicObject baseDy = null;
        Shift shift = null;
        DutyShift dutyShift = null;
        for (Map.Entry<Date, Shift> entry : shiftMap.entrySet()) {
            shift = entry.getValue();
        }
        for (Map.Entry<Date, Shift> entry : dutyShiftMap.entrySet()) {
            dutyShift = (DutyShift)entry.getValue();
        }
        for (Map.Entry<Date, Shift> entry : baseDys.entrySet()) {
            baseDy = (DynamicObject)entry.getValue();
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(checkingBillDy);
        Date date = this.checkingEntryDy.getDate(entryInfo.get(START_TIME_NAME));
        Date otEndTime = this.checkingEntryDy.getDate(entryInfo.get(END_TIME_NAME));
        TimeInterval timeInterval = OTApplyBillAssemblyResultService.getTimeInterval(dutyShift, shift, date, otEndTime);
        logger.info("OTApplyBillAssemblyResultService.verifyBaseDateRange baseDy is null?{}", (Object)(baseDy == null ? 1 : 0));
        DateRangeServiceImpl dateRangeService = new DateRangeServiceImpl();
        if (baseDy != null) {
            logger.info("OTApplyBillAssemblyResultService.verifyBaseDateRange baseDyPkId = {}", baseDy.getPkValue());
            boolean verifyResult = dateRangeService.isSatisfyDateRange("1", timeInterval, baseDy.getString("daterangecondition"));
            logger.info("OTApplyBillAssemblyResultService.verifyBaseDateRange verifyResult = {}", (Object)verifyResult);
            if (!verifyResult) {
                String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.NOBASERANGE_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.NOBASERANGE.getMsg(), this.checkingShowIndex);
                return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.BASERANGE.getCheckType());
            }
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyBaseDateRange(DynamicObject checkingBillDy, Integer checkIndex, List<RuleConditionRetrieval> retrievals) {
        Map<String, String> entryInfo;
        String entryName;
        String billEntrySeqKey;
        List ruleConditionRetrievals;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        Map resultMap = RuleConditionCommonService.groupByRetrievalResult(retrievals);
        boolean verifyResult = false;
        if (WTCCollections.isNotEmpty((Map)resultMap) && WTCCollections.isNotEmpty((Collection)(ruleConditionRetrievals = (List)resultMap.get(billEntrySeqKey = RuleConditionCommonService.getBillEntrySeqKey((DynamicObject)checkingBillDy, (String)(entryName = (entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(checkingBillDy)).get(ENTRY_NAME)), (int)checkIndex))))) {
            for (RuleConditionRetrieval retrieval : ruleConditionRetrievals) {
                if (!retrieval.isMatchResult()) continue;
                verifyResult = true;
                break;
            }
        }
        if (!verifyResult) {
            String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.NOBASERANGE_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.NOBASERANGE.getMsg(), this.checkingShowIndex);
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.BASERANGE.getCheckType());
        }
        return BillCheckResult.success();
    }

    public void collectMatchData(DynamicObject checkingBillDy, Integer checkIndex, int type, List<RuleConditionBillDateRangeDto> dateRangeDtos) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Shift> shiftMap = this.otApplyBillOperator.getShift(billId, checkIndex);
        Map<Date, DutyShift> dutyShiftMap = this.otApplyBillOperator.getDutyShift(billId, checkIndex);
        Map<Date, DynamicObject> baseDys = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
        Map<Date, DynamicObject> ruleCalDys = this.otApplyBillOperator.getRuleCalDy(billId, checkIndex);
        DynamicObject matchRuleCalDy = null;
        DynamicObject baseDy = null;
        for (Map.Entry<Date, DynamicObject> entry : baseDys.entrySet()) {
            baseDy = entry.getValue();
        }
        for (Map.Entry<Date, DynamicObject> entry : ruleCalDys.entrySet()) {
            matchRuleCalDy = entry.getValue();
        }
        String condition = "";
        if (1 == type && baseDy != null) {
            condition = baseDy.getString("daterangecondition");
        } else if (2 == type && matchRuleCalDy != null) {
            condition = matchRuleCalDy.getString("daterangecondition");
        }
        if (HRStringUtils.isNotEmpty((String)condition)) {
            Shift shift = null;
            DutyShift dutyShift = null;
            for (Map.Entry<Date, Shift> entry : shiftMap.entrySet()) {
                shift = entry.getValue();
            }
            for (Map.Entry<Date, Shift> entry : dutyShiftMap.entrySet()) {
                dutyShift = (DutyShift)entry.getValue();
            }
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(checkingBillDy);
            Date date = this.checkingEntryDy.getDate(entryInfo.get(START_TIME_NAME));
            Date otEndTime = this.checkingEntryDy.getDate(entryInfo.get(END_TIME_NAME));
            TimeInterval timeInterval = OTApplyBillAssemblyResultService.getTimeInterval(dutyShift, shift, date, otEndTime);
            Date dutyDate = this.checkingEntryDy.getDate(entryInfo.get(DUTY_DAY_NAME));
            if (dutyDate == null) {
                dutyDate = date;
            }
            if (dutyDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u52a0\u73ed\u65f6\u6bb5\u6216\u65f6\u957f\uff0c\u518d\u9009\u62e9\u8865\u507f\u65b9\u5f0f\u3002", (String)"OTApplyBillAssemblyResultService_3", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            Date formatDutyDate = new Date(dutyDate.getTime());
            RuleConditionBillDateRangeDto dateRangeDto = new RuleConditionBillDateRangeDto();
            dateRangeDto.setCondition(condition);
            dateRangeDto.setAccessDto(ConditionValidateService.getRuleConditionInfo((String)condition));
            dateRangeDto.setTimeInterval(timeInterval);
            dateRangeDto.setDutyDate(formatDutyDate);
            dateRangeDto.setBillDy(checkingBillDy);
            String entryKey = entryInfo.get(ENTRY_NAME);
            dateRangeDto.setEntryKey(entryKey);
            dateRangeDto.setIndex(checkIndex.intValue());
            String billEntrySeqKey = RuleConditionCommonService.getBillEntrySeqKey((DynamicObject)checkingBillDy, (String)entryKey, (int)checkIndex);
            dateRangeDto.setDimensionKey(billEntrySeqKey);
            dateRangeDto.setBillBusType(UnifyBillEnum.OT.name());
            Map<Date, DynamicObject> attFileVersion = this.otApplyBillOperator.getAttFileVersion(billId, checkIndex);
            if (WTCCollections.isNotEmpty(attFileVersion)) {
                DynamicObject attFileV = attFileVersion.get(formatDutyDate);
                dateRangeDto.setAttFileV(attFileV);
            }
            dateRangeDtos.add(dateRangeDto);
        }
    }

    public BillCheckResult getDutyDate(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.NODUTYDATE_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.NODUTYDATE.getMsg(), this.checkingShowIndex);
        Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDateResult = this.otApplyBillOperator.getDutyDate(billId, checkIndex);
        logger.info("OTApplyBillAssemblyResultService.getDutyDate dutyDateResult = {}", (Object)JSON.toJSONString(dutyDateResult));
        List dutyDates = (List)dutyDateResult.item1;
        if (dutyDates.isEmpty()) {
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.EXISTDUTYDATE.getCheckType());
        }
        return BillCheckResult.success(dutyDates.get(0));
    }

    public List<Tuple<DutyShift, Shift>> getDutyShiftsRange(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        List<Object> dutyShiftsRange = this.otApplyBillOperator.getDutyShiftsRange(billId, checkIndex);
        dutyShiftsRange = dutyShiftsRange == null ? Collections.emptyList() : dutyShiftsRange;
        return dutyShiftsRange;
    }

    public BillCheckResult getPolicy(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, DynamicObject> ruleCalDy = this.otApplyBillOperator.getRuleCalDy(billId, checkIndex);
        if (ruleCalDy == null || ruleCalDy.size() == 0) {
            return BillCheckResult.fail((Integer)checkIndex, (String)"no rule", (String)OTCheckTypeEnum.POLICY.getCheckType());
        }
        for (Map.Entry<Date, DynamicObject> entry : ruleCalDy.entrySet()) {
            DynamicObject rule = entry.getValue();
            Long policy = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)rule, (String)"otsystem");
            if (policy == null) continue;
            return BillCheckResult.success((Object)policy);
        }
        return BillCheckResult.fail((Integer)checkIndex, (String)"no rule", (String)OTCheckTypeEnum.POLICY.getCheckType());
    }

    public BillCheckResult existAttFileAuth(DynamicObject checkingBillDy) {
        this.initCheckingInfo(checkingBillDy, null);
        Long attFileBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.checkingBillDy, (String)"attfile");
        Boolean auth = this.otApplyBillOperator.haveAttFileAuth(attFileBoId);
        if (auth.booleanValue()) {
            return BillCheckResult.success();
        }
        return BillCheckResult.fail((Integer)-1, (String)ApplyBillCheckMsgEnum.NOATTFILEAUTH.getMsg(), (String)OTCheckTypeEnum.ATTFILE_BO_AUTH.getCheckType());
    }

    public BillCheckResult existOnePlan(DynamicObject checkingBillDy) {
        this.initCheckingInfo(checkingBillDy, null);
        Long attFileBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.checkingBillDy, (String)"attfile");
        List planDys = this.otApplyBillOperator.getAllPlan(attFileBoId);
        if (!planDys.isEmpty()) {
            return BillCheckResult.success();
        }
        return BillCheckResult.fail((Integer)-1, (String)ApplyBillCheckMsgEnum.NOONEPLAN.getMsg(), (String)OTCheckTypeEnum.AT_LEAST_ONE_PLAN.getCheckType());
    }

    public BillCheckResult verifyDutyAuth(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Boolean> dutyAuth = this.otApplyBillOperator.getDutyAuth(billId, checkIndex);
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NOATTFILEAUTHINTIME_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NOATTFILEAUTHINTIME.getMsg(), this.checkingShowIndex, dutyDateStr);
        for (Map.Entry<Date, Boolean> entry : dutyAuth.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.DUTYAUTH.getCheckType());
        }
        return BillCheckResult.success();
    }

    public Set<Long> getOtTypeInAttFile(DynamicObject checkingBillDy) {
        this.initCheckingInfo(checkingBillDy, null);
        Long attFileBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.checkingBillDy, (String)"attfile");
        logger.info("OTApplyBillAssemblyResultService.getOtTypeInAttFile attFileBoId = {}", (Object)attFileBoId);
        List allType = this.otApplyBillOperator.getAllType(attFileBoId);
        HashSet typeId = Sets.newHashSetWithExpectedSize((int)allType.size());
        for (DynamicObject typeDy : allType) {
            typeId.add(typeDy.getLong("id"));
        }
        logger.info("OTApplyBillAssemblyResultService.getOtTypeInAttFile typeId = {}", (Object)JSON.toJSONString((Object)typeId));
        return typeId;
    }

    public BillCheckResult existDutyDate(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NODUTYDATE_SINGLE.getMsg(), this.checkingTimeInfo) : MessageFormat.format(ApplyBillCheckMsgEnum.NODUTYDATE.getMsg(), this.checkingShowIndex, this.checkingTimeInfo);
        BillCheckResult dutyDate = this.getDutyDate(checkingBillDy, checkIndex);
        if (dutyDate.isVerifyResult()) {
            return BillCheckResult.success();
        }
        return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.EXISTDUTYDATE.getCheckType());
    }

    public BillCheckResult verifyHaveShift(DynamicObject checkingBillDy, Integer checkIndex) {
        String msg;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        String string = msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NOSCH_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NOSCH.getMsg(), this.checkingShowIndex, dutyDateStr);
        if (HRStringUtils.equals((String)this.checkingOtApplyType, (String)OtApplyTypeEnum.OT_SD.getNum())) {
            Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDateResult = this.otApplyBillOperator.getDutyDate(billId, checkIndex);
            ApplyBillDutyDateErrorEnum errorEnum = (ApplyBillDutyDateErrorEnum)dutyDateResult.item2;
            if (errorEnum != null) {
                if (HRStringUtils.equals((String)errorEnum.getKey(), (String)ApplyBillDutyDateErrorEnum.NOSHIFT.getKey())) {
                    return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.SHIFT.getCheckType());
                }
                String error = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.SHIFTERROR_SINGLE.getMsg(), this.checkingTimeInfo, ApplyBillDutyDateErrorEnum.CROSSSHIFT.getDescription()) : MessageFormat.format(ApplyBillCheckMsgEnum.SHIFTERROR.getMsg(), this.checkingShowIndex, this.checkingTimeInfo, ApplyBillDutyDateErrorEnum.CROSSSHIFT.getDescription());
                return BillCheckResult.fail((Integer)checkIndex, (String)error, (String)OTCheckTypeEnum.SHIFT.getCheckType());
            }
        } else if (HRStringUtils.equals((String)this.checkingOtApplyType, (String)OtApplyTypeEnum.OT_SC.getNum())) {
            Map<Date, Shift> shift = this.otApplyBillOperator.getShift(billId, checkIndex);
            for (Map.Entry<Date, Shift> entry : shift.entrySet()) {
                if (entry.getValue() != null) continue;
                return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.SHIFT.getCheckType());
            }
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifySuspend(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        Map<Date, Boolean> suspendInfo = this.otApplyBillOperator.verifyNotInSuspend(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.SUSPEND_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.SUSPEND.getMsg(), this.checkingShowIndex, dutyDateStr);
        for (Map.Entry<Date, Boolean> entry : suspendInfo.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.SUSPEND.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyNeedReason(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Boolean> reasonInfo = this.otApplyBillOperator.getNeedReason(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.NOREASON_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.NOREASON.getMsg(), this.checkingShowIndex);
        String reasonFieldName = "";
        if (OtApplyTypeEnum.OT_SD.getNum().equals(this.checkingOtApplyType)) {
            reasonFieldName = "otresond";
        } else if (OtApplyTypeEnum.OT_SC.getNum().equals(this.checkingOtApplyType)) {
            reasonFieldName = "otreson";
        }
        String reason = this.checkingEntryDy.getString(reasonFieldName);
        if (!HRStringUtils.isEmpty((String)reason)) {
            return BillCheckResult.success();
        }
        for (Map.Entry<Date, Boolean> entry : reasonInfo.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.REASON.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyHavePlan(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NOPLAN_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NOPLAN.getMsg(), this.checkingShowIndex, dutyDateStr);
        Map<Date, DynamicObject> planDys = this.otApplyBillOperator.getPlanDy(billId, checkIndex);
        logger.info("OTApplyBillAssemblyResultService.verifyHavePlan,planDys size:{}", (Object)planDys.size());
        for (Map.Entry<Date, DynamicObject> entry : planDys.entrySet()) {
            logger.info("OTApplyBillAssemblyResultService.verifyHavePlan,planDys>DynamicObject is null{}", (Object)(entry.getValue() == null ? 1 : 0));
            if (entry.getValue() != null) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.PLANS.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyHaveRule(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NORULE_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NORULE.getMsg(), this.checkingShowIndex, dutyDateStr);
        Map<Date, DynamicObject> ruleCalDys = this.otApplyBillOperator.getRuleCalDy(billId, checkIndex);
        logger.info("OTApplyBillAssemblyResultService.verifyHaveRule,ruleCalDys size:{}", (Object)ruleCalDys.size());
        for (Map.Entry<Date, DynamicObject> entry : ruleCalDys.entrySet()) {
            if (entry.getValue() != null) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.RULE.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyHaveBaseSet(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        String dutyDateStr = this.getDutyDateInfo(billId, checkIndex);
        String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.NOBASESET_SINGLE.getMsg(), dutyDateStr) : MessageFormat.format(ApplyBillCheckMsgEnum.NOBASESET.getMsg(), this.checkingShowIndex, dutyDateStr);
        Map<Date, DynamicObject> baseSetDys = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
        logger.info("OTApplyBillAssemblyResultService.verifyHaveBaseSet,baseSetDys size:{}", (Object)baseSetDys.size());
        for (Map.Entry<Date, DynamicObject> entry : baseSetDys.entrySet()) {
            if (entry.getValue() != null) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.BASESET.getCheckType());
        }
        return BillCheckResult.success();
    }

    private String getDutyDateInfo(long billId, Integer checkIndex) {
        Tuple<List<Date>, ApplyBillDutyDateErrorEnum> dutyDateTuple = this.otApplyBillOperator.getDutyDate(billId, checkIndex);
        String dutyDateStr = "";
        if (dutyDateTuple != null && CollectionUtils.isNotEmpty((Collection)((Collection)dutyDateTuple.item1))) {
            dutyDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)((Date)((List)dutyDateTuple.item1).get(0)));
        }
        return dutyDateStr;
    }

    public BillCheckResult verifyFrozen(DynamicObject checkingBillDy, Integer checkIndex, String resMsg) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Tuple<Date, Date>> billFrozenInfos = this.otApplyBillOperator.getBillFrozenInfo(billId, checkIndex);
        boolean singleStyle = this.isSingleStyle(checkingBillDy);
        for (Map.Entry<Date, Tuple<Date, Date>> entry : billFrozenInfos.entrySet()) {
            Tuple<Date, Date> frozenTime = entry.getValue();
            Date frozenStartTime = (Date)frozenTime.item1;
            Date frozenEndTime = (Date)frozenTime.item2;
            if (frozenStartTime == null || frozenEndTime == null) continue;
            String start = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenStartTime);
            String end = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenEndTime);
            String msg = HRStringUtils.isNotEmpty((String)resMsg) ? MessageFormat.format(resMsg, start, end) : (singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.FROZEN_SINGLE.getMsg(), start, end) : MessageFormat.format(ApplyBillCheckMsgEnum.FROZEN.getMsg(), this.checkingShowIndex, start, end));
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.FROZEN.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyMaxAdvanceLimit(DynamicObject checkingBillDy, Integer checkIndex) {
        BillPeriodInfoResp matchBillPeriodCheck;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, DynamicObject> baseSetDyMap = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
        Collection<DynamicObject> baseSetDys = baseSetDyMap.values();
        if (CollectionUtils.isEmpty(baseSetDys)) {
            return BillCheckResult.success();
        }
        DynamicObject baseDy = baseSetDys.iterator().next();
        Set<Date> dates = baseSetDyMap.keySet();
        Date dutyDate = dates.iterator().next();
        if (dutyDate.before(WTCDateUtils.getDayBegin())) {
            return BillCheckResult.success();
        }
        List<BillServiceAdvAfterResp> maxLimit = this.getMaxLimit();
        BillServiceAdvAfterResp limitResp = null;
        for (BillServiceAdvAfterResp advLimitResp : maxLimit) {
            LinkedHashSet checkDates;
            LocalDate next;
            BillServiceBaseNewSetInfo baseSetInfo = advLimitResp.getBaseSetInfo();
            if (baseSetInfo == null || baseSetInfo.getBaseSetDy() == null || WTCCollections.isEmpty((Collection)baseSetInfo.getCheckDates()) || (next = (LocalDate)(checkDates = baseSetInfo.getCheckDates()).iterator().next()) == null) continue;
            Date checkDate = WTCDateUtils.toDate((LocalDate)next);
            long baseSetPkId = baseSetInfo.getBaseSetDy().getLong("id");
            long attFileBoIdFromInfo = baseSetInfo.getAttFileBoId();
            long time = checkDate.getTime();
            long attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)this.checkingBillDy, (String)"attfile");
            if (attFileBoId != attFileBoIdFromInfo || baseDy.getLong("id") != baseSetPkId || dutyDate.getTime() != time) continue;
            limitResp = advLimitResp;
            break;
        }
        if (limitResp == null || limitResp.isPassCheck()) {
            return BillCheckResult.success();
        }
        boolean singleStyle = this.isSingleStyle(checkingBillDy);
        String maxLimitUnit = limitResp.getLimitUnit();
        if (BaseSetUnitTypeEnum.PERIOD.getCode().equals(maxLimitUnit) && !(matchBillPeriodCheck = limitResp.getBillPeriodInfoResp()).isMaxAdvancePeriodCheck()) {
            String multiDates = MessageFormat.format(ApplyBillCheckMsgEnum.NOPERIODORI.getMsg(), this.checkingShowIndex, matchBillPeriodCheck.getTipInfo());
            String singleDate = matchBillPeriodCheck.getTipInfo();
            String tip = singleStyle ? singleDate : multiDates;
            return BillCheckResult.fail((Integer)checkIndex, (String)tip, (String)OTCheckTypeEnum.MAX_LIMIT_ADVANCE.getCheckType());
        }
        HashMap unitMapping = Maps.newHashMapWithExpectedSize((int)4);
        unitMapping.put(BaseSetUnitTypeEnum.MONTH.getCode(), OTKdStringHelper.unitMonth());
        unitMapping.put(BaseSetUnitTypeEnum.PERIOD.getCode(), OTKdStringHelper.unitPeriod());
        unitMapping.put(BaseSetUnitTypeEnum.DAY.getCode(), OTKdStringHelper.unitDay());
        unitMapping.put(BaseSetUnitTypeEnum.WEEKDAY.getCode(), OTKdStringHelper.unitWeekDay());
        String unit = (String)unitMapping.get(limitResp.getLimitUnit());
        String tip = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.MAXADVANCE_SINGLE.getMsg(), limitResp.getLimitNum(), unit) : MessageFormat.format(ApplyBillCheckMsgEnum.MAXADVANCE.getMsg(), this.checkingShowIndex, limitResp.getLimitNum(), unit);
        return BillCheckResult.fail((Integer)checkIndex, (String)tip, (String)OTCheckTypeEnum.MAX_LIMIT_ADVANCE.getCheckType());
    }

    public BillCheckResult verifyAdvanceAndAfter(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, UnifyBillAdvanceAfterInfo> advanceAndAfterInfo = this.otApplyBillOperator.getAdvanceAndAfterInfo(billId, checkIndex);
        for (Map.Entry<Date, UnifyBillAdvanceAfterInfo> entry : advanceAndAfterInfo.entrySet()) {
            Date dutyDate = entry.getKey();
            Map<Date, DynamicObject> baseSetDys = this.otApplyBillOperator.getBaseSetDy(billId, checkIndex);
            DynamicObject baseDy = baseSetDys.get(dutyDate);
            if (baseDy == null) continue;
            UnifyBillAdvanceAfterInfo advanceAfterErrorInfo = entry.getValue();
            boolean singleStyle = this.isSingleStyle(checkingBillDy);
            if (this.verifyPeriod(baseDy, dutyDate)) {
                Tuples.Tuple2 period = AdvanceAfterValidateUtil.verifyAfterAndAdvancePeriod((List)Lists.newArrayList((Object[])new Date[]{dutyDate}), (UnifyBillAdvanceAfterInfo)advanceAfterErrorInfo, (long)advanceAfterErrorInfo.getPersonId());
                if (!((Boolean)period.item1).booleanValue()) {
                    String tip = singleStyle ? (String)period.item2 : MessageFormat.format(ApplyBillCheckMsgEnum.NOPERIODORI.getMsg(), this.checkingShowIndex, period.item2);
                    return BillCheckResult.fail((Integer)checkIndex, (String)tip, (String)OTCheckTypeEnum.ADVANCE_AND_AFTER.getCheckType());
                }
            }
            Tuple<Boolean, String> msgByAdvanceAfterErrorInfo = this.getMsgByAdvanceAfterErrorInfo(this.checkingShowIndex, advanceAfterErrorInfo, dutyDate, checkingBillDy);
            if (((Boolean)msgByAdvanceAfterErrorInfo.item1).booleanValue()) continue;
            return BillCheckResult.fail((Integer)checkIndex, (String)((String)msgByAdvanceAfterErrorInfo.item2), (String)OTCheckTypeEnum.ADVANCE_AND_AFTER.getCheckType());
        }
        return BillCheckResult.success();
    }

    private boolean verifyPeriod(DynamicObject baseDy, Date dutyDate) {
        boolean isPeriodVerify = false;
        isPeriodVerify = WTCDateUtils.toLocalDate((Date)dutyDate).isBefore(LocalDate.now()) ? baseDy.getBoolean("isaftercrl") && BaseSetUnitTypeEnum.PERIOD.getCode().equals(baseDy.getString("afterunit")) : baseDy.getBoolean("isadvancecrl") && BaseSetUnitTypeEnum.PERIOD.getCode().equals(baseDy.getString("advanceunit")) || baseDy.getBoolean("ismaxadvancecrl") && BaseSetUnitTypeEnum.PERIOD.getCode().equals(baseDy.getString("maxadvanceunit"));
        return isPeriodVerify;
    }

    public BillCheckResult checkEndTimeLarger(DynamicObject checkingBillDy, Integer checkIndex) {
        boolean checkResult;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        if (this.checkQueryStartTime == null || this.checkQueryEndTime == null) {
            return BillCheckResult.success();
        }
        String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.LARGERTIME_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.LARGERTIME.getMsg(), this.checkingShowIndex);
        boolean bl = checkResult = this.checkQueryStartTime.getTime() < this.checkQueryEndTime.getTime();
        if (!checkResult) {
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.LARGERTIME.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult checkRepeatInOneBill(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        if (!OTApplyUtil.checkOtBillInSideRespect(checkingBillDy, checkIndex)) {
            String msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.REPEAT_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.REPEAT.getMsg(), this.checkingShowIndex);
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.REPEATINONEBILL.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult checkRepeat(DynamicObject checkingBillDy, Integer checkIndex, boolean containAllOperatingDy) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        DynamicObject onlyCheckDy = containAllOperatingDy ? null : checkingBillDy;
        Map<Long, List<OtTimeRepeated>> repeatMap = this.getRepeat(onlyCheckDy);
        if (repeatMap == null || repeatMap.size() == 0) {
            return BillCheckResult.success();
        }
        Long pkValue = (Long)this.checkingBillDy.getPkValue();
        List<OtTimeRepeated> repeatBillList = repeatMap.get(pkValue);
        if (CollectionUtils.isEmpty(repeatBillList)) {
            return BillCheckResult.success();
        }
        for (OtTimeRepeated repeated : repeatBillList) {
            Integer entryIndex = repeated.getEntryIndex();
            if (checkIndex == null || !checkIndex.equals(entryIndex)) continue;
            String msg = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.REPEATOTHER_SINGLE.getMsg(), repeated.getOtRepeatedEnum().getDescription(), repeated.getBillNo(), HRDateTimeUtils.format((Date)repeated.getRepeatedStartTime(), (String)"yyyy-MM-dd HH:mm"), HRDateTimeUtils.format((Date)repeated.getRepeatedEndTime(), (String)"yyyy-MM-dd HH:mm")) : MessageFormat.format(ApplyBillCheckMsgEnum.REPEATOTHER.getMsg(), entryIndex + 1, repeated.getOtRepeatedEnum().getDescription(), repeated.getBillNo(), HRDateTimeUtils.format((Date)repeated.getRepeatedStartTime(), (String)"yyyy-MM-dd HH:mm"), HRDateTimeUtils.format((Date)repeated.getRepeatedEndTime(), (String)"yyyy-MM-dd HH:mm"));
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.REPEAT.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult getOtBucket(DynamicObject checkingBillDy, Integer checkIndex, boolean containAllOperatingDy) {
        String msg;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        DynamicObject onlyCheckDy = containAllOperatingDy ? null : checkingBillDy;
        OtTimeBucketResult otTimeBucket = this.getOtTimeBucketResult(this.checkingBillDy, this.checkingEntryDy, checkIndex, this.getOTimeBucket(onlyCheckDy), containAllOperatingDy);
        logger.info("OTApplyBillAssemblyResultService.getOtBucket  otTimeBucket={}", (Object)JSON.toJSONString((Object)otTimeBucket));
        String string = msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.NOTIMEBUCKET_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.NOTIMEBUCKET.getMsg(), this.checkingShowIndex);
        if (otTimeBucket == null) {
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.SIMULATION_PERIOD.getCheckType());
        }
        if (otTimeBucket.getResultCode().equals(OtTimeBucketResultEnum.SUCCESS_CODE.getNumber()) || otTimeBucket.getResultCode().equals(OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET.getNumber())) {
            return BillCheckResult.success((Object)otTimeBucket.getOtTimeBucket());
        }
        if (otTimeBucket.getResultCode().equals(OtTimeBucketResultEnum.FAIL_NOT_ENOUGH_ENABLE_TIMEBUCKET.getNumber())) {
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.SIMULATION_PERIOD.getCheckType());
        }
        return BillCheckResult.fail((Integer)checkIndex, (String)otTimeBucket.getResultMsg(), (String)OTCheckTypeEnum.SIMULATION_PERIOD.getCheckType());
    }

    private OtTimeBucketResult getOtTimeBucketResult(DynamicObject billDy, DynamicObject entryDy, Integer checkIndex, List<OtTimeBucketResult> otTimeBucketResults, boolean containAllOperatingDy) {
        DynamicObject onlyCheckDy;
        DynamicObject dynamicObject = onlyCheckDy = containAllOperatingDy ? null : this.checkingBillDy;
        if ((Long)billDy.getPkValue() == 0L) {
            ArrayList matchOtTimeBucket = Lists.newArrayListWithExpectedSize((int)10);
            for (OtTimeBucketResult otTimeBucket : otTimeBucketResults) {
                if (otTimeBucket.getOtTimeBucket().getId() != 0L || otTimeBucket.getOtTimeBucket().getBillId() != 0L) continue;
                matchOtTimeBucket.add(otTimeBucket);
            }
            return (OtTimeBucketResult)matchOtTimeBucket.get(checkIndex);
        }
        if (0L == (Long)entryDy.getPkValue()) {
            int countMatch = 0;
            for (OtTimeBucketResult bucketResult : this.getOTimeBucket(onlyCheckDy)) {
                if (!billDy.getPkValue().equals(bucketResult.getOtTimeBucket().getBillId())) continue;
                if (countMatch == checkIndex) {
                    return bucketResult;
                }
                ++countMatch;
            }
        }
        for (OtTimeBucketResult bucketResult : this.getOTimeBucket(onlyCheckDy)) {
            if (!billDy.getPkValue().equals(bucketResult.getOtTimeBucket().getBillId()) || !entryDy.getPkValue().equals(bucketResult.getOtTimeBucket().getId())) continue;
            return bucketResult;
        }
        return null;
    }

    public BillCheckResult verifyOver24InOneBill(DynamicObject checkingBillDy, Integer checkIndex) {
        int anInt;
        String msg;
        this.initCheckingInfo(checkingBillDy, checkIndex);
        String string = msg = this.isSingleStyle(checkingBillDy) ? ApplyBillCheckMsgEnum.OVER24INONEBILL_SINGLE.getMsg() : MessageFormat.format(ApplyBillCheckMsgEnum.OVER24INONEBILL.getMsg(), this.checkingShowIndex);
        if (OtApplyTypeEnum.OT_SD.getNum().equals(this.checkingOtApplyType)) {
            Date startTime = this.checkingEntryDy.getDate("otstartdate");
            Date endTime = this.checkingEntryDy.getDate("otenddate");
            if (startTime == null || endTime == null) {
                return BillCheckResult.fail((Integer)checkIndex, (String)OTKdStringHelper.startOrEndTimeIsNull(), (String)OTCheckTypeEnum.OVER24INONEBILL.getCheckType());
            }
            if (BigDecimal.valueOf(endTime.getTime()).subtract(BigDecimal.valueOf(startTime.getTime())).compareTo(DAY_MILLISECOND) > 0) {
                return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.OVER24INONEBILL.getCheckType());
            }
        } else if (OtApplyTypeEnum.OT_SC.getNum().equals(this.checkingOtApplyType) && BigDecimal.valueOf(anInt = this.checkingEntryDy.getInt("otdtime")).compareTo(DAY_SECOND) > 0) {
            return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.OVER24INONEBILL.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyOver24(DynamicObject checkingBillDy, Integer checkIndex, boolean containAllOperatingDy) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(this.checkingBillDy);
        Date dutyDate = this.checkingEntryDy.getDate(entryInfo.get(DUTY_DAY_NAME));
        if (dutyDate == null) {
            return BillCheckResult.fail((Integer)checkIndex, (String)OTKdStringHelper.noDutyDate(), (String)OTCheckTypeEnum.OVER24.getCheckType());
        }
        DynamicObject onlyCheckDy = containAllOperatingDy ? null : checkingBillDy;
        List<OverTwentyFourVo> overTwentyFourVos = this.getDuration(onlyCheckDy);
        logger.info("OTApplyBillAssemblyResultService.verifyOver24 overTwentyFourVos.size={}", (Object)overTwentyFourVos.size());
        Long personId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.checkingBillDy, (String)"personid");
        boolean result = true;
        Date overDate = null;
        OverTwentyFourVo matchOverTwentyFour = null;
        for (OverTwentyFourVo overTwentyFourVo : overTwentyFourVos) {
            if (dutyDate.getTime() != overTwentyFourVo.getDutyDate().getTime() || !personId.equals(overTwentyFourVo.getPersonId())) continue;
            result = overTwentyFourVo.isCheckResult();
            overDate = overTwentyFourVo.getDutyDate();
            matchOverTwentyFour = overTwentyFourVo;
            break;
        }
        if (result) {
            return BillCheckResult.success();
        }
        BigDecimal otSec = matchOverTwentyFour.getOtSec() == null ? BigDecimal.ZERO : matchOverTwentyFour.getOtSec();
        BigDecimal vaSec = matchOverTwentyFour.getVaSec() == null ? BigDecimal.ZERO : matchOverTwentyFour.getVaSec();
        String msg = "";
        BigDecimal restHour = this.restHour(otSec, vaSec);
        restHour = restHour.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : restHour;
        String hourStr = ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"OTApplyBillAssemblyResultService_0", (String)"wtc-wtom-business", (Object[])new Object[0]);
        String secStr = ResManager.loadKDString((String)"\u5206", (String)"OTApplyBillAssemblyResultService_1", (String)"wtc-wtom-business", (Object[])new Object[0]);
        String otSecStr = OTBillHelper.getTimeStrWithUnit(otSec.multiply(new BigDecimal("1000")), hourStr, secStr);
        String vaSecStr = OTBillHelper.getTimeStrWithUnit(vaSec.multiply(new BigDecimal("1000")), hourStr, secStr);
        String restSecStr = OTBillHelper.getTimeStrWithUnit(restHour.multiply(new BigDecimal("1000")), hourStr, secStr);
        otSecStr = HRStringUtils.isEmpty((String)otSecStr) ? "0" + secStr : otSecStr;
        vaSecStr = HRStringUtils.isEmpty((String)vaSecStr) ? "0" + secStr : vaSecStr;
        restSecStr = HRStringUtils.isEmpty((String)restSecStr) ? "0" + secStr : restSecStr;
        boolean singleStyle = this.isSingleStyle(checkingBillDy);
        msg = otSec.compareTo(BigDecimal.ZERO) != 0 && vaSec.compareTo(BigDecimal.ZERO) != 0 ? (singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_OT_VA_SINGLE.getMsg(), vaSecStr, otSecStr, restSecStr) : MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_OT_VA.getMsg(), this.checkingShowIndex, vaSecStr, otSecStr, restSecStr)) : (otSec.compareTo(BigDecimal.ZERO) != 0 && vaSec.compareTo(BigDecimal.ZERO) == 0 ? (singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_OT_SINGLE.getMsg(), otSecStr, restSecStr) : MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_OT.getMsg(), this.checkingShowIndex, otSecStr, restSecStr)) : (otSec.compareTo(BigDecimal.ZERO) == 0 && vaSec.compareTo(BigDecimal.ZERO) != 0 ? (singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_VA_SINGLE.getMsg(), vaSecStr, restSecStr) : MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_VA.getMsg(), this.checkingShowIndex, vaSecStr, restSecStr)) : (singleStyle ? MessageFormat.format(ApplyBillCheckMsgEnum.OVER24_SINGLE.getMsg(), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)overDate)) : MessageFormat.format(ApplyBillCheckMsgEnum.OVER24.getMsg(), this.checkingShowIndex, WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)overDate)))));
        return BillCheckResult.fail((Integer)checkIndex, (String)msg, (String)OTCheckTypeEnum.OVER24.getCheckType());
    }

    private BigDecimal restHour(BigDecimal otSec, BigDecimal vaSec) {
        if (otSec == null) {
            otSec = BigDecimal.ZERO;
        }
        if (vaSec == null) {
            vaSec = BigDecimal.ZERO;
        }
        return new BigDecimal(86400).subtract(otSec).subtract(vaSec);
    }

    public BillCheckResult verifyAttachmentFile(DynamicObject checkingBillDy, List<BigDecimal> attachmentInfoCapacity) {
        this.initCheckingInfo(checkingBillDy, null);
        UnifyBillAttachmentInfo billAttachmentInfo = this.otApplyBillOperator.matchAttachmentInfo(attachmentInfoCapacity, checkingBillDy.getLong("id"));
        if (billAttachmentInfo != null && !billAttachmentInfo.isAttachmentVerifyResult().booleanValue()) {
            String tip = "";
            switch (billAttachmentInfo.getBillAttachmentErrorEnum()) {
                case NEED_ERROR: {
                    tip = ApplyBillCheckMsgEnum.NEEDFILE.getMsg();
                    break;
                }
                case CAPACITY_ERROR: {
                    tip = ApplyBillCheckMsgEnum.OVERFILESIZE.getMsg();
                    break;
                }
                case NUM_ERROR: {
                    tip = ApplyBillCheckMsgEnum.OVERFILENUM.getMsg();
                    break;
                }
            }
            return BillCheckResult.fail((Integer)-1, (String)tip, (String)OTCheckTypeEnum.ATTACHMENT.getCheckType());
        }
        return BillCheckResult.success();
    }

    public BillCheckResult verifyMinOTTIme(DynamicObject checkingBillDy, Integer checkIndex) {
        this.initCheckingInfo(checkingBillDy, checkIndex);
        long billId = checkingBillDy.getLong("id");
        checkIndex = checkIndex == null ? Integer.valueOf(-1) : checkIndex;
        Map<Date, Tuple<String, Integer>> minOTTime = this.otApplyBillOperator.getMinOTTime(billId, checkIndex);
        int secNum = 0;
        if (OtApplyTypeEnum.OT_SD.getNum().equals(this.checkingOtApplyType)) {
            Date startTime = this.checkingEntryDy.getDate("otstartdate");
            Date endTime = this.checkingEntryDy.getDate("otenddate");
            secNum = OTBillHelper.getIntSdTime(startTime, endTime);
        } else if (OtApplyTypeEnum.OT_SC.getNum().equals(this.checkingOtApplyType)) {
            secNum = this.checkingEntryDy.getInt("otdtime");
        }
        for (Map.Entry<Date, Tuple<String, Integer>> entry : minOTTime.entrySet()) {
            String unit = (String)entry.getValue().item1;
            int num = (Integer)entry.getValue().item2;
            int secNumInBase = 0;
            String unitInfo = "";
            if (HRStringUtils.equals((String)unit, (String)TimeUnitEnum.MINUTE.getCode())) {
                secNumInBase = BigDecimal.valueOf(num).multiply(BigDecimal.valueOf(60L)).intValue();
                unitInfo = OTKdStringHelper.min();
            } else if (HRStringUtils.equals((String)unit, (String)TimeUnitEnum.HOUR.getCode())) {
                secNumInBase = BigDecimal.valueOf(num).multiply(BigDecimal.valueOf(3600L)).intValue();
                unitInfo = OTKdStringHelper.hour();
            }
            if (secNumInBase == 0 || secNum >= secNumInBase) continue;
            String info = this.isSingleStyle(checkingBillDy) ? MessageFormat.format(ApplyBillCheckMsgEnum.MINOTTIME_SINGLE.getMsg(), num, unitInfo) : MessageFormat.format(ApplyBillCheckMsgEnum.MINOTTIME.getMsg(), this.checkingShowIndex, num, unitInfo);
            return BillCheckResult.fail((Integer)checkIndex, (String)info, (String)OTCheckTypeEnum.MINOT.getCheckType());
        }
        return BillCheckResult.success();
    }

    public static String getOtBucketStr(Date otDate, Date applyStartTime, Date applyEndTime) {
        if (otDate == null || applyStartTime == null || applyEndTime == null) {
            return "";
        }
        String startOt = HRDateTimeUtils.format((Date)applyStartTime, (String)"HH:mm");
        String endOt = HRDateTimeUtils.format((Date)applyEndTime, (String)"HH:mm");
        Date dayLastDate = OTApplyBillAssemblyResultService.getDayLastDate(otDate);
        if (!applyEndTime.before(dayLastDate)) {
            endOt = endOt + OTKdStringHelper.getNextDay();
        }
        if (applyEndTime.before(otDate)) {
            endOt = endOt + OTKdStringHelper.getPreDay();
        }
        if (applyStartTime.before(otDate)) {
            startOt = startOt + OTKdStringHelper.getPreDay();
        }
        if (!applyStartTime.before(dayLastDate)) {
            startOt = startOt + OTKdStringHelper.getNextDay();
        }
        return startOt + "~" + endOt;
    }

    private static Date getDayLastDate(Date startDate) {
        Date lastStartDate = startDate;
        lastStartDate = HRDateTimeUtils.addHour((Date)lastStartDate, (long)23L);
        lastStartDate = HRDateTimeUtils.addMinute((Date)lastStartDate, (long)59L);
        lastStartDate = HRDateTimeUtils.addSecond((Date)lastStartDate, (long)59L);
        return lastStartDate;
    }

    private Tuple<Boolean, String> getMsgByAdvanceAfterErrorInfo(Integer checkIndex, UnifyBillAdvanceAfterInfo errorInfo, Date checkDate, DynamicObject checkingBillDy) {
        Date checkDateStart;
        if (errorInfo == null) {
            return new Tuple((Object)Boolean.TRUE, (Object)"");
        }
        HashMap unitMapping = Maps.newHashMapWithExpectedSize((int)4);
        unitMapping.put(BaseSetUnitTypeEnum.DAY.getCode(), OTKdStringHelper.unitDay());
        unitMapping.put(BaseSetUnitTypeEnum.MONTH.getCode(), OTKdStringHelper.unitMonth());
        unitMapping.put(BaseSetUnitTypeEnum.PERIOD.getCode(), OTKdStringHelper.unitPeriod());
        unitMapping.put(BaseSetUnitTypeEnum.WEEKDAY.getCode(), OTKdStringHelper.unitWeekDay());
        String advanceUnit = "";
        Integer advanceNum = 0;
        UnifyAdvanceAndAfterDetail advanceDetail = null;
        boolean advancePass = true;
        if (errorInfo.isPassAdvance() != null && !errorInfo.isPassAdvance().booleanValue()) {
            advanceDetail = errorInfo.getAdvanceInfo();
            advanceUnit = advanceDetail.getAdvanceAfterUnit();
            advanceNum = advanceDetail.getAdvanceAfterNum();
            advancePass = false;
        }
        String afterUnit = "";
        int afterNum = 0;
        UnifyAdvanceAndAfterDetail afterDetail = null;
        boolean afterPass = true;
        if (errorInfo.isPassAfter() != null && !errorInfo.isPassAfter().booleanValue()) {
            afterDetail = errorInfo.getAfterInfo();
            afterUnit = afterDetail.getAdvanceAfterUnit();
            afterNum = afterDetail.getAdvanceAfterNum();
            afterPass = false;
        }
        StringBuilder result = new StringBuilder();
        boolean pass = true;
        Date todayStart = WTCDateUtils.getDayStart((Date)new Date());
        if (todayStart.compareTo(checkDateStart = WTCDateUtils.getDayStart((Date)checkDate)) <= 0 && !advancePass) {
            ApplyBillCheckMsgEnum advance = null;
            if (this.isSingleStyle(checkingBillDy)) {
                advance = ApplyBillCheckMsgEnum.ADVANCE_SINGLE;
                checkIndex = -1;
            } else {
                advance = ApplyBillCheckMsgEnum.ADVANCE;
            }
            result.append(this.getAdvanceOrAfterTip(advanceUnit, advanceNum, checkIndex, unitMapping, advance));
            pass = false;
        }
        if (todayStart.compareTo(checkDateStart) > 0 && !afterPass) {
            ApplyBillCheckMsgEnum after = null;
            if (this.isSingleStyle(checkingBillDy)) {
                after = ApplyBillCheckMsgEnum.AFTER_SINGLE;
                checkIndex = -1;
            } else {
                after = ApplyBillCheckMsgEnum.AFTER;
            }
            result.append(this.getAdvanceOrAfterTip(afterUnit, afterNum, checkIndex, unitMapping, after));
            pass = false;
        }
        return new Tuple((Object)pass, (Object)result.toString());
    }

    private String getAdvanceOrAfterTip(String unit, int num, int checkIndex, Map<String, String> unitMapping, ApplyBillCheckMsgEnum msgEnum) {
        String unitMsg = unitMapping.get(unit);
        if (checkIndex == -1) {
            return MessageFormat.format(msgEnum.getMsg(), num + unitMsg);
        }
        return MessageFormat.format(msgEnum.getMsg(), checkIndex, num + unitMsg);
    }

    private UnifyBillApplyInitInfo getTimePairInfo(DynamicObject billDy, Integer index) {
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
        DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryInfo.get(ENTRY_NAME));
        ArrayList entryInitInfos = Lists.newArrayListWithExpectedSize((int)entry.size());
        String otApplyType = billDy.getString("otapplytype");
        for (int entryIndex = 0; entryIndex < entry.size(); ++entryIndex) {
            DynamicObject entryDy;
            Tuple<Date, Date> contextStartTimeAndEndTime;
            if (index != null && index != entryIndex || (contextStartTimeAndEndTime = this.getContextStartTimeAndEndTime(entryDy = (DynamicObject)entry.get(entryIndex), otApplyType)) == null) continue;
            UnifyBillApplyServiceEntryInitInfo unifyBillApplyServiceEntryInitInfo = new UnifyBillApplyServiceEntryInitInfo(entryDy.getLong("id"), entryIndex, (Date)contextStartTimeAndEndTime.item1, (Date)contextStartTimeAndEndTime.item2, HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entryDy, (String)entryInfo.get(OT_TYPE_NAME)).longValue());
            unifyBillApplyServiceEntryInitInfo.setEntryKey(entryDy.getDataEntityType().getName());
            unifyBillApplyServiceEntryInitInfo.setBillEntryDy(entryDy);
            entryInitInfos.add(unifyBillApplyServiceEntryInitInfo);
        }
        UnifyBillApplyInitInfo billApplyServiceInitInfo = new UnifyBillApplyInitInfo((Object)billDy.getLong("id"), HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)billDy, (String)"attfile").longValue(), (List)entryInitInfos);
        billApplyServiceInitInfo.setBillDy(billDy);
        OTBillServiceResult otBillServiceResult = new OTBillServiceResult();
        if (OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)) {
            otBillServiceResult.setOtApplyTypeEnum(OtApplyTypeEnum.OT_SC);
        } else if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
            otBillServiceResult.setOtApplyTypeEnum(OtApplyTypeEnum.OT_SD);
        }
        billApplyServiceInitInfo.setExpandInfo((Object)otBillServiceResult);
        return billApplyServiceInitInfo;
    }

    private Tuple<Date, Date> getContextStartTimeAndEndTime(DynamicObject entryDy, String otApplyType) {
        if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
            Date startDate = entryDy.getDate("otstartdate");
            Date endDate = entryDy.getDate("otenddate");
            if (startDate == null || endDate == null) {
                return null;
            }
            return new Tuple((Object)startDate, (Object)endDate);
        }
        if (OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)) {
            Date otDate = entryDy.getDate("otdate");
            if (otDate == null) {
                return null;
            }
            return new Tuple((Object)otDate, (Object)otDate);
        }
        return null;
    }

    public static Map<String, String> getEntryInfo(DynamicObject billDy) {
        String otApplyType = (String)billDy.get("otapplytype");
        return OTApplyBillAssemblyResultService.getEntryInfoByType(otApplyType);
    }

    public static Map<String, String> getEntryInfoByType(String otApplyType) {
        String entryName = null;
        String otTypeNameName = null;
        String startTimeName = null;
        String endTimeName = null;
        String dutyTimeName = null;
        String compensateName = null;
        String otTimeName = null;
        if (otApplyType.equals(OtApplyTypeEnum.OT_SD.getNum())) {
            entryName = "sdentry";
            otTypeNameName = "sdottype";
            startTimeName = "otstartdate";
            endTimeName = "otenddate";
            dutyTimeName = "otdutydate";
            compensateName = "compentyped";
            otTimeName = "intottime";
        } else if (otApplyType.equals(OtApplyTypeEnum.OT_SC.getNum())) {
            entryName = "scentry";
            otTypeNameName = "scottype";
            startTimeName = "otdstarttime";
            endTimeName = "otdendtime";
            dutyTimeName = "dutydate";
            compensateName = "compentype";
            otTimeName = "otdtime";
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put(ENTRY_NAME, entryName);
        result.put(OT_TYPE_NAME, otTypeNameName);
        result.put(START_TIME_NAME, startTimeName);
        result.put(END_TIME_NAME, endTimeName);
        result.put(DUTY_DAY_NAME, dutyTimeName);
        result.put(COMPENSATE_NAME, compensateName);
        result.put(OT_TIME_NAME, otTimeName);
        return result;
    }

    private List<OtTimeBucketResult> getOTimeBucket(DynamicObject onlyCheckDy) {
        Long checkDyId = onlyCheckDy == null ? -1L : onlyCheckDy.getLong("id");
        if (this.otTimeBucketResult != null && checkDyId.equals(this.needCheckBucketId)) {
            return this.otTimeBucketResult;
        }
        OTApplyBillInitData applyBillInitData = this.getApplyBillInitData();
        List<DynamicObject> scEntryDys = applyBillInitData.getScOperatingOtBillList();
        Date minBelongDate = null;
        Date maxBelongDate = null;
        if (scEntryDys != null) {
            minBelongDate = OTApplyUtil.getOtApplyEntryMaxOrMinWithScSelectDate(Lists.newArrayList((Object[])this.billDys), true);
            maxBelongDate = OTApplyUtil.getOtApplyEntryMaxOrMinWithScSelectDate(Lists.newArrayList((Object[])this.billDys), false);
            minBelongDate = minBelongDate != null ? HRDateTimeUtils.addDay((Date)minBelongDate, (long)-3L) : null;
            maxBelongDate = maxBelongDate != null ? HRDateTimeUtils.addDay((Date)maxBelongDate, (long)3L) : null;
        }
        OtTimeBucketService service = new OtTimeBucketService();
        OtCalculateBucketReqInfo reqInfo = new OtCalculateBucketReqInfo();
        reqInfo.setOtApplyBillInitData(applyBillInitData);
        reqInfo.setAttFileDutyDateShifts(this.getShiftByContext(minBelongDate, maxBelongDate, applyBillInitData.getAttFileBoIdSet()));
        reqInfo.setVaValidateTimeRspDtoMap(this.getVaData());
        reqInfo.setOnlyCheckOperatingDy(onlyCheckDy);
        this.otTimeBucketResult = service.getOtTimeBucketResult(reqInfo);
        this.needCheckBucketId = checkDyId;
        return this.otTimeBucketResult;
    }

    private OTApplyBillInitData getApplyBillInitData() {
        if (this.applyBillInitDataContext == null) {
            this.applyBillInitDataContext = OTApplyBillInitData.of(Lists.newArrayList((Object[])this.billDys));
        }
        return this.applyBillInitDataContext;
    }

    private List<AttFileDutyDateShift> getShiftByContext(Date minBelongDate, Date maxBelongDate, Set<Long> attFileBoIdSet) {
        List<AttFileDutyDateShift> attFileDutyDateShifts;
        ArrayList<AttFileDutyDateShift> shiftInUnifyQuery = new ArrayList<AttFileDutyDateShift>(10);
        for (DynamicObject billDy : this.billDys) {
            UnifyBillApplyInitInfo timePairInfo = this.getTimePairInfo(billDy, null);
            for (UnifyBillApplyServiceEntryInitInfo entryInitInfo : timePairInfo.getEntryInitInfoList()) {
                List<Tuple<DutyShift, Shift>> dutyShiftsRange = this.otApplyBillOperator.getDutyShiftsRange(timePairInfo.getBillId(), entryInitInfo.getEntryIndex());
                shiftInUnifyQuery.addAll(this.getShiftInfo(dutyShiftsRange, timePairInfo.getAttFileBoId()));
            }
        }
        Date maxDate = WTCDateUtils.getMinEndDate();
        Date minDate = WTCDateUtils.getMaxEndDate();
        for (AttFileDutyDateShift attFileDutyDateShift : shiftInUnifyQuery) {
            Date shiftDutyDate = attFileDutyDateShift.getDutyDate();
            if (shiftDutyDate == null) continue;
            maxDate = shiftDutyDate.compareTo(maxDate) > 0 ? shiftDutyDate : maxDate;
            minDate = shiftDutyDate.compareTo(minDate) < 0 ? shiftDutyDate : minDate;
        }
        LocalDate minLocalDate = WTCDateUtils.toLocalDate((Date)minDate);
        LocalDate maxLocalDate = WTCDateUtils.toLocalDate((Date)maxDate);
        boolean useUnifyShift = minBelongDate != null && maxBelongDate != null && WTCDateUtils.betweenDate((LocalDate)WTCDateUtils.toLocalDate((Date)minBelongDate), (LocalDate)minLocalDate, (LocalDate)maxLocalDate) && WTCDateUtils.betweenDate((LocalDate)WTCDateUtils.toLocalDate((Date)maxBelongDate), (LocalDate)minLocalDate, (LocalDate)maxLocalDate);
        logger.info("OTApplyBillAssemblyResultService_getShiftByContext useUnifyShift:{}", (Object)useUnifyShift);
        if (useUnifyShift) {
            attFileDutyDateShifts = shiftInUnifyQuery;
        } else {
            logger.warn("OTApplyBillAssemblyResultService_getShiftByContext\u83b7\u53d6\u52a0\u73ed\u65f6\u6bb5\u65f6\uff0c\u5355\u636e\u5934\u7684\u5f00\u59cb\u4e0e\u7ed3\u675f\u8bbe\u7f6e\u4e0d\u53ef\u4e3a\u7a7a\u3002maxDate:{},minDate\uff1a{}", (Object)maxDate, (Object)minDate);
            attFileDutyDateShifts = this.queryShiftInfo(attFileBoIdSet, WTCDateUtils.addDays((Date)minBelongDate, (int)-3), WTCDateUtils.addDays((Date)maxBelongDate, (int)3));
        }
        return attFileDutyDateShifts;
    }

    private List<AttFileDutyDateShift> queryShiftInfo(Set<Long> attFileBoIdSet, Date minDate, Date maxDate) {
        if (CollectionUtils.isEmpty(attFileBoIdSet)) {
            return Collections.emptyList();
        }
        Date pre = HRDateTimeUtils.addDay((Date)minDate, (long)-1L);
        Date next = HRDateTimeUtils.addDay((Date)maxDate, (long)1L);
        DutyShiftResponse shiftResponse = ApplyUtil.getShift((List)Lists.newArrayList(attFileBoIdSet), (Date)pre, (Date)next);
        if (shiftResponse == null) {
            return Collections.emptyList();
        }
        List dateRange = WTCDateUtils.getDateRange((Date)pre, (Date)next);
        if (CollectionUtils.isEmpty((Collection)dateRange)) {
            return Collections.emptyList();
        }
        ArrayList<AttFileDutyDateShift> result = new ArrayList<AttFileDutyDateShift>(10);
        for (Long attFileBoId : attFileBoIdSet) {
            List<DutyShift> dutyShiftList = dateRange.stream().map(date -> shiftResponse.getDutyShift(attFileBoId, date)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            for (Date date2 : dateRange) {
                AttFileDutyDateShift attFileDutyDateShift = new AttFileDutyDateShift();
                attFileDutyDateShift.setAttFileBoId(attFileBoId.longValue());
                attFileDutyDateShift.setDutyDate(date2);
                Tuple<DutyShift, Shift> dutyShiftShiftTuple = this.getDutyShiftAndShiftByDate(shiftResponse, dutyShiftList, date2);
                if (dutyShiftShiftTuple != null) {
                    attFileDutyDateShift.setDutyShift((DutyShift)dutyShiftShiftTuple.item1);
                    attFileDutyDateShift.setShift((Shift)dutyShiftShiftTuple.item2);
                }
                result.add(attFileDutyDateShift);
            }
        }
        return result;
    }

    private Tuple<DutyShift, Shift> getDutyShiftAndShiftByDate(DutyShiftResponse shiftResponse, List<DutyShift> dutyShiftList, Date dutyDate) {
        if (CollectionUtils.isEmpty(dutyShiftList) || dutyDate == null) {
            return null;
        }
        for (DutyShift dutyShift : dutyShiftList) {
            Date rosterDate = dutyShift.getRosterDate();
            if (rosterDate == null || dutyDate.compareTo(rosterDate) != 0) continue;
            Optional shiftHisData = shiftResponse.getShiftHisData(dutyShift.getShiftVid());
            return new Tuple((Object)dutyShift, shiftHisData.orElse(null));
        }
        return null;
    }

    private List<AttFileDutyDateShift> getShiftInfo(List<Tuple<DutyShift, Shift>> dutyShiftsRange, Long attFileBoId) {
        if (CollectionUtils.isEmpty(dutyShiftsRange)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dutyShiftsRange.size());
        for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : dutyShiftsRange) {
            AttFileDutyDateShift attFileDutyDateShift = new AttFileDutyDateShift();
            attFileDutyDateShift.setAttFileBoId(attFileBoId.longValue());
            DutyShift dutyShift = (DutyShift)dutyShiftShiftTuple.item1;
            Shift shift = (Shift)dutyShiftShiftTuple.item2;
            attFileDutyDateShift.setDutyDate(dutyShift.getRosterDate());
            attFileDutyDateShift.setDutyShift(dutyShift);
            attFileDutyDateShift.setShift(shift);
            result.add(attFileDutyDateShift);
        }
        return result;
    }

    private Map<Long, List<OtTimeRepeated>> getRepeat(DynamicObject onlyCheckDy) {
        Long checkDyId = onlyCheckDy == null ? -1L : onlyCheckDy.getLong("id");
        if (this.respectBill == null || !checkDyId.equals(this.needCheckRepeatId)) {
            OtTimeRepeatedService service = new OtTimeRepeatedService();
            OtCalculateRepeatReqInfo reqInfo = new OtCalculateRepeatReqInfo();
            reqInfo.setOtApplyBillInitData(this.getApplyBillInitData());
            reqInfo.setVaValidateTimeRspDtoMap(this.getVaData());
            reqInfo.setOnlyCheckOperatingDy(onlyCheckDy);
            this.respectBill = service.getRepeatedBill(reqInfo);
            this.needCheckRepeatId = checkDyId;
        }
        return this.respectBill;
    }

    private List<OverTwentyFourVo> getDuration(DynamicObject onlyCheckDy) {
        Long checkDyId = onlyCheckDy == null ? -1L : onlyCheckDy.getLong("id");
        if (this.belongAndPersonDuration == null || !checkDyId.equals(this.needCheck24Id)) {
            OtCalculateTwentyFourReqInfo reqInfo = new OtCalculateTwentyFourReqInfo();
            reqInfo.setOtApplyBillInitData(this.getApplyBillInitData());
            reqInfo.setVaValidateTimeRspDtoMap(this.getVaData());
            reqInfo.setOnlyCheckOperatingDy(onlyCheckDy);
            this.needCheck24Id = checkDyId;
            this.belongAndPersonDuration = TwentyFourCheck.getBelongAndPersonDuration(reqInfo);
        }
        return this.belongAndPersonDuration;
    }

    private Map<Long, List<VaValidateTimeRspModel>> getVaData() {
        if (this.vaInfoMap == null) {
            if (this.billDys == null) {
                return Collections.emptyMap();
            }
            Date minBelongDate = OTApplyUtil.getOtApplyEntryMaxOrMinWithScSelectDate(Lists.newArrayList((Object[])this.billDys), true);
            Date maxBelongDate = OTApplyUtil.getOtApplyEntryMaxOrMinWithScSelectDate(Lists.newArrayList((Object[])this.billDys), false);
            minBelongDate = minBelongDate != null ? HRDateTimeUtils.addDay((Date)minBelongDate, (long)-3L) : null;
            maxBelongDate = maxBelongDate != null ? HRDateTimeUtils.addDay((Date)maxBelongDate, (long)3L) : null;
            Set<Long> attFileBoIdSet = Lists.newArrayList((Object[])this.billDys).stream().map(ob -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ob, (String)"attfile")).collect(Collectors.toSet());
            List<AttFileDutyDateShift> shiftByContext = this.getShiftByContext(minBelongDate, maxBelongDate, attFileBoIdSet);
            ArrayList shiftInfo = Lists.newArrayListWithExpectedSize((int)shiftByContext.size());
            shiftByContext.forEach(sc -> {
                if (sc.getDutyShift() != null && sc.getShift() != null) {
                    shiftInfo.add(new Tuples.Tuple2((Object)sc.getDutyShift(), (Object)sc.getShift()));
                }
            });
            this.vaInfoMap = OTApplyUtil.getVaBucket(Lists.newArrayList((Object[])this.billDys), shiftInfo);
        }
        return this.vaInfoMap;
    }

    private List<BillServiceAdvAfterResp> getMaxLimit() {
        if (this.maxLimitInfo == null) {
            List initInfos = this.otApplyBillOperator.getInfoContext().getInitInfos();
            ArrayList baseSet = new ArrayList(10);
            for (UnifyBillApplyInitInfo initInfo : initInfos) {
                List entryInitInfoList = initInfo.getEntryInitInfoList();
                for (UnifyBillApplyServiceEntryInitInfo entryInitInfo : entryInitInfoList) {
                    Map<Date, DynamicObject> baseSetDy = this.otApplyBillOperator.getBaseSetDy(initInfo.getBillId(), entryInitInfo.getEntryIndex());
                    baseSetDy.forEach((dutyDate, baseDy) -> {
                        BillServiceBaseNewSetInfo baseSetInfo = new BillServiceBaseNewSetInfo();
                        baseSetInfo.setBaseSetDy(baseDy);
                        baseSetInfo.setAttFileBoId(initInfo.getAttFileBoId());
                        baseSetInfo.setPersonId(this.otApplyBillOperator.getPersonIdByAttFileBoId(initInfo.getAttFileBoId()));
                        baseSetInfo.setCheckDates(WTCDateUtils.getLocalDateRange((Date)dutyDate, (Date)dutyDate));
                        baseSet.add(baseSetInfo);
                    });
                }
            }
            HashMap advanceAndAfterInfo = new HashMap(16);
            HashMap<BillAdvanceAfterFieldEnum, String> maxField = new HashMap<BillAdvanceAfterFieldEnum, String>(16);
            maxField.put(BillAdvanceAfterFieldEnum.UNIT, "maxadvanceunit");
            maxField.put(BillAdvanceAfterFieldEnum.OFFSET, "maxadvancenum");
            maxField.put(BillAdvanceAfterFieldEnum.CTRL, "ismaxadvancecrl");
            advanceAndAfterInfo.put(BillAdvanceAfterEnum.MAX_ADVANCE, maxField);
            BillBaseStateLessService service = new BillBaseStateLessService();
            Map billAdvanceAfterEnumListMap = service.checkAdvanceAfter(baseSet, advanceAndAfterInfo);
            this.maxLimitInfo = (List)billAdvanceAfterEnumListMap.get(BillAdvanceAfterEnum.MAX_ADVANCE);
        }
        return this.maxLimitInfo;
    }

    protected void refreshBillDy(DynamicObject[] billDys) {
        this.billDys = billDys;
    }

    private boolean isSingleStyle(DynamicObject dynamicObject) {
        return BillStyleService.getInstance().isOpenSingleStyle(dynamicObject);
    }
}

