/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtom.business.OTApplyUtil;

public class OTApplyBillInitData {
    private Date startDate;
    private Date endDate;
    private DynamicObject[] sdFromDBOtBillArr;
    private DynamicObject[] scFromDBOtBillArr;
    private List<DynamicObject> sdOperatingOtBillList;
    private List<DynamicObject> scOperatingOtBillList;
    private Set<Long> personIdSet;
    private Set<Long> attFileBoIdSet;

    private OTApplyBillInitData() {
    }

    public static OTApplyBillInitData of(List<DynamicObject> dynamicObjectList) {
        OTApplyBillInitData otApplyBillInitData = new OTApplyBillInitData();
        HRBaseServiceHelper workServiceHelper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        Date startDate = OTApplyUtil.getMinBelongDate(dynamicObjectList, -2);
        Date endDate = OTApplyUtil.getMaxBelongDate(dynamicObjectList, 2);
        List<DynamicObject> scDynamicObjectList = dynamicObjectList.stream().filter(ob -> HRStringUtils.equals((String)"2", (String)ob.getString("otapplytype"))).sorted(Comparator.comparing(ob -> ob.getDate("createtime"))).collect(Collectors.toList());
        List<DynamicObject> sdDynamicObjectList = dynamicObjectList.stream().filter(ob -> HRStringUtils.equals((String)"1", (String)ob.getString("otapplytype"))).collect(Collectors.toList());
        Set<Long> personIdSet = dynamicObjectList.stream().map(ob -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ob, (String)"personid")).collect(Collectors.toSet());
        Set attFileBoIdSet = dynamicObjectList.stream().map(ob -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)ob, (String)"attfile")).collect(Collectors.toSet());
        DynamicObject[] scEntryWorkBills = workServiceHelper.loadDynamicObjectArray(OTApplyUtil.getQueryScentryWorkCondition(personIdSet, startDate, endDate, scDynamicObjectList));
        DynamicObject[] sdEntryWorkBills = workServiceHelper.loadDynamicObjectArray(OTApplyUtil.getQuerySdentryWorkCondition(personIdSet, startDate, endDate, sdDynamicObjectList));
        otApplyBillInitData.startDate = startDate;
        otApplyBillInitData.endDate = endDate;
        otApplyBillInitData.scOperatingOtBillList = scDynamicObjectList;
        otApplyBillInitData.sdOperatingOtBillList = sdDynamicObjectList;
        otApplyBillInitData.scFromDBOtBillArr = scEntryWorkBills;
        otApplyBillInitData.sdFromDBOtBillArr = sdEntryWorkBills;
        otApplyBillInitData.personIdSet = personIdSet;
        otApplyBillInitData.attFileBoIdSet = attFileBoIdSet;
        return otApplyBillInitData;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public DynamicObject[] getSdFromDBOtBillArr() {
        return this.sdFromDBOtBillArr;
    }

    public DynamicObject[] getScFromDBOtBillArr() {
        return this.scFromDBOtBillArr;
    }

    public List<DynamicObject> getSdOperatingOtBillList() {
        return this.sdOperatingOtBillList;
    }

    public List<DynamicObject> getScOperatingOtBillList() {
        return this.scOperatingOtBillList;
    }

    public Set<Long> getPersonIdSet() {
        return this.personIdSet;
    }

    public Set<Long> getAttFileBoIdSet() {
        return this.attFileBoIdSet;
    }
}

