/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.worktimebucket.BillBucketEnum;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtabm.common.entity.VaValidateTimeRspModel;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OTApplyUtil {
    private static final Log LOG = LogFactory.getLog(OTApplyUtil.class);

    public static Date getMinBelongDate(List<DynamicObject> dynamicObjectList, int addDay) {
        Date minDate = OTApplyUtil.getOtApplyEntryMaxOrMin(dynamicObjectList, true);
        return minDate == null ? null : HRDateTimeUtils.addDay((Date)minDate, (long)addDay);
    }

    public static Date getMaxBelongDate(List<DynamicObject> dynamicObjectList, int addDay) {
        Date maxDate = OTApplyUtil.getOtApplyEntryMaxOrMin(dynamicObjectList, false);
        return maxDate == null ? null : HRDateTimeUtils.addDay((Date)maxDate, (long)addDay);
    }

    private static Date getOtApplyEntryMaxOrMin(List<DynamicObject> dynamicObjectList, boolean isMin) {
        Date resultDate = null;
        for (DynamicObject otDy : dynamicObjectList) {
            String otApplyType = otDy.getString("otapplytype");
            Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(otApplyType);
            DynamicObjectCollection entries = otDy.getDynamicObjectCollection(entryInfoByType.get("ENTRY_NAME"));
            for (DynamicObject entry : entries) {
                boolean largerThan;
                Date duty = entry.getDate(entryInfoByType.get("DUTY_DAY_NAME"));
                boolean smallThan = resultDate == null || duty != null && duty.compareTo(resultDate) < 0;
                boolean bl = largerThan = resultDate == null || duty != null && duty.compareTo(resultDate) > 0;
                if (isMin && smallThan) {
                    resultDate = duty;
                    continue;
                }
                if (isMin || !largerThan) continue;
                resultDate = duty;
            }
        }
        return resultDate;
    }

    public static Date getOtApplyEntryMaxOrMinWithScSelectDate(List<DynamicObject> dynamicObjectList, boolean isMin) {
        Date oriDate = null;
        oriDate = isMin ? OTApplyUtil.getMinBelongDate(dynamicObjectList, 0) : OTApplyUtil.getMaxBelongDate(dynamicObjectList, 0);
        Date resultDate = null;
        for (DynamicObject otDy : dynamicObjectList) {
            String otApplyType = otDy.getString("otapplytype");
            if (!OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)) continue;
            DynamicObjectCollection entries = otDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            for (DynamicObject entry : entries) {
                boolean largerThan;
                Date userSetDutyDate = entry.getDate("otdate");
                boolean smallThan = resultDate == null || userSetDutyDate != null && userSetDutyDate.compareTo(resultDate) < 0;
                boolean bl = largerThan = resultDate == null || userSetDutyDate != null && userSetDutyDate.compareTo(resultDate) > 0;
                if (isMin && smallThan) {
                    resultDate = userSetDutyDate;
                    continue;
                }
                if (isMin || !largerThan) continue;
                resultDate = userSetDutyDate;
            }
        }
        if (oriDate == null) {
            return resultDate;
        }
        if (resultDate == null) {
            return oriDate;
        }
        if (isMin) {
            if (resultDate.before(oriDate)) {
                return resultDate;
            }
            return oriDate;
        }
        if (resultDate.after(oriDate)) {
            return resultDate;
        }
        return oriDate;
    }

    public static QFilter[] getQuerySdentryWorkCondition(Collection<Long> attPersonIds, Date fromDate, Date toDate, Collection<DynamicObject> dynamicObjects) {
        QFilter attPersonIdsFilter = new QFilter("personid", "in", attPersonIds);
        List pkIds = dynamicObjects.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        QFilter noContianPkIdsFilter = new QFilter("id", "not in", pkIds);
        QFilter billStatus = OTApplyUtil.getBillStatusQFilter();
        QFilter dentryDateFilter = new QFilter("sdentry.otdutydate", "<=", (Object)toDate).and(new QFilter("sdentry.otdutydate", ">=", (Object)fromDate));
        QFilter isNotChange = new QFilter("ischange", "=", (Object)Boolean.FALSE);
        return new QFilter[]{attPersonIdsFilter, dentryDateFilter, billStatus, noContianPkIdsFilter, isNotChange};
    }

    public static QFilter[] getQueryScentryWorkCondition(Collection<Long> attPersonIds, Date fromDate, Date toDate, Collection<DynamicObject> dynamicObjects) {
        QFilter attPersonIdsFilter = new QFilter("personid", "in", attPersonIds);
        QFilter isNotChange = new QFilter("ischange", "=", (Object)Boolean.FALSE);
        QFilter billStatus = OTApplyUtil.getBillStatusQFilter();
        QFilter pentryDateFilter = new QFilter("scentry.dutydate", "<=", (Object)toDate).and(new QFilter("scentry.dutydate", ">=", (Object)fromDate));
        List pkIds = dynamicObjects.stream().map(ob -> ob.getLong("id")).collect(Collectors.toList());
        QFilter noContianPkIdsFilter = new QFilter("id", "not in", pkIds);
        return new QFilter[]{attPersonIdsFilter, pentryDateFilter, billStatus, noContianPkIdsFilter, isNotChange};
    }

    private static QFilter getBillStatusQFilter() {
        ArrayList status = Lists.newArrayList((Object[])new String[]{"B", "C", "D"});
        return new QFilter("billstatus", "in", (Object)status);
    }

    private static Map<Date, Map<Long, List<Tuple<DynamicObject, DynamicObject>>>> getBillGroupByPersonAndDate(Date startDate, Date endDate, String belongDateKey, String entryKey, List<DynamicObject> workApplyBills, boolean isFilterOffNoPlan, String startDateKey) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        if (startDate == null) {
            return Collections.emptyMap();
        }
        Date belongDate = WTCDateUtils.getZeroDate((Date)startDate);
        while (belongDate != null && endDate != null && belongDate.compareTo(endDate) <= 0) {
            List<Tuple<DynamicObject, DynamicObject>> dynamicObjectList = OTApplyUtil.getBillGroupByBelongDate(belongDate, workApplyBills, belongDateKey, entryKey);
            if (!CollectionUtils.isEmpty(dynamicObjectList)) {
                map.put(belongDate, dynamicObjectList);
            }
            belongDate = HRDateTimeUtils.addDay((Date)belongDate, (long)1L);
        }
        HashMap personDateDy = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((key, value) -> {
            Map<Long, List<Tuple>> dyTupleMap = isFilterOffNoPlan ? value.stream().filter(ob -> ((DynamicObject)ob.item2).getDate(startDateKey) != null).collect(Collectors.groupingBy(ob -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)((DynamicObject)ob.item1), (String)"personid"))) : value.stream().collect(Collectors.groupingBy(ob -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)((DynamicObject)ob.item1), (String)"personid")));
            personDateDy.put(key, dyTupleMap);
        });
        return personDateDy;
    }

    private static List<Tuple<DynamicObject, DynamicObject>> getBillGroupByBelongDate(Date belongDate, List<DynamicObject> workApplyBills, String belongDateKey, String entryKey) {
        if (belongDate == null) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : workApplyBills) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
            List belongDateDy = dynamicObjectCollection.stream().filter(ob -> ob.getDate(belongDateKey) != null && belongDate.compareTo(ob.getDate(belongDateKey)) == 0).collect(Collectors.toList());
            for (DynamicObject dy : belongDateDy) {
                list.add(new Tuple((Object)dynamicObject, (Object)dy));
            }
        }
        return list;
    }

    public static Map<Date, Map<Long, List<Tuple<DynamicObject, DynamicObject>>>> getTupleByPersonAndBgDate(List<DynamicObject> entryList, DynamicObject[] entryWorkBills, Date minBelongDate, Date maxBelongDate, String applyType, boolean isFilterOffNoPlan) {
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        dynamicObjectList.addAll(entryList);
        if (entryWorkBills != null && entryWorkBills.length > 0) {
            dynamicObjectList.addAll(Arrays.asList(entryWorkBills));
        }
        Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(applyType);
        return OTApplyUtil.getBillGroupByPersonAndDate(minBelongDate, maxBelongDate, entryInfoByType.get("DUTY_DAY_NAME"), entryInfoByType.get("ENTRY_NAME"), dynamicObjectList, isFilterOffNoPlan, entryInfoByType.get("START_TIME_NAME"));
    }

    public static boolean checkOtBillInSideRespect(DynamicObject dynamicObject, int index) {
        if (dynamicObject == null) {
            return false;
        }
        String otApplyType = dynamicObject.getString("otapplytype");
        Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(otApplyType);
        String entryKey = entryInfoByType.get("ENTRY_NAME");
        String startDateKey = entryInfoByType.get("START_TIME_NAME");
        String endDateKey = entryInfoByType.get("END_TIME_NAME");
        DynamicObjectCollection dyCollection = dynamicObject.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)dyCollection)) {
            return true;
        }
        if (dyCollection.size() < index + 1) {
            return true;
        }
        DynamicObject checkEntryDy = (DynamicObject)dyCollection.get(index);
        Date checkStartDate = checkEntryDy.getDate(startDateKey);
        Date checkEndDate = checkEntryDy.getDate(endDateKey);
        if (checkStartDate == null || checkEndDate == null) {
            return true;
        }
        for (int checkIndex = 0; checkIndex < dyCollection.size(); ++checkIndex) {
            if (checkIndex == index) continue;
            DynamicObject entryDy = (DynamicObject)dyCollection.get(checkIndex);
            Date startDate = entryDy.getDate(startDateKey);
            Date endDate = entryDy.getDate(endDateKey);
            if (startDate == null || endDate == null || !OTApplyUtil.inTimeBucketNotEquals(checkStartDate, checkEndDate, startDate, endDate)) continue;
            return false;
        }
        return true;
    }

    private static boolean inTimeBucketNotEquals(Date startTime, Date endTime, Date verifyStartTime, Date verifyEndTime) {
        return WTCDateUtils.betweenDayNotEquals((Date)verifyStartTime, (Date)startTime, (Date)endTime) || WTCDateUtils.betweenDayNotEquals((Date)verifyEndTime, (Date)startTime, (Date)endTime) || WTCDateUtils.betweenDayNotEquals((Date)startTime, (Date)verifyStartTime, (Date)verifyEndTime) || WTCDateUtils.betweenDayNotEquals((Date)endTime, (Date)verifyStartTime, (Date)verifyEndTime) || startTime.getTime() == verifyStartTime.getTime() && endTime.getTime() == verifyEndTime.getTime();
    }

    public static Map<Long, List<VaValidateTimeRspModel>> getVaBucket(List<DynamicObject> otBillDys, List<Tuples.Tuple2<DutyShift, Shift>> shiftInfo) {
        return Collections.emptyMap();
    }

    public static List<OtTimeBucket> getExistTimeBucketByScDy(List<DynamicObject> scOtDyList) {
        if (CollectionUtils.isEmpty(scOtDyList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)scOtDyList.size());
        for (DynamicObject dynamicObject : scOtDyList) {
            String billNo = dynamicObject.getString("billno");
            long billId = dynamicObject.getLong("id");
            long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"personid");
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            for (int index = 0; index < entryColl.size(); ++index) {
                DynamicObject entryDy = (DynamicObject)entryColl.get(index);
                OtTimeBucket otTimeBucket = new OtTimeBucket();
                otTimeBucket.setCheckingIndex(Integer.valueOf(index));
                otTimeBucket.setBillBucketEnum(BillBucketEnum.OT);
                otTimeBucket.setBillNo(billNo);
                otTimeBucket.setBillId(billId);
                otTimeBucket.setPresonId(personId);
                otTimeBucket.setId(entryDy.getLong("id"));
                Date startTime = entryDy.getDate("otdstarttime");
                Date endTime = entryDy.getDate("otdendtime");
                if (startTime != null && endTime != null) {
                    otTimeBucket.setStartTime(WTCDateUtils.toLocalDateTime((Date)startTime));
                    otTimeBucket.setEndTime(WTCDateUtils.toLocalDateTime((Date)endTime));
                }
                result.add(otTimeBucket);
            }
        }
        return result;
    }

    public static List<OtTimeBucket> getExistTimeBucketBySdDy(List<DynamicObject> scOtDyList) {
        if (CollectionUtils.isEmpty(scOtDyList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)scOtDyList.size());
        for (DynamicObject dynamicObject : scOtDyList) {
            String billNo = dynamicObject.getString("billno");
            long billId = dynamicObject.getLong("id");
            long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"personid");
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
            for (int index = 0; index < entryColl.size(); ++index) {
                OtTimeBucket otTimeBucket = new OtTimeBucket();
                DynamicObject entryDy = (DynamicObject)entryColl.get(index);
                otTimeBucket.setBillBucketEnum(BillBucketEnum.OT);
                otTimeBucket.setBillNo(billNo);
                otTimeBucket.setBillId(billId);
                otTimeBucket.setPresonId(personId);
                otTimeBucket.setId(entryDy.getLong("id"));
                Date startTime = entryDy.getDate("otstartdate");
                Date endTime = entryDy.getDate("otenddate");
                otTimeBucket.setCheckingIndex(Integer.valueOf(index));
                if (startTime == null || endTime == null) {
                    LOG.warn("\u6309\u65f6\u957f\u7533\u8bf7\u7684\u5355\u636e\u5f02\u5e38\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    continue;
                }
                otTimeBucket.setStartTime(WTCDateUtils.toLocalDateTime((Date)startTime));
                otTimeBucket.setEndTime(WTCDateUtils.toLocalDateTime((Date)endTime));
                result.add(otTimeBucket);
            }
        }
        return result;
    }

    public static List<OtTimeBucket> getVaBucket(long personId, List<VaValidateTimeRspModel> vaValidateTimeRspModels) {
        if (CollectionUtils.isEmpty(vaValidateTimeRspModels)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)vaValidateTimeRspModels.size());
        for (VaValidateTimeRspModel vaValidateTimeRspModel : vaValidateTimeRspModels) {
            OtTimeBucket otTimeBucket = new OtTimeBucket();
            otTimeBucket.setStartTime(WTCDateUtils.toLocalDateTime((Date)vaValidateTimeRspModel.getStartDate()));
            otTimeBucket.setEndTime(WTCDateUtils.toLocalDateTime((Date)vaValidateTimeRspModel.getEndDate()));
            otTimeBucket.setPresonId(personId);
            otTimeBucket.setBillId(vaValidateTimeRspModel.getBillId().longValue());
            otTimeBucket.setBillNo(vaValidateTimeRspModel.getBillNo());
            otTimeBucket.setBillBucketEnum(BillBucketEnum.VA);
            if (vaValidateTimeRspModel.getDutyShift() != null) {
                otTimeBucket.setWorkTime(WTCDateUtils.toLocalDateTime((Date)vaValidateTimeRspModel.getDutyShift().getRosterDate()));
            }
            result.add(otTimeBucket);
        }
        return result;
    }

    public static List<Date> allowAdjustmentOtDate(Date startTime, Date endTime, List<Tuple<DutyShift, Shift>> shiftInfoList, Set<Date> exceptionalDate) {
        if (CollectionUtils.isEmpty(shiftInfoList)) {
            LOG.warn("UnifyEntryDutyDateOtService_getCustomDutyDate \u6392\u73ed\u6570\u636e\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        if (startTime == null || endTime == null) {
            LOG.warn("UnifyEntryDutyDateOtService_getCustomDutyDate \u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a\uff0cstartTime = {},endTime = {}", (Object)startTime, (Object)endTime);
        }
        ArrayList shiftInfoListAfterSort = Lists.newArrayList(shiftInfoList);
        shiftInfoListAfterSort.sort(new Comparator<Tuple<DutyShift, Shift>>(){

            @Override
            public int compare(Tuple<DutyShift, Shift> o1, Tuple<DutyShift, Shift> o2) {
                Date o1Date = WTCDateUtils.getMinEndDate();
                Date o2Date = WTCDateUtils.getMinEndDate();
                if (o1.item1 != null && ((DutyShift)o1.item1).getRosterDate() != null) {
                    o1Date = ((DutyShift)o1.item1).getRosterDate();
                }
                if (o2.item1 != null && ((DutyShift)o2.item1).getRosterDate() != null) {
                    o2Date = ((DutyShift)o2.item1).getRosterDate();
                }
                return o1Date.compareTo(o2Date);
            }
        });
        Date starDayStartTime = WTCDateUtils.getDayStartTime((Date)startTime);
        Date startDayEndTime = WTCDateUtils.getDayStartTime((Date)endTime);
        HashSet effectShiftDate = Sets.newHashSet((Object[])new String[]{HRDateTimeUtils.format((Date)starDayStartTime, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)startDayEndTime, (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)WTCDateUtils.addDays((Date)starDayStartTime, (int)-1), (String)"yyyy-MM-dd"), HRDateTimeUtils.format((Date)WTCDateUtils.addDays((Date)startDayEndTime, (int)1), (String)"yyyy-MM-dd")});
        ArrayList effectShift = Lists.newArrayListWithExpectedSize((int)effectShiftDate.size());
        ArrayList effectShiftWithTime = Lists.newArrayListWithExpectedSize((int)effectShiftDate.size());
        for (Tuple shiftInfo : shiftInfoListAfterSort) {
            DutyShift dutyShift = (DutyShift)shiftInfo.item1;
            if (dutyShift == null || dutyShift.getRosterDate() == null || !effectShiftDate.contains(HRDateTimeUtils.format((Date)dutyShift.getRosterDate(), (String)"yyyy-MM-dd"))) continue;
            effectShift.add(shiftInfo);
            List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, (Shift)shiftInfo.item2);
            if (!CollectionUtils.isNotEmpty(shiftDetailAbsoluteTime)) continue;
            effectShiftWithTime.add(new Tuple(shiftDetailAbsoluteTime.get((int)0).item2, shiftDetailAbsoluteTime.get((int)(shiftDetailAbsoluteTime.size() - 1)).item3));
        }
        List<Object> result = new ArrayList(10);
        result = OTApplyUtil.inNoPlanShift(effectShift, effectShiftWithTime, startTime, endTime) ? Lists.newArrayList((Object[])new Date[]{WTCDateUtils.addDays((Date)starDayStartTime, (int)-1), starDayStartTime, WTCDateUtils.addDays((Date)starDayStartTime, (int)1)}) : (!OTApplyUtil.crossShift(startTime, endTime, effectShiftWithTime) ? OTApplyUtil.notInShift(effectShift, startTime, endTime) : OTApplyUtil.inShift(effectShift, startTime, endTime));
        if (CollectionUtils.isEmpty(result)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u81ea\u5b9a\u4e49\u52a0\u73ed\u65e5\u671f\u9650\u5236\u3002", (String)"OTApplyUtil_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        result.addAll(exceptionalDate);
        return result;
    }

    private static boolean inNoPlanShift(List<Tuple<DutyShift, Shift>> effectShift, List<Tuple<Date, Date>> effectShiftWithTime, Date startTime, Date endTime) {
        String starDayEndTime;
        String starDayStartTime = HRDateTimeUtils.format((Date)startTime, (String)"yyyy-MM-dd");
        if (!HRStringUtils.equals((String)starDayStartTime, (String)(starDayEndTime = HRDateTimeUtils.format((Date)endTime, (String)"yyyy-MM-dd")))) {
            return false;
        }
        for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : effectShift) {
            DutyShift dutyShift = (DutyShift)dutyShiftShiftTuple.item1;
            if (dutyShift == null || dutyShift.getRosterDate() == null || !starDayEndTime.equals(HRDateTimeUtils.format((Date)dutyShift.getRosterDate(), (String)"yyyy-MM-dd")) || !((Shift)dutyShiftShiftTuple.item2).isOff() || !((Shift)dutyShiftShiftTuple.item2).getOffNonPlan() || OTApplyUtil.crossShift(startTime, endTime, effectShiftWithTime)) continue;
            return true;
        }
        return false;
    }

    private static List<Date> notInShift(List<Tuple<DutyShift, Shift>> effectShift, Date startTime, Date endTime) {
        ArrayList<Date> result = new ArrayList<Date>(10);
        Tuple<DutyShift, Shift> beforeShift = null;
        Tuple<DutyShift, Shift> afterShift = null;
        for (Tuple<DutyShift, Shift> shiftTuple : effectShift) {
            Date shiftLast;
            List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime;
            DutyShift dutyShift = (DutyShift)shiftTuple.item1;
            Shift shift = (Shift)shiftTuple.item2;
            Date rosterDate = dutyShift.getRosterDate();
            if (shift.isOff() && shift.getOffNonPlan() && rosterDate != null && !rosterDate.after(WTCDateUtils.getDayBegin((Date)startTime))) {
                beforeShift = OTApplyUtil.getOlderOrBefore(beforeShift, shiftTuple, true);
            } else {
                shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, shift);
                if (CollectionUtils.isNotEmpty(shiftDetailAbsoluteTime) && !(shiftLast = (Date)shiftDetailAbsoluteTime.get((int)(shiftDetailAbsoluteTime.size() - 1)).item3).after(startTime)) {
                    beforeShift = OTApplyUtil.getOlderOrBefore(beforeShift, shiftTuple, true);
                }
            }
            if (shift.isOff() && shift.getOffNonPlan() && rosterDate != null && !rosterDate.before(WTCDateUtils.getDayBegin((Date)endTime))) {
                afterShift = OTApplyUtil.getOlderOrBefore(afterShift, shiftTuple, false);
                continue;
            }
            shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, shift);
            if (!CollectionUtils.isNotEmpty(shiftDetailAbsoluteTime) || (shiftLast = (Date)shiftDetailAbsoluteTime.get((int)0).item2).before(endTime)) continue;
            afterShift = OTApplyUtil.getOlderOrBefore(afterShift, shiftTuple, false);
        }
        if (beforeShift == null || afterShift == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u524d\u540e\u73ed\u6b21\u3002", (String)"OTApplyUtil_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        if (beforeShift.item1 != null && ((DutyShift)beforeShift.item1).getRosterDate() != null) {
            result.add(((DutyShift)beforeShift.item1).getRosterDate());
        }
        if (afterShift.item1 != null && ((DutyShift)afterShift.item1).getRosterDate() != null) {
            result.add(((DutyShift)afterShift.item1).getRosterDate());
        }
        return result;
    }

    private static List<Date> inShift(List<Tuple<DutyShift, Shift>> effectShift, Date startTime, Date endTime) {
        for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : effectShift) {
            List<Tuples.Tuple3<String, Date, Date>> shiftInfo = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime((DutyShift)dutyShiftShiftTuple.item1, (Shift)dutyShiftShiftTuple.item2);
            for (Tuples.Tuple3<String, Date, Date> shiftInfoWithTime : shiftInfo) {
                if (!OTApplyUtil.isCross(startTime, endTime, (Date)shiftInfoWithTime.item2, (Date)shiftInfoWithTime.item3) || dutyShiftShiftTuple.item1 == null || ((DutyShift)dutyShiftShiftTuple.item1).getRosterDate() == null) continue;
                return Lists.newArrayList((Object[])new Date[]{((DutyShift)dutyShiftShiftTuple.item1).getRosterDate()});
            }
        }
        return Collections.emptyList();
    }

    private static boolean crossShift(Date startTime, Date endTime, List<Tuple<Date, Date>> effectShiftWithTime) {
        for (Tuple<Date, Date> shiftWithTime : effectShiftWithTime) {
            if (shiftWithTime.item1 == null || shiftWithTime.item2 == null || !OTApplyUtil.isCross(startTime, endTime, (Date)shiftWithTime.item1, (Date)shiftWithTime.item2)) continue;
            return true;
        }
        return false;
    }

    private static Tuple<DutyShift, Shift> getOlderOrBefore(Tuple<DutyShift, Shift> first, Tuple<DutyShift, Shift> second, boolean isOlder) {
        if (first == null || first.item1 == null || ((DutyShift)first.item1).getRosterDate() == null) {
            return second;
        }
        if (second != null && second.item1 != null && ((DutyShift)second.item1).getRosterDate() != null) {
            Date o1Date = WTCDateUtils.getMinEndDate();
            Date o2Date = WTCDateUtils.getMinEndDate();
            if (((DutyShift)first.item1).getRosterDate() != null) {
                o1Date = ((DutyShift)first.item1).getRosterDate();
            }
            if (((DutyShift)second.item1).getRosterDate() != null) {
                o2Date = ((DutyShift)second.item1).getRosterDate();
            }
            if (isOlder && o2Date.after(o1Date)) {
                return second;
            }
            if (!isOlder && o2Date.before(o1Date)) {
                return second;
            }
        }
        return first;
    }

    private static boolean isCross(Date otStartTime, Date otEndTime, Date shiftStartTime, Date shiftEndTime) {
        if (otStartTime == null || otEndTime == null || shiftStartTime == null || shiftEndTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u73ed\u65f6\u6bb5\u6216\u73ed\u6b21\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OTApplyUtil_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        return WTCDateUtils.betweenDayNotEquals((Date)otStartTime, (Date)shiftStartTime, (Date)shiftEndTime) || WTCDateUtils.betweenDayNotEquals((Date)otEndTime, (Date)shiftStartTime, (Date)shiftEndTime) || WTCDateUtils.betweenDayNotEquals((Date)shiftStartTime, (Date)otStartTime, (Date)otEndTime) || WTCDateUtils.betweenDayNotEquals((Date)shiftEndTime, (Date)otStartTime, (Date)otEndTime) || otStartTime.getTime() == shiftStartTime.getTime() && otEndTime.getTime() == shiftEndTime.getTime();
    }

    public static Tuples.Tuple3<Boolean, Date, Date> repeatTime(Date verifyStart, Date verifyEnd, Date compareStart, Date compareEnd) {
        if (verifyStart == null || verifyEnd == null || compareStart == null || compareEnd == null) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, null, null);
        }
        if (verifyStart.equals(compareStart) && verifyEnd.equals(compareEnd)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)verifyStart, (Object)verifyEnd);
        }
        if (compareStart.equals(verifyStart) && !compareEnd.after(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)compareStart, (Object)compareEnd);
        }
        if (compareStart.equals(verifyStart) && compareEnd.after(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)compareStart, (Object)verifyEnd);
        }
        if (compareStart.equals(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, null, null);
        }
        if (compareEnd.equals(verifyStart)) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, null, null);
        }
        if (compareEnd.equals(verifyEnd) && !compareStart.before(verifyStart)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)compareStart, (Object)compareEnd);
        }
        if (compareEnd.equals(verifyEnd) && compareStart.before(verifyStart)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)verifyStart, (Object)compareEnd);
        }
        if (WTCDateUtils.betweenTimeEquals((Date)compareStart, (Date)verifyStart, (Date)verifyEnd) && !compareEnd.before(verifyEnd) && compareStart.compareTo(verifyEnd) != 0) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)compareStart, (Object)verifyEnd);
        }
        if (WTCDateUtils.betweenTimeEquals((Date)compareStart, (Date)verifyStart, (Date)verifyEnd) && compareEnd.before(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)compareStart, (Object)compareEnd);
        }
        if (compareStart.before(verifyStart) && WTCDateUtils.betweenTimeEquals((Date)compareEnd, (Date)verifyStart, (Date)verifyEnd) && compareEnd.compareTo(verifyEnd) != 0) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)verifyStart, (Object)compareEnd);
        }
        if (compareStart.before(verifyStart) && compareEnd.before(verifyStart)) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, null, null);
        }
        if (compareStart.before(verifyStart) && compareEnd.after(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.TRUE, (Object)verifyStart, (Object)verifyEnd);
        }
        if (compareStart.after(verifyEnd)) {
            return new Tuples.Tuple3((Object)Boolean.FALSE, null, null);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u91cd\u53e0\u60c5\u51b5\u3002", (String)"OtTimeRepeatedService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
    }

    public static List<Tuples.Tuple2<Date, Date>> mergeAndSplitContinuousTime(List<Tuples.Tuple2<Date, Date>> oriTimeLineList) {
        if (CollectionUtils.isEmpty(oriTimeLineList)) {
            return Collections.emptyList();
        }
        ArrayList oriTimeLineListCopy = Lists.newArrayList(oriTimeLineList);
        OTApplyUtil.sortTime(oriTimeLineListCopy);
        ArrayList<Tuples.Tuple2> oriTimeLineListNew = new ArrayList<Tuples.Tuple2>(10);
        Iterator iterator = oriTimeLineListCopy.iterator();
        while (iterator.hasNext()) {
            Date repeatEndBeginDay;
            Tuples.Tuple2 oriTimeLine = (Tuples.Tuple2)iterator.next();
            Date repeatStart = (Date)oriTimeLine.item1;
            Date repeatEnd = (Date)oriTimeLine.item2;
            Date repeatStartBeginDay = WTCDateUtils.getDayStart((Date)repeatStart);
            if (repeatStartBeginDay.compareTo(repeatEndBeginDay = WTCDateUtils.getDayStart((Date)repeatEnd)) == 0) continue;
            List dateRange = WTCDateUtils.getDateRange((Date)repeatStartBeginDay, (Date)repeatEndBeginDay);
            for (Date date : dateRange) {
                if (date.compareTo(repeatStartBeginDay) == 0) {
                    oriTimeLineListNew.add(new Tuples.Tuple2((Object)repeatStart, (Object)HRDateTimeUtils.addDay((Date)date, (long)1L)));
                    continue;
                }
                if (date.compareTo(repeatEndBeginDay) == 0) {
                    oriTimeLineListNew.add(new Tuples.Tuple2((Object)repeatEndBeginDay, (Object)repeatEnd));
                    continue;
                }
                oriTimeLineListNew.add(new Tuples.Tuple2((Object)date, (Object)HRDateTimeUtils.addDay((Date)date, (long)1L)));
            }
            iterator.remove();
        }
        oriTimeLineListCopy.addAll(oriTimeLineListNew);
        OTApplyUtil.sortTime(oriTimeLineListCopy);
        ArrayList handleResult = Lists.newArrayListWithExpectedSize((int)oriTimeLineList.size());
        int checkLineIndex = 0;
        while (checkLineIndex < oriTimeLineListCopy.size()) {
            Tuples.Tuple3<Date, Date, Integer> continuousTime = OTApplyUtil.getContinuousTime(oriTimeLineListCopy, checkLineIndex);
            Date dateStart = (Date)continuousTime.item1;
            Date dateEnd = (Date)continuousTime.item2;
            if (dateStart != null && !dateStart.equals(dateEnd)) {
                handleResult.add(new Tuples.Tuple2((Object)dateStart, (Object)dateEnd));
            }
            checkLineIndex = (Integer)continuousTime.item3 + 1;
        }
        return handleResult;
    }

    private static Tuples.Tuple3<Date, Date, Integer> getContinuousTime(List<Tuples.Tuple2<Date, Date>> date, int startIndex) {
        if (startIndex == date.size() - 1) {
            Tuples.Tuple2<Date, Date> lastInfo = date.get(date.size() - 1);
            return new Tuples.Tuple3(lastInfo.item1, lastInfo.item2, (Object)startIndex);
        }
        Tuples.Tuple2<Date, Date> startPoint = date.get(startIndex);
        Tuples.Tuple3 resultTimePoint = new Tuples.Tuple3(startPoint.item1, startPoint.item2, (Object)startIndex);
        Date lastPoint = (Date)resultTimePoint.item2;
        for (int index = startIndex + 1; index < date.size() && lastPoint.compareTo(WTCDateUtils.getDayStart((Date)lastPoint)) != 0 && lastPoint.compareTo((Date)date.get((int)index).item1) == 0; ++index) {
            resultTimePoint = new Tuples.Tuple3(resultTimePoint.item1, date.get((int)index).item2, (Object)index);
            lastPoint = (Date)resultTimePoint.item2;
        }
        return resultTimePoint;
    }

    private static void sortTime(List<Tuples.Tuple2<Date, Date>> oriTimeLineListCopy) {
        oriTimeLineListCopy.sort((o1, o2) -> {
            Date item1 = (Date)o1.item1;
            Date item2 = (Date)o2.item2;
            if (item1 == null || item2 == null) {
                return 0;
            }
            return item1.compareTo(item2);
        });
    }
}

