/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sdk.wtc.wtom.business.applytime.OtApplyTimeExtPlugin;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.sdk.OTApplySdkHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OtUnUsedInfo;

public class OTApplyValidateAndUpdateHelper {
    private static final Log logger = LogFactory.getLog(BillUnifyService.class);

    public static void updateDutyInfo(DynamicObject[] dataEntities, OTBillHelper otBillHelper, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        for (DynamicObject dataEntity : dataEntities) {
            String applyType = dataEntity.getString("otapplytype");
            if (OtApplyTypeEnum.OT_SC.getNum().equals(applyType)) {
                OTApplyValidateAndUpdateHelper.setDataToScDy(dataEntity, otBillHelper, unCheckInfoMap);
                dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode()).clear();
                continue;
            }
            if (!OtApplyTypeEnum.OT_SD.getNum().equals(applyType)) continue;
            OTApplyValidateAndUpdateHelper.setDataToSdDy(dataEntity, otBillHelper, unCheckInfoMap);
            dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode()).clear();
        }
        OTApplyValidateAndUpdateHelper.updateMaxAndMinDutyDateToBill(dataEntities);
    }

    @Deprecated
    public static void updateDutyInfo(DynamicObject[] dataEntities, OTBillHelper otBillHelper) {
        OTApplyValidateAndUpdateHelper.updateDutyInfo(dataEntities, otBillHelper, Collections.emptyMap());
    }

    public static Map<Long, BillCheckResult> updateCompensate(DynamicObject[] dataEntities, OTBillHelper otBillHelper, boolean needCheckEmpChoice, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        ArrayList<RuleConditionBillDateRangeDto> dateRangeDtos = new ArrayList<RuleConditionBillDateRangeDto>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            long billId = dataEntity.getLong("id");
            OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.get(billId);
            if (otUnUsedInfo != null && !otUnUsedInfo.isNeedCheck()) continue;
            List uncheckIndex = otUnUsedInfo == null || CollectionUtils.isEmpty((Collection)otUnUsedInfo.getUnCheckIndex()) ? Collections.emptyList() : otUnUsedInfo.getUnCheckIndex();
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(dataEntity);
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
            for (int i = 0; i < entry.size(); ++i) {
                if (uncheckIndex.contains(i)) continue;
                otBillHelper.otApplyBillAssemblyResultService.collectMatchData(dataEntity, i, 2, dateRangeDtos);
            }
        }
        List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
        HashMap<Long, BillCheckResult> resultMap = new HashMap<Long, BillCheckResult>(16);
        String tip = ResManager.loadKDString((String)"\u5206\u5f55{0}\u884c\uff1a\u5458\u5de5\u81ea\u9009\u8865\u507f\u65b9\u5f0f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8865\u507f\u65b9\u5f0f\u3002", (String)"OTApplyValidateAndUpdateHelper_0", (String)"wtc-wtom-business", (Object[])new Object[0]);
        String tipEmpty = ResManager.loadKDString((String)"\u5206\u5f55{0}\u884c\uff1a\u5f53\u8865\u507f\u65b9\u5f0f\u4e3a\u5458\u5de5\u81ea\u9009\u65f6\uff0c\u8865\u507f\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"OTApplyValidateAndUpdateHelper_1", (String)"wtc-wtom-business", (Object[])new Object[0]);
        String tipSingle = ResManager.loadKDString((String)"\u5458\u5de5\u81ea\u9009\u8865\u507f\u65b9\u5f0f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8865\u507f\u65b9\u5f0f\u3002", (String)"OTApplyValidateAndUpdateHelper_2", (String)"wtc-wtom-business", (Object[])new Object[0]);
        String tipEmptySingle = ResManager.loadKDString((String)"\u5f53\u8865\u507f\u65b9\u5f0f\u4e3a\u5458\u5de5\u81ea\u9009\u65f6\uff0c\u8865\u507f\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"OTApplyValidateAndUpdateHelper_3", (String)"wtc-wtom-business", (Object[])new Object[0]);
        for (DynamicObject dataEntity : dataEntities) {
            boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(dataEntity);
            long billId = dataEntity.getLong("id");
            OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.get(billId);
            if (otUnUsedInfo != null && !otUnUsedInfo.isNeedCheck()) continue;
            List uncheckIndex = otUnUsedInfo == null || CollectionUtils.isEmpty((Collection)otUnUsedInfo.getUnCheckIndex()) ? Collections.emptyList() : otUnUsedInfo.getUnCheckIndex();
            BillCheckResult billCheckResult = BillCheckResult.success();
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(dataEntity);
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
            for (int i = 0; i < entry.size(); ++i) {
                if (uncheckIndex.contains(i)) continue;
                DynamicObject entryDy = (DynamicObject)entry.get(i);
                List<Long> compensateTypeDefList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, i, ruleConditionRetrievals);
                if (CollectionUtils.isEmpty(compensateTypeDefList)) {
                    entryDy.set(entryInfo.get("COMPENSATE_NAME") + "_" + "id", null);
                    continue;
                }
                Boolean isChoseByEmp = otBillHelper.getCompensateIsEmpChoseNew(dataEntity, i, ruleConditionRetrievals);
                Boolean bl = isChoseByEmp = isChoseByEmp == null ? Boolean.FALSE : isChoseByEmp;
                if (!isChoseByEmp.booleanValue()) {
                    entryDy.set(entryInfo.get("COMPENSATE_NAME") + "_" + "id", (Object)compensateTypeDefList.get(0));
                    continue;
                }
                if (!needCheckEmpChoice) continue;
                String keyCompen = entryInfo.get("COMPENSATE_NAME");
                long oriCompenId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entryDy, (String)keyCompen);
                if (oriCompenId == 0L) {
                    String msg = openSingleStyle ? tipEmptySingle : MessageFormat.format(tipEmpty, i + 1);
                    BillCheckResult fail = BillCheckResult.fail((Integer)i, (String)msg, (String)OTCheckTypeEnum.COMPENSATION.getCheckType());
                    billCheckResult = OTApplyBillAssemblyResultService.mergeBillCheckResult(billCheckResult, fail);
                    continue;
                }
                List<Long> compensateTypeDefIdList = otBillHelper.getCompensateTypeDefIdNew(dataEntity, i, ruleConditionRetrievals);
                long compenId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)entryInfo.get("COMPENSATE_NAME"));
                if (compenId == 0L || compensateTypeDefIdList.contains(compenId)) continue;
                String msg = openSingleStyle ? tipSingle : MessageFormat.format(tip, i + 1);
                BillCheckResult fail = BillCheckResult.fail((Integer)i, (String)msg, (String)OTCheckTypeEnum.COMPENSATION.getCheckType());
                billCheckResult = OTApplyBillAssemblyResultService.mergeBillCheckResult(billCheckResult, fail);
            }
            resultMap.put(dataEntity.getLong("id"), billCheckResult);
        }
        return resultMap;
    }

    @Deprecated
    public static Map<Long, BillCheckResult> updateCompensate(DynamicObject[] dataEntities, OTBillHelper otBillHelper) {
        return OTApplyValidateAndUpdateHelper.updateCompensate(dataEntities, otBillHelper, true, Collections.emptyMap());
    }

    @Deprecated
    public static Map<Long, BillCheckResult> updateCompensate(DynamicObject[] dataEntities, OTBillHelper otBillHelper, boolean needCheckEmpChoice) {
        return OTApplyValidateAndUpdateHelper.updateCompensate(dataEntities, otBillHelper, needCheckEmpChoice, Collections.emptyMap());
    }

    public static void setDataToScDy(DynamicObject dataEntity, OTBillHelper otBillHelper, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        long billId = dataEntity.getLong("id");
        OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.get(billId);
        if (otUnUsedInfo != null && !otUnUsedInfo.isNeedCheck()) {
            return;
        }
        List uncheckIndex = otUnUsedInfo == null || CollectionUtils.isEmpty((Collection)otUnUsedInfo.getUnCheckIndex()) ? Collections.emptyList() : otUnUsedInfo.getUnCheckIndex();
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("scentry");
        for (int i = 0; i < entry.size(); ++i) {
            if (uncheckIndex.contains(i)) continue;
            DynamicObject entryDy = (DynamicObject)entry.get(i);
            BillCheckResult dutyDate = otBillHelper.getDutyDate(dataEntity, i);
            if (dutyDate.isVerifyResult()) {
                entryDy.set("dutydate", dutyDate.getData());
                continue;
            }
            throw new KDBizException("error in match duty data");
        }
    }

    public static void setDataToSdDy(DynamicObject dataEntity, OTBillHelper otBillHelper, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        long billId = dataEntity.getLong("id");
        OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.get(billId);
        if (otUnUsedInfo != null && !otUnUsedInfo.isNeedCheck()) {
            return;
        }
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("sdentry");
        List uncheckIndex = otUnUsedInfo == null || CollectionUtils.isEmpty((Collection)otUnUsedInfo.getUnCheckIndex()) ? Collections.emptyList() : otUnUsedInfo.getUnCheckIndex();
        for (int i = 0; i < entry.size(); ++i) {
            if (uncheckIndex.contains(i)) continue;
            DynamicObject entryDy = (DynamicObject)entry.get(i);
            Date startTime = entryDy.getDate("otstartdate");
            Date endTime = entryDy.getDate("otenddate");
            BillCheckResult dutyDate = otBillHelper.getDutyDate(dataEntity, i);
            if (!dutyDate.isVerifyResult()) {
                throw new KDBizException("error in match dutyDate");
            }
            entryDy.set("otdutydate", dutyDate.getData());
            OTApplySdkHelper sdkHelper = new OTApplySdkHelper();
            WTCPluginProxy plugin = WTCPluginProxyFactory.create(OtApplyTimeExtPlugin.class, (String)"kd.sdk.wtc.wtom.business.applytime.OtApplyTimeExtPlugin");
            int applyTimeProxyResult = sdkHelper.getApplyTimeProxyResult(dataEntity, entryDy, i, otBillHelper.getDutyShiftsRange(dataEntity, i), OTBillHelper.getIntSdTime(startTime, endTime), (WTCPluginProxy<OtApplyTimeExtPlugin>)plugin);
            entryDy.set("intottime", (Object)applyTimeProxyResult);
            String otTime = OTBillHelper.getTimeBySec(applyTimeProxyResult);
            entryDy.set("ottime", (Object)otTime);
        }
    }

    public static void updateOtBucket(DynamicObject[] dataEntities, OTBillHelper otBillHelper, Map<Long, OtUnUsedInfo> unCheckInfoMap, boolean containAllOperatingDy) {
        for (DynamicObject dataEntity : dataEntities) {
            long billId = dataEntity.getLong("id");
            OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.get(billId);
            if (otUnUsedInfo != null && !otUnUsedInfo.isNeedCheck()) {
                return;
            }
            List uncheckIndex = otUnUsedInfo == null || CollectionUtils.isEmpty((Collection)otUnUsedInfo.getUnCheckIndex()) ? Collections.emptyList() : otUnUsedInfo.getUnCheckIndex();
            String applyType = dataEntity.getString("otapplytype");
            if (!OtApplyTypeEnum.OT_SC.getNum().equals(applyType)) continue;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("scentry");
            for (int i = 0; i < entry.size(); ++i) {
                if (uncheckIndex.contains(i)) continue;
                DynamicObject entryDy = (DynamicObject)entry.get(i);
                BillCheckResult entryOtBucket = otBillHelper.getEntryOtBucket(dataEntity, i, containAllOperatingDy);
                OTApplyValidateAndUpdateHelper.updateEntryOtBucket(entryDy, entryOtBucket);
            }
        }
    }

    @Deprecated
    public static void updateOtBucket(DynamicObject[] dataEntities, OTBillHelper otBillHelper) {
        OTApplyValidateAndUpdateHelper.updateOtBucket(dataEntities, otBillHelper, Collections.emptyMap(), true);
    }

    private static void updateEntryOtBucket(DynamicObject entryDy, BillCheckResult entryOtBucket) {
        OtTimeBucket otTimeBucket;
        if (entryOtBucket.isVerifyResult()) {
            otTimeBucket = (OtTimeBucket)entryOtBucket.getData();
            if (otTimeBucket == null) {
                entryDy.set("otdstarttime", null);
                entryDy.set("otdendtime", null);
                return;
            }
        } else {
            OtTimeBucket otTimeBucket2 = (OtTimeBucket)entryOtBucket.getData();
            logger.warn("OtApplyAllValidator_updateEntryOtBucket ", (Object)otTimeBucket2);
            throw new KDBizException("error in match updateOtBucket");
        }
        LocalDateTime startTime = otTimeBucket.getStartTime();
        LocalDateTime endTime = otTimeBucket.getEndTime();
        Date startDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)startTime);
        Date endDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)endTime);
        entryDy.set("otdstarttime", (Object)startDate);
        entryDy.set("otdendtime", (Object)endDate);
    }

    private static void updateMaxAndMinDutyDateToBill(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String applyType = dataEntity.getString("otapplytype");
            String entryName = null;
            String dutyDateName = null;
            if (applyType.equals(OtApplyTypeEnum.OT_SD.getNum())) {
                entryName = "sdentry";
                dutyDateName = "otdutydate";
            } else if (applyType.equals(OtApplyTypeEnum.OT_SC.getNum())) {
                entryName = "scentry";
                dutyDateName = "dutydate";
            }
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection(entryName);
            Date maxDate = WTCHisServiceHelper.getMinEndDate();
            Date minDate = WTCHisServiceHelper.getMaxEndDate();
            for (DynamicObject entryDy : entry) {
                Date dutyDay = entryDy.getDate(dutyDateName);
                if (dutyDay == null) continue;
                if (dutyDay.getTime() >= maxDate.getTime()) {
                    maxDate = dutyDay;
                }
                if (dutyDay.getTime() > minDate.getTime()) continue;
                minDate = dutyDay;
            }
            dataEntity.set("startdate", (Object)minDate);
            dataEntity.set("enddate", (Object)maxDate);
        }
    }

    public static void initId(DynamicObject[] dataEntities) {
        int idNum = dataEntities.length;
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection scEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            DynamicObjectCollection sdEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
            int scEntryNum = scEntry == null ? 0 : scEntry.size();
            int sdEntryNum = sdEntry == null ? 0 : sdEntry.size();
            idNum = idNum + scEntryNum + sdEntryNum;
        }
        long[] newPkIds = ORM.create().genLongIds("wtom_overtimeapplybill", idNum);
        int idIndex = 0;
        for (DynamicObject dataEntity : dataEntities) {
            long pkId = dataEntity.getLong("id");
            if (pkId == 0L) {
                dataEntity.set("id", (Object)newPkIds[idIndex]);
                ++idIndex;
            }
            DynamicObjectCollection scEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            for (DynamicObject scDy : scEntry) {
                long scPkId = scDy.getLong("id");
                if (scPkId != 0L) continue;
                scDy.set("id", (Object)newPkIds[idIndex]);
                ++idIndex;
            }
            DynamicObjectCollection sdEntry = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
            for (DynamicObject sdDy : sdEntry) {
                long sdPkId = sdDy.getLong("id");
                if (sdPkId != 0L) continue;
                sdDy.set("id", (Object)newPkIds[idIndex]);
                ++idIndex;
            }
        }
    }

    public static void updateTimeToZeroSec(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String applyType = dataEntity.getString("otapplytype");
            if (!OtApplyTypeEnum.OT_SD.getNum().equals(applyType)) continue;
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("sdentry");
            for (DynamicObject entryDy : entry) {
                entryDy.set("otstartdate", (Object)WTCDateUtils.getDayStartSec((Date)entryDy.getDate("otstartdate")));
                entryDy.set("otenddate", (Object)WTCDateUtils.getDayStartSec((Date)entryDy.getDate("otenddate")));
            }
        }
    }
}

