/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyRuleEnum;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;

public class OTBillHelper {
    private static final Log LOG = LogFactory.getLog(OTBillHelper.class);
    protected OTApplyBillAssemblyResultService otApplyBillAssemblyResultService;
    protected DynamicObject[] billDys;

    public BillCheckResult checkHaveAttFileHavePlan(DynamicObject checkingDy) {
        return this.otApplyBillAssemblyResultService.existOnePlan(checkingDy);
    }

    @Deprecated
    public OTBillHelper(DynamicObject billDy, Integer checkIndex, String attFileF7AuthEntity) {
        this.otApplyBillAssemblyResultService = new OTApplyBillAssemblyResultService(billDy, checkIndex, attFileF7AuthEntity);
    }

    public OTBillHelper(DynamicObject billDy, Integer checkIndex, UnifyBillApplyAttr unifyBillApplyAttr) {
        this.otApplyBillAssemblyResultService = new OTApplyBillAssemblyResultService(billDy, checkIndex, unifyBillApplyAttr);
    }

    @Deprecated
    public OTBillHelper(DynamicObject[] billDys, String attFileF7AuthEntity) {
        this.billDys = billDys;
        this.otApplyBillAssemblyResultService = new OTApplyBillAssemblyResultService(billDys, attFileF7AuthEntity);
    }

    public OTBillHelper(DynamicObject[] billDys, UnifyBillApplyAttr unifyBillApplyAttr) {
        this.billDys = billDys;
        this.otApplyBillAssemblyResultService = new OTApplyBillAssemblyResultService(billDys, unifyBillApplyAttr);
    }

    public OTBillHelper(DynamicObject[] billDys, OTApplyBillAssemblyResultService otApplyBillAssemblyResultService) {
        this.billDys = billDys;
        if (otApplyBillAssemblyResultService != null) {
            this.otApplyBillAssemblyResultService = otApplyBillAssemblyResultService;
        }
    }

    public void refreshBillDy(DynamicObject[] billDys) {
        this.billDys = billDys;
        if (this.otApplyBillAssemblyResultService != null) {
            this.otApplyBillAssemblyResultService.refreshBillDy(billDys);
        }
    }

    public BillCheckResult checkAttachmentFile(DynamicObject checkingDy, List<Map<String, Object>> attachmentFiles) {
        ArrayList info = Lists.newArrayListWithExpectedSize((int)attachmentFiles.size());
        for (Map<String, Object> stringObjectMap : attachmentFiles) {
            Object size = stringObjectMap.get("size");
            BigDecimal fileSize = BigDecimal.valueOf(Long.parseLong(size.toString())).divide(BigDecimal.valueOf(0x100000L), 2, 4);
            info.add(fileSize);
        }
        return this.otApplyBillAssemblyResultService.verifyAttachmentFile(checkingDy, info);
    }

    public static Map<Long, DynamicObject> getLatestTypeAndRuleCalDy(LinkedHashSet<Long> otTypeBoIds, long attFileBoId) {
        if (otTypeBoIds == null || otTypeBoIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return ApplyUtil.getLatestTypeAndRuleCalDy((long)attFileBoId, (UnifyBillEnum)UnifyBillEnum.OT);
    }

    private static List<DynamicObject> getAllCalByRule(DynamicObject ruleDy) {
        if (ruleDy == null) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> ruleCalDys = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection calRule = ruleDy.getDynamicObjectCollection(UnifyRuleEnum.OT.getCalEntry());
        ruleCalDys.addAll((Collection<DynamicObject>)calRule);
        return ruleCalDys;
    }

    public BillCheckResult checkEntry(OTCheckTypeEnum otCheckTypeEnum, DynamicObject checkingDy, Integer checkingIndex) {
        return this.verifyEvent(otCheckTypeEnum, checkingDy, checkingIndex, null);
    }

    public BillCheckResult checkEntry(OTCheckTypeEnum otCheckTypeEnum, DynamicObject checkingDy, Integer checkingIndex, String msg) {
        return this.verifyEvent(otCheckTypeEnum, checkingDy, checkingIndex, msg);
    }

    private BillCheckResult verifyEvent(OTCheckTypeEnum otCheckTypeEnum, DynamicObject checkingDy, Integer checkingIndex, String msg) {
        BillCheckResult billCheckResult = BillCheckResult.success();
        switch (otCheckTypeEnum) {
            case LARGERTIME: {
                billCheckResult = this.otApplyBillAssemblyResultService.checkEndTimeLarger(checkingDy, checkingIndex);
                break;
            }
            case REPEATINONEBILL: {
                billCheckResult = this.otApplyBillAssemblyResultService.checkRepeatInOneBill(checkingDy, checkingIndex);
                break;
            }
            case OVER24INONEBILL: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyOver24InOneBill(checkingDy, checkingIndex);
                break;
            }
            case DUTYAUTH: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyDutyAuth(checkingDy, checkingIndex);
                break;
            }
            case FLXS: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyFlxOtResult(checkingDy, checkingIndex);
                break;
            }
            case SCFLXS: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyFlxOtResultSc(checkingDy, checkingIndex);
                break;
            }
            case INSHIF: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyInShift(checkingDy, checkingIndex);
                break;
            }
            case EACHDATESHIFT: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyEachDateShift(checkingDy, checkingIndex);
                break;
            }
            case EXISTDUTYDATE: {
                billCheckResult = this.otApplyBillAssemblyResultService.existDutyDate(checkingDy, checkingIndex);
                break;
            }
            case FROZEN: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyFrozen(checkingDy, checkingIndex, msg);
                break;
            }
            case SHIFT: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyHaveShift(checkingDy, checkingIndex);
                break;
            }
            case SUSPEND: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifySuspend(checkingDy, checkingIndex);
                break;
            }
            case PLANS: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyHavePlan(checkingDy, checkingIndex);
                break;
            }
            case REASON: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyNeedReason(checkingDy, checkingIndex);
                break;
            }
            case OVER24: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyOver24(checkingDy, checkingIndex, true);
                break;
            }
            case RULE: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyHaveRule(checkingDy, checkingIndex);
                break;
            }
            case BASESET: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyHaveBaseSet(checkingDy, checkingIndex);
                break;
            }
            case MINOT: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyMinOTTIme(checkingDy, checkingIndex);
                break;
            }
            case ADVANCE_AND_AFTER: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyAdvanceAndAfter(checkingDy, checkingIndex);
                break;
            }
            case MAX_LIMIT_ADVANCE: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyMaxAdvanceLimit(checkingDy, checkingIndex);
                break;
            }
            case REPEAT: {
                billCheckResult = this.otApplyBillAssemblyResultService.checkRepeat(checkingDy, checkingIndex, true);
                break;
            }
            case BASERANGE: {
                ArrayList<RuleConditionBillDateRangeDto> dateRangeDtos = new ArrayList<RuleConditionBillDateRangeDto>(1);
                this.otApplyBillAssemblyResultService.collectMatchData(checkingDy, checkingIndex, 1, dateRangeDtos);
                List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
                billCheckResult = this.otApplyBillAssemblyResultService.verifyBaseDateRange(checkingDy, checkingIndex, ruleConditionRetrievals);
                break;
            }
            case LARGETZERO: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyLargerZero(checkingDy, checkingIndex);
                break;
            }
            case APPLY_SPAN: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyApplySpan(checkingDy, checkingIndex);
                break;
            }
            case WORK_EXPERIENCE: {
                billCheckResult = this.otApplyBillAssemblyResultService.verifyWorkExperience(checkingDy, checkingIndex);
            }
        }
        return billCheckResult;
    }

    public BillCheckResult getDutyDate(DynamicObject checkingDy, Integer checkingIndex) {
        return this.otApplyBillAssemblyResultService.getDutyDate(checkingDy, checkingIndex);
    }

    public List<Tuple<DutyShift, Shift>> getDutyShiftsRange(DynamicObject checkingBillDy, Integer checkIndex) {
        return this.otApplyBillAssemblyResultService.getDutyShiftsRange(checkingBillDy, checkIndex);
    }

    public BillCheckResult getPolicy(DynamicObject checkingDy, Integer checkingIndex) {
        return this.otApplyBillAssemblyResultService.getPolicy(checkingDy, checkingIndex);
    }

    public BillCheckResult getEntryOtBucket(DynamicObject checkingDy, Integer checkingIndex, boolean containAllOperatingDy) {
        return this.otApplyBillAssemblyResultService.getOtBucket(checkingDy, checkingIndex, containAllOperatingDy);
    }

    public Set<Long> getAllOTType(DynamicObject checkingDy) {
        return this.otApplyBillAssemblyResultService.getOtTypeInAttFile(checkingDy);
    }

    @Deprecated
    public List<Long> getCompensateTypeDefId(DynamicObject checkingDy, Integer checkingIndex) {
        DynamicObject calDy = this.otApplyBillAssemblyResultService.getCalDy(checkingDy, checkingIndex);
        ArrayList<Long> compenList = new ArrayList<Long>(10);
        if (calDy != null) {
            DynamicObjectCollection subEntryColl = calDy.getDynamicObjectCollection("overworkcaldetail");
            if (CollectionUtils.isEmpty((Collection)subEntryColl)) {
                return new ArrayList<Long>(10);
            }
            for (DynamicObject subEntry : subEntryColl) {
                Long compenId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)subEntry, (String)"otcompenmode");
                if (compenId == null || compenId == 0L) continue;
                compenList.add(compenId);
            }
        }
        return compenList;
    }

    public List<Long> getCompensateTypeDefIdNew(DynamicObject checkingDy, Integer checkingIndex, List<RuleConditionRetrieval> retrievals) {
        DynamicObject calDy = this.otApplyBillAssemblyResultService.getCalDy(checkingDy, checkingIndex, retrievals);
        ArrayList<Long> compenList = new ArrayList<Long>(10);
        if (calDy != null) {
            DynamicObjectCollection subEntryColl = calDy.getDynamicObjectCollection("overworkcaldetail");
            if (CollectionUtils.isEmpty((Collection)subEntryColl)) {
                return new ArrayList<Long>(10);
            }
            for (DynamicObject subEntry : subEntryColl) {
                Long compenId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)subEntry, (String)"otcompenmode");
                if (compenId == null || compenId == 0L) continue;
                compenList.add(compenId);
            }
        }
        return compenList;
    }

    @Deprecated
    public Boolean getCompensateIsEmpChose(DynamicObject checkingDy, Integer checkingIndex) {
        DynamicObject calDy = this.otApplyBillAssemblyResultService.getCalDy(checkingDy, checkingIndex);
        if (calDy == null) {
            return null;
        }
        return calDy.getBoolean("isempchoice");
    }

    public Boolean getCompensateIsEmpChoseNew(DynamicObject checkingDy, Integer checkingIndex, List<RuleConditionRetrieval> retrievals) {
        DynamicObject calDy = this.otApplyBillAssemblyResultService.getCalDy(checkingDy, checkingIndex, retrievals);
        if (calDy == null) {
            return null;
        }
        return calDy.getBoolean("isempchoice");
    }

    public static int getIntSdTime(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0;
        }
        BigDecimal start = new BigDecimal(startTime.getTime());
        BigDecimal end = new BigDecimal(endTime.getTime());
        return end.subtract(start).divide(new BigDecimal(1000), 4, 4).intValue();
    }

    public static String getTimeStr(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return "";
        }
        long start = startTime.getTime();
        long end = endTime.getTime();
        BigDecimal otTime = BigDecimal.valueOf(end).subtract(BigDecimal.valueOf(start));
        return OTBillHelper.getTimeStr(otTime);
    }

    public static String getTimeBySec(int sec) {
        if (sec < 0) {
            return "";
        }
        return OTBillHelper.getTimeStr(new BigDecimal(sec + "").multiply(BigDecimal.valueOf(1000L)));
    }

    public static String getTimeStr(BigDecimal time) {
        return OTBillHelper.getTimeStrWithUnit(time, "h ", "min");
    }

    public static String getTimeStrWithUnit(BigDecimal time, String hourStr, String secStr) {
        time = time.divide(BigDecimal.valueOf(1000L), 6, 4);
        BigDecimal[] hourAndMin = time.divideAndRemainder(BigDecimal.valueOf(3600L));
        int min = 0;
        int hour = 0;
        if (hourAndMin.length > 0) {
            hour = hourAndMin[0].intValue();
        }
        if (hourAndMin.length > 1) {
            min = hourAndMin[hourAndMin.length - 1].divide(BigDecimal.valueOf(60L), 0, RoundingMode.HALF_UP).intValue();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (hour != 0) {
            stringBuilder.append(hour).append(hourStr);
        }
        if (min != 0) {
            stringBuilder.append(min).append(secStr);
        }
        return stringBuilder.toString();
    }

    public static DynamicObject getEntryDyByBillDy(DynamicObject billDy, int index) {
        if (billDy == null) {
            return null;
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
        String entryName = entryInfo.get("ENTRY_NAME");
        DynamicObjectCollection dynamicObjectCollection = billDy.getDynamicObjectCollection(entryName);
        if (dynamicObjectCollection.size() < index + 1) {
            return null;
        }
        return (DynamicObject)dynamicObjectCollection.get(index);
    }

    public OTApplyBillAssemblyResultService getOtApplyBillAssemblyResultService() {
        return this.otApplyBillAssemblyResultService;
    }
}

