/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.common.enums.ApplyBillCheckMsgEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OTBillStyleService {
    private static final Set<String> REFRESH_OP = Sets.newHashSet((Object[])new String[]{"save", "unsubmit", "submit", "submiteffect", "discard"});

    private OTBillStyleService() {
    }

    public static OTBillStyleService getInstance() {
        return SingletonInstance.SINGLETON;
    }

    public void handleSingleStyle(IFormView billView, String openPage) {
        if (billView == null) {
            return;
        }
        IDataModel model = billView.getModel();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(model.getDataEntity(true));
        if (openSingleStyle) {
            DynamicObjectCollection collection = this.getOTEntryColl(billView);
            if (collection != null && collection.size() > 0) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                param.putAll(singleTypeService.convertValToMap(dynamicObject));
            }
            param.put("otapplytype", model.getValue("otapplytype"));
            singleTypeService.openSingleFlex(billView, param, model.getDataEntity(true), openPage, (Set)Sets.newHashSet((Object[])new String[]{OtApplyTypeEnum.OT_SC.getCode(), OtApplyTypeEnum.OT_SD.getCode(), "flexpanelap9999", "flexpanelap91"}));
        }
    }

    public DynamicObjectCollection getOTEntryColl(IFormView billView) {
        if (billView == null) {
            return null;
        }
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        String applyType = dataEntity.getString("otapplytype");
        DynamicObjectCollection collection = null;
        if (OtApplyTypeEnum.OT_SC.getNum().equals(applyType)) {
            collection = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
        } else if (OtApplyTypeEnum.OT_SD.getNum().equals(applyType)) {
            collection = dataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
        }
        return collection;
    }

    public void changeSingleFlexStatus(IFormView parentView, AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (parentView == null) {
            return;
        }
        FormOperate source = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = source.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && REFRESH_OP.contains(operateKey)) {
            boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(parentView.getModel().getDataEntity(true));
            String singlePageId = parentView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
            IFormView singleView = parentView.getView(singlePageId);
            if (openSingleStyle && singleView != null) {
                singleView.setStatus(parentView.getFormShowParameter().getStatus());
                OTBillStyleService.getInstance().setParentViewValToSingleModel(parentView, singleView);
                parentView.sendFormAction(singleView);
                singleView.getModel().setDataChanged(false);
                parentView.getModel().setDataChanged(false);
            }
        }
    }

    public void singleBeforeCloseEvent(IFormView billView, BeforeClosedEvent event, AbstractBillPlugIn billPlugIn) {
        if (billView == null) {
            return;
        }
        try {
            billView.getModel().getDataEntity();
        }
        catch (KDException exception) {
            return;
        }
        HashSet unNotify = Sets.newHashSet((Object[])new String[]{"avoidscdelete", "avoidsddelete", "scmobileentryfield", "billentryname_long", "sdmobileentryfield", "billentryname_seg", "derson", "dutydate", "dperson", "intottime", "ottime", "otdstarttime", "otdendtime", "otdutydate"});
        IDataModel model = billView.getModel();
        BillStyleService singleTypeService = BillStyleService.getInstance();
        boolean openSingleStyle = singleTypeService.isOpenSingleStyle(model.getDataEntity(true));
        String singlePageId = billView.getPageCache().get("CACHE_SINGLE_FLEX_PAGE_ID");
        IFormView singleView = billView.getView(singlePageId);
        if (openSingleStyle && singleView != null) {
            DynamicObjectCollection otEntryColl = OTBillStyleService.getInstance().getOTEntryColl(billView);
            if (otEntryColl == null || otEntryColl.size() == 0) {
                return;
            }
            DynamicObject entryDy = (DynamicObject)otEntryColl.get(0);
            HashMap<String, LocaleString> fieldAndName = new HashMap<String, LocaleString>(16);
            for (IDataEntityProperty property : entryDy.getDataEntityType().getProperties()) {
                LocaleString displayName;
                if (unNotify.contains(property.getName()) || (displayName = property.getDisplayName()) == null) continue;
                fieldAndName.put(property.getAlias(), displayName);
            }
            DataEntityState dataEntityState = entryDy.getDataEntityState();
            Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
            HashSet<String> changeField = new HashSet<String>(16);
            for (IDataEntityProperty bizChangedProperty : bizChangedProperties) {
                LocaleString displayName = (LocaleString)fieldAndName.get(bizChangedProperty.getAlias());
                if (displayName == null) continue;
                changeField.add(displayName.getLocaleValue());
            }
            model.getDataChanged();
            if (CollectionUtils.isNotEmpty(changeField)) {
                event.setCancel(true);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)billPlugIn);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"OTBillSingleStyleService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OTBillSingleStyleService_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.OKCancel;
                String msg = ResManager.loadKDString((String)"\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"OTBillSingleStyleService_2", (String)"wtc-wtom-business", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OTBillSingleStyleService_3", (String)"wtc-wtom-business", (Object[])new Object[0]);
                msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
                String changeBegin = ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a", (String)"OTBillSingleStyleService_4", (String)"wtc-wtom-business", (Object[])new Object[0]);
                String info = changeBegin + String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCommonSymbol(), changeField);
                billView.showConfirm(msg, info, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            }
        }
    }

    public String getSingleEmpty(String ... keys) {
        HashMap<String, String> keyTipVal = new HashMap<String, String>(16);
        keyTipVal.put("sdottype", ApplyBillCheckMsgEnum.SDOTTYPE.getMsg());
        keyTipVal.put("otstartdate", ApplyBillCheckMsgEnum.OTSTARTDATE.getMsg());
        keyTipVal.put("otenddate", ApplyBillCheckMsgEnum.OTENDDATE.getMsg());
        keyTipVal.put("scottype", ApplyBillCheckMsgEnum.SCOTTYPE.getMsg());
        keyTipVal.put("otdate", ApplyBillCheckMsgEnum.OTDATE.getMsg());
        keyTipVal.put("otdtime", ApplyBillCheckMsgEnum.OTDTIME.getMsg());
        String notEmpty = ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OTBillSingleStyleService_5", (String)"wtc-wtom-business", (Object[])new Object[0]);
        ArrayList<String> unPassKey = new ArrayList<String>(10);
        for (String key : keys) {
            String name = (String)keyTipVal.get(key);
            if (!HRStringUtils.isNotEmpty((String)name)) continue;
            unPassKey.add(name);
        }
        if (WTCCollections.isEmpty(unPassKey)) {
            return "";
        }
        String keysVal = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), unPassKey);
        return MessageFormat.format(notEmpty, keysVal);
    }

    public void setParentViewValToSingleModel(IFormView parentView, IFormView singleView) {
        if (parentView == null || singleView == null) {
            return;
        }
        HashMap param = new HashMap(16);
        BillStyleService singleTypeService = BillStyleService.getInstance();
        DynamicObjectCollection collection = OTBillStyleService.getInstance().getOTEntryColl(parentView);
        if (collection != null && collection.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)collection.get(0);
            param.putAll(singleTypeService.convertValToMap(dynamicObject));
        }
        singleTypeService.setModelVal(singleView, param, Collections.emptySet(), -1);
    }

    private static class SingletonInstance {
        private static final OTBillStyleService SINGLETON = new OTBillStyleService();

        private SingletonInstance() {
        }
    }
}

