/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OtUnUsedInfo;

public class OTBillVerifyAllHelper
extends OTBillHelper {
    private List<OTCheckTypeEnum> scBeforeDutyDayCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.LARGETZERO, OTCheckTypeEnum.OVER24INONEBILL, OTCheckTypeEnum.REPEATINONEBILL, OTCheckTypeEnum.EACHDATESHIFT});
    private List<OTCheckTypeEnum> scBeforeRuleCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.WORK_EXPERIENCE, OTCheckTypeEnum.SHIFT, OTCheckTypeEnum.EXISTDUTYDATE, OTCheckTypeEnum.DUTYAUTH, OTCheckTypeEnum.SUSPEND, OTCheckTypeEnum.FROZEN, OTCheckTypeEnum.PLANS, OTCheckTypeEnum.RULE, OTCheckTypeEnum.BASESET});
    private List<OTCheckTypeEnum> scAfterRuleCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.MINOT, OTCheckTypeEnum.ADVANCE_AND_AFTER, OTCheckTypeEnum.MAX_LIMIT_ADVANCE, OTCheckTypeEnum.APPLY_SPAN, OTCheckTypeEnum.REASON, OTCheckTypeEnum.SCFLXS});
    private List<OTCheckTypeEnum> sdBeforeDutyDayCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.LARGERTIME, OTCheckTypeEnum.OVER24INONEBILL, OTCheckTypeEnum.REPEATINONEBILL, OTCheckTypeEnum.INSHIF, OTCheckTypeEnum.EACHDATESHIFT, OTCheckTypeEnum.EXISTDUTYDATE});
    private List<OTCheckTypeEnum> sdBeforeRuleCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.WORK_EXPERIENCE, OTCheckTypeEnum.DUTYAUTH, OTCheckTypeEnum.SHIFT, OTCheckTypeEnum.SUSPEND, OTCheckTypeEnum.FROZEN, OTCheckTypeEnum.PLANS, OTCheckTypeEnum.RULE, OTCheckTypeEnum.BASESET});
    private List<OTCheckTypeEnum> sdAfterRuleCheckEvent = Lists.newArrayList((Object[])new OTCheckTypeEnum[]{OTCheckTypeEnum.ADVANCE_AND_AFTER, OTCheckTypeEnum.MAX_LIMIT_ADVANCE, OTCheckTypeEnum.APPLY_SPAN, OTCheckTypeEnum.MINOT, OTCheckTypeEnum.FLXS, OTCheckTypeEnum.REASON});

    @Deprecated
    public OTBillVerifyAllHelper(DynamicObject[] billDys, List<OTCheckTypeEnum> unCheckEvent, String attFileF7AuthEntity) {
        super(billDys, attFileF7AuthEntity);
        this.init(unCheckEvent);
    }

    public OTBillVerifyAllHelper(DynamicObject[] billDys, List<OTCheckTypeEnum> unCheckEvent, UnifyBillApplyAttr attr) {
        super(billDys, attr);
        this.init(unCheckEvent);
    }

    private void init(List<OTCheckTypeEnum> unCheckEvent) {
        this.scBeforeDutyDayCheckEvent.removeAll(unCheckEvent);
        this.scBeforeRuleCheckEvent.removeAll(unCheckEvent);
        this.scAfterRuleCheckEvent.removeAll(unCheckEvent);
        this.sdBeforeDutyDayCheckEvent.removeAll(unCheckEvent);
        this.sdBeforeRuleCheckEvent.removeAll(unCheckEvent);
        this.sdAfterRuleCheckEvent.removeAll(unCheckEvent);
    }

    public Map<Long, BillCheckResult> checkBeforeDutyDate(boolean needCheckBoAuth, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        if (needCheckBoAuth) {
            for (DynamicObject billDy : this.billDys) {
                long billId = billDy.getLong("id");
                OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
                if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) continue;
                BillCheckResult billCheckResult = this.otApplyBillAssemblyResultService.existAttFileAuth(billDy);
                resultMap.put(billDy.getLong("id"), billCheckResult);
            }
        }
        return this.checkAllDyEvent(resultMap, this.sdBeforeDutyDayCheckEvent, this.scBeforeDutyDayCheckEvent, unCheckInfoMap);
    }

    @Deprecated
    public Map<Long, BillCheckResult> checkBeforeDutyDate(boolean needCheckBoAuth) {
        return this.checkBeforeDutyDate(needCheckBoAuth, Collections.emptyMap());
    }

    public Map<Long, BillCheckResult> checkBeforeBaseInfo(Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            resultMap.put(billDy.getLong("id"), BillCheckResult.success());
        }
        return this.checkAllDyEvent(resultMap, this.sdBeforeRuleCheckEvent, this.scBeforeRuleCheckEvent, unCheckInfoMap);
    }

    public Map<Long, BillCheckResult> checkAfterBaseInfo(Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            resultMap.put(billDy.getLong("id"), BillCheckResult.success());
        }
        return this.checkAllDyEvent(resultMap, this.sdAfterRuleCheckEvent, this.scAfterRuleCheckEvent, unCheckInfoMap);
    }

    private Map<Long, BillCheckResult> checkAllDyEvent(Map<Long, BillCheckResult> resultMap, List<OTCheckTypeEnum> sdEvent, List<OTCheckTypeEnum> scEvent, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        for (DynamicObject billDy : this.billDys) {
            this.checkAllDyEvent(resultMap, sdEvent, scEvent, billDy, unCheckInfoMap);
        }
        return resultMap;
    }

    private void checkAllDyEvent(Map<Long, BillCheckResult> resultMap, List<OTCheckTypeEnum> sdEvent, List<OTCheckTypeEnum> scEvent, DynamicObject billDy, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        long billId = billDy.getLong("id");
        OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
        if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) {
            return;
        }
        Long pkId = billDy.getLong("id");
        BillCheckResult billCheckResult = resultMap.get(pkId);
        List<Object> needCheck = Collections.emptyList();
        String otApplyType = billDy.getString("otapplytype");
        if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
            needCheck = sdEvent;
        } else if (OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)) {
            needCheck = scEvent;
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
        DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
        List uncheckIndex = otOpUnCheckInfo == null || CollectionUtils.isEmpty((Collection)otOpUnCheckInfo.getUnCheckIndex()) ? Collections.emptyList() : otOpUnCheckInfo.getUnCheckIndex();
        block0: for (int j = 0; j < entry.size(); ++j) {
            if (uncheckIndex.contains(j)) continue;
            for (OTCheckTypeEnum oTCheckTypeEnum : needCheck) {
                BillCheckResult oriBillCheckResult = this.checkEntry(oTCheckTypeEnum, billDy, j);
                billCheckResult = OTApplyBillAssemblyResultService.mergeBillCheckResult(billCheckResult, oriBillCheckResult);
                resultMap.put(billDy.getLong("id"), billCheckResult);
                if (oriBillCheckResult == null || oriBillCheckResult.isVerifyResult()) continue;
                continue block0;
            }
        }
    }

    public Map<Long, BillCheckResult> checkAllTimeBucket(boolean containAllOperatingDy, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            long billId = billDy.getLong("id");
            OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
            if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) continue;
            BillCheckResult initResult = BillCheckResult.success();
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
            if (OtApplyTypeEnum.OT_SD.getCode().equals(entryInfo.get("ENTRY_NAME"))) continue;
            DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
            List uncheckIndex = otOpUnCheckInfo == null || CollectionUtils.isEmpty((Collection)otOpUnCheckInfo.getUnCheckIndex()) ? Collections.emptyList() : otOpUnCheckInfo.getUnCheckIndex();
            for (int j = 0; j < entry.size(); ++j) {
                if (uncheckIndex.contains(j)) continue;
                BillCheckResult otBucket = this.otApplyBillAssemblyResultService.getOtBucket(billDy, j, containAllOperatingDy);
                initResult = OTApplyBillAssemblyResultService.mergeBillCheckResult(initResult, otBucket);
            }
            resultMap.put(billDy.getLong("id"), initResult);
        }
        return resultMap;
    }

    @Deprecated
    public Map<Long, BillCheckResult> checkAllTimeBucket(boolean containAllOperatingDy) {
        return this.checkAllTimeBucket(containAllOperatingDy, Collections.emptyMap());
    }

    public Map<Long, BillCheckResult> checkAllTime(boolean containAllOperatingDy, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            long billId = billDy.getLong("id");
            OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
            if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) continue;
            resultMap.put(billDy.getLong("id"), BillCheckResult.success());
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
            DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
            BillCheckResult result = BillCheckResult.success();
            List uncheckIndex = otOpUnCheckInfo == null || CollectionUtils.isEmpty((Collection)otOpUnCheckInfo.getUnCheckIndex()) ? Collections.emptyList() : otOpUnCheckInfo.getUnCheckIndex();
            for (int j = 0; j < entry.size(); ++j) {
                if (uncheckIndex.contains(j)) continue;
                BillCheckResult over24 = this.otApplyBillAssemblyResultService.verifyOver24(billDy, j, containAllOperatingDy);
                resultMap.put(billDy.getLong("id"), over24);
                result = OTApplyBillAssemblyResultService.mergeBillCheckResult(result, over24);
                if (!over24.isVerifyResult()) continue;
                BillCheckResult repeat = this.otApplyBillAssemblyResultService.checkRepeat(billDy, j, containAllOperatingDy);
                result = OTApplyBillAssemblyResultService.mergeBillCheckResult(result, repeat);
            }
            resultMap.put(billDy.getLong("id"), result);
        }
        return resultMap;
    }

    @Deprecated
    public Map<Long, BillCheckResult> checkAllTime(boolean containAllOperatingDy) {
        return this.checkAllTime(containAllOperatingDy, Collections.emptyMap());
    }

    public Map<Long, BillCheckResult> checkDateRange(Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        ArrayList<RuleConditionBillDateRangeDto> dateRangeDtos = new ArrayList<RuleConditionBillDateRangeDto>(this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            long billId = billDy.getLong("id");
            OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
            if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) continue;
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
            DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
            List uncheckIndex = otOpUnCheckInfo == null || CollectionUtils.isEmpty((Collection)otOpUnCheckInfo.getUnCheckIndex()) ? Collections.emptyList() : otOpUnCheckInfo.getUnCheckIndex();
            for (int j = 0; j < entry.size(); ++j) {
                if (uncheckIndex.contains(j)) continue;
                this.otApplyBillAssemblyResultService.collectMatchData(billDy, j, 1, dateRangeDtos);
            }
        }
        List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        for (DynamicObject billDy : this.billDys) {
            long billId = billDy.getLong("id");
            OtUnUsedInfo otOpUnCheckInfo = unCheckInfoMap.get(billId);
            if (otOpUnCheckInfo != null && !otOpUnCheckInfo.isNeedCheck()) continue;
            resultMap.put(billDy.getLong("id"), BillCheckResult.success());
            Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
            String entryKey = entryInfo.get("ENTRY_NAME");
            DynamicObjectCollection entry = billDy.getDynamicObjectCollection(entryKey);
            List uncheckIndex = otOpUnCheckInfo == null || CollectionUtils.isEmpty((Collection)otOpUnCheckInfo.getUnCheckIndex()) ? Collections.emptyList() : otOpUnCheckInfo.getUnCheckIndex();
            for (int j = 0; j < entry.size(); ++j) {
                if (uncheckIndex.contains(j)) continue;
                BillCheckResult baseDateRange = this.otApplyBillAssemblyResultService.verifyBaseDateRange(billDy, j, ruleConditionRetrievals);
                BillCheckResult oldResult = (BillCheckResult)resultMap.get(billDy.getLong("id"));
                if (oldResult != null) {
                    baseDateRange = OTApplyBillAssemblyResultService.mergeBillCheckResult(oldResult, baseDateRange);
                }
                resultMap.put(billDy.getLong("id"), baseDateRange);
            }
        }
        return resultMap;
    }

    public Map<Long, BillCheckResult> checkAttachmentFile() {
        return this.checkAttachmentFile(true, null);
    }

    public Map<Long, BillCheckResult> checkAttachmentFile(boolean isFromList, List<Map<String, Object>> billAttachments) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)this.billDys.length);
        if (this.billDys.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> attachments = new HashMap<String, List<Map<String, Object>>>(16);
        if (isFromList) {
            Object[] pkIds = Arrays.stream(this.billDys).map(DataEntityBase::getPkValue).distinct().toArray();
            Set<String> entityByOtBillDy = this.getEntityByOtBillDy(this.billDys);
            for (String entity : entityByOtBillDy) {
                Map attachmentsInfo = AttachmentServiceHelper.getAttachments((String)entity, (Object[])pkIds, (String)"attachmentpanel", (boolean)false);
                if (CollectionUtils.isEmpty((Map)attachmentsInfo)) continue;
                attachments.putAll(attachmentsInfo);
            }
        } else {
            DynamicObject billDy = this.billDys[0];
            long billId = billDy.getLong("id");
            if (WTCCollections.isNotEmpty(billAttachments)) {
                attachments.put(String.valueOf(billId), billAttachments);
            }
        }
        for (DynamicObject billDy : this.billDys) {
            String[] formatArr;
            BillCheckResult result = BillCheckResult.success();
            List attachmentFiles = (List)attachments.get(billDy.getPkValue().toString());
            if (attachmentFiles == null) {
                resultMap.put(billDy.getLong("id"), this.otApplyBillAssemblyResultService.verifyAttachmentFile(billDy, Collections.emptyList()));
                continue;
            }
            ArrayList info = Lists.newArrayListWithExpectedSize((int)attachmentFiles.size());
            BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
            String attachmentFormat = billSystemParam.getAttachmentFormat();
            HashSet<String> formatSet = new HashSet<String>(16);
            if (HRStringUtils.isNotEmpty((String)attachmentFormat)) {
                for (String type : formatArr = attachmentFormat.split(",")) {
                    if (!HRStringUtils.isNotEmpty((String)type)) continue;
                    formatSet.add(type.toLowerCase(Locale.ROOT));
                }
            }
            formatArr = attachmentFiles.iterator();
            while (formatArr.hasNext()) {
                Map stringObjectMap = (Map)formatArr.next();
                Object size = stringObjectMap.get("size");
                BigDecimal fileSize = BigDecimal.valueOf(Long.parseLong(size.toString())).divide(BigDecimal.valueOf(0x100000L), 2, RoundingMode.HALF_UP);
                info.add(fileSize);
                String name = stringObjectMap.getOrDefault("name", "");
                String type = name.substring(name.lastIndexOf(".") + 1);
                if (CollectionUtils.isEmpty(formatSet) || formatSet.contains(type.toLowerCase(Locale.ROOT))) continue;
                String tip = ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u4e0d\u652f\u6301{0}\u62d3\u5c55\u540d\u6587\u4ef6\u3002", (String)"OTBillVerifyAllHelper_0", (String)"wtc-wtom-business", (Object[])new Object[0]);
                String tipInfo = MessageFormat.format(tip, type);
                BillCheckResult fail = BillCheckResult.fail((Integer)-1, (String)tipInfo, (String)OTCheckTypeEnum.ATTACHMENT.getCheckType());
                result = OTApplyBillAssemblyResultService.mergeBillCheckResult(result, fail);
            }
            BillCheckResult billCheckResult = this.otApplyBillAssemblyResultService.verifyAttachmentFile(billDy, info);
            if (!billCheckResult.isVerifyResult()) {
                result = OTApplyBillAssemblyResultService.mergeBillCheckResult(result, billCheckResult);
            }
            resultMap.put(billDy.getLong("id"), result);
        }
        return resultMap;
    }

    private Set<String> getEntityByOtBillDy(DynamicObject[] billDys) {
        LinkedHashSet needQueryAttachmentEntity = Sets.newLinkedHashSetWithExpectedSize((int)2);
        for (DynamicObject billDy : this.billDys) {
            if (needQueryAttachmentEntity.size() == 2) break;
            String applyType = billDy.getString("applytyperadio");
            if (BillApplyTypeEnum.OTHER.getCode().equals(applyType)) {
                needQueryAttachmentEntity.add("wtom_overtimeapplybill");
                continue;
            }
            if (!BillApplyTypeEnum.SELF.getCode().equals(applyType)) continue;
            needQueryAttachmentEntity.add("wtom_otbillself");
        }
        return needQueryAttachmentEntity;
    }
}

