/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTApplyValidateAndUpdateHelper;
import kd.wtc.wtom.business.OTBillVerifyAllHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OtUnUsedInfo;

public class OTValidateService {
    private static final Log logger = LogFactory.getLog(OTValidateService.class);
    private final List<Map<Long, BillCheckResult>> allErrorInfo = new ArrayList<Map<Long, BillCheckResult>>(10);
    private final Map<String, String> variables;
    private DynamicObject[] dataEntities;
    private String appId;
    private static Set<String> MUST_REQUIRE_VAL = Sets.newHashSet((Object[])new String[]{"id", "attfile", "attfilebasef7", "personid", "applytyperadio", "ischange", "isnewbill", "originalid", "parent", "iscancel", "otapplytype"});
    private static Set<String> SD_MUST_REQUIRE_VAL = Sets.newHashSet((Object[])new String[]{"sdottype", "otstartdate", "otenddate"});
    private static Set<String> SC_MUST_REQUIRE_VAL = Sets.newHashSet((Object[])new String[]{"scottype", "otdate", "otdtime"});

    public OTValidateService(DynamicObject[] dataEntities, String appId, Map<String, String> variables) {
        ArrayList<DynamicObject> filter = new ArrayList<DynamicObject>(10);
        if (dataEntities != null) {
            for (DynamicObject dataEntity : dataEntities) {
                if (dataEntity == null) continue;
                filter.add(dataEntity);
            }
        }
        this.dataEntities = filter.toArray(new DynamicObject[0]);
        this.appId = appId;
        if (variables == null) {
            variables = new HashMap<String, String>(16);
        }
        this.variables = variables;
    }

    public Map<Long, BillCheckResult> verifyAll() {
        this.validateProcess();
        return this.mergeResult();
    }

    private Map<Long, BillCheckResult> mergeResult() {
        HashMap<Long, BillCheckResult> afterMerge = new HashMap<Long, BillCheckResult>(16);
        for (Map<Long, BillCheckResult> resultMap : this.allErrorInfo) {
            for (Map.Entry<Long, BillCheckResult> idAndCheck : resultMap.entrySet()) {
                if (idAndCheck.getValue() == null) continue;
                BillCheckResult billCheckResult = (BillCheckResult)afterMerge.get(idAndCheck.getKey());
                if (billCheckResult == null) {
                    afterMerge.put(idAndCheck.getKey(), idAndCheck.getValue());
                    continue;
                }
                afterMerge.put(idAndCheck.getKey(), OTApplyBillAssemblyResultService.mergeBillCheckResult(billCheckResult, idAndCheck.getValue()));
            }
        }
        HashMap<Long, BillCheckResult> afterMergeWithFail = new HashMap<Long, BillCheckResult>(16);
        for (Map.Entry idAndResult : afterMerge.entrySet()) {
            BillCheckResult value = (BillCheckResult)idAndResult.getValue();
            if (value.isVerifyResult()) continue;
            afterMergeWithFail.put((Long)idAndResult.getKey(), (BillCheckResult)idAndResult.getValue());
        }
        return afterMergeWithFail;
    }

    private void validateProcess() {
        List<Map<Long, BillCheckResult>> failCheckMustInputList = this.handleMustInput();
        this.allErrorInfo.addAll(failCheckMustInputList);
        HashSet<Long> failCheckMustInput = new HashSet<Long>(16);
        for (Map<Long, BillCheckResult> resultMap : failCheckMustInputList) {
            failCheckMustInput.addAll(resultMap.keySet());
        }
        HashMap<Long, OtUnUsedInfo> pkIdAndUnCheckInfo = new HashMap<Long, OtUnUsedInfo>(16);
        String attFileF7AuthEntity = "";
        if (this.dataEntities.length > 0) {
            attFileF7AuthEntity = this.dataEntities[0].getDataEntityType().getName();
        }
        ArrayList billDyList = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Long billPkId;
            DynamicObject billDy = this.dataEntities[i];
            boolean isChange = billDy.getBoolean("ischange");
            if (isChange || failCheckMustInput.contains(billPkId = Long.valueOf(this.dataEntities[i].getLong("id")))) continue;
            billDyList.add(billDy);
        }
        DynamicObject[] billArr = billDyList.toArray(new DynamicObject[0]);
        OTApplyValidateAndUpdateHelper.initId(billArr);
        OTApplyValidateAndUpdateHelper.updateTimeToZeroSec(billArr);
        UnifyBillApplyAttr attr = new UnifyBillApplyAttr();
        logger.info("OTValidateService_validateProcess this.appId = {}", (Object)this.appId);
        attr.setAttFileF7AuthAppId(this.appId);
        attr.setAttFileF7AuthEntity(attFileF7AuthEntity);
        attr.setAttFileAuthField("attfilebasef7");
        OTBillVerifyAllHelper billHelper = new OTBillVerifyAllHelper(billArr, Collections.emptyList(), attr);
        Map<Long, BillCheckResult> beforeDutyCheckMap = billHelper.checkBeforeDutyDate(false, pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(beforeDutyCheckMap, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess beforeDutyCheckMap = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(beforeDutyCheckMap), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        OTApplyValidateAndUpdateHelper.updateDutyInfo(billArr, billHelper, pkIdAndUnCheckInfo);
        this.validateAndUpdateTimeInfo(billArr, attr, pkIdAndUnCheckInfo);
        Map<Long, BillCheckResult> beforeRuleInfo = billHelper.checkBeforeBaseInfo(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(beforeRuleInfo, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess beforeRuleInfo = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(beforeRuleInfo), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        Map<Long, BillCheckResult> afterRuleInfo = billHelper.checkAfterBaseInfo(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(afterRuleInfo, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess afterRuleInfo = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(afterRuleInfo), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        Map<Long, BillCheckResult> dataRangeResult = billHelper.checkDateRange(pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(dataRangeResult, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess dataRangeResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(dataRangeResult), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        boolean isImport = this.isImport();
        logger.info("OTValidateService_validateProcess isImport = {} ", (Object)isImport);
        Map<Long, BillCheckResult> compendResult = OTApplyValidateAndUpdateHelper.updateCompensate(billArr, billHelper, !isImport, pkIdAndUnCheckInfo);
        this.saveFailReasonAndFailData(compendResult, pkIdAndUnCheckInfo);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess compendResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(compendResult), (Object)JSON.toJSONString(pkIdAndUnCheckInfo));
        }
        if (this.variables != null && !isImport) {
            boolean isFromList = HRStringUtils.equals((String)this.variables.get("LIST_OP"), (String)"LIST_OP_TRUE");
            String billAttachmentStr = this.variables.get("wtc_bill_attachment");
            List billAttachments = null;
            if (HRStringUtils.isNotEmpty((String)billAttachmentStr)) {
                billAttachments = SerializationUtils.fromJsonStringToList((String)billAttachmentStr, Map.class);
            }
            this.saveFailReasonAndFailData(billHelper.checkAttachmentFile(isFromList, (List<Map<String, Object>>)billAttachments), pkIdAndUnCheckInfo);
        }
    }

    private List<Map<Long, BillCheckResult>> handleMustInput() {
        String tip = ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OTValidateService_0", (String)"wtc-wtom-business", (Object[])new Object[0]);
        ArrayList<Map<Long, BillCheckResult>> result = new ArrayList<Map<Long, BillCheckResult>>(10);
        for (DynamicObject dataEntity : this.dataEntities) {
            HashMap<Long, BillCheckResult> oneBill;
            long billId = dataEntity.getLong("id");
            for (String val : MUST_REQUIRE_VAL) {
                Object obj = dataEntity.get(val);
                if (obj != null) continue;
                oneBill = new HashMap<Long, BillCheckResult>(16);
                oneBill.put(billId, BillCheckResult.fail((Integer)-1, (String)MessageFormat.format(tip, val), (String)OTCheckTypeEnum.MUST_INPUT.getCheckType()));
                result.add(oneBill);
            }
            if (WTCCollections.isNotEmpty(result)) {
                return result;
            }
            String applyType = dataEntity.getString("otapplytype");
            Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(applyType);
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(entryInfoByType.get("ENTRY_NAME"));
            if (WTCCollections.isEmpty((Collection)entryColl)) {
                oneBill = new HashMap(16);
                oneBill.put(billId, BillCheckResult.fail((Integer)-1, (String)ResManager.loadKDString((String)"\u52a0\u73ed\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"OTValidateService_1", (String)"wtc-wtom-business", (Object[])new Object[0]), (String)OTCheckTypeEnum.MUST_INPUT.getCheckType()));
                result.add(oneBill);
                return result;
            }
            Set<String> entryVerify = null;
            if (applyType.equals(OtApplyTypeEnum.OT_SD.getNum())) {
                entryVerify = SD_MUST_REQUIRE_VAL;
            } else if (applyType.equals(OtApplyTypeEnum.OT_SC.getNum())) {
                entryVerify = SC_MUST_REQUIRE_VAL;
            }
            if (entryVerify == null) continue;
            for (String verifyEvent : entryVerify) {
                for (int index = 0; index < entryColl.size(); ++index) {
                    if (((DynamicObject)entryColl.get(index)).get(verifyEvent) != null) continue;
                    HashMap<Long, BillCheckResult> oneBill2 = new HashMap<Long, BillCheckResult>(16);
                    oneBill2.put(billId, BillCheckResult.fail((Integer)index, (String)MessageFormat.format(tip, verifyEvent), (String)OTCheckTypeEnum.MUST_INPUT.getCheckType()));
                    result.add(oneBill2);
                }
            }
        }
        return result;
    }

    private void validateAndUpdateTimeInfo(DynamicObject[] billDys, UnifyBillApplyAttr attr, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        boolean isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.variables.get("importtag_of_datasource"));
        OTBillVerifyAllHelper timeBucketCheckHelper = new OTBillVerifyAllHelper(billDys, Collections.emptyList(), attr);
        Map<Long, BillCheckResult> timeBucket = timeBucketCheckHelper.checkAllTimeBucket(!isImport, unCheckInfoMap);
        this.saveFailReasonAndFailData(timeBucket, unCheckInfoMap);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess timeBucket = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(timeBucket), (Object)JSON.toJSONString(unCheckInfoMap));
        }
        OTApplyValidateAndUpdateHelper.updateOtBucket(billDys, timeBucketCheckHelper, unCheckInfoMap, !isImport);
        OTBillVerifyAllHelper timeCheckHelper = new OTBillVerifyAllHelper(billDys, Collections.emptyList(), attr);
        Map<Long, BillCheckResult> timeResult = timeCheckHelper.checkAllTime(!isImport, unCheckInfoMap);
        this.saveFailReasonAndFailData(timeResult, unCheckInfoMap);
        if (logger.isDebugEnabled()) {
            logger.debug("OTValidateService_validateProcess timeResult = {} pkIdAndUnCheckInfo = {}", (Object)JSON.toJSONString(timeResult), (Object)JSON.toJSONString(unCheckInfoMap));
        }
    }

    private void saveFailReasonAndFailData(Map<Long, BillCheckResult> checkResultMap, Map<Long, OtUnUsedInfo> unCheckInfoMap) {
        if (CollectionUtils.isEmpty(checkResultMap)) {
            return;
        }
        this.allErrorInfo.add(checkResultMap);
        for (Map.Entry<Long, BillCheckResult> checkResult : checkResultMap.entrySet()) {
            Set failEntryIndexList;
            Long billId = checkResult.getKey();
            OtUnUsedInfo otUnUsedInfo = unCheckInfoMap.computeIfAbsent(billId, key -> new OtUnUsedInfo());
            BillCheckResult value = checkResult.getValue();
            if (value == null || value.isVerifyResult() || CollectionUtils.isEmpty((Collection)(failEntryIndexList = value.getFailEntryIndexList()))) continue;
            if (otUnUsedInfo.isNeedCheck() && failEntryIndexList.contains(-1)) {
                otUnUsedInfo.setNeedCheck(false);
            }
            for (Integer failIndex : failEntryIndexList) {
                if (failIndex == -1) continue;
                otUnUsedInfo.getUnCheckIndex().add(failIndex);
            }
        }
    }

    private boolean isImport() {
        boolean isImport = false;
        if (this.variables.containsKey("importtag_of_datasource")) {
            isImport = HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)this.variables.get("importtag_of_datasource"));
        }
        return isImport;
    }
}

