/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.check;

import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucketResult;
import kd.wtc.wtbs.business.util.signcard.SignCardHelper;
import kd.wtc.wtbs.common.enums.overwork.OtTimeBucketResultEnum;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.model.evaluation.ShiftDetail;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.common.model.otapply.AttFileDutyDateShift;

@Deprecated
public class EnoughTimeCheck {
    private static final Log log = LogFactory.getLog(OTApplyUtil.class);
    private static final Long MILLIS = 1000L;

    private EnoughTimeCheck() {
        throw new IllegalStateException("Utility class");
    }

    public static List<OtTimeBucketResult> getOtTimeBucketResult(OTApplyBillInitData otApplyBillInitData, List<AttFileDutyDateShift> attFileDutyDateShifts) {
        if (otApplyBillInitData == null) {
            return Collections.emptyList();
        }
        List<DynamicObject> scEntryDys = otApplyBillInitData.getScOperatingOtBillList();
        if (CollectionUtils.isEmpty(scEntryDys)) {
            return Collections.emptyList();
        }
        ArrayList<Long> attFileBoIdList = new ArrayList<Long>(otApplyBillInitData.getAttFileBoIdSet());
        Date minBelongDate = OTApplyUtil.getMinBelongDate(scEntryDys, -1);
        Date maxBelongDate = OTApplyUtil.getMaxBelongDate(scEntryDys, 1);
        List<DynamicObject> sEntryDys = otApplyBillInitData.getSdOperatingOtBillList();
        DynamicObject[] sentryWorkBills = otApplyBillInitData.getSdFromDBOtBillArr();
        sEntryDys.addAll(Arrays.asList(sentryWorkBills));
        Map<Date, Map<Long, List<OtTimeBucket>>> sentryMap = EnoughTimeCheck.getBillGroupByPersonAndDate(minBelongDate, maxBelongDate, "1", sEntryDys);
        DynamicObject[] scentryWorkBills = otApplyBillInitData.getScFromDBOtBillArr();
        Map<Date, Map<Long, List<OtTimeBucket>>> scentryMap = EnoughTimeCheck.getBillGroupByPersonAndDate(minBelongDate, maxBelongDate, "2", Arrays.asList(scentryWorkBills));
        ArrayList otTimeBucketResultList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList otTimeBucketList = Lists.newArrayListWithExpectedSize((int)16);
        log.info("personIdSet= {}, minBelongDate = {} maxBelongDate = {}, otApplyBillInitData = {}", new Object[]{attFileBoIdList, minBelongDate, maxBelongDate, otApplyBillInitData});
        for (DynamicObject dynamicObject : scEntryDys) {
            DynamicObjectCollection entryDynamicObjectCollection = dynamicObject.getDynamicObjectCollection("scentry");
            if (CollectionUtils.isEmpty((Collection)entryDynamicObjectCollection)) continue;
            EnoughTimeCheck.dealBillEntryData(dynamicObject, attFileDutyDateShifts, otTimeBucketList, entryDynamicObjectCollection, otTimeBucketResultList, scentryMap, sentryMap);
        }
        log.info("personIdSet= {}, minBelongDate = {} maxBelongDate = {}, otTimeBucketResultList = {}", new Object[]{attFileBoIdList, minBelongDate, maxBelongDate, JSON.toJSON((Object)otTimeBucketResultList)});
        return otTimeBucketResultList;
    }

    private static void dealBillEntryData(DynamicObject dynamicObject, List<AttFileDutyDateShift> attFileDutyDateShifts, List<OtTimeBucket> otTimeBucketList, DynamicObjectCollection entryDynamicObjectCollection, List<OtTimeBucketResult> otTimeBucketResultList, Map<Date, Map<Long, List<OtTimeBucket>>> scentryMap, Map<Date, Map<Long, List<OtTimeBucket>>> sentryMap) {
        Long personId = dynamicObject.getLong("personid.id");
        Long attFileBoId = dynamicObject.getLong("attfile.id");
        Long dynamicId = dynamicObject.getLong("id");
        for (DynamicObject dy : entryDynamicObjectCollection) {
            Date belongDate = dy.getDate("otdate");
            if (belongDate == null) {
                OtTimeBucket emptyOtTimeBucket = new OtTimeBucket();
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET, (OtTimeBucket)emptyOtTimeBucket));
                continue;
            }
            OtTimeBucket otTimeBucketDy = EnoughTimeCheck.getOtTimeBucket(WTCDateUtils.toLocalDateTime((Date)dy.getDate("otdstarttime")), WTCDateUtils.toLocalDateTime((Date)dy.getDate("otdendtime")), dynamicId, dy.getLong("id"), personId, WTCDateUtils.toLocalDateTime((Date)belongDate));
            log.info("EnoughTimeCheck.dealBillEntryData after getOtTimeBucket = {}", (Object)JSON.toJSONString((Object)otTimeBucketDy));
            AttFileDutyDateShift attFileDutyDateShift = EnoughTimeCheck.matchShiftInfo(attFileDutyDateShifts, attFileBoId, belongDate);
            Shift shift = attFileDutyDateShift == null ? null : attFileDutyDateShift.getShift();
            log.info("EnoughTimeCheck.dealBillEntryData attFileBoId = {},belongDate={},shift = {}", new Object[]{attFileBoId, belongDate, shift == null});
            if (shift == null) {
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_SHIFT, (OtTimeBucket)otTimeBucketDy));
                continue;
            }
            log.info("EnoughTimeCheck.dealBillEntryData  shift.getShiftType={},shift.getCheckCardTimes()={},shift.getName()={},shift.isOff()={},                    shift.getOffNonPlan()={},shift.getLastRefStartDay()={},shift.getLastRefEndDay() ={} ", new Object[]{shift.getShiftType(), shift.getCheckCardTimes(), shift.getName(), shift.isOff(), shift.getOffNonPlan(), shift.getLastRefStartDay(), shift.getLastRefEndDay()});
            LocalDateTime otDayLeaveWorkTime = EnoughTimeCheck.getOtDayLeaveWorkTime(shift, personId, belongDate, sentryMap, scentryMap);
            if (shift.getOffNonPlan() && otDayLeaveWorkTime == null) {
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET, (OtTimeBucket)otTimeBucketDy));
                continue;
            }
            Date nextDate = HRDateTimeUtils.addDay((Date)belongDate, (long)1L);
            Date afterNextDate = HRDateTimeUtils.addDay((Date)nextDate, (long)1L);
            AttFileDutyDateShift nextAttFileDutyDateShift = EnoughTimeCheck.matchShiftInfo(attFileDutyDateShifts, attFileBoId, nextDate);
            Shift nextShift = nextAttFileDutyDateShift == null ? null : nextAttFileDutyDateShift.getShift();
            AttFileDutyDateShift afterAttFileDutyDateShift = EnoughTimeCheck.matchShiftInfo(attFileDutyDateShifts, attFileBoId, afterNextDate);
            Shift afterNextShift = afterAttFileDutyDateShift == null ? null : afterAttFileDutyDateShift.getShift();
            LocalDateTime nextDayStartWorkTime = EnoughTimeCheck.getNextDayStartWorkTime(nextShift, afterNextShift, personId, nextDate, sentryMap, scentryMap);
            List<OtTimeBucket> otTimeBucketSentryList = EnoughTimeCheck.getBillByPersonAndDate(belongDate, personId, sentryMap, scentryMap).stream().filter(ob -> ob.getStartTime() != null && ob.getEndTime() != null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(otTimeBucketList)) {
                otTimeBucketSentryList.addAll(otTimeBucketList.stream().filter(ob -> ob.getWorkTime().compareTo(WTCDateUtils.toLocalDateTime((Date)belongDate)) == 0).collect(Collectors.toList()));
            }
            otTimeBucketSentryList.sort(Comparator.comparing(OtTimeBucket::getStartTime));
            log.info("belongDate={},personId={},otDayLeaveWorkTime={},nextDayStartWorkTime={},otTimeBucketSentryList={}", new Object[]{belongDate, personId, otDayLeaveWorkTime, nextDayStartWorkTime, JSON.toJSON(otTimeBucketSentryList)});
            List<OtTimeBucket> canUseList = EnoughTimeCheck.getCanUseList(otDayLeaveWorkTime, nextDayStartWorkTime, otTimeBucketSentryList, personId);
            log.info("canUseList={}", JSON.toJSON(canUseList));
            int otTime = dy.getInt("otdtime");
            OtTimeBucket otTimeBucket = EnoughTimeCheck.getEnoughOtTimeBucket(canUseList, otTime, dynamicId, dy.getLong("id"), personId, belongDate);
            if (otTimeBucket == null) {
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_ENOUGH_ENABLE_TIMEBUCKET, (OtTimeBucket)otTimeBucketDy));
                continue;
            }
            otTimeBucketList.add(otTimeBucket);
            otTimeBucketResultList.add(OtTimeBucketResult.getSuccessResult((OtTimeBucket)otTimeBucket));
        }
    }

    private static OtTimeBucket getEnoughOtTimeBucket(List<OtTimeBucket> canUseList, int otTime, Long billId, Long entryId, Long personId, Date belongDate) {
        for (OtTimeBucket info : canUseList) {
            long seconds = Duration.between(info.getStartTime(), info.getEndTime()).toMillis();
            if ((long)otTime * MILLIS > seconds) continue;
            LocalDateTime otStartTime = info.getStartTime();
            return EnoughTimeCheck.getOtTimeBucket(otStartTime, otStartTime.plusSeconds(otTime), billId, entryId, personId, WTCDateUtils.toLocalDateTime((Date)belongDate));
        }
        return null;
    }

    private static LocalDateTime getNextDayStartWorkTime(Shift nextShift, Shift afterNextShift, Long personId, Date nextDate, Map<Date, Map<Long, List<OtTimeBucket>>> sentryMap, Map<Date, Map<Long, List<OtTimeBucket>>> scentryMap) {
        LocalDateTime nextDayStartWorkTime = null;
        if (nextShift == null || nextShift.isOff() && nextShift.getOffNonPlan()) {
            nextDayStartWorkTime = WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getDayLastDate((Date)nextDate));
        } else if (nextShift.isOff() && !nextShift.getOffNonPlan() && afterNextShift != null && !afterNextShift.isOff()) {
            Date afterNextDate = HRDateTimeUtils.addDay((Date)nextDate, (long)1L);
            List<OtTimeBucket> nextOtTimeBucketSentryList = EnoughTimeCheck.getBillByPersonAndDate(afterNextDate, personId, sentryMap, scentryMap);
            LocalDateTime afterNextMaxDate = EnoughTimeCheck.getMinBillDate(nextOtTimeBucketSentryList);
            List nextShiftDetailList = afterNextShift.getShiftDetailList();
            ShiftDetail shiftDetail = (ShiftDetail)nextShiftDetailList.get(0);
            shiftDetail.setCheckDate(afterNextDate);
            LocalDateTime shiftStartLocalDate = WTCDateUtils.toLocalDateTime((Date)shiftDetail.getAbsoluteShiftStartDate());
            afterNextMaxDate = afterNextMaxDate == null ? shiftStartLocalDate : afterNextMaxDate;
            nextDayStartWorkTime = afterNextMaxDate.isBefore(shiftStartLocalDate) ? afterNextMaxDate : shiftStartLocalDate;
        } else if (nextShift.isOff() && !nextShift.getOffNonPlan() && (afterNextShift == null || afterNextShift.isOff())) {
            nextDayStartWorkTime = WTCDateUtils.toLocalDateTime((Date)HRDateTimeUtils.addDay((Date)nextDate, (long)2L));
        } else {
            List nextShiftDetailList = nextShift.getShiftDetailList();
            if (!CollectionUtils.isEmpty((Collection)nextShiftDetailList)) {
                ShiftDetail shiftDetail = (ShiftDetail)nextShiftDetailList.get(0);
                shiftDetail.setCheckDate(nextDate);
                nextDayStartWorkTime = WTCDateUtils.toLocalDateTime((Date)shiftDetail.getAbsoluteShiftStartDate());
            }
        }
        if (nextShift != null) {
            List<OtTimeBucket> nextOtTimeBucketSentryList = EnoughTimeCheck.getBillByPersonAndDate(nextDate, personId, sentryMap, scentryMap);
            LocalDateTime nextMaxDate = EnoughTimeCheck.getMinBillDate(nextOtTimeBucketSentryList);
            if (nextDayStartWorkTime != null && nextMaxDate != null && nextMaxDate.isBefore(nextDayStartWorkTime)) {
                nextDayStartWorkTime = nextMaxDate;
            }
        }
        return nextDayStartWorkTime;
    }

    private static LocalDateTime getOtDayLeaveWorkTime(Shift shift, Long personId, Date belongDate, Map<Date, Map<Long, List<OtTimeBucket>>> sentryMap, Map<Date, Map<Long, List<OtTimeBucket>>> scentryMap) {
        LocalDateTime otDayLeaveWorkTime = null;
        if (!shift.isOff()) {
            List shiftDetailList = shift.getShiftDetailList();
            if (!CollectionUtils.isEmpty((Collection)shiftDetailList)) {
                ShiftDetail shiftDetail = (ShiftDetail)shiftDetailList.get(shiftDetailList.size() - 1);
                shiftDetail.setCheckDate(belongDate);
                otDayLeaveWorkTime = WTCDateUtils.toLocalDateTime((Date)shiftDetail.getAbsoluteShiftEndDate());
            }
        } else {
            List shiftDetailList;
            LocalDateTime effectCard = EnoughTimeCheck.getFirstEffCard(personId, belongDate);
            if (effectCard != null) {
                otDayLeaveWorkTime = effectCard;
            } else if (!shift.getOffNonPlan() && !CollectionUtils.isEmpty((Collection)(shiftDetailList = shift.getShiftDetailList()))) {
                ShiftDetail shiftDetail = (ShiftDetail)shiftDetailList.get(0);
                shiftDetail.setCheckDate(belongDate);
                otDayLeaveWorkTime = WTCDateUtils.toLocalDateTime((Date)shiftDetail.getAbsoluteShiftStartDate());
            }
        }
        if (log.isInfoEnabled()) {
            log.info("getOtDayLeaveWorkTime_otDayLeaveWorkTime:{}", (Object)otDayLeaveWorkTime);
        }
        List<OtTimeBucket> preOtTimeBucketSentryList = EnoughTimeCheck.getBillByPersonAndDate(HRDateTimeUtils.addDay((Date)belongDate, (long)-1L), personId, sentryMap, scentryMap);
        LocalDateTime preMaxDate = EnoughTimeCheck.getMaxBillDate(preOtTimeBucketSentryList);
        if (log.isInfoEnabled()) {
            log.info("getOtDayLeaveWorkTime_preMaxDate:{}", (Object)preMaxDate);
        }
        if (otDayLeaveWorkTime != null && preMaxDate != null && preMaxDate.compareTo(otDayLeaveWorkTime) > 0) {
            otDayLeaveWorkTime = preMaxDate;
            if (log.isInfoEnabled()) {
                log.info("getOtDayLeaveWorkTime_preMaxDate replaceBy  preMaxDate:{}", (Object)preMaxDate);
            }
        }
        return otDayLeaveWorkTime;
    }

    private static LocalDateTime getMinBillDate(List<OtTimeBucket> otTimeBucketSentryList) {
        return CollectionUtils.isEmpty(otTimeBucketSentryList) ? null : (LocalDateTime)otTimeBucketSentryList.stream().filter(ob -> ob.getStartTime() != null).map(OtTimeBucket::getStartTime).distinct().min(LocalDateTime::compareTo).orElse(null);
    }

    private static LocalDateTime getMaxBillDate(List<OtTimeBucket> otTimeBucketSentryList) {
        return CollectionUtils.isEmpty(otTimeBucketSentryList) ? null : (LocalDateTime)otTimeBucketSentryList.stream().filter(ob -> ob.getEndTime() != null).map(OtTimeBucket::getEndTime).distinct().max(LocalDateTime::compareTo).orElse(null);
    }

    private static Map<Date, Map<Long, List<OtTimeBucket>>> getBillGroupByPersonAndDate(Date startDate, Date endDate, String applyType, List<DynamicObject> workApplyBills) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        Date belongDate = WTCDateUtils.getZeroDate((Date)startDate);
        while (belongDate.compareTo(endDate) <= 0) {
            List<OtTimeBucket> otTimeBucketList = EnoughTimeCheck.getOtTimeBucketGroupByBelongDate(belongDate, workApplyBills, applyType);
            if (!CollectionUtils.isEmpty(otTimeBucketList)) {
                map.put(belongDate, otTimeBucketList);
            }
            belongDate = HRDateTimeUtils.addDay((Date)belongDate, (long)1L);
        }
        HashMap personDateDy = Maps.newHashMapWithExpectedSize((int)16);
        map.forEach((key, value) -> personDateDy.put(key, value.stream().collect(Collectors.groupingBy(OtTimeBucket::getPresonId))));
        return personDateDy;
    }

    private static List<OtTimeBucket> getBillByPersonAndDate(Date date, Long personId, Map<Date, Map<Long, List<OtTimeBucket>>> sentryMap, Map<Date, Map<Long, List<OtTimeBucket>>> scentryMap) {
        Date belongDate = WTCDateUtils.getZeroDate((Date)date);
        Map<Long, List<OtTimeBucket>> otTimeBucketSentryMap = sentryMap.get(belongDate);
        Map<Long, List<OtTimeBucket>> otTimeBucketScentryMap = scentryMap.get(belongDate);
        ArrayList<OtTimeBucket> otTimeBucketSentryList = new ArrayList<OtTimeBucket>(CollectionUtils.isEmpty(otTimeBucketSentryMap) || otTimeBucketSentryMap.get(personId) == null ? Collections.emptyList() : (Collection)otTimeBucketSentryMap.get(personId));
        List otTimeBucketScentryList = CollectionUtils.isEmpty(otTimeBucketScentryMap) || otTimeBucketScentryMap.get(personId) == null ? Collections.emptyList() : otTimeBucketScentryMap.get(personId);
        otTimeBucketSentryList.addAll(otTimeBucketScentryList);
        return otTimeBucketSentryList;
    }

    private static List<OtTimeBucket> getOtTimeBucketGroupByBelongDate(Date belongDate, List<DynamicObject> workApplyBills, String applyType) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : workApplyBills) {
            String entryKey = HRStringUtils.equals((String)"2", (String)applyType) ? "scentry" : "sdentry";
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
            String belongDateKey = HRStringUtils.equals((String)"2", (String)applyType) ? "otdate" : "otdutydate";
            String startDateKey = HRStringUtils.equals((String)"2", (String)applyType) ? "otdstarttime" : "otstartdate";
            String endDateKey = HRStringUtils.equals((String)"2", (String)applyType) ? "otdendtime" : "otenddate";
            List belongDateDy = dynamicObjectCollection.stream().filter(ob -> belongDate.compareTo(ob.getDate(belongDateKey)) == 0).collect(Collectors.toList());
            for (DynamicObject dy : belongDateDy) {
                list.add(EnoughTimeCheck.getOtTimeBucket(WTCDateUtils.toLocalDateTime((Date)dy.getDate(startDateKey)), WTCDateUtils.toLocalDateTime((Date)dy.getDate(endDateKey)), dynamicObject.getLong("id"), dy.getLong("id"), dynamicObject.getLong("personid.id"), WTCDateUtils.toLocalDateTime((Date)belongDate)));
            }
        }
        return list;
    }

    private static List<OtTimeBucket> getCanUseList(LocalDateTime otDayLeaveWorkTime, LocalDateTime nextDayStartWorkTime, List<OtTimeBucket> existStartEndList, Long personId) {
        if (otDayLeaveWorkTime == null || nextDayStartWorkTime == null) {
            return Collections.emptyList();
        }
        Map<Object, Object> bucketGroupByPerson = null;
        if (!CollectionUtils.isEmpty(existStartEndList)) {
            bucketGroupByPerson = existStartEndList.stream().collect(Collectors.groupingBy(OtTimeBucket::getPresonId));
        }
        bucketGroupByPerson = bucketGroupByPerson == null ? Collections.emptyMap() : bucketGroupByPerson;
        List existBucketInPerson = (List)bucketGroupByPerson.get(personId);
        ArrayList canUseList = Lists.newArrayListWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty((Collection)existBucketInPerson)) {
            OtTimeBucket info2 = EnoughTimeCheck.getOtTimeBucket(otDayLeaveWorkTime, nextDayStartWorkTime);
            canUseList.add(info2);
        } else {
            List startEndList = existBucketInPerson.stream().filter(ob -> ob.getStartTime() != null && ob.getEndTime() != null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(startEndList)) {
                startEndList.removeIf(next -> next.getEndTime().isBefore(otDayLeaveWorkTime) || next.getEndTime().isEqual(otDayLeaveWorkTime));
            }
            if (CollectionUtils.isEmpty(startEndList)) {
                OtTimeBucket info3 = EnoughTimeCheck.getOtTimeBucket(otDayLeaveWorkTime, nextDayStartWorkTime);
                canUseList.add(info3);
            } else {
                int num = 0;
                for (OtTimeBucket otTimeBucket : startEndList) {
                    LocalDateTime startTime;
                    if (num == 0) {
                        startTime = otDayLeaveWorkTime;
                    } else {
                        OtTimeBucket pre = (OtTimeBucket)startEndList.get(num - 1);
                        startTime = pre.getEndTime();
                    }
                    if (startTime.isBefore(otTimeBucket.getStartTime())) {
                        OtTimeBucket firstOtTimeBucket = EnoughTimeCheck.getOtTimeBucket(startTime, otTimeBucket.getStartTime());
                        canUseList.add(firstOtTimeBucket);
                    }
                    ++num;
                }
                OtTimeBucket last = (OtTimeBucket)startEndList.get(startEndList.size() - 1);
                if (last.getEndTime().isBefore(nextDayStartWorkTime)) {
                    OtTimeBucket lastOtTimeBucket = EnoughTimeCheck.getOtTimeBucket(last.getEndTime(), nextDayStartWorkTime);
                    canUseList.add(lastOtTimeBucket);
                }
            }
        }
        return canUseList.stream().filter(info -> !info.getEndTime().isAfter(nextDayStartWorkTime)).collect(Collectors.toList());
    }

    private static OtTimeBucket getOtTimeBucket(LocalDateTime startTime, LocalDateTime endTime) {
        OtTimeBucket otTimeBucket = new OtTimeBucket();
        otTimeBucket.setStartTime(startTime);
        otTimeBucket.setEndTime(endTime);
        return otTimeBucket;
    }

    private static OtTimeBucket getOtTimeBucket(LocalDateTime startTime, LocalDateTime endTime, Long billId, Long id, Long personId, LocalDateTime workTime) {
        OtTimeBucket otTimeBucket = new OtTimeBucket();
        otTimeBucket.setStartTime(startTime);
        otTimeBucket.setEndTime(endTime);
        otTimeBucket.setBillId(billId.longValue());
        otTimeBucket.setId(id.longValue());
        otTimeBucket.setPresonId(personId.longValue());
        otTimeBucket.setWorkTime(workTime);
        return otTimeBucket;
    }

    private static LocalDateTime getFirstEffCard(Long personId, Date belongDate) {
        Map firstMap = SignCardHelper.getFirstSignPoint(Collections.singleton(personId), (Date)belongDate);
        if (!CollectionUtils.isEmpty((Map)firstMap)) {
            return WTCDateUtils.toLocalDateTime((Date)((Date)firstMap.get(personId)));
        }
        return null;
    }

    private static AttFileDutyDateShift matchShiftInfo(List<AttFileDutyDateShift> oriData, long attFileBoId, Date dutyDate) {
        if (dutyDate == null) {
            return null;
        }
        for (AttFileDutyDateShift oriDatum : oriData) {
            Date oriDutyDate = oriDatum.getDutyDate();
            if (oriDutyDate == null || attFileBoId != oriDatum.getAttFileBoId() || !WTCDateUtils.compareDateWithDayTime((Date)dutyDate, (Date)oriDutyDate)) continue;
            return oriDatum;
        }
        return null;
    }
}

