/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.check;

import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucketResult;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.signcard.SignCardHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.overwork.OtTimeBucketResultEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.wtabm.common.entity.VaValidateTimeRspModel;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.business.check.OtCalculateBucketReqInfo;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.AttFileDutyDateShift;

public class OtTimeBucketService {
    private static final Log log = LogFactory.getLog(OtTimeBucketService.class);
    private static final Long MILLIS = 1000L;

    public List<OtTimeBucketResult> getOtTimeBucketResult(OtCalculateBucketReqInfo reqInfo) {
        if (reqInfo == null) {
            return Collections.emptyList();
        }
        OTApplyBillInitData otApplyBillInitData = reqInfo.getOtApplyBillInitData();
        List<AttFileDutyDateShift> attFileDutyDateShifts = reqInfo.getAttFileDutyDateShifts();
        Map<Long, List<VaValidateTimeRspModel>> vaValidateTimeRspDtoMap = reqInfo.getVaValidateTimeRspDtoMap();
        if (otApplyBillInitData == null) {
            return Collections.emptyList();
        }
        DynamicObject onlyCheckOperatingDy = reqInfo.getOnlyCheckOperatingDy();
        List<DynamicObject> operatingScDyList = otApplyBillInitData.getScOperatingOtBillList();
        ArrayList finalOperatingScDyList = Lists.newArrayList(operatingScDyList);
        if (onlyCheckOperatingDy != null) {
            finalOperatingScDyList.removeIf(next -> next.getLong("id") != onlyCheckOperatingDy.getLong("id"));
        }
        if (CollectionUtils.isEmpty((Collection)finalOperatingScDyList)) {
            log.info("OtTimeBucketService_getOtTimeBucketResult finalOperatingScDyList is null");
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> finalOperatingSdDyList = new ArrayList<DynamicObject>(10);
        if (onlyCheckOperatingDy == null && CollectionUtils.isNotEmpty(otApplyBillInitData.getSdOperatingOtBillList())) {
            finalOperatingSdDyList.addAll(otApplyBillInitData.getSdOperatingOtBillList());
        }
        DynamicObject[] dbSdDyArr = otApplyBillInitData.getSdFromDBOtBillArr();
        finalOperatingSdDyList.addAll(Arrays.asList(dbSdDyArr));
        Map<String, Date> effectCardInfoForOff = this.getEffectCardInfo(attFileDutyDateShifts);
        Object[] dbScDyArr = otApplyBillInitData.getScFromDBOtBillArr();
        ArrayList<DynamicObject> tripScDataFromOperating = new ArrayList<DynamicObject>(10);
        ArrayList tripStatus = Lists.newArrayList((Object[])new String[]{"B", "C", "D"});
        Iterator iterator = finalOperatingScDyList.iterator();
        while (iterator.hasNext()) {
            DynamicObject dbScDy = (DynamicObject)iterator.next();
            String status = dbScDy.getString("billstatus");
            if (!tripStatus.contains(status)) continue;
            tripScDataFromOperating.add(dbScDy);
            iterator.remove();
        }
        Map<Long, List<DynamicObject>> personIdAndOperatingScDy = Lists.newArrayList((Iterable)finalOperatingScDyList).stream().collect(Collectors.groupingBy(scDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scDy, (String)"personid")));
        ArrayList dbScDyList = Lists.newArrayList((Object[])dbScDyArr);
        dbScDyList.addAll(tripScDataFromOperating);
        Map<Long, List<DynamicObject>> personIdAndDBScDy = dbScDyList.stream().collect(Collectors.groupingBy(scDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scDy, (String)"personid")));
        Map<Long, List<DynamicObject>> personIdAndAllSdDy = finalOperatingSdDyList.stream().collect(Collectors.groupingBy(sdDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)sdDy, (String)"personid")));
        if (vaValidateTimeRspDtoMap == null) {
            vaValidateTimeRspDtoMap = new HashMap<Long, List<VaValidateTimeRspModel>>(16);
        }
        ArrayList<OtTimeBucketResult> result = new ArrayList<OtTimeBucketResult>(10);
        for (Map.Entry<Long, List<DynamicObject>> personIdAndScData : personIdAndOperatingScDy.entrySet()) {
            ArrayList<OtTimeBucket> allExistTimeBucket = new ArrayList<OtTimeBucket>(10);
            Long personId = personIdAndScData.getKey();
            allExistTimeBucket.addAll(OTApplyUtil.getExistTimeBucketByScDy(personIdAndDBScDy.get(personId)));
            allExistTimeBucket.addAll(OTApplyUtil.getExistTimeBucketBySdDy(personIdAndAllSdDy.get(personId)));
            allExistTimeBucket.addAll(OTApplyUtil.getVaBucket(personId, vaValidateTimeRspDtoMap.get(personId)));
            for (DynamicObject operatingScDy : personIdAndScData.getValue()) {
                List<OtTimeBucketResult> otTimeBucketByScEntryDy = this.getOtTimeBucketByScEntryDy(operatingScDy, attFileDutyDateShifts, allExistTimeBucket, effectCardInfoForOff);
                result.addAll(otTimeBucketByScEntryDy);
                allExistTimeBucket.addAll(this.convert2TimeBucket(otTimeBucketByScEntryDy));
            }
        }
        for (DynamicObject dynamicObject : tripScDataFromOperating) {
            List<OtTimeBucket> existTimeBucketByScDy = OTApplyUtil.getExistTimeBucketByScDy(Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
            if (!WTCCollections.isNotEmpty(existTimeBucketByScDy)) continue;
            for (OtTimeBucket otTimeBucket : existTimeBucketByScDy) {
                result.add(OtTimeBucketResult.getSuccessResult((OtTimeBucket)otTimeBucket));
            }
        }
        return result;
    }

    private Map<String, Date> getEffectCardInfo(List<AttFileDutyDateShift> attFileDutyDateShifts) {
        if (CollectionUtils.isEmpty(attFileDutyDateShifts)) {
            return Collections.emptyMap();
        }
        HashSet attFileBoIdSet = Sets.newHashSetWithExpectedSize((int)attFileDutyDateShifts.size());
        HashSet shiftDateSet = Sets.newHashSetWithExpectedSize((int)attFileDutyDateShifts.size());
        for (AttFileDutyDateShift attFileDutyDateShift : attFileDutyDateShifts) {
            attFileBoIdSet.add(attFileDutyDateShift.getAttFileBoId());
            if (attFileDutyDateShift.getShift() == null || !attFileDutyDateShift.getShift().isOff()) continue;
            shiftDateSet.add(attFileDutyDateShift.getDutyDate());
        }
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAttStatus(null);
        attFileQueryParam.setSetBoIds((Set)attFileBoIdSet);
        attFileQueryParam.setProperties("attperson,boid");
        List attFileVersionList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        HashMap personIdAndAttFileMap = Maps.newHashMapWithExpectedSize((int)attFileDutyDateShifts.size());
        for (DynamicObject attFileBoDy : attFileVersionList) {
            long personId = attFileBoDy.getLong("attperson");
            if (personId == 0L) continue;
            Set attFileBoIdInPerson = personIdAndAttFileMap.computeIfAbsent(personId, key -> new HashSet(16));
            attFileBoIdInPerson.add(attFileBoDy.getLong("boid"));
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)shiftDateSet.size());
        for (Date shiftDate : shiftDateSet) {
            Map firstMap = SignCardHelper.getFirstSignPoint(personIdAndAttFileMap.keySet(), (Date)shiftDate);
            for (Map.Entry personIdAndPoint : firstMap.entrySet()) {
                Set attFileBoIdInPerson = (Set)personIdAndAttFileMap.get(personIdAndPoint.getKey());
                attFileBoIdInPerson.forEach(attFileBoId -> {
                    Date cfr_ignored_0 = (Date)result.put(this.getCardPointKey((long)attFileBoId, shiftDate), personIdAndPoint.getValue());
                });
            }
        }
        return result;
    }

    private List<OtTimeBucket> convert2TimeBucket(List<OtTimeBucketResult> otTimeBucketResults) {
        if (CollectionUtils.isEmpty(otTimeBucketResults)) {
            return Collections.emptyList();
        }
        return otTimeBucketResults.stream().map(OtTimeBucketResult::getOtTimeBucket).collect(Collectors.toList());
    }

    private List<OtTimeBucketResult> getOtTimeBucketByScEntryDy(DynamicObject scOtDy, List<AttFileDutyDateShift> attFileDutyDateShifts, List<OtTimeBucket> existTimeBucket, Map<String, Date> effectCardInfoForOff) {
        long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scOtDy, (String)"personid");
        long attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scOtDy, (String)"attfile");
        long billId = scOtDy.getLong("id");
        DynamicObjectCollection entryColl = scOtDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            return Collections.emptyList();
        }
        ArrayList otTimeBucketResultList = Lists.newArrayListWithExpectedSize((int)entryColl.size());
        ArrayList existTimeBucketTmp = Lists.newArrayList(existTimeBucket);
        for (int index = 0; index < entryColl.size(); ++index) {
            DynamicObject entryDy = (DynamicObject)entryColl.get(index);
            OtTimeBucket otTimeBucket = new OtTimeBucket();
            otTimeBucket.setPresonId(personId);
            otTimeBucket.setCheckingIndex(Integer.valueOf(index));
            Date dutyDate = entryDy.getDate("otdate");
            int otTimeSec = entryDy.getInt("otdtime");
            if (dutyDate == null || otTimeSec <= 0) {
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.NOT_ENOUGH_PARAM, (OtTimeBucket)otTimeBucket));
                log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy OtTimeBucketResultEnum.NOT_ENOUGH_PARAM");
                continue;
            }
            AttFileDutyDateShift dutyDateShiftInfo = this.filterShift(attFileBoId, dutyDate, attFileDutyDateShifts);
            AttFileDutyDateShift nextDateShiftInfo = this.filterShift(attFileBoId, WTCDateUtils.addDays((Date)dutyDate, (int)1), attFileDutyDateShifts);
            AttFileDutyDateShift afterNextDateShiftInfo = this.filterShift(attFileBoId, WTCDateUtils.addDays((Date)dutyDate, (int)2), attFileDutyDateShifts);
            if (dutyDateShiftInfo == null || dutyDateShiftInfo.getShift() == null) {
                otTimeBucketResultList.add(OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_SHIFT, (OtTimeBucket)otTimeBucket));
                log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy OtTimeBucketResultEnum.FAIL_NOT_SHIFT");
                continue;
            }
            ArrayList<OtTimeBucket> existBucketEntryTmp = new ArrayList<OtTimeBucket>(10);
            existBucketEntryTmp.addAll(this.getExistBucketByShift(Lists.newArrayList((Object[])new AttFileDutyDateShift[]{dutyDateShiftInfo, nextDateShiftInfo, afterNextDateShiftInfo})));
            existBucketEntryTmp.addAll(existTimeBucketTmp);
            Tuples.Tuple2<LocalDateTime, LocalDateTime> initTimeLine = this.getInitTimeLine(dutyDateShiftInfo, nextDateShiftInfo, afterNextDateShiftInfo, effectCardInfoForOff);
            log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy initTimeLine={}", initTimeLine);
            if (initTimeLine.item1 == null || initTimeLine.item2 == null) {
                otTimeBucket.setBillId(billId);
                otTimeBucket.setId(entryDy.getLong("id"));
                otTimeBucket.setWorkTime(WTCDateUtils.toLocalDateTime((Date)dutyDate));
                OtTimeBucketResult successResult = OtTimeBucketResult.getSuccessResult((OtTimeBucket)otTimeBucket);
                successResult.setResultCode(OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET.getNumber());
                successResult.setResultMsg(OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET.getDesc());
                otTimeBucketResultList.add(successResult);
                log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy OtTimeBucketResultEnum.FAIL_NOT_PLAN_TIMEBUCKET");
                continue;
            }
            TimeInfo timeInfo = new TimeInfo((LocalDateTime)initTimeLine.item1, (LocalDateTime)initTimeLine.item2);
            Tuples.Tuple2<Boolean, List<TimeInfo>> allCanUseTime = this.filterByExistTimeBucket(Lists.newArrayList((Object[])new TimeInfo[]{timeInfo}), existBucketEntryTmp);
            if (log.isDebugEnabled()) {
                log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy timeInfo={},existBucketEntryTmp = {},allCanUseTime={}", new Object[]{timeInfo, JSON.toJSONString(existBucketEntryTmp), JSON.toJSON(allCanUseTime)});
            }
            log.info("OtTimeBucketService_getOtTimeBucketByScEntryDy timeInfo={},existBucketEntryTmp = {},allCanUseTime = {}", new Object[]{timeInfo, existBucketEntryTmp, allCanUseTime.item2});
            OtTimeBucketResult entryDyBucketResult = this.getEntryDyBucketResult(otTimeSec, (List)allCanUseTime.item2, dutyDate, personId, billId, entryDy.getLong("id"));
            otTimeBucketResultList.add(entryDyBucketResult);
            existTimeBucketTmp.add(entryDyBucketResult.getOtTimeBucket());
        }
        return otTimeBucketResultList;
    }

    private List<OtTimeBucket> getExistBucketByShift(List<AttFileDutyDateShift> attFileDutyDateShifts) {
        if (CollectionUtils.isEmpty(attFileDutyDateShifts)) {
            return Collections.emptyList();
        }
        ArrayList<OtTimeBucket> result = new ArrayList<OtTimeBucket>(10);
        for (AttFileDutyDateShift attFileDutyDateShift : attFileDutyDateShifts) {
            if (attFileDutyDateShift == null) continue;
            Shift shift = attFileDutyDateShift.getShift();
            DutyShift dutyShift = attFileDutyDateShift.getDutyShift();
            if (shift == null || dutyShift == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("shift.is off = {},dutyShift.date = {}", (Object)shift.isOff(), (Object)dutyShift.getRosterDate());
            }
            if (shift.isOff()) continue;
            List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(attFileDutyDateShift.getDutyShift(), attFileDutyDateShift.getShift());
            ArrayList unVerifyTypeCodeList = Lists.newArrayList((Object[])new String[]{OutWorkType.BREAK.code, OutWorkType.OT.code});
            for (Tuples.Tuple3<String, Date, Date> shiftInfo : shiftDetailAbsoluteTime) {
                if (unVerifyTypeCodeList.contains(shiftInfo.item1)) continue;
                OtTimeBucket otTimeBucket = new OtTimeBucket();
                if (shiftInfo.item2 != null) {
                    otTimeBucket.setStartTime(WTCDateUtils.toLocalDateTime((Date)((Date)shiftInfo.item2)));
                }
                if (shiftInfo.item3 != null) {
                    otTimeBucket.setEndTime(WTCDateUtils.toLocalDateTime((Date)((Date)shiftInfo.item3)));
                }
                result.add(otTimeBucket);
            }
        }
        log.info("OtTimeBucketService_getExistBucketByShift result={}", result);
        if (log.isDebugEnabled()) {
            try {
                log.debug("OtTimeBucketService_getExistBucketByShift attFileDutyDateShifts={}", (Object)WTCSerializationUtils.toJsonString(attFileDutyDateShifts));
            }
            catch (Exception e) {
                log.debug("OtTimeBucketService_getExistBucketByShift attFileDutyDateShifts to json error");
            }
        }
        return result;
    }

    private OtTimeBucketResult getEntryDyBucketResult(long sec, List<TimeInfo> allCanUseTimeList, Date dutyDate, long personId, Long billId, Long entryId) {
        OtTimeBucket otTimeBucket = new OtTimeBucket();
        otTimeBucket.setBillId(billId.longValue());
        otTimeBucket.setId(entryId.longValue());
        otTimeBucket.setPresonId(personId);
        otTimeBucket.setWorkTime(WTCDateUtils.toLocalDateTime((Date)dutyDate));
        if (CollectionUtils.isEmpty(allCanUseTimeList)) {
            return OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_ENOUGH_ENABLE_TIMEBUCKET, (OtTimeBucket)otTimeBucket);
        }
        for (TimeInfo allCanUseTime : allCanUseTimeList) {
            Duration duration = Duration.between(allCanUseTime.getStartTime(), allCanUseTime.getEndTime());
            long seconds = duration.getSeconds();
            if (seconds < sec) continue;
            otTimeBucket.setStartTime(allCanUseTime.getStartTime());
            otTimeBucket.setEndTime(allCanUseTime.getStartTime().plusSeconds(sec));
            return OtTimeBucketResult.getSuccessResult((OtTimeBucket)otTimeBucket);
        }
        return OtTimeBucketResult.getFailResult((OtTimeBucketResultEnum)OtTimeBucketResultEnum.FAIL_NOT_ENOUGH_ENABLE_TIMEBUCKET, (OtTimeBucket)otTimeBucket);
    }

    private Tuples.Tuple2<Boolean, List<TimeInfo>> filterByExistTimeBucket(List<TimeInfo> needFilterTimeInfo, List<OtTimeBucket> existTimeBucket) {
        ArrayList<TimeInfo> result = new ArrayList<TimeInfo>(10);
        if (CollectionUtils.isEmpty(needFilterTimeInfo)) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, result);
        }
        boolean haveChange = false;
        for (TimeInfo timeInfo : needFilterTimeInfo) {
            LocalDateTime startTime = timeInfo.getStartTime();
            LocalDateTime endTime = timeInfo.getEndTime();
            boolean passAllExistTimeBucket = true;
            for (OtTimeBucket otTimeBucket : existTimeBucket) {
                if (timeInfo.isSplit()) break;
                Tuples.Tuple2<Boolean, List<TimeInfo>> splitTimeLineList = this.splitTimeLine(startTime, endTime, otTimeBucket.getStartTime(), otTimeBucket.getEndTime());
                if (!((Boolean)splitTimeLineList.item1).booleanValue()) continue;
                timeInfo.setSplit(true);
                haveChange = true;
                passAllExistTimeBucket = false;
                result.addAll((Collection)this.filterByExistTimeBucket((List<TimeInfo>)((List)splitTimeLineList.item2), existTimeBucket).item2);
            }
            if (!passAllExistTimeBucket) continue;
            result.add(timeInfo);
        }
        result.sort(new Comparator<TimeInfo>(){

            @Override
            public int compare(TimeInfo o1, TimeInfo o2) {
                LocalDateTime o1Date = o1.getStartTime() == null ? WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getMaxEndDate()) : o1.getStartTime();
                LocalDateTime o2Date = o2.getStartTime() == null ? WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getMaxEndDate()) : o2.getStartTime();
                return o1Date.compareTo(o2Date);
            }
        });
        return new Tuples.Tuple2((Object)haveChange, result);
    }

    private Tuples.Tuple2<Boolean, List<TimeInfo>> splitTimeLine(LocalDateTime startTimeLine, LocalDateTime endTimeLine, LocalDateTime splitStartTimeLine, LocalDateTime splitEndTimeLine) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)10);
        Date start = WTCDateUtils.toDate((LocalDateTime)startTimeLine);
        Date end = WTCDateUtils.toDate((LocalDateTime)endTimeLine);
        Date splitStart = WTCDateUtils.toDate((LocalDateTime)splitStartTimeLine);
        Date splitEnd = WTCDateUtils.toDate((LocalDateTime)splitEndTimeLine);
        if (splitStart == null || splitEnd == null) {
            return new Tuples.Tuple2((Object)Boolean.FALSE, (Object)Lists.newArrayList((Object[])new TimeInfo[]{new TimeInfo(startTimeLine, endTimeLine)}));
        }
        if (WTCDateUtils.betweenTimeEquals((Date)splitStart, (Date)start, (Date)end) && !splitEnd.before(end)) {
            result.add(new TimeInfo(startTimeLine, splitStartTimeLine));
        } else if (WTCDateUtils.betweenTimeEquals((Date)splitStart, (Date)start, (Date)end) && splitEnd.before(end)) {
            result.add(new TimeInfo(startTimeLine, splitStartTimeLine));
            result.add(new TimeInfo(splitEndTimeLine, endTimeLine));
        } else if (splitStart.before(start) && WTCDateUtils.betweenTimeEquals((Date)splitEnd, (Date)start, (Date)end)) {
            result.add(new TimeInfo(splitEndTimeLine, endTimeLine));
        } else if (splitStart.before(start) && splitEnd.before(start)) {
            result.add(new TimeInfo(startTimeLine, endTimeLine));
        } else if (splitStart.before(start) && splitEnd.after(end)) {
            result.add(new TimeInfo(startTimeLine, endTimeLine));
        } else if (splitStart.after(end)) {
            result.add(new TimeInfo(startTimeLine, endTimeLine));
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5207\u5272\u60c5\u51b5\u3002", (String)"OtTimeBucketService_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        boolean haveChange = result.size() != 1 || !((TimeInfo)result.get(0)).getStartTime().equals(startTimeLine) || !((TimeInfo)result.get(0)).getEndTime().equals(endTimeLine);
        return new Tuples.Tuple2((Object)haveChange, result.stream().filter(timeInfo -> !timeInfo.getStartTime().equals(timeInfo.getEndTime())).collect(Collectors.toList()));
    }

    private Tuples.Tuple2<LocalDateTime, LocalDateTime> getInitTimeLine(AttFileDutyDateShift dutyDateShiftInfo, AttFileDutyDateShift nextDateShiftInfo, AttFileDutyDateShift afterNextDateShiftInfo, Map<String, Date> effectCardInfoForOff) {
        List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime;
        LocalDateTime timeLineStart = null;
        Shift shift = dutyDateShiftInfo.getShift();
        DutyShift dutyShift = dutyDateShiftInfo.getDutyShift();
        long attFileBoId = dutyDateShiftInfo.getAttFileBoId();
        Date shiftDate = dutyDateShiftInfo.getDutyDate();
        log.info("OtTimeBucketService_getInitTimeLine shiftDate = {}", (Object)shiftDate);
        if (shift.isOff() && shift.getOffNonPlan()) {
            Date cardPoint = effectCardInfoForOff.get(this.getCardPointKey(attFileBoId, shiftDate));
            log.info("OtTimeBucketService_getInitTimeLine is off,no plan,cardPoint = {}", (Object)cardPoint);
            if (cardPoint == null) {
                return new Tuples.Tuple2(null, null);
            }
            timeLineStart = WTCDateUtils.toLocalDateTime((Date)cardPoint);
        } else if (shift.isOff() && !shift.getOffNonPlan()) {
            shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, shift);
            if (CollectionUtils.isEmpty(shiftDetailAbsoluteTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            Date cardPoint = effectCardInfoForOff.get(this.getCardPointKey(attFileBoId, shiftDate));
            log.info("OtTimeBucketService_getInitTimeLine is off,no havePlan,cardPoint = {}", (Object)cardPoint);
            timeLineStart = cardPoint != null ? WTCDateUtils.toLocalDateTime((Date)cardPoint) : WTCDateUtils.toLocalDateTime((Date)((Date)shiftDetailAbsoluteTime.get((int)0).item2));
        } else {
            log.info("OtTimeBucketService_getInitTimeLine normal shift");
            shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, shift);
            if (CollectionUtils.isEmpty(shiftDetailAbsoluteTime)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            timeLineStart = WTCDateUtils.toLocalDateTime((Date)((Date)shiftDetailAbsoluteTime.get((int)0).item2));
        }
        log.info("OtTimeBucketService_getInitTimeLine timeLineStart = {}", (Object)timeLineStart);
        LocalDateTime timeLineEnd = this.getInitTimeLine_end(dutyDateShiftInfo, nextDateShiftInfo, afterNextDateShiftInfo, timeLineStart);
        return new Tuples.Tuple2((Object)timeLineStart, (Object)timeLineEnd);
    }

    private String getCardPointKey(long attFileBoId, Date shiftDate) {
        return attFileBoId + "" + shiftDate.getTime();
    }

    private LocalDateTime getInitTimeLine_end(AttFileDutyDateShift dutyDateShift, AttFileDutyDateShift nextDateShiftInfo, AttFileDutyDateShift afterNextDateShiftInfo, LocalDateTime timeLineStart) {
        List<Tuples.Tuple3<String, Date, Date>> dutyDateShiftDetail = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyDateShift.getDutyShift(), dutyDateShift.getShift());
        if (nextDateShiftInfo == null || nextDateShiftInfo.getShift() == null) {
            log.info("OtTimeBucketService getInitTimeLine_end enter nextShift is null");
            if (timeLineStart == null) {
                log.warn("\u6570\u636e\u5f02\u5e38\uff0c\u5207\u5272\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002");
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5207\u5272\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_4", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            LocalDateTime addTwentyFour = timeLineStart.plusHours(24L);
            if (WTCCollections.isNotEmpty(dutyDateShiftDetail)) {
                int lastIndex = dutyDateShiftDetail.size() > 1 ? dutyDateShiftDetail.size() - 1 : 0;
                addTwentyFour = WTCDateUtils.toLocalDateTime((Date)((Date)dutyDateShiftDetail.get((int)lastIndex).item3)).plusHours(24L);
            }
            log.info("OtTimeBucketService getInitTimeLine_end addTwentyFour.1  = {}", (Object)addTwentyFour);
            LocalDateTime afterNextShiftBegin = WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getMaxEndDate());
            if (afterNextDateShiftInfo != null && afterNextDateShiftInfo.getShift() != null) {
                List<Tuples.Tuple3<String, Date, Date>> afterNextShiftDetail = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(afterNextDateShiftInfo.getDutyShift(), afterNextDateShiftInfo.getShift());
                Shift afterNextShift = afterNextDateShiftInfo.getShift();
                if (afterNextShift.isOff() && afterNextShift.getOffNonPlan()) {
                    afterNextShiftBegin = WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getDayEnd((Date)afterNextDateShiftInfo.getDutyDate()));
                } else {
                    if (CollectionUtils.isEmpty(afterNextShiftDetail)) {
                        log.warn("\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                        throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
                    }
                    Optional eleFromList = WTCCollectionIndexUtil.getEleFromList(afterNextShiftDetail, (int)0);
                    if (eleFromList.isPresent()) {
                        afterNextShiftBegin = WTCDateUtils.toLocalDateTime((Date)((Date)((Tuples.Tuple3)eleFromList.get()).item2));
                    }
                }
            }
            addTwentyFour = addTwentyFour.isBefore(afterNextShiftBegin) ? addTwentyFour : afterNextShiftBegin;
            log.info("OtTimeBucketService getInitTimeLine_end addTwentyFour.2 = {}", (Object)addTwentyFour);
            return addTwentyFour;
        }
        if (afterNextDateShiftInfo == null || afterNextDateShiftInfo.getShift() == null) {
            log.info("OtTimeBucketService getInitTimeLine_end enter afterNextDateShiftInfo is null");
            if (nextDateShiftInfo.getShift().isOff() && nextDateShiftInfo.getShift().getOffNonPlan()) {
                return WTCDateUtils.toLocalDateTime((Date)WTCDateUtils.getDayEnd((Date)nextDateShiftInfo.getDutyDate()));
            }
            List<Tuples.Tuple3<String, Date, Date>> afterDutyDateShiftDetail = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(nextDateShiftInfo.getDutyShift(), nextDateShiftInfo.getShift());
            if (CollectionUtils.isEmpty(afterDutyDateShiftDetail)) {
                log.warn("\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            int lastIndex = afterDutyDateShiftDetail.size() > 1 ? afterDutyDateShiftDetail.size() - 1 : 0;
            return WTCDateUtils.toLocalDateTime((Date)((Date)afterDutyDateShiftDetail.get((int)lastIndex).item3));
        }
        log.info("OtTimeBucketService getInitTimeLine_end enter normal time line end");
        return this.getNormalTimeLine_end(dutyDateShift, nextDateShiftInfo, afterNextDateShiftInfo);
    }

    private LocalDateTime getNormalTimeLine_end(AttFileDutyDateShift dutyDateShift, AttFileDutyDateShift nextDateShiftInfo, AttFileDutyDateShift afterNextDateShiftInfo) {
        Date shiftDutyDate = dutyDateShift.getDutyDate();
        Shift nextShift = nextDateShiftInfo.getShift();
        Shift afterNextShift = afterNextDateShiftInfo.getShift();
        Date endTime = null;
        if (nextShift.isOff() && afterNextShift.isOff() && afterNextShift.getOffNonPlan()) {
            endTime = WTCDateUtils.getDayEnd((Date)WTCDateUtils.addDays((Date)shiftDutyDate, (int)1));
            log.info("OtTimeBucketService_getNormalTimeLine_end  nextShift.isOff() && afterNextShift.isOff() && afterNextShift.getOffNonPlan(),endTime = {}", (Object)endTime);
        } else if (nextShift.isOff() && (!afterNextShift.isOff() || afterNextShift.isOff() && !afterNextShift.getOffNonPlan())) {
            List<Tuples.Tuple3<String, Date, Date>> afterNextDetail = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(afterNextDateShiftInfo.getDutyShift(), afterNextDateShiftInfo.getShift());
            if (CollectionUtils.isEmpty(afterNextDetail)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            endTime = (Date)afterNextDetail.get((int)0).item2;
            log.info("OtTimeBucketService_getNormalTimeLine_end  nextShift.isOff() && (!afterNextShift.isOff() || (afterNextShift.isOff() && !afterNextShift.getOffNonPlan())) ,afterNextDetail = {},endTime= {}", afterNextDetail, (Object)endTime);
        } else if (!nextShift.isOff() || nextShift.isOff() && !nextShift.getOffNonPlan()) {
            List<Tuples.Tuple3<String, Date, Date>> nextDetail = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(nextDateShiftInfo.getDutyShift(), nextDateShiftInfo.getShift());
            if (CollectionUtils.isEmpty(nextDetail)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u73ed\u6b21\u6570\u636e\u5f02\u5e38\uff0c\u6709\u65f6\u6bb5\u7684\u6570\u636e\u8fd4\u56de\u5206\u6bb5\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtTimeBucketService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            endTime = (Date)nextDetail.get((int)0).item2;
            log.info("OtTimeBucketService_getNormalTimeLine_end  (!nextShift.isOff() || (nextShift.isOff() && !nextShift.getOffNonPlan())) ,nextDetail = {},endTime= {}", nextDetail, (Object)endTime);
        }
        if (endTime == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u65f6\u6bb5\u573a\u666f\u672a\u5904\u7406\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002", (String)"OtTimeBucketService_3", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        return WTCDateUtils.toLocalDateTime((Date)endTime);
    }

    private AttFileDutyDateShift filterShift(long attFileBoId, Date dutyDate, List<AttFileDutyDateShift> attFileDutyDateShifts) {
        if (dutyDate == null) {
            return null;
        }
        List collect = attFileDutyDateShifts.stream().filter(attFileDutyDateShift -> {
            Date shiftDutyDate = attFileDutyDateShift.getDutyDate();
            if (shiftDutyDate == null) {
                return false;
            }
            return attFileDutyDateShift.getAttFileBoId() == attFileBoId && HRDateTimeUtils.format((Date)dutyDate, (String)"yyyy-MM-dd").equals(HRDateTimeUtils.format((Date)shiftDutyDate, (String)"yyyy-MM-dd"));
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return null;
        }
        return (AttFileDutyDateShift)collect.get(0);
    }

    private static class TimeInfo {
        private LocalDateTime startTime;
        private LocalDateTime endTime;
        private boolean isSplit;

        public TimeInfo(LocalDateTime startTime, LocalDateTime endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isSplit = false;
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public void setStartTime(LocalDateTime startTime) {
            this.startTime = startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(LocalDateTime endTime) {
            this.endTime = endTime;
        }

        public boolean isSplit() {
            return this.isSplit;
        }

        public void setSplit(boolean split) {
            this.isSplit = split;
        }

        public String toString() {
            return "TimeInfo{startTime=" + this.startTime + ", endTime=" + this.endTime + ", isSplit=" + this.isSplit + '}';
        }
    }
}

