/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.check;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeBucket;
import kd.wtc.wtbs.business.model.worktimebucket.OtTimeRepeated;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtabm.common.entity.VaValidateTimeRspModel;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.business.check.OtCalculateRepeatReqInfo;

public class OtTimeRepeatedService {
    public Map<Long, List<OtTimeRepeated>> getRepeatedBill(OtCalculateRepeatReqInfo reqInfo) {
        if (reqInfo == null) {
            return Collections.emptyMap();
        }
        OTApplyBillInitData otApplyBillInitData = reqInfo.getOtApplyBillInitData();
        Map<Long, List<VaValidateTimeRspModel>> vaValidateTimeRspDtoMap = reqInfo.getVaValidateTimeRspDtoMap();
        DynamicObject onlyCheckOperatingDy = reqInfo.getOnlyCheckOperatingDy();
        if (otApplyBillInitData == null) {
            return Collections.emptyMap();
        }
        Date minBelongDate = otApplyBillInitData.getStartDate();
        if (minBelongDate == null) {
            return Collections.emptyMap();
        }
        ArrayList<DynamicObject> finalOperatingScDyList = new ArrayList<DynamicObject>(10);
        finalOperatingScDyList.addAll(Lists.newArrayList((Object[])otApplyBillInitData.getScFromDBOtBillArr()));
        ArrayList<DynamicObject> finalOperatingSdDyList = new ArrayList<DynamicObject>(10);
        finalOperatingSdDyList.addAll(Lists.newArrayList((Object[])otApplyBillInitData.getSdFromDBOtBillArr()));
        List<DynamicObject> scOperatingOtBillList = otApplyBillInitData.getScOperatingOtBillList();
        if (onlyCheckOperatingDy != null && CollectionUtils.isNotEmpty(scOperatingOtBillList)) {
            long onlyCheckOperatingDyId = onlyCheckOperatingDy.getLong("id");
            for (DynamicObject dynamicObject : scOperatingOtBillList) {
                if (dynamicObject.getLong("id") != onlyCheckOperatingDyId) continue;
                finalOperatingScDyList.add(dynamicObject);
            }
        } else {
            finalOperatingScDyList.addAll(scOperatingOtBillList);
        }
        List<DynamicObject> sdOperatingOtBillList = otApplyBillInitData.getSdOperatingOtBillList();
        if (onlyCheckOperatingDy != null && CollectionUtils.isNotEmpty(sdOperatingOtBillList)) {
            long onlyCheckOperatingDyId = onlyCheckOperatingDy.getLong("id");
            for (DynamicObject dynamicObject : sdOperatingOtBillList) {
                if (dynamicObject.getLong("id") != onlyCheckOperatingDyId) continue;
                finalOperatingSdDyList.add(dynamicObject);
            }
        } else {
            finalOperatingSdDyList.addAll(sdOperatingOtBillList);
        }
        List<OtTimeBucket> scTimeBucket = OTApplyUtil.getExistTimeBucketByScDy(finalOperatingScDyList);
        List<OtTimeBucket> sdTimeBucket = OTApplyUtil.getExistTimeBucketBySdDy(finalOperatingSdDyList);
        ArrayList<OtTimeBucket> arrayList = new ArrayList<OtTimeBucket>(10);
        for (Map.Entry<Long, List<VaValidateTimeRspModel>> vaInfo : vaValidateTimeRspDtoMap.entrySet()) {
            Long personId = vaInfo.getKey();
            List<VaValidateTimeRspModel> value = vaInfo.getValue();
            arrayList.addAll(OTApplyUtil.getVaBucket(personId, value));
        }
        return this.getOtRepeat(scTimeBucket, sdTimeBucket, arrayList);
    }

    private Map<Long, List<OtTimeRepeated>> getOtRepeat(List<OtTimeBucket> scTimeBucket, List<OtTimeBucket> sdTimeBucket, List<OtTimeBucket> vaBucket) {
        HashMap<Long, List<OtTimeRepeated>> result = new HashMap<Long, List<OtTimeRepeated>>(16);
        ArrayList allInfo = Lists.newArrayList(scTimeBucket);
        allInfo.addAll(sdTimeBucket);
        allInfo.addAll(vaBucket);
        block0: for (OtTimeBucket otTimeBucket : sdTimeBucket) {
            long billId = otTimeBucket.getBillId();
            List otTimeRepeatedList = result.computeIfAbsent(billId, key -> new ArrayList(10));
            long personId = otTimeBucket.getPresonId();
            for (OtTimeBucket compareTimeBucket : allInfo) {
                long verifyBillId = compareTimeBucket.getBillId();
                if (billId == verifyBillId || personId != compareTimeBucket.getPresonId()) continue;
                Tuples.Tuple3<Boolean, Date, Date> verifyResult = this.repeatTime(otTimeBucket, compareTimeBucket);
                if (!((Boolean)verifyResult.item1).booleanValue()) continue;
                OtTimeRepeated repeated = new OtTimeRepeated();
                repeated.setOtRepeatedEnum(compareTimeBucket.getBillBucketEnum());
                repeated.setBillId(Long.valueOf(billId));
                repeated.setEntryIndex(otTimeBucket.getCheckingIndex());
                repeated.setRepeatedStartTime((Date)verifyResult.item2);
                repeated.setRepeatedEndTime((Date)verifyResult.item3);
                repeated.setBillNo(compareTimeBucket.getBillNo());
                otTimeRepeatedList.add(repeated);
                continue block0;
            }
        }
        return result;
    }

    private Tuples.Tuple3<Boolean, Date, Date> repeatTime(OtTimeBucket needVerify, OtTimeBucket compare) {
        Date start = WTCDateUtils.toDate((LocalDateTime)needVerify.getStartTime());
        Date end = WTCDateUtils.toDate((LocalDateTime)needVerify.getEndTime());
        Date splitStart = WTCDateUtils.toDate((LocalDateTime)compare.getStartTime());
        Date splitEnd = WTCDateUtils.toDate((LocalDateTime)compare.getEndTime());
        return OTApplyUtil.repeatTime(start, end, splitStart, splitEnd);
    }
}

