/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

@Deprecated
public class TimeBucketRespectCheck {
    private static final Log log = LogFactory.getLog(OTApplyUtil.class);

    private TimeBucketRespectCheck() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<Long, Set<String>> getRespectBill(OTApplyBillInitData otApplyBillInitData) {
        if (otApplyBillInitData == null) {
            return Collections.emptyMap();
        }
        Date minBelongDate = otApplyBillInitData.getStartDate();
        if (minBelongDate == null) {
            return Collections.emptyMap();
        }
        Date maxBelongDate = otApplyBillInitData.getEndDate();
        Map<Date, Map<Long, List<Tuple<DynamicObject, DynamicObject>>>> scEntryMap = OTApplyUtil.getTupleByPersonAndBgDate(otApplyBillInitData.getScOperatingOtBillList(), otApplyBillInitData.getScFromDBOtBillArr(), minBelongDate, maxBelongDate, "2", true);
        Map<Date, Map<Long, List<Tuple<DynamicObject, DynamicObject>>>> sdEntryMap = OTApplyUtil.getTupleByPersonAndBgDate(otApplyBillInitData.getSdOperatingOtBillList(), otApplyBillInitData.getSdFromDBOtBillArr(), minBelongDate, maxBelongDate, "1", false);
        HashMap allRespectBill = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        dynamicObjectList.addAll(otApplyBillInitData.getScOperatingOtBillList());
        dynamicObjectList.addAll(otApplyBillInitData.getSdOperatingOtBillList());
        log.info("minBelongDate = {} maxBelongDate = {}, otApplyBillInitData = {}", new Object[]{minBelongDate, maxBelongDate, otApplyBillInitData});
        for (DynamicObject dynamicObject : dynamicObjectList) {
            String applyType = dynamicObject.getString("otapplytype");
            Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(applyType);
            String entryKey = entryInfoByType.get("ENTRY_NAME");
            String startDateKey = entryInfoByType.get("START_TIME_NAME");
            String endDateKey = entryInfoByType.get("END_TIME_NAME");
            String belongDateKey = entryInfoByType.get("DUTY_DAY_NAME");
            DynamicObjectCollection entryDynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
            Long personId = dynamicObject.getLong("personid.id");
            Map<Date, List<DynamicObject>> listMap = entryDynamicObjectCollection.stream().filter(ob -> ob.getDate(belongDateKey) != null).collect(Collectors.groupingBy(ob -> ob.getDate(belongDateKey)));
            HashSet respectBill = Sets.newHashSetWithExpectedSize((int)16);
            listMap.forEach((belongDate, dyList) -> dyList.forEach(dy -> {
                List<Tuple<DynamicObject, DynamicObject>> scdys = TimeBucketRespectCheck.getBetweenTwoDaysTuple(belongDate, personId, scEntryMap, dynamicObject);
                List<Tuple<DynamicObject, DynamicObject>> sddys = TimeBucketRespectCheck.getBetweenTwoDaysTuple(belongDate, personId, sdEntryMap, dynamicObject);
                TimeBucketRespectCheck.getRespectTuple(dy.getDate(startDateKey), dy.getDate(endDateKey), scdys, OtApplyTypeEnum.OT_SC.getNum(), respectBill);
                TimeBucketRespectCheck.getRespectTuple(dy.getDate(startDateKey), dy.getDate(endDateKey), sddys, OtApplyTypeEnum.OT_SD.getNum(), respectBill);
            }));
            allRespectBill.put(dynamicObject.getLong("id"), respectBill);
        }
        log.info("minBelongDate = {} maxBelongDate = {}, allRespectBill = {}", new Object[]{minBelongDate, maxBelongDate, allRespectBill});
        return allRespectBill;
    }

    private static List<Tuple<DynamicObject, DynamicObject>> getBetweenTwoDaysTuple(Date belongDate, Long personId, Map<Date, Map<Long, List<Tuple<DynamicObject, DynamicObject>>>> entryMap, DynamicObject dynamicObject) {
        ArrayList dyList = Lists.newArrayListWithExpectedSize((int)16);
        Date subTwoDay = HRDateTimeUtils.addDay((Date)belongDate, (long)-2L);
        Date addTwoDay = HRDateTimeUtils.addDay((Date)belongDate, (long)2L);
        if (CollectionUtils.isEmpty(entryMap)) {
            return Collections.emptyList();
        }
        while (subTwoDay.compareTo(addTwoDay) <= 0) {
            List<Tuple<DynamicObject, DynamicObject>> dyTuple;
            Map<Long, List<Tuple<DynamicObject, DynamicObject>>> personDurationMap = entryMap.get(subTwoDay);
            if (!CollectionUtils.isEmpty(personDurationMap) && !CollectionUtils.isEmpty(dyTuple = personDurationMap.get(personId))) {
                dyList.addAll(dyTuple);
            }
            subTwoDay = HRDateTimeUtils.addDay((Date)subTwoDay, (long)1L);
        }
        return CollectionUtils.isEmpty((Collection)dyList) ? Collections.emptyList() : dyList.stream().filter(ob -> ob.item1 != dynamicObject).collect(Collectors.toList());
    }

    private static void getRespectTuple(Date startDate, Date endDate, List<Tuple<DynamicObject, DynamicObject>> dys, String applyType, Set<String> respectBill) {
        if (startDate == null || endDate == null) {
            return;
        }
        Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(applyType);
        String startDateKey = entryInfoByType.get("START_TIME_NAME");
        String endDateKey = entryInfoByType.get("END_TIME_NAME");
        for (Tuple<DynamicObject, DynamicObject> tuple : dys) {
            Date curStartDate = ((DynamicObject)tuple.item2).getDate(startDateKey);
            Date curEndDate = ((DynamicObject)tuple.item2).getDate(endDateKey);
            if (curStartDate == null || curEndDate == null || startDate.compareTo(curEndDate) >= 0 || endDate.compareTo(curStartDate) <= 0) continue;
            respectBill.add(((DynamicObject)tuple.item1).getString("billno"));
        }
    }
}

