/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtabm.common.entity.VaValidateTimeRspModel;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTApplyBillInitData;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.business.check.OtCalculateTwentyFourReqInfo;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OverTwentyFour;
import kd.wtc.wtom.common.model.otapply.OverTwentyFourVo;

public class TwentyFourCheck {
    private static final Log log = LogFactory.getLog(OTApplyUtil.class);

    private TwentyFourCheck() {
        throw new IllegalStateException("Utility class");
    }

    public static List<OverTwentyFourVo> getBelongAndPersonDuration(OtCalculateTwentyFourReqInfo reqInfo) {
        if (reqInfo == null) {
            return Collections.emptyList();
        }
        OTApplyBillInitData otApplyBillInitData = reqInfo.getOtApplyBillInitData();
        Map<Long, List<VaValidateTimeRspModel>> vaValidateTimeRspDtoMap = reqInfo.getVaValidateTimeRspDtoMap();
        if (otApplyBillInitData == null) {
            return Collections.emptyList();
        }
        Map<String, List<OverTwentyFour>> beforeSumForOtOnProcess = TwentyFourCheck.getOtSumResult(otApplyBillInitData, true, reqInfo.getOnlyCheckOperatingDy());
        List<OverTwentyFour> otSum = TwentyFourCheck.mergeOver24(beforeSumForOtOnProcess, BillTypeEnum.OVERTIMEBILL);
        HashMap beforeSumForVa = Maps.newHashMapWithExpectedSize((int)10);
        Map<String, List<OverTwentyFour>> va24Data = TwentyFourCheck.convertVaBill(vaValidateTimeRspDtoMap);
        for (Map.Entry<String, List<OverTwentyFour>> signatureAndData : va24Data.entrySet()) {
            List overTwentyFourList = beforeSumForVa.computeIfAbsent(signatureAndData.getKey(), key -> new ArrayList(10));
            overTwentyFourList.addAll((Collection)signatureAndData.getValue());
        }
        List<OverTwentyFour> vaSum = TwentyFourCheck.mergeOver24(beforeSumForVa, BillTypeEnum.VACATIONBILL);
        log.info("TwentyFourCheck_getBelongAndPersonDuration otSumAll.size = {}", (Object)vaSum.size());
        HashMap<String, List<OverTwentyFour>> allInfo = new HashMap<String, List<OverTwentyFour>>(16);
        Map<String, List<OverTwentyFour>> beforeSumForOtAll = TwentyFourCheck.getOtSumResult(otApplyBillInitData, false, reqInfo.getOnlyCheckOperatingDy());
        allInfo.putAll(beforeSumForOtAll);
        for (Map.Entry<String, List<OverTwentyFour>> signatureAndData : va24Data.entrySet()) {
            List overTwentyFourList = allInfo.computeIfAbsent(signatureAndData.getKey(), key -> new ArrayList(10));
            overTwentyFourList.addAll((Collection)signatureAndData.getValue());
        }
        List<OverTwentyFour> otAndVaSum = TwentyFourCheck.mergeOver24(allInfo, null);
        log.info("TwentyFourCheck_getBelongAndPersonDuration otAndVaSum.size = {}", (Object)otAndVaSum.size());
        return TwentyFourCheck.mergeResultToVo(otAndVaSum, otSum, vaSum);
    }

    private static Map<String, List<OverTwentyFour>> getOtSumResult(OTApplyBillInitData otApplyBillInitData, boolean onlyOnOProcess, DynamicObject onlyCheckOperatingDy) {
        Object[] scEntryWorkBills = otApplyBillInitData.getScFromDBOtBillArr();
        Object[] sdEntryWorkBills = otApplyBillInitData.getSdFromDBOtBillArr();
        ArrayList entryWorkBill = Lists.newArrayList((Object[])scEntryWorkBills);
        entryWorkBill.addAll(Lists.newArrayList((Object[])sdEntryWorkBills));
        ArrayList<DynamicObject> finalOperatingSdDyList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> finalOperatingScDyList = new ArrayList<DynamicObject>(10);
        if (!onlyOnOProcess) {
            finalOperatingSdDyList.addAll(otApplyBillInitData.getScOperatingOtBillList());
            finalOperatingScDyList.addAll(otApplyBillInitData.getSdOperatingOtBillList());
            if (onlyCheckOperatingDy != null) {
                long onlyUseDyId = onlyCheckOperatingDy.getLong("id");
                Iterator sdIterator = finalOperatingSdDyList.iterator();
                while (sdIterator.hasNext()) {
                    DynamicObject next = (DynamicObject)sdIterator.next();
                    if (next.getLong("id") == onlyUseDyId) continue;
                    sdIterator.remove();
                }
                Iterator scIterator = finalOperatingScDyList.iterator();
                while (scIterator.hasNext()) {
                    DynamicObject next = (DynamicObject)scIterator.next();
                    if (next.getLong("id") == onlyUseDyId) continue;
                    scIterator.remove();
                }
            }
        }
        entryWorkBill.addAll(finalOperatingSdDyList);
        entryWorkBill.addAll(finalOperatingScDyList);
        HashMap beforeSumForOt = Maps.newHashMapWithExpectedSize((int)10);
        for (DynamicObject otBillDy : entryWorkBill) {
            Map<String, List<OverTwentyFour>> afterConvertData = TwentyFourCheck.convertOtBill(otBillDy);
            for (Map.Entry<String, List<OverTwentyFour>> signatureAndData : afterConvertData.entrySet()) {
                List overTwentyFourList = beforeSumForOt.computeIfAbsent(signatureAndData.getKey(), key -> new ArrayList(10));
                overTwentyFourList.addAll((Collection)signatureAndData.getValue());
            }
        }
        return beforeSumForOt;
    }

    private static List<OverTwentyFourVo> mergeResultToVo(List<OverTwentyFour> otAndVaSum, List<OverTwentyFour> otSum, List<OverTwentyFour> vaSum) {
        Map<String, OverTwentyFour> otVaMap = TwentyFourCheck.getPersonDateMap(otAndVaSum);
        Map<String, OverTwentyFour> otMap = TwentyFourCheck.getPersonDateMap(otSum);
        Map<String, OverTwentyFour> vaMap = TwentyFourCheck.getPersonDateMap(vaSum);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)otAndVaSum.size());
        for (Map.Entry<String, OverTwentyFour> otVa : otVaMap.entrySet()) {
            String key = otVa.getKey();
            OverTwentyFour value = otVa.getValue();
            OverTwentyFourVo newResult = new OverTwentyFourVo();
            newResult.setCheckResult(value.getDuration().compareTo(new BigDecimal("86400")) <= 0);
            newResult.setDutyDate(value.getBelongDate());
            newResult.setPersonId(value.getPersonId().longValue());
            if (vaMap.get(key) != null) {
                newResult.setVaSec(vaMap.get(key).getDuration());
            }
            if (otMap.get(key) != null) {
                newResult.setOtSec(otMap.get(key).getDuration());
            }
            result.add(newResult);
        }
        return result;
    }

    private static Map<String, OverTwentyFour> getPersonDateMap(List<OverTwentyFour> otAndVaSum) {
        if (CollectionUtils.isEmpty(otAndVaSum)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)otAndVaSum.size());
        for (OverTwentyFour overTwentyFour : otAndVaSum) {
            Long personId = overTwentyFour.getPersonId();
            Date belongDate = overTwentyFour.getBelongDate();
            String key = personId + "";
            if (belongDate != null) {
                key = key + belongDate.getTime();
            }
            result.put(key, overTwentyFour);
        }
        return result;
    }

    private static List<OverTwentyFour> mergeOver24(Map<String, List<OverTwentyFour>> beforeSum, BillTypeEnum billTypeEnum) {
        ArrayList afterSum = Lists.newArrayListWithExpectedSize((int)beforeSum.size());
        for (Map.Entry<String, List<OverTwentyFour>> inOnePersonAndDate : beforeSum.entrySet()) {
            List<OverTwentyFour> value = inOnePersonAndDate.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            OverTwentyFour overTwentyFour = new OverTwentyFour();
            overTwentyFour.setBelongDate(value.get(0).getBelongDate());
            overTwentyFour.setPersonId(value.get(0).getPersonId());
            overTwentyFour.setBillTypeEnum(billTypeEnum);
            BigDecimal totalSec = BigDecimal.ZERO;
            for (OverTwentyFour twentyFour : value) {
                totalSec = totalSec.add(twentyFour.getDuration());
            }
            overTwentyFour.setDuration(totalSec);
            afterSum.add(overTwentyFour);
        }
        return afterSum;
    }

    private static Map<String, List<OverTwentyFour>> convertVaBill(Map<Long, List<VaValidateTimeRspModel>> vaValidateTimeRspDtoMap) {
        if (vaValidateTimeRspDtoMap == null) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry<Long, List<VaValidateTimeRspModel>> personIdAndVaData : vaValidateTimeRspDtoMap.entrySet()) {
            Long personId = personIdAndVaData.getKey();
            List<VaValidateTimeRspModel> vaValidateTimeRspDtoList = personIdAndVaData.getValue();
            for (VaValidateTimeRspModel vaValidateTimeRspDto : vaValidateTimeRspDtoList) {
                DutyShift dutyShift = vaValidateTimeRspDto.getDutyShift();
                if (dutyShift == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f11\u5047\u65f6\u6bb5\u8fd4\u56de\u7684\u5f52\u5c5e\u73ed\u6b21\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"TwentyFourCheck_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
                }
                Date rosterDate = WTCDateUtils.getDayStart((Date)dutyShift.getRosterDate());
                BigDecimal vaTimeSec = vaValidateTimeRspDto.getVaTimeSec();
                String signature = personId + rosterDate.getTime() + "";
                List overTwentyFourList = result.computeIfAbsent(signature, key -> new ArrayList(10));
                OverTwentyFour overTwentyFour = new OverTwentyFour();
                overTwentyFour.setDuration(vaTimeSec);
                overTwentyFour.setPersonId(personId);
                overTwentyFour.setBelongDate(rosterDate);
                overTwentyFour.setBillTypeEnum(BillTypeEnum.VACATIONBILL);
                overTwentyFourList.add(overTwentyFour);
            }
        }
        return result;
    }

    private static Map<String, List<OverTwentyFour>> convertOtBill(DynamicObject otDyn) {
        long personId = 0L;
        Object personDyObj = otDyn.get("personid");
        if (personDyObj != null) {
            personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)otDyn, (String)"personid");
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(otDyn);
        String otApplyType = otDyn.getString("otapplytype");
        DynamicObjectCollection entryColl = otDyn.getDynamicObjectCollection(entryInfo.get("ENTRY_NAME"));
        HashMap result = Maps.newHashMapWithExpectedSize((int)entryColl.size());
        for (DynamicObject entryDy : entryColl) {
            OverTwentyFour overTwentyFour = new OverTwentyFour();
            overTwentyFour.setBillTypeEnum(BillTypeEnum.OVERTIMEBILL);
            Date date = entryDy.getDate(entryInfo.get("DUTY_DAY_NAME"));
            if (date == null) continue;
            overTwentyFour.setPersonId(Long.valueOf(personId));
            overTwentyFour.setBelongDate(date);
            BigDecimal duration = BigDecimal.ZERO;
            if (OtApplyTypeEnum.OT_SD.getNum().equals(otApplyType)) {
                Date entryEndDate = entryDy.getDate(entryInfo.get("END_TIME_NAME"));
                Date entryStartDate = entryDy.getDate(entryInfo.get("START_TIME_NAME"));
                if (entryEndDate == null || entryStartDate == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u7684\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TwentyFourCheck_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
                }
                duration = BigDecimal.valueOf(entryEndDate.getTime()).subtract(BigDecimal.valueOf(entryStartDate.getTime())).divide(new BigDecimal("1000"), 4, RoundingMode.HALF_UP);
            } else if (OtApplyTypeEnum.OT_SC.getNum().equals(otApplyType)) {
                duration = new BigDecimal(entryDy.getInt("otdtime") + "");
            }
            overTwentyFour.setDuration(duration);
            String signature = personId + date.getTime() + "";
            List overTwentyFourList = result.computeIfAbsent(signature, key -> new ArrayList(10));
            overTwentyFourList.add(overTwentyFour);
        }
        return result;
    }
}

