/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.mob;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.common.concurrent.WTCMutexHelper;
import kd.wtc.wtom.business.OTKdStringHelper;

public class MobOTChangeService {
    private static MobOTChangeService mobOTChangeService;

    public static MobOTChangeService getInstance() {
        if (mobOTChangeService == null) {
            mobOTChangeService = new MobOTChangeService();
        }
        return mobOTChangeService;
    }

    public void setOtBillInfo(IFormView view, String changeType) {
        this.setOtBillSummary(view);
        if ("1".equals(changeType)) {
            this.setOtEntryIndex(view.getModel());
        }
    }

    private void setOtBillSummary(IFormView view) {
        Label allOtTimeLabel;
        IDataModel model = view.getModel();
        DynamicObject otBill = model.getDataEntity();
        String otApplyType = otBill.getString("otapplytype");
        Label otApplyTypeLabel = (Label)view.getControl("otapplytype");
        if ("1".equals(otApplyType)) {
            if (otApplyTypeLabel != null) {
                otApplyTypeLabel.setText(ResManager.loadKDString((String)"\u6309\u65f6\u6bb5", (String)"MobOTChangeService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
        } else if (otApplyTypeLabel != null) {
            otApplyTypeLabel.setText(ResManager.loadKDString((String)"\u6309\u65f6\u957f", (String)"MobOTChangeService_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        if ((allOtTimeLabel = (Label)view.getControl("totaltime")) != null) {
            String vaTime = otBill.getString("vatimetext");
            allOtTimeLabel.setText(vaTime);
        }
    }

    public void setOtEntryIndex(IDataModel model) {
        DynamicObject otBill = model.getDataEntity();
        String otApplyType = otBill.getString("otapplytype");
        if ("1".equals(otApplyType)) {
            DynamicObjectCollection busTripBillEntry = otBill.getDynamicObjectCollection("sdentry");
            for (int index = 0; index < busTripBillEntry.size(); ++index) {
                model.setValue("billentryname_seg", (Object)(index + 1), index);
            }
        } else {
            DynamicObjectCollection busTripBillEntry = otBill.getDynamicObjectCollection("scentry");
            for (int index = 0; index < busTripBillEntry.size(); ++index) {
                model.setValue("billentryname_long", (Object)(index + 1), index);
            }
        }
    }

    public String changeToDetail(IFormView view) {
        String curFormId = view.getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"wtom_otbillchange_m", (String)curFormId)) {
            return "wtom_otbillchange_md";
        }
        return "wtom_otselfbillchange_md";
    }

    public void toSubmitFeedbackPage(IFormView view, IDataModel model, String applyFormId) {
        MobileCommonServiceHelper.getInstance().toSubmitFeedbackPage(view, OTKdStringHelper.otName(), applyFormId, model.getDataEntity().getLong("id"));
    }

    public String detailToChange(IFormView view) {
        String curFormId = view.getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"wtom_otbillchange_md", (String)curFormId)) {
            return "wtom_otbillchange_m";
        }
        return "wtom_otselfbillchange_m";
    }

    public void setSubmitInfo(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        dataEntity.set("submitter", (Object)RequestContext.get().getCurrUserId());
        dataEntity.set("submitdate", (Object)new Date());
        dataEntity.set("vatime", (Object)0);
    }

    public void setChangeTitleInfo(IFormView view) {
        Label otTypeChangeTips;
        Label billTitle = (Label)view.getControl("billtitle");
        if (billTitle != null) {
            DynamicObject otBill = view.getModel().getDataEntity();
            billTitle.setText(ResManager.loadKDString((String)"%s\u7684\u52a0\u73ed\u53d8\u66f4\u5355", (String)"MobOTChangeService_2", (String)"wtc-wtom-business", (Object[])new Object[]{otBill.getString("personid.name")}));
        }
        if ((otTypeChangeTips = (Label)view.getControl("optypechangetips")) != null) {
            String text = ResManager.loadKDString((String)"\u5b9e\u9645\u6ca1\u6709\u52a0\u73ed\uff0c\u65e0\u9700\u7ef4\u62a4\u52a0\u73ed\u4fe1\u606f\uff0c\u539f\u52a0\u73ed\u5355\u505a\u5931\u6548\u5904\u7406\u3002", (String)"MobOTChangeService_3", (String)"wtc-wtom-business", (Object[])new Object[0]);
            otTypeChangeTips.setText(text);
        }
    }

    public void setChangeDetailTitleInfo(IFormView view) {
        Label billHeader = (Label)view.getControl("billheader");
        if (billHeader != null) {
            DynamicObject otBill = view.getModel().getDataEntity();
            billHeader.setText(ResManager.loadKDString((String)"%s\u7684\u52a0\u73ed\u53d8\u66f4\u5355", (String)"MobOTChangeService_2", (String)"wtc-wtom-business", (Object[])new Object[]{otBill.getString("personid.name")}));
        }
    }

    public void releaseMutexIfIsCurrentUser(Long objectId, String entityType) {
        if (HRStringUtils.equals((String)"wtom_otbillchange_md", (String)entityType) || HRStringUtils.equals((String)"wtom_otbillchange_m", (String)entityType)) {
            entityType = "wtom_otbillchange";
        } else if (HRStringUtils.equals((String)"wtom_otselfbillchange_md", (String)entityType) || HRStringUtils.equals((String)"wtom_otselfbillchange_m", (String)entityType)) {
            entityType = "wtom_otselfbillchange";
        }
        if (this.currentUserHasMutex(objectId, entityType)) {
            WTCMutexHelper.release((String)entityType, (String)"modify", (String)String.valueOf(objectId));
        }
    }

    private boolean currentUserHasMutex(Long objectId, String EntityType) {
        if (objectId == null) {
            return false;
        }
        QFilter operateKeyFilter = new QFilter("operationkey", "=", (Object)"modify");
        QFilter entityKeyFilter = new QFilter("entitykey", "=", (Object)EntityType);
        QFilter objectIdFilter = new QFilter("objectid", "=", (Object)String.valueOf(objectId));
        QFilter userFilter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId());
        HRBaseServiceHelper dataLockHelper = new HRBaseServiceHelper("bos_datalock");
        DynamicObject[] dynamicObjects = dataLockHelper.query("id", new QFilter[]{objectIdFilter, operateKeyFilter, entityKeyFilter, userFilter});
        return dynamicObjects != null && dynamicObjects.length > 0;
    }
}

