/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.mob;

import java.text.MessageFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.field.TimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtom.business.common.OtRuleResp;
import kd.wtc.wtbs.business.bill.BillStyleService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.mobile.BillContainerService;
import kd.wtc.wtbs.business.mobile.MobileCommonServiceHelper;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.ArrayUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.web.OTApplyBillCommonService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class MobOverworkBusiness {
    private static final Log LOGGER = LogFactory.getLog(MobOverworkBusiness.class);
    private static Map<String, String> ENTRY_NAMES = null;

    private MobOverworkBusiness() {
    }

    public static MobOverworkBusiness getInstance() {
        return Instance.INSTANCE;
    }

    @Deprecated
    public void initOverworkPerson(IFormView iFormView) {
        Long userId = BillUnifyService.getUserId((IFormView)iFormView);
        LOGGER.info("MobOverworkBusiness.initOverworkPerson userId is {}", (Object)userId);
        boolean hasPerm = this.verifyHasPerm("wtom_overtimeapply", "");
        if (hasPerm) {
            String value = (String)iFormView.getModel().getValue("applytyperadio");
            if (HRStringUtils.equals((String)value, (String)"0")) {
                iFormView.setVisible(Boolean.FALSE, new String[]{"flexpanelap711"});
                List attArchives = MobileCommonServiceHelper.getInstance().getAttFile(userId);
                LOGGER.info("MobOverworkBusiness.initOverworkPerson attArchives is {}", (Object)attArchives);
                if (attArchives.size() == 1) {
                    iFormView.setVisible(Boolean.FALSE, new String[]{"flexpeople"});
                    String attFile = (String)((Map)attArchives.get(0)).get("boid");
                    iFormView.getModel().setValue("personid", (Object)userId);
                    LOGGER.info("MobOverworkBusiness.initOverworkPerson attArchives is {}", (Object)attFile);
                    iFormView.setEnable(Boolean.FALSE, new String[]{"selectpersonflex"});
                    String attPerson = (String)((Map)attArchives.get(0)).get("attperson.id");
                    iFormView.setEnable(Boolean.FALSE, new String[]{"flexpeople"});
                    iFormView.getModel().setValue("attfile", (Object)Long.parseLong(attFile));
                    iFormView.getModel().setValue("personid", (Object)attPerson);
                    DynamicObject person = iFormView.getModel().getDataEntity().getDynamicObject("personid");
                    iFormView.getPageCache().put("selectpersonname", person.getString("name"));
                } else {
                    iFormView.setEnable(Boolean.TRUE, new String[]{"flexpeople"});
                }
            } else if (HRStringUtils.equals((String)value, (String)"1")) {
                iFormView.setVisible(Boolean.TRUE, new String[]{"flexpeople"});
                iFormView.setEnable(Boolean.TRUE, new String[]{"selectpersonflex"});
                iFormView.getModel().setValue("personid", null);
                iFormView.getPageCache().put("selectpersonname", "");
                iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelap711"});
                iFormView.setEnable(Boolean.TRUE, new String[]{"flexpeople"});
                iFormView.getModel().setValue("attfile", null);
            }
        } else {
            iFormView.setVisible(Boolean.FALSE, new String[]{"applypersonflex"});
        }
        boolean isAbnormal = false;
        if (iFormView.getFormShowParameter() != null && iFormView.getFormShowParameter().getCustomParam("isAbnormal") != null) {
            isAbnormal = (Boolean)iFormView.getFormShowParameter().getCustomParam("isAbnormal");
        }
        if (isAbnormal) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"applypersonflex"});
        }
    }

    public void initOverworkPersonseleOther(IFormView iFormView) {
        iFormView.setVisible(Boolean.TRUE, new String[]{"flexpeople"});
        iFormView.setEnable(Boolean.TRUE, new String[]{"selectpersonflex"});
        iFormView.getModel().setValue("personid", null);
        iFormView.getPageCache().put("selectpersonname", "");
        iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelapsel"});
        iFormView.setEnable(Boolean.TRUE, new String[]{"flexpeople"});
        iFormView.getModel().setValue("attfile", null);
        boolean isAbnormal = false;
        if (iFormView.getFormShowParameter() != null && iFormView.getFormShowParameter().getCustomParam("isAbnormal") != null) {
            isAbnormal = (Boolean)iFormView.getFormShowParameter().getCustomParam("isAbnormal");
        }
        if (isAbnormal) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"applypersonflex"});
        }
    }

    public void initOverworkPersonsele(IFormView iFormView) {
        Long userId = BillUnifyService.getUserId((IFormView)iFormView);
        List top1IdList = BillUnifyService.getCurrUserAttFileTop1Ver((Long)userId, (String)iFormView.getFormShowParameter().getAppId(), (String)iFormView.getEntityId(), (String)"attfilebasef7");
        if (CollectionUtils.isEmpty((Collection)top1IdList)) {
            return;
        }
        long attFileId = (Long)top1IdList.get(top1IdList.size() - 1);
        List boids = AttFileF7Utils.batchQueryAttFileBoidByVid(Collections.singletonList(attFileId));
        long attFile = (Long)boids.get(0);
        iFormView.getModel().setValue("personid", (Object)userId);
        LOGGER.info("MobOverworkBusiness.initOverworkPerson attArchives is {}", (Object)attFile);
        iFormView.getModel().setValue("attfile", (Object)attFile);
        iFormView.getModel().setValue("attfilebasef7", (Object)attFileId);
        iFormView.getModel().setValue("personid", (Object)userId);
        DynamicObject person = iFormView.getModel().getDataEntity().getDynamicObject("personid");
        iFormView.getPageCache().put("selectpersonname", person.getString("name"));
        if (top1IdList.size() == 1) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"flexpanelapother"});
        }
    }

    public void initApplyType(IFormView iFormView) {
        String value = (String)iFormView.getModel().getValue("otapplytype");
        LOGGER.info("MobOverworkBusiness_initApplyType value ={}", (Object)value);
        boolean openSingleStyle = BillStyleService.getInstance().isOpenSingleStyle(iFormView.getModel().getDataEntity(true));
        if (HRStringUtils.equals((String)value, (String)"1")) {
            iFormView.getModel().deleteEntryData("scentry");
            if (iFormView.getModel().getEntryEntity("sdentry").size() == 0) {
                iFormView.getModel().batchCreateNewEntryRow("sdentry", 1);
            }
            iFormView.setVisible(Boolean.TRUE, new String[]{"entryflex_seg"});
            iFormView.setVisible(Boolean.FALSE, new String[]{"entryflex_long"});
            iFormView.setVisible(Boolean.FALSE, new String[]{"addbylongselectflex"});
            iFormView.setVisible(Boolean.TRUE, new String[]{"addentryflex"});
            iFormView.setVisible(Boolean.FALSE, new String[]{"flexpanelapdate"});
            iFormView.getPageCache().put("cache_entrysuffix", "_seg");
            this.showEntryCardHeader(iFormView, "_seg");
            if (openSingleStyle) {
                iFormView.setVisible(Boolean.FALSE, new String[]{"addentryflex"});
            } else {
                iFormView.setVisible(Boolean.TRUE, new String[]{"addentryflex"});
            }
        } else if (HRStringUtils.equals((String)value, (String)"2")) {
            iFormView.getModel().deleteEntryData("sdentry");
            iFormView.getPageCache().put("selectedoverdate", "");
            Label label = (Label)iFormView.getControl("selectedoverdate");
            label.setText("");
            iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelap71"});
            iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelapdate"});
            iFormView.setVisible(Boolean.TRUE, new String[]{"entryflex_long"});
            iFormView.setVisible(Boolean.FALSE, new String[]{"entryflex_seg"});
            iFormView.setVisible(Boolean.TRUE, new String[]{"addbylongselectflex"});
            iFormView.setVisible(Boolean.FALSE, new String[]{"addentryflex"});
            iFormView.getPageCache().put("cache_entrysuffix", "_long");
            this.showEntryCardHeader(iFormView, "_long");
        }
        if (openSingleStyle) {
            iFormView.setVisible(Boolean.FALSE, new String[]{"flexpanelap10"});
        } else {
            iFormView.setVisible(Boolean.TRUE, new String[]{"flexpanelap10"});
        }
    }

    private String getEntryName(String suffix) {
        return ENTRY_NAMES.get(suffix);
    }

    public void showEntryCardHeader(IFormView iFormView, String suffix) {
        String entryName = this.getEntryName(suffix);
        CardEntry entryGrid = (CardEntry)iFormView.getControl(entryName);
        Object[] items = entryGrid.getEntryData().getDataEntitys();
        Boolean moreThanOne = Boolean.TRUE;
        if (ArrayUtils.isNotEmpty((Object[])items) && items.length == 1) {
            moreThanOne = Boolean.FALSE;
        }
        entryGrid.setChildVisible(moreThanOne.booleanValue(), 0, new String[]{"cardnameflex" + suffix});
        if (moreThanOne.booleanValue()) {
            IDataModel model = iFormView.getModel();
            for (int index = 0; index < items.length; ++index) {
                String billEntryName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u52a0\u73ed\u660e\u7ec6%d", (String)"MobOverworkBusiness_0", (String)"wtc-wtom-business", (Object[])new Object[0]), index + 1);
                model.setValue("billentryname" + suffix, (Object)billEntryName, index);
            }
        }
    }

    public void openSubmitPage(IFormView iFormView, String applyFormId) {
        BillContainerService.getInstance().openSuccessPage(iFormView, ResManager.loadKDString((String)"\u52a0\u73ed\u7533\u8bf7", (String)"MobOverworkBusiness_1", (String)"wtc-wtom-business", (Object[])new Object[0]), applyFormId, ((Long)iFormView.getModel().getDataEntity().get("id")).longValue());
    }

    public String deleteEntry(IFormView view, String suffix) {
        String returnStr = "";
        String entryName = this.getEntryName(suffix);
        LOGGER.info("MobOverworkBusiness_deleteEntry suffix={}.entryName={}", (Object)suffix, (Object)entryName);
        if (HRStringUtils.isEmpty((String)entryName)) {
            return "";
        }
        CardEntry entryGrid = (CardEntry)view.getControl(entryName);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if ("_seg".equals(suffix)) {
            view.getModel().deleteEntryRow("sdentry", focusRow);
        } else {
            DynamicObject dynamicObject = entryGrid.getEntryData().getDataEntitys()[focusRow];
            Date otdate = dynamicObject.getDate("otdate");
            returnStr = DateUtils.formatDate((Date)otdate, (Object[])new Object[]{"yyyy-MM-dd"});
            view.getModel().deleteEntryRow("scentry", focusRow);
        }
        return returnStr;
    }

    @Deprecated
    public List<Map<String, String>> queryOverworkType1(IFormView view) {
        return this.queryOverworkType(view, Collections.emptySet(), -1);
    }

    public List<Map<String, String>> queryOverworkType(IFormView view, Set<LocalDate> selectDates, int checkIndex) {
        if (view == null) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper ottypeDao = new HRBaseServiceHelper("wtbd_ottype");
        QFilter allQFilter = new QFilter("id", "!=", (Object)0L);
        if (WTCCollections.isNotEmpty(selectDates)) {
            DynamicObject attFileIdDy = (DynamicObject)view.getModel().getValue("attfile");
            long attFileId = attFileIdDy == null ? 0L : attFileIdDy.getLong("id");
            DynamicObject orgDy = (DynamicObject)view.getModel().getValue("org");
            long orgId = orgDy == null ? 0L : orgDy.getLong("id");
            List<OtRuleResp> otMatchRule = OTApplyBillCommonService.getInstance().getOtMatchRule(view.getModel().getDataEntity(true), checkIndex, selectDates, attFileId);
            QFilter qFilter = OTApplyBillCommonService.getInstance().selectOtTypeByDate(otMatchRule, orgId);
            allQFilter.and(qFilter);
        } else {
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthAppId(view.getFormShowParameter().getAppId());
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            unifyBillApplyAttr.setAttFileF7AuthEntity(view.getEntityId());
            OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{view.getModel().getDataEntity(true)}, unifyBillApplyAttr);
            Set<Long> allOTType = otBillHelper.getAllOTType(view.getModel().getDataEntity(true));
            QFilter enable = new QFilter("id", "in", allOTType);
            enable.and(WTCHisServiceHelper.statusValidQFilter());
            DynamicObject orgDy = (DynamicObject)view.getModel().getValue("org");
            if (orgDy != null) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_ottype", (Long)orgDy.getLong("id"));
                if (baseDataFilter != null) {
                    enable.and(baseDataFilter);
                }
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"MobOverworkBusiness_3", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            allQFilter.and(enable);
        }
        LOGGER.info("MobOverworkBusiness_queryOverworkType allQFilter :{}", (Object)allQFilter);
        DynamicObject[] query = ottypeDao.loadDynamicObjectArray(new QFilter[]{allQFilter});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)query.length);
        DynamicObject mainDataEntity = view.getModel().getDataEntity(true);
        long attFileBo = 0L;
        if (mainDataEntity != null && mainDataEntity.getDynamicObject("attfile") != null) {
            attFileBo = mainDataEntity.getDynamicObject("attfile").getLong("id");
        }
        LinkedHashSet<Long> otTypeBoIds = new LinkedHashSet<Long>(1);
        Map<Object, Object> policyInfo = new HashMap(16);
        for (DynamicObject otType : query) {
            long id = otType.getLong("id");
            otTypeBoIds.add(id);
        }
        policyInfo = OTBillHelper.getLatestTypeAndRuleCalDy(otTypeBoIds, attFileBo);
        String attPolicy = UnifyBillEnum.OT.getUnifyPlanEnum().getRuleEnum().getUnifyRuleCalEntryEnum().getAttPolicy();
        for (DynamicObject otType : query) {
            long attPolicyId;
            HashMap param = Maps.newHashMapWithExpectedSize((int)4);
            long id = otType.getLong("id");
            DynamicObject ruleCalDy = (DynamicObject)policyInfo.get(otType.getLong("id"));
            long l = attPolicyId = ruleCalDy == null ? 0L : HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleCalDy, (String)attPolicy);
            if (attPolicyId != 0L) {
                param.put("formid", attPolicyId + "");
                LOGGER.info("MobOverworkBusiness_queryOverworkType attPolicyId can not find. otType id :{}", (Object)otType.getLong("id"));
            } else {
                param.put("formid", "");
            }
            param.put("text", otType.getString("name"));
            param.put("id", String.valueOf(id));
            result.add(param);
        }
        return result;
    }

    public void setPersonName(IFormView iFormView, Map<String, String> returnData) {
        String personId = returnData.get("personid");
        String attFile = returnData.get("attfile");
        String attfilebasef7 = returnData.get("id");
        LOGGER.info("MobBusiTripBusiness.setPersonName.personId:{}", (Object)personId);
        LOGGER.info("MobBusiTripBusiness.setPersonName.attFile:{}", (Object)attFile);
        LOGGER.info("MobBusiTripBusiness.setPersonName.attfilebasef7:{}", (Object)attfilebasef7);
        if (personId != null && attFile != null) {
            iFormView.getModel().setValue("attfile", (Object)Long.parseLong(attFile));
            iFormView.getModel().setValue("attfilebasef7", (Object)Long.parseLong(attfilebasef7));
            iFormView.getModel().setValue("personid", (Object)Long.parseLong(personId));
            iFormView.setVisible(Boolean.FALSE, new String[]{"flexpanelapsel"});
        }
    }

    public void setOtType(IFormView view, Map<String, String> returnData) {
        if (MapUtils.isEmpty(returnData)) {
            return;
        }
        long id = Long.parseLong(returnData.get("id"));
        String fieldName = this.getOtTypeFieldName(view);
        String entryName = "";
        if ("scottype".equals(fieldName)) {
            entryName = "scentry";
        } else if ("sdottype".equals(fieldName)) {
            entryName = "sdentry";
        }
        if (HRStringUtils.isEmpty((String)entryName)) {
            return;
        }
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity(entryName);
        if (entryEntity.size() > 0) {
            view.getModel().setValue(fieldName, (Object)id);
        }
    }

    private String getOtTypeFieldName(IFormView view) {
        String cache = view.getPageCache().get("cache_entrysuffix");
        assert (cache != null);
        String entryName = this.getEntryName(cache);
        String prefix = entryName.substring(0, 2);
        String fieldName = prefix + "ottype";
        return fieldName;
    }

    private int getFocusRow(IFormView view) {
        String suffix = view.getPageCache().get("cache_entrysuffix");
        String entryName = this.getEntryName(suffix);
        CardEntry entryGrid = (CardEntry)view.getControl(entryName);
        return entryGrid.getEntryState().getFocusRow();
    }

    public List<String> getSelectedDateList(IFormView view) {
        String value = view.getPageCache().get("selectedoverdate");
        if (HRStringUtils.isEmpty((String)value)) {
            return Collections.emptyList();
        }
        String[] dateStrs = value.split(",");
        return Arrays.asList(dateStrs);
    }

    public void setSelectDates(IFormView view, List<String> selectDates) {
        String cache = view.getPageCache().get("cache_entrysuffix");
        assert (cache != null);
        String entryName = this.getEntryName(cache);
        IDataModel dataModel = view.getModel();
        if (CollectionUtils.isEmpty(selectDates)) {
            Label label = (Label)view.getControl("selectedoverdate");
            label.setText("");
            dataModel.deleteEntryData(entryName);
            view.getPageCache().put("selectedoverdate", null);
            return;
        }
        selectDates = selectDates.stream().map(selectDate -> WTCInteDateUtil.formatDateStrBySysTzAndUserFmt((String)selectDate, (String)"yyyy-MM-dd")).collect(Collectors.toList());
        ArrayList<String> resultList = new ArrayList<String>(8);
        List<String> params = this.getSelectedDateList(view);
        ArrayList<Integer> indexList = new ArrayList<Integer>(8);
        int addIndex = 0;
        this.setDates(selectDates, params, indexList, addIndex);
        resultList.addAll(selectDates);
        for (String param : params) {
            if (selectDates.contains(param)) continue;
            resultList.add(param);
        }
        List<String> collect = resultList.stream().map(dateStr -> {
            try {
                return WTCInteDateUtil.getUserSimpleDateFormat().parse((String)dateStr);
            }
            catch (ParseException e) {
                LOGGER.warn("MobOverworkBusiness.setSelectDates parseDate warn", (Throwable)e);
                return null;
            }
        }).sorted().map(date -> WTCInteDateUtil.getUserSimpleDateFormat().format((Date)date)).collect(Collectors.toList());
        DynamicObjectCollection dynamicObjects = view.getModel().getDataEntity(true).getDynamicObjectCollection("scentry");
        EntryType entryType = (EntryType)dynamicObjects.getDynamicObjectType();
        if (params.isEmpty()) {
            view.getModel().batchCreateNewEntryRow("scentry", indexList.size());
        } else {
            for (int ind = 0; ind < indexList.size(); ++ind) {
                dynamicObjects.add(((Integer)indexList.get(ind)).intValue(), new DynamicObject((DynamicObjectType)entryType));
            }
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity("scentry");
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject entryDy = (DynamicObject)entryEntity.get(index);
                int otDTime = entryDy.getInt("otdtime");
                if (otDTime != 0) continue;
                dataModel.setValue("otdtime", (Object)-1, index);
            }
            view.updateView("scentry");
        }
        this.removeDate(view, selectDates, params, collect, dynamicObjects);
        StringBuilder builder = new StringBuilder(128);
        Date otDate = null;
        for (int index = 0; index < collect.size(); ++index) {
            String date2 = collect.get(index);
            try {
                otDate = WTCInteDateUtil.getUserSimpleDateFormat().parse(date2);
            }
            catch (ParseException e) {
                LOGGER.warn("MobOverworkBusiness.setSelectDates parseDate warn", (Throwable)e);
            }
            dataModel.setValue("otdate", (Object)otDate, index);
            builder.append(date2).append(',');
        }
        if (builder.length() > 0) {
            String dateStr2 = builder.substring(0, builder.length() - 1);
            Label label = (Label)view.getControl("selectedoverdate");
            label.setText(dateStr2);
            view.getPageCache().put("selectedoverdate", dateStr2);
            view.getPageCache().put("datelabel", dateStr2);
            view.setVisible(Boolean.FALSE, new String[]{"flexpanelap71"});
        }
        this.showEntryCardHeader(view, cache);
        DynamicObjectCollection scEntry = dataModel.getEntryEntity("scentry");
        for (int index = 0; index < scEntry.size(); ++index) {
            int otDTime = ((DynamicObject)scEntry.get(index)).getInt("otdtime");
            if (otDTime == 0 || otDTime == -1) {
                TimeEdit edit = (TimeEdit)view.getControl("otdtime");
                edit.setEntryTimeFocusValue(0L, index);
            }
            OTApplyBillCommonService.getInstance().setTypeAfterChoseDate(view, index);
        }
    }

    private void setDates(List<String> selectDates, List<String> params, List<Integer> indexList, int addIndex) {
        for (int seleIndex = 0; seleIndex < selectDates.size(); ++seleIndex) {
            boolean isMax = true;
            if (params.contains(selectDates.get(seleIndex))) continue;
            for (int index = 0; index < params.size(); ++index) {
                try {
                    if (HRDateTimeUtils.parseDate((String)params.get(index)).getTime() <= HRDateTimeUtils.parseDate((String)selectDates.get(seleIndex)).getTime()) continue;
                    indexList.add(index);
                    isMax = false;
                    break;
                }
                catch (ParseException e) {
                    LOGGER.error("\u6309\u65f6\u957f\u65b0\u589e\u52a0\u73ed\u7533\u8bf7\u5355\uff0c\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)e);
                }
            }
            if (params.isEmpty()) {
                indexList.add(seleIndex);
                continue;
            }
            if (!isMax) continue;
            indexList.add(params.size() + addIndex);
            ++addIndex;
        }
    }

    private void removeDate(IFormView view, List<String> selectDates, List<String> params, List<String> collect, DynamicObjectCollection dynamicObjects) {
        ArrayList<String> removeList = new ArrayList<String>(8);
        ArrayList<Integer> removeIndexList = new ArrayList<Integer>(8);
        if (!params.isEmpty()) {
            for (String param : params) {
                if (selectDates.contains(param)) continue;
                removeList.add(param);
            }
            for (String remove : removeList) {
                for (int index = 0; index < collect.size(); ++index) {
                    if (!remove.equals(collect.get(index))) continue;
                    removeIndexList.add(index);
                }
            }
            for (int index = removeIndexList.size() - 1; index > -1; --index) {
                dynamicObjects.remove(dynamicObjects.get(((Integer)removeIndexList.get(index)).intValue()));
            }
            for (String remove : removeList) {
                collect.remove(remove);
            }
            view.updateView("scentry");
        }
    }

    private boolean verifyHasPerm(String entityId, String permCode) {
        if (HRStringUtils.isEmpty((String)permCode)) {
            return true;
        }
        String appId = AppMetadataCache.getAppInfo((String)"wtam").getId();
        RequestContext context = RequestContext.get();
        int perm = PermissionServiceHelper.checkPermission((Long)context.getCurrUserId(), (Long)context.getOrgId(), (String)appId, (String)entityId, (String)permCode);
        return perm == 1;
    }

    public void setTotalDate(IFormView view, String delDateStr) {
        String totalDateStr = view.getPageCache().get("selectedoverdate");
        IDataModel model = view.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
        ArrayList<String> dateStrList = new ArrayList<String>(10);
        for (DynamicObject entryDy : entryEntity) {
            Date dutyDate = entryDy.getDate("otdate");
            if (dutyDate == null) continue;
            dateStrList.add(WTCInteDateUtil.getUserSimpleDateFormat().format(dutyDate));
        }
        String dateStr = "";
        if (dateStrList.size() > 0) {
            dateStr = String.join((CharSequence)",", dateStrList);
        }
        Label label = (Label)view.getControl("selectedoverdate");
        label.setText(dateStr);
        view.getPageCache().put("selectedoverdate", dateStr);
    }

    public void setTotelDate(IFormView view) {
        DynamicObjectCollection sdEntry = view.getModel().getEntryEntity("sdentry");
        long totalTime = 0L;
        for (DynamicObject dynamicObject : sdEntry) {
            long otTime = (long)dynamicObject.getInt("intottime") * 1000L;
            totalTime += otTime;
        }
        String strTime = MobOverworkBusiness.getStrTime(totalTime);
        Label totalTimela = (Label)view.getControl("totaltime");
        totalTimela.setText(strTime);
    }

    public void setTotelDateLong(IFormView view) {
        DynamicObjectCollection sdEntry = view.getModel().getEntryEntity("scentry");
        long totalTime = 0L;
        for (DynamicObject dynamicObject : sdEntry) {
            long otTime = dynamicObject.getLong("otdtime");
            if (otTime == -1L) continue;
            totalTime += otTime;
        }
        String strTime = MobOverworkBusiness.getStrTime(totalTime * 1000L);
        Label totalTimela = (Label)view.getControl("totaltime");
        totalTimela.setText(strTime);
    }

    public void setEnableAfterSelectCustomDate(IFormView view) {
        DynamicObjectCollection scEntry = view.getModel().getEntryEntity("scentry");
        if (WTCCollections.isEmpty((Collection)scEntry)) {
            return;
        }
        for (int index = 0; index < scEntry.size(); ++index) {
            Object dutyDate = ((DynamicObject)scEntry.get(index)).get("dutydate");
            if (dutyDate != null) continue;
            view.setEnable(Boolean.FALSE, index, new String[]{"compentype"});
        }
    }

    public void setSelectedoverdate(IFormView view) {
        DynamicObjectCollection sdEntry = view.getModel().getEntryEntity("scentry");
        StringBuilder builder = new StringBuilder(128);
        for (DynamicObject dynamicObject : sdEntry) {
            Date otDate = dynamicObject.getDate("otdate");
            if (otDate == null) continue;
            builder.append(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)otDate)).append(',');
        }
        if (builder.length() > 0) {
            String dateStr = builder.substring(0, builder.length() - 1);
            Label label = (Label)view.getControl("selectedoverdate");
            label.setText(dateStr);
            view.getPageCache().put("selectedoverdate", dateStr);
        }
    }

    private static String getStrTime(long time) {
        long mins = time / 1000L % 3600L;
        long min = mins / 60L;
        long hour = (time / 1000L - mins) / 3600L;
        StringBuilder stringBuilder = new StringBuilder();
        if (hour != 0L) {
            stringBuilder.append(hour).append('h');
        }
        if (min != 0L) {
            stringBuilder.append(min).append("min");
        }
        return stringBuilder.toString();
    }

    public void handleChangeAttFile(IFormView formView) {
        if (formView == null) {
            return;
        }
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
        unifyBillApplyAttr.setAttFileF7AuthAppId(formView.getFormShowParameter().getAppId());
        unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
        unifyBillApplyAttr.setAttFileF7AuthEntity(formView.getEntityId());
        OTBillHelper otBillHelper = new OTBillHelper(new DynamicObject[]{formView.getModel().getDataEntity(true)}, unifyBillApplyAttr);
        BillCheckResult billCheckResult = otBillHelper.checkHaveAttFileHavePlan(formView.getModel().getDataEntity(true));
        if (!billCheckResult.isVerifyResult()) {
            formView.showTipNotification((String)billCheckResult.getMsg().get(0));
        }
    }

    public void cleanEndity(IFormView formView) {
        if (formView == null) {
            return;
        }
        IDataModel dataModel = formView.getModel();
        String cache = formView.getPageCache().get("cache_entrysuffix");
        String entryName = this.getEntryName(cache);
        LOGGER.info("MobOverworkBusiness.cleanEndity cache is {},entryName is {}", (Object)cache, (Object)entryName);
        if (HRStringUtils.isEmpty((String)entryName)) {
            return;
        }
        Label label = (Label)formView.getControl("selectedoverdate");
        label.setText("");
        dataModel.deleteEntryData(entryName);
        dataModel.batchCreateNewEntryRow("sdentry", 1);
        formView.getPageCache().put("selectedoverdate", null);
        Label totalTime = (Label)formView.getControl("totaltime");
        totalTime.setText("");
        this.showEntryCardHeader(formView, cache);
        AttachmentPanel attachmentpanel = (AttachmentPanel)formView.getControl("attachmentpanel");
        List attachmentDataList = attachmentpanel.getAttachmentData();
        for (Map attachmentData : attachmentDataList) {
            attachmentpanel.remove(attachmentData);
        }
        formView.updateView(entryName);
    }

    public void openChangeView(IFormView view, boolean self) {
        HRBaseServiceHelper ottypeDao = new HRBaseServiceHelper("wtom_overtimeapplybill");
        long id = view.getModel().getDataEntity().getLong("id");
        QFilter enable = new QFilter("id", "=", (Object)id);
        DynamicObject query = ottypeDao.loadDynamicObject(enable);
        if (query == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u52a0\u73ed\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MobOTApplyDetailPlugin_1", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
        } else if ("F".equals(query.getString("billstatus"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u52a0\u73ed\u7533\u8bf7\u5355\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u5df2\u88ab\u5e9f\u5f03\u3002", (String)"MobOTApplyDetailPlugin_2", (String)"wtc-wtom-formplugin", (Object[])new Object[0]));
        } else if ("C".equals(query.getString("billstatus"))) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("id", String.valueOf(id));
            String openFormId = self ? "wtom_otselfbillchange_m" : "wtom_otbillchange_m";
            param.put("personid_cache", BillUnifyService.getUserId((IFormView)view));
            BillContainerService.getInstance().openChangePage(view, openFormId, param);
        }
    }

    public boolean showTipMultiPeriodInOneDay(IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(OtApplyTypeEnum.OT_SC.getCode());
        HashSet<String> dateStr = new HashSet<String>(16);
        for (DynamicObject entryDy : entryEntity) {
            Date dutyDate = entryDy.getDate("otdate");
            if (dutyDate == null) continue;
            String formatDate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dutyDate);
            if (dateStr.contains(formatDate)) {
                String tip = ResManager.loadKDString((String)"\u5355\u636e{0}\u5b58\u5728\u591a\u4e2a\u65f6\u6bb5\u7684\u52a0\u73ed\u660e\u7ec6\uff0c\u8bf7\u5728PC\u7aef\u8fdb\u884c\u8c03\u6574\u3002", (String)"MobOverworkBusiness_6", (String)"wtc-wtom-business", (Object[])new Object[0]);
                formView.showTipNotification(MessageFormat.format(tip, formatDate));
                return true;
            }
            dateStr.add(formatDate);
        }
        return false;
    }

    static {
        ENTRY_NAMES = Maps.newHashMapWithExpectedSize((int)2);
        ENTRY_NAMES.put("_seg", "sdentry");
        ENTRY_NAMES.put("_long", "scentry");
    }

    private static class Instance {
        private static MobOverworkBusiness INSTANCE = new MobOverworkBusiness();

        private Instance() {
        }
    }
}

