/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.rpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.wtom.common.rpc.OtDutyDateStartEndTime;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OTApplyRPCHelper {
    public Map<Long, Map<Date, OtDutyDateStartEndTime>> queryDutyDateMaxAndMinTime(Set<Long> attPersonIds, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(attPersonIds) || startDate == null || endDate == null) {
            return Collections.emptyMap();
        }
        if (startDate.after(endDate)) {
            throw new KDBizException("the startDate  must be less than or equal to the endDate");
        }
        DynamicObject[] otDys = this.getOtDys(attPersonIds, startDate, endDate);
        List<Date> dateRange = this.getDateRange(startDate, endDate);
        Map<Long, Map<Date, List<OtDutyDateStartEndTime>>> otDutyStartEndTimeByDyList = this.groupAndConvertOtDysByPerson(otDys);
        HashMap result = Maps.newHashMapWithExpectedSize((int)otDutyStartEndTimeByDyList.size());
        otDutyStartEndTimeByDyList.forEach((key, val) -> result.put(key, this.getStartAndEndOtTime(dateRange, (Map<Date, List<OtDutyDateStartEndTime>>)val)));
        return result;
    }

    private Map<Date, OtDutyDateStartEndTime> getStartAndEndOtTime(List<Date> dateRange, Map<Date, List<OtDutyDateStartEndTime>> allStartEndOtTimeList) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)allStartEndOtTimeList.size());
        for (Date date : dateRange) {
            List<OtDutyDateStartEndTime> otDutyDateStartEndTimes = allStartEndOtTimeList.get(date);
            if (CollectionUtils.isEmpty(otDutyDateStartEndTimes)) {
                result.put(date, null);
                continue;
            }
            Date startOtTime = null;
            Date endOtTime = null;
            for (OtDutyDateStartEndTime otDutyDateStartEndTime : otDutyDateStartEndTimes) {
                if (otDutyDateStartEndTime == null) continue;
                Date startTime = otDutyDateStartEndTime.getStartTime();
                if (startOtTime == null || startTime != null && startTime.before(startOtTime)) {
                    startOtTime = startTime;
                }
                Date endTime = otDutyDateStartEndTime.getEndTime();
                if (endOtTime != null && (endTime == null || !endTime.after(endOtTime))) continue;
                endOtTime = endTime;
            }
            OtDutyDateStartEndTime otDutyDateStartEndTime = new OtDutyDateStartEndTime();
            otDutyDateStartEndTime.setStartTime(startOtTime);
            otDutyDateStartEndTime.setEndTime(endOtTime);
            result.put(date, otDutyDateStartEndTime);
        }
        return result;
    }

    private DynamicObject[] getOtDys(Set<Long> attPersonIds, Date startDate, Date endDate) {
        HRBaseServiceHelper workServiceHelper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        QFilter personIdFilter = new QFilter("personid.id", "in", attPersonIds);
        QFilter auditPass = new QFilter("billstatus", "=", (Object)"C");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)endDate).and(new QFilter("enddate", ">=", (Object)startDate));
        QFilter isNotChange = new QFilter("ischange", "=", (Object)Boolean.FALSE);
        String queryColumn = WTCStringUtils.joinOnComma((String[])new String[]{"personid.id", "scentry.dutydate", "sdentry.otdutydate", "otapplytype", OtApplyTypeEnum.OT_SD.getCode() + "." + "otstartdate", OtApplyTypeEnum.OT_SD.getCode() + "." + "otenddate", OtApplyTypeEnum.OT_SC.getCode() + "." + "otdstarttime", OtApplyTypeEnum.OT_SC.getCode() + "." + "otdendtime", OtApplyTypeEnum.OT_SC.getCode() + "." + "dutydate"});
        return workServiceHelper.query(queryColumn, new QFilter[]{isNotChange, personIdFilter, auditPass, dateFilter});
    }

    private Map<Long, Map<Date, List<OtDutyDateStartEndTime>>> groupAndConvertOtDysByPerson(DynamicObject[] otDys) {
        HashMap allResult = Maps.newHashMapWithExpectedSize((int)otDys.length);
        for (DynamicObject otDy : otDys) {
            long personId = otDy.getLong("personid.id");
            Map localDateListMap = allResult.computeIfAbsent(personId, k -> Maps.newHashMapWithExpectedSize((int)10));
            Map<Date, List<OtDutyDateStartEndTime>> personOtTimeList = this.convertDy(otDy);
            personOtTimeList.forEach((key, val) -> {
                List otDutyDateStartEndTimes = localDateListMap.computeIfAbsent(key, k -> Lists.newArrayListWithExpectedSize((int)16));
                otDutyDateStartEndTimes.addAll(val);
            });
        }
        return allResult;
    }

    private Map<Date, List<OtDutyDateStartEndTime>> convertDy(DynamicObject otDy) {
        Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfoByType(otDy.getString("otapplytype"));
        DynamicObjectCollection collection = otDy.getDynamicObjectCollection(entryInfoByType.get("ENTRY_NAME"));
        HashMap result = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (DynamicObject dy : collection) {
            Date dutyDate = dy.getDate(entryInfoByType.get("DUTY_DAY_NAME"));
            List otTime = result.computeIfAbsent(dutyDate, k -> Lists.newArrayListWithExpectedSize((int)collection.size()));
            OtDutyDateStartEndTime otDutyDateStartEndTime = new OtDutyDateStartEndTime();
            Date otStartTime = dy.getDate(entryInfoByType.get("START_TIME_NAME"));
            otDutyDateStartEndTime.setStartTime(otStartTime);
            Date otEndTime = dy.getDate(entryInfoByType.get("END_TIME_NAME"));
            otDutyDateStartEndTime.setEndTime(otEndTime);
            otTime.add(otDutyDateStartEndTime);
        }
        return result;
    }

    private List<Date> getDateRange(Date startDate, Date endDate) {
        Date lastDate = startDate;
        ArrayList dateRange = Lists.newArrayListWithExpectedSize((int)10);
        while (lastDate.getTime() <= endDate.getTime()) {
            dateRange.add(lastDate);
            lastDate = HRDateTimeUtils.addDay((Date)lastDate, (long)1L);
        }
        return dateRange;
    }
}

