/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.sdk;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.wtc.wtbs.common.dto.shift.ShiftDto;
import kd.sdk.wtc.wtbs.common.enums.DutyDateErrorEnum;
import kd.sdk.wtc.wtom.business.applytime.OnCalOtApplyTimeEvent;
import kd.sdk.wtc.wtom.business.applytime.OnSetOtApplyTimeQuery;
import kd.sdk.wtc.wtom.business.applytime.OtApplyTimeExtPlugin;
import kd.sdk.wtc.wtom.business.common.OtRuleCalInfo;
import kd.sdk.wtc.wtom.business.common.OtRuleQuery;
import kd.sdk.wtc.wtom.business.common.OtRuleResp;
import kd.sdk.wtc.wtom.business.common.OtStandardDutyDateQuery;
import kd.sdk.wtc.wtom.business.common.OtStandardDutyDateResp;
import kd.sdk.wtc.wtom.business.validate.OtBillValidateResult;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.util.shift.ShiftConvertUtils;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.billservice.common.BillSetCommonService;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.business.web.billservice.plan.BillPlanService;
import kd.wtc.wtbs.business.web.billservice.rule.BillRuleService;
import kd.wtc.wtbs.business.web.billservice.shift.BillShiftService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.bill.PlanSceneEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.billservice.BillDutyDatePlanInfo;
import kd.wtc.wtbs.common.model.billservice.BillDutyDateRuleInfo;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.billservice.BillRuleField;
import kd.wtc.wtbs.common.model.billservice.BillSetSpiltRangeQuery;
import kd.wtc.wtbs.common.model.billservice.BillShiftParam;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTValidateService;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OTApplySdkHelper {
    public List<OtBillValidateResult> validateOtDy(List<DynamicObject> queryOtBillDys, String appId) {
        if (WTCCollections.isEmpty(queryOtBillDys)) {
            return Collections.emptyList();
        }
        List<DynamicObject> newDyList = this.copyOtBillDy(queryOtBillDys);
        OTValidateService otValidateService = new OTValidateService(newDyList.toArray(new DynamicObject[0]), appId, Collections.emptyMap());
        Map<Long, BillCheckResult> failInfoMap = otValidateService.verifyAll();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)queryOtBillDys.size());
        for (DynamicObject queryOtBillDy : queryOtBillDys) {
            OtBillValidateResult resp = new OtBillValidateResult();
            long billId = queryOtBillDy.getLong("id");
            BillCheckResult billCheckResult = failInfoMap.get(billId);
            resp.setOtBill(queryOtBillDy);
            resp.setSuccess(billCheckResult == null);
            if (billCheckResult != null) {
                resp.setOtBillValidateErrorInfo(billCheckResult.getFailEnumAndReasonMap());
            }
            result.add(resp);
        }
        return result;
    }

    private List<DynamicObject> copyOtBillDy(List<DynamicObject> queryOtBillDys) {
        if (WTCCollections.isEmpty(queryOtBillDys)) {
            return Collections.emptyList();
        }
        ArrayList newDyLists = Lists.newArrayListWithExpectedSize((int)queryOtBillDys.size());
        for (DynamicObject queryOtBillDy : queryOtBillDys) {
            int index;
            MainEntityType dyType = EntityMetadataCache.getDataEntityType((String)queryOtBillDy.getDataEntityType().getName());
            DynamicObject newDataEntity = (DynamicObject)dyType.createInstance();
            HRDynamicObjectUtils.copy((DynamicObject)queryOtBillDy, (DynamicObject)newDataEntity);
            newDataEntity.set("id", (Object)queryOtBillDy.getLong("id"));
            DynamicObjectCollection sourceScEntry = queryOtBillDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            DynamicObjectCollection sourceSdEntry = queryOtBillDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            DynamicObjectCollection scEntry = newDataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            DynamicObjectCollection sdEntry = newDataEntity.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            if (WTCCollections.isNotEmpty((Collection)scEntry)) {
                for (index = 0; index < scEntry.size(); ++index) {
                    ((DynamicObject)scEntry.get(index)).set("id", (Object)((DynamicObject)sourceScEntry.get(index)).getLong("id"));
                }
            }
            if (WTCCollections.isNotEmpty((Collection)sdEntry)) {
                for (index = 0; index < scEntry.size(); ++index) {
                    ((DynamicObject)sdEntry.get(index)).set("id", (Object)((DynamicObject)sourceSdEntry.get(index)).getLong("id"));
                }
            }
            newDyLists.add(newDataEntity);
        }
        return newDyLists;
    }

    public int getApplyTimeProxyResult(DynamicObject billDy, DynamicObject entryDy, int entryIndex, List<Tuple<DutyShift, Shift>> shiftInfo, int applyTimeInSec, WTCPluginProxy<OtApplyTimeExtPlugin> plugin) {
        if (plugin == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u52a0\u73ed\u65f6\u957f\u5165\u53c2\u4e0d\u6b63\u786e\u3002", (String)"OTApplySdkHelper_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
            if (billDy == null || entryDy == null || entryIndex < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u52a0\u73ed\u65f6\u957f\u5165\u53c2\u4e0d\u6b63\u786e\u3002", (String)"OTApplySdkHelper_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billDy.getDataEntityType().getName());
            OnSetOtApplyTimeQuery query = new OnSetOtApplyTimeQuery();
            DynamicObject newBillDy = serviceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)billDy, (DynamicObject)newBillDy);
            newBillDy.set("id", (Object)billDy.getLong("id"));
            query.setOtBillDy(newBillDy);
            DynamicObject newEntryDy = (DynamicObject)entryDy.getDataEntityType().createInstance();
            query.setEntryDy(newEntryDy);
            query.setEntryIndex(entryIndex);
            HashMap<LocalDate, ShiftDto> shiftDtoMap = new HashMap<LocalDate, ShiftDto>(16);
            if (WTCCollections.isNotEmpty(shiftInfo)) {
                for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : shiftInfo) {
                    DutyShift dutyShift = (DutyShift)dutyShiftShiftTuple.item1;
                    Shift shift = (Shift)dutyShiftShiftTuple.item2;
                    if (dutyShift == null || shift == null) continue;
                    ShiftDto shiftDto = ShiftConvertUtils.convertShift((Shift)shift);
                    Date rosterDate = dutyShift.getRosterDate();
                    if (rosterDate == null) continue;
                    shiftDtoMap.put(WTCDateUtils.toLocalDate((Date)rosterDate), shiftDto);
                }
            }
            query.setShiftDtoMap(shiftDtoMap);
            OnCalOtApplyTimeEvent onCalOtApplyTimeEvent = new OnCalOtApplyTimeEvent(query, applyTimeInSec);
            plugin.invokeReplace(service -> service.onSetOtApplyTimeEvent(onCalOtApplyTimeEvent));
            return onCalOtApplyTimeEvent.getApplyTimeInSec();
        }
        return applyTimeInSec;
    }

    public List<OtStandardDutyDateResp> fillOTDutyDateInfo(List<OtStandardDutyDateQuery> otDutyDateParamList) {
        this.verifyDutyDateParam(otDutyDateParamList);
        List<BillShiftParam> shiftParams = this.convertShiftParam(otDutyDateParamList);
        BillShiftService shiftService = new BillShiftService();
        shiftService.fillShiftInfo(shiftParams);
        BillOptionalDutyDateService dutyDateService = new BillOptionalDutyDateService();
        ArrayList dutyDateResps = Lists.newArrayListWithExpectedSize((int)otDutyDateParamList.size());
        for (int indexShift = 0; indexShift < shiftParams.size(); ++indexShift) {
            BillShiftParam shiftParam = shiftParams.get(indexShift);
            OtStandardDutyDateQuery standardDutyDateParam = otDutyDateParamList.get(indexShift);
            BillOptionDutyDateReq dutyDateReq = new BillOptionDutyDateReq();
            dutyDateReq.setAttFileBoId(Long.valueOf(standardDutyDateParam.getAttFileBoId()));
            dutyDateReq.setShiftInfo(this.transTuple(shiftParam.getDutyShiftAndShift()));
            dutyDateReq.setStartTime(standardDutyDateParam.getOtStartTime());
            dutyDateReq.setEndTime(standardDutyDateParam.getOtEndTime());
            BillOptionDutyDateResp dutyDate = dutyDateService.getDutyDate(dutyDateReq);
            dutyDateResps.add(dutyDate);
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)otDutyDateParamList.size());
        for (int index = 0; index < otDutyDateParamList.size(); ++index) {
            OtStandardDutyDateResp resp = new OtStandardDutyDateResp();
            OtStandardDutyDateQuery otStandardDutyDateQuery = otDutyDateParamList.get(index);
            BillOptionDutyDateResp billOptionDutyDateResp = (BillOptionDutyDateResp)dutyDateResps.get(index);
            resp.setStandardDutyDateQuery(otStandardDutyDateQuery);
            if (billOptionDutyDateResp.getErrorEnum() != null) {
                DutyDateErrorEnum dutyDateErrorEnum = DutyDateErrorEnum.getEnumByKey((String)billOptionDutyDateResp.getErrorEnum().getKey());
                resp.setErrorEnum(dutyDateErrorEnum);
            } else {
                resp.setDutyDate(billOptionDutyDateResp.getDutyDate());
            }
            result.add(resp);
        }
        return result;
    }

    public List<OtRuleResp> fillOTRuleInfo(List<OtRuleQuery> otRuleQueryList) {
        if (CollectionUtils.isEmpty(otRuleQueryList)) {
            return Collections.emptyList();
        }
        BillPlanService planService = new BillPlanService();
        List<BillDutyDatePlanInfo> billDutyDatePlanInfos = this.convertToBillDutyDatePlanInfo(otRuleQueryList);
        planService.fillPlanByAttFileAndDate(billDutyDatePlanInfos, AttFileScheduleEnum.OTP, "wtp_otplan");
        List<BillDutyDateRuleInfo> billDutyDateRuleInfos = this.convertToRuleParam(billDutyDatePlanInfos, otRuleQueryList);
        BillRuleService ruleService = new BillRuleService();
        BillRuleField field = new BillRuleField();
        field.setRuleEntityName("wtp_overworkrule");
        field.setRuleInPlan("overworkrule");
        field.setRuleCalEntryKeyName("overworkcalentry");
        field.setLimitJsonKeyName("limitscope");
        field.setTypeKeyName("ottype");
        field.setBillType(UnifyBillEnum.OT.name());
        ruleService.fillRuleCalByRetrieval(billDutyDateRuleInfos, PlanSceneEnum.OTP, field, true);
        Tuples.Tuple2<Date, Date> minAndMax = this.minAndMax(billDutyDateRuleInfos);
        HashSet<Long> allBaseSet = new HashSet<Long>(16);
        for (BillDutyDateRuleInfo billDutyDateRuleInfo : billDutyDateRuleInfos) {
            List ruleCalList = billDutyDateRuleInfo.getRuleCalList();
            if (CollectionUtils.isEmpty((Collection)ruleCalList)) continue;
            for (DynamicObject dynamicObject : ruleCalList) {
                DynamicObject otBaseSet = dynamicObject.getDynamicObject("otbaseset");
                if (otBaseSet == null) continue;
                allBaseSet.add(otBaseSet.getLong("id"));
            }
        }
        DynamicObject[] allSeqHisDys = UnifyBillCommonHelper.getAllSeqHisDys((String)"wtp_otbaseset", (Date)((Date)minAndMax.item1), (Date)((Date)minAndMax.item2), allBaseSet);
        return OTApplySdkHelper.getRuleResp(otRuleQueryList, billDutyDatePlanInfos, billDutyDateRuleInfos, allSeqHisDys);
    }

    private static List<OtRuleResp> getRuleResp(List<OtRuleQuery> otRuleQueryList, List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<BillDutyDateRuleInfo> billDutyDateRuleInfos, DynamicObject[] allSeqHisDys) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)otRuleQueryList.size());
        ArrayList<DynamicObject> engineQuery = new ArrayList<DynamicObject>(10);
        for (BillDutyDatePlanInfo billDutyDatePlanInfo : billDutyDatePlanInfos) {
            if (billDutyDatePlanInfo.getPlanDy() == null) continue;
            engineQuery.add(billDutyDatePlanInfo.getPlanDy());
        }
        Map planIdAndUseEngine = BillPlanService.getInstance().usePlanEngine(engineQuery);
        for (int index = 0; index < otRuleQueryList.size(); ++index) {
            Tuples.Tuple2 ruleRange;
            OtRuleResp resp = new OtRuleResp();
            OtRuleQuery ruleParam = otRuleQueryList.get(index);
            resp.setOtRuleQuery(ruleParam);
            BillDutyDateRuleInfo ruleInfo = billDutyDateRuleInfos.get(index);
            List ruleCalList = ruleInfo.getRuleCalList();
            if (CollectionUtils.isEmpty((Collection)ruleCalList)) {
                resp.setOtRuleCalInfoParams(Collections.emptyList());
            }
            resp.setPlanDy(ruleInfo.getPlanDy());
            resp.setRuleDy(ruleInfo.getRuleDy());
            DynamicObject attFileVersionDy = ruleInfo.getAttFileVersionDy();
            DynamicObject planVersionDy = ruleInfo.getPlanDy();
            boolean usedEngine = false;
            if (planVersionDy != null) {
                usedEngine = (Boolean)planIdAndUseEngine.get(planVersionDy.getLong("id"));
            }
            String engineCondition = usedEngine ? "usedEngine" : "";
            DynamicObject ruleVersionDy = ruleInfo.getRuleDy();
            Optional sideDyOption = BillPlanService.getInstance().getSideDy(billDutyDatePlanInfos, ruleInfo.getAttFileBoId(), ruleInfo.getQueryDate());
            DynamicObject sideDy = sideDyOption.orElse(null);
            LocalDate baseDate = WTCDateUtils.toLocalDate((Date)ruleInfo.getQueryDate());
            Tuples.Tuple2 planRange = BillSetCommonService.getInstance().splitHisPlanRange(attFileVersionDy, sideDy, planVersionDy, baseDate);
            if (planRange != null) {
                if (planRange.item1 != null) {
                    resp.setPlanEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item1)));
                }
                if (planRange.item2 != null) {
                    resp.setPlanEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)planRange.item2)));
                }
            }
            if ((ruleRange = BillSetCommonService.getInstance().splitHisRuleRange(attFileVersionDy, sideDy, planVersionDy, engineCondition, ruleVersionDy, baseDate)) != null) {
                if (ruleRange.item1 != null) {
                    resp.setRuleEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item1)));
                }
                if (ruleRange.item2 != null) {
                    resp.setRuleEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)ruleRange.item2)));
                }
            }
            ArrayList<OtRuleCalInfo> otRuleCalInfos = new ArrayList<OtRuleCalInfo>(10);
            for (DynamicObject dynamicObject : ruleCalList) {
                OtRuleCalInfo calInfoParam = new OtRuleCalInfo();
                DynamicObject baseSet = UnifyBillCommonHelper.getSeqHisDyByDate((Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dynamicObject, (String)"otbaseset"), (Date)ruleParam.getQueryDate(), (List)Lists.newArrayList((Object[])allSeqHisDys));
                calInfoParam.setRuleEntryCalDy(dynamicObject);
                calInfoParam.setBaseSetDy(baseSet);
                otRuleCalInfos.add(calInfoParam);
                String limitCondition = dynamicObject.getString("limitscope");
                BillSetSpiltRangeQuery billSetSpiltRangeQuery = new BillSetSpiltRangeQuery();
                billSetSpiltRangeQuery.setAttFileVersionDy(attFileVersionDy);
                billSetSpiltRangeQuery.setSideTableDy(sideDy);
                billSetSpiltRangeQuery.setPlanVersionDy(planVersionDy);
                billSetSpiltRangeQuery.setEngineCondition(engineCondition);
                billSetSpiltRangeQuery.setRuleVersionDy(ruleVersionDy);
                billSetSpiltRangeQuery.setLimitCondition(limitCondition);
                billSetSpiltRangeQuery.setCalSetVersionDy(baseSet);
                billSetSpiltRangeQuery.setBaseDate(baseDate);
                Tuples.Tuple2 rangeTime = BillSetCommonService.getInstance().splitHisBaseSet(billSetSpiltRangeQuery);
                if (rangeTime == null) continue;
                if (rangeTime.item1 != null) {
                    calInfoParam.setBaseSetEffectStart(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item1)));
                }
                if (rangeTime.item2 == null) continue;
                calInfoParam.setBaseSetEffectEnd(WTCDateUtils.toDate((LocalDate)((LocalDate)rangeTime.item2)));
            }
            resp.setOtRuleCalInfoParams(otRuleCalInfos);
            result.add(resp);
        }
        return result;
    }

    private Tuples.Tuple2<Date, Date> minAndMax(List<BillDutyDateRuleInfo> billDutyDateRuleInfos) {
        Date min = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMaxEndDate());
        Date max = WTCDateUtils.getDayStart((Date)WTCDateUtils.getMinEndDate());
        for (BillDutyDateRuleInfo ruleInfo : billDutyDateRuleInfos) {
            Date queryDate = ruleInfo.getQueryDate();
            if (queryDate == null) continue;
            if (queryDate.before(min)) {
                min = queryDate;
            }
            if (!queryDate.after(max)) continue;
            max = queryDate;
        }
        return new Tuples.Tuple2((Object)min, (Object)max);
    }

    private List<BillDutyDateRuleInfo> convertToRuleParam(List<BillDutyDatePlanInfo> billDutyDatePlanInfos, List<OtRuleQuery> otRuleQueryList) {
        ArrayList<BillDutyDateRuleInfo> result = new ArrayList<BillDutyDateRuleInfo>(10);
        for (int index = 0; index < otRuleQueryList.size(); ++index) {
            OtRuleQuery ruleParam = otRuleQueryList.get(index);
            BillDutyDatePlanInfo billDutyDatePlanInfo = billDutyDatePlanInfos.get(index);
            BillDutyDateRuleInfo ruleInfo = new BillDutyDateRuleInfo(billDutyDatePlanInfo.getAttFileBoId(), billDutyDatePlanInfo.getQueryDate(), billDutyDatePlanInfo.getPlanDy(), ruleParam.getOtType());
            DynamicObject otBillDy = ruleParam.getOtBillDy();
            if (otBillDy != null) {
                Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(otBillDy);
                String entryName = entryInfo.get("ENTRY_NAME");
                ruleInfo.setBillDy(otBillDy);
                ruleInfo.setEntryKey(entryName);
                ruleInfo.setEntryIndex(ruleParam.getEntryIndex());
            }
            result.add(ruleInfo);
        }
        return result;
    }

    private List<BillDutyDatePlanInfo> convertToBillDutyDatePlanInfo(List<OtRuleQuery> otRuleQueryList) {
        ArrayList<BillDutyDatePlanInfo> result = new ArrayList<BillDutyDatePlanInfo>(10);
        for (OtRuleQuery otRuleQuery : otRuleQueryList) {
            BillDutyDatePlanInfo billDutyDatePlanInfo = new BillDutyDatePlanInfo(otRuleQuery.getAttFileBoId(), WTCDateUtils.getDayStart((Date)otRuleQuery.getQueryDate()));
            result.add(billDutyDatePlanInfo);
        }
        return result;
    }

    private List<Tuple<DutyShift, Shift>> transTuple(List<Tuples.Tuple2<DutyShift, Shift>> tuple2Data) {
        if (CollectionUtils.isEmpty(tuple2Data)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)tuple2Data.size());
        for (Tuples.Tuple2<DutyShift, Shift> tuple2Datum : tuple2Data) {
            result.add(new Tuple(tuple2Datum.item1, tuple2Datum.item2));
        }
        return result;
    }

    private List<BillShiftParam> convertShiftParam(List<OtStandardDutyDateQuery> otDutyDateParam) {
        ArrayList shiftParams = Lists.newArrayListWithExpectedSize((int)otDutyDateParam.size());
        for (OtStandardDutyDateQuery otStandardDutyDateQuery : otDutyDateParam) {
            Date start = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)otStandardDutyDateQuery.getOtStartTime()), (long)-3L);
            Date end = HRDateTimeUtils.addDay((Date)WTCDateUtils.getDayStart((Date)otStandardDutyDateQuery.getOtEndTime()), (long)3L);
            shiftParams.add(new BillShiftParam(otStandardDutyDateQuery.getAttFileBoId(), start, end));
        }
        return shiftParams;
    }

    private void verifyDutyDateParam(List<OtStandardDutyDateQuery> dutyDateParam) {
        for (OtStandardDutyDateQuery otStandardDutyDateQuery : dutyDateParam) {
            long attFileBoId = otStandardDutyDateQuery.getAttFileBoId();
            if (attFileBoId != 0L && otStandardDutyDateQuery.getOtStartTime() != null && otStandardDutyDateQuery.getOtEndTime() != null) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65f6\u95f4\u8303\u56f4\uff1a1900-01-01\u81f32099-12-31\u3002", (String)"OTApplySdkHelper_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
    }
}

