/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.unifybill.matchcore.entry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtom.OnMatchOtDutyDateEvent;
import kd.sdk.wtc.wtom.OtDutyDateParam;
import kd.sdk.wtc.wtom.business.OtDutyDateExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.applybill.callchain.UnifyCallChainService;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.UnifyEntryDutyDateService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.business.web.billservice.dutyDate.BillOptionalDutyDateService;
import kd.wtc.wtbs.common.enums.bill.ApplyBillDutyDateErrorEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateReq;
import kd.wtc.wtbs.common.model.billservice.BillOptionDutyDateResp;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.business.OTApplyUtil;
import kd.wtc.wtom.business.unifybill.callchain.OtUnifyCallChainService;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.business.unifybill.operatecore.OTApplyBillOperator;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;
import kd.wtc.wtom.common.model.otapply.OTBillServiceEntryResult;
import kd.wtc.wtom.common.model.otapply.OTBillServiceResult;

public class UnifyEntryDutyDateOtService
extends UnifyEntryDutyDateService {
    private final List<DynamicObject> operatingDyList;
    private static final Log LOG = LogFactory.getLog(UnifyEntryDutyDateOtService.class);

    public UnifyEntryDutyDateOtService(OTApplyBillOperator operator, List<DynamicObject> operatingDyList) {
        super((WtcAbstractUnityBillOperator)operator);
        this.operatingDyList = operatingDyList;
    }

    public OTApplyBillOperator getOperator() {
        return (OTApplyBillOperator)super.getOperator();
    }

    protected UnifyCallChainService choseCallChainService() {
        return new OtUnifyCallChainService(this.getOperator());
    }

    protected void beforeStartMatch() {
        super.beforeStartMatch();
    }

    protected void matchProcess() {
        List billServiceInfoList = this.getBillInfoContext().getBillResult();
        List<UnifyBillResult> sdData = billServiceInfoList.stream().filter(res -> {
            OTBillServiceResult billInfo = this.getOTBillInfo((UnifyBillResult)res);
            return OtApplyTypeEnum.OT_SD == billInfo.getOtApplyTypeEnum();
        }).collect(Collectors.toList());
        BillOptionalDutyDateService service = new BillOptionalDutyDateService();
        List<Tuple<DutyShift, Shift>> dutyShiftRange = this.getDutyShiftRange(sdData);
        for (UnifyBillResult serviceResult : sdData) {
            long attFileBoId = serviceResult.getAttFileBoId();
            ArrayList<Tuple<DutyShift, Shift>> dutyShiftRangeInAttFileBoId = new ArrayList<Tuple<DutyShift, Shift>>(10);
            for (Tuple<DutyShift, Shift> dutyShiftShiftTuple : dutyShiftRange) {
                Long attFileBaseBoId;
                DutyShift dutyShift = (DutyShift)dutyShiftShiftTuple.item1;
                if (dutyShift == null || (attFileBaseBoId = dutyShift.getAttFileBaseBoId()) == null || attFileBaseBoId != attFileBoId) continue;
                dutyShiftRangeInAttFileBoId.add(dutyShiftShiftTuple);
            }
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                BillOptionDutyDateReq req = new BillOptionDutyDateReq();
                req.setAttFileBoId(Long.valueOf(serviceResult.getAttFileBoId()));
                req.setShiftInfo(dutyShiftRangeInAttFileBoId);
                req.setEndTime(billServiceEntryResult.getDutyDateQueryEndTime());
                req.setStartTime(billServiceEntryResult.getDutyDateQueryStartTime());
                BillOptionDutyDateResp dutyDateInfo = service.getDutyDate(req);
                if (dutyDateInfo.isCorrectMatch()) {
                    billServiceEntryResult.setHaveCorrectDuty(Boolean.TRUE);
                    UnifyBillDutyInfoResult dutyInfoResult = new UnifyBillDutyInfoResult(dutyDateInfo.getDutyDate());
                    dutyInfoResult.setEntryMainDutyDate(dutyDateInfo.getDutyDate());
                    billServiceEntryResult.setDutyInfos((List)Lists.newArrayList((Object[])new UnifyBillDutyInfoResult[]{dutyInfoResult}));
                    continue;
                }
                billServiceEntryResult.setHaveCorrectDuty(Boolean.FALSE);
                billServiceEntryResult.setBillDutyDateErrorEnum(dutyDateInfo.getErrorEnum());
            }
        }
        for (UnifyBillResult billServiceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                OTBillServiceEntryResult otBillServiceEntryResult = OtUnifyBillCommonHelper.getOTBillEntryInfo(billServiceEntryResult);
                if (otBillServiceEntryResult.getCheckInShiftOt().booleanValue()) continue;
                billServiceEntryResult.setBillDutyDateErrorEnum(ApplyBillDutyDateErrorEnum.INSHIFTOT);
                billServiceEntryResult.getDutyInfos().clear();
                LOG.info("UnifyEntryDutyDateOtService.matchProcess clear in shift");
            }
        }
        WTCPluginProxy plugin = WTCPluginProxyFactory.create(OtDutyDateExtPlugin.class, (String)"kd.sdk.wtc.wtom.business.OtDutyDateExtPlugin");
        if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
            LOG.info("UnifyEntryDutyDateOtService_matchProcess \u5b58\u5728\u4e8c\u5f00\u57cb\u70b9\uff0c\u8fdb\u884c\u91cd\u65b0\u8d4b\u503c\u5f52\u5c5e\u65e5\u671f");
            this.getCustomDutyDate(sdData);
        }
        List scData = billServiceInfoList.stream().filter(res -> {
            OTBillServiceResult billInfo = this.getOTBillInfo((UnifyBillResult)res);
            return OtApplyTypeEnum.OT_SC == billInfo.getOtApplyTypeEnum();
        }).collect(Collectors.toList());
        for (UnifyBillResult serviceResult : scData) {
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                Date endTime = WTCDateUtils.getDayStartTime((Date)billServiceEntryResult.getDutyDateQueryEndTime());
                Date startTime = WTCDateUtils.getDayStartTime((Date)billServiceEntryResult.getDutyDateQueryStartTime());
                ArrayList dutyInfos = Lists.newArrayListWithExpectedSize((int)10);
                while (startTime.getTime() <= endTime.getTime()) {
                    dutyInfos.add(new UnifyBillDutyInfoResult(startTime));
                    startTime = HRDateTimeUtils.addDay((Date)startTime, (long)1L);
                }
                billServiceEntryResult.setDutyInfos((List)dutyInfos);
                billServiceEntryResult.setHaveCorrectDuty(Boolean.TRUE);
            }
        }
        this.getBillInfoContext().getBillResult().clear();
        this.getBillInfoContext().getBillResult().addAll(sdData);
        this.getBillInfoContext().getBillResult().addAll(scData);
    }

    private OTBillServiceResult getOTBillInfo(UnifyBillResult billServiceResult) {
        if (billServiceResult.getExpandInfo() == null) {
            billServiceResult.setExpandInfo((Object)new OTBillServiceResult());
        }
        return (OTBillServiceResult)billServiceResult.getExpandInfo();
    }

    private List<Tuple<DutyShift, Shift>> getDutyShiftRange(List<UnifyBillResult> billCheckInfoList) {
        ArrayList countDutyShiftRange = Lists.newArrayListWithExpectedSize((int)16);
        for (UnifyBillResult billServiceResult : billCheckInfoList) {
            for (UnifyBillEntryResult billServiceEntryResult : billServiceResult.getEntryResultList()) {
                List dutyShiftRange = billServiceEntryResult.getDutyShiftRange();
                if (CollectionUtils.isEmpty((Collection)dutyShiftRange)) continue;
                countDutyShiftRange.addAll(dutyShiftRange);
            }
        }
        return countDutyShiftRange;
    }

    private void getCustomDutyDate(List<UnifyBillResult> unifyBillResults) {
        List<OtDutyDateParam> otDutyDateParams = this.getCustomParam(unifyBillResults);
        if (CollectionUtils.isEmpty(otDutyDateParams)) {
            return;
        }
        LOG.info("UnifyEntryDutyDateOtService_getCustomDutyDate  otDutyDateParams.size={}", (Object)otDutyDateParams.size());
        this.getOtIntervalDutyDate(otDutyDateParams);
        List<Tuple<DutyShift, Shift>> shiftInfoList = this.getShiftInfo(unifyBillResults);
        this.verifyCustomDate(otDutyDateParams, shiftInfoList);
        for (int index = 0; index < otDutyDateParams.size(); ++index) {
            OtDutyDateParam param = otDutyDateParams.get(index);
            long billId = param.getOtBillDy().getLong("id");
            int entryIndex = param.getEntryIndex();
            Date customDutyDate = param.getCustomizedDutyDate();
            for (UnifyBillResult unifyBillResult : unifyBillResults) {
                long oriBillId = unifyBillResult.getBillId();
                if (oriBillId != billId) continue;
                this.changeDutyForEntryResult(unifyBillResult.getEntryResultList(), entryIndex, customDutyDate);
            }
        }
    }

    private void verifyCustomDate(List<OtDutyDateParam> otDutyDateParams, List<Tuple<DutyShift, Shift>> shiftInfoList) {
        for (int index = 0; index < otDutyDateParams.size(); ++index) {
            OtDutyDateParam reqParam = otDutyDateParams.get(index);
            Date customDate = reqParam.getCustomizedDutyDate();
            Date standardDutyDate = reqParam.getStandardDutyDate();
            if (standardDutyDate != null && customDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u52a0\u73ed\u65e5\u671f\u4e0d\u5141\u8bb8\u8fd4\u56de\u4e3a\u7a7a\u3002", (String)"UnifyEntryDutyDateOtService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            if (customDate == null) continue;
            if (customDate.compareTo(WTCDateUtils.getDayBegin((Date)customDate)) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u73ed\u5f52\u5c5e\u65e5\u671f\u53ea\u652f\u6301\u5230\u5929\uff0c\u4e0d\u652f\u6301\u5177\u4f53\u65f6\u5206\u3002", (String)"UnifyEntryDutyDateOtService_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            Date preStandardDutyDate = WTCDateUtils.addDays((Date)standardDutyDate, (int)-2);
            Date afterStandardDutyDate = WTCDateUtils.addDays((Date)standardDutyDate, (int)2);
            if (standardDutyDate != null && (customDate.before(preStandardDutyDate) || customDate.after(afterStandardDutyDate))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8fd4\u56de\u8be5\u81ea\u5b9a\u4e49\u52a0\u73ed\u65e5\u671f\u3002", (String)"UnifyEntryDutyDateOtService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            long attFileBoId = 0L;
            if (reqParam.getOtBillDy() != null) {
                attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)reqParam.getOtBillDy(), (String)"attfile");
            }
            ArrayList<Tuple<DutyShift, Shift>> shiftInfoListAfterFilter = new ArrayList<Tuple<DutyShift, Shift>>(10);
            if (WTCCollections.isNotEmpty(shiftInfoList)) {
                for (Tuple<DutyShift, Shift> tuple : shiftInfoList) {
                    if (tuple == null || tuple.item1 == null || ((DutyShift)tuple.item1).getAttFileBaseBoId() != attFileBoId) continue;
                    shiftInfoListAfterFilter.add(tuple);
                }
            }
            boolean match = false;
            for (Tuple dutyShiftShiftTuple3 : shiftInfoListAfterFilter) {
                Date shiftRosterDate = ((DutyShift)dutyShiftShiftTuple3.item1).getRosterDate();
                if (shiftRosterDate.compareTo(customDate) != 0) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u52a0\u73ed\u65e5\u671f\u4e0b\u6ca1\u6709\u6392\u73ed\u3002", (String)"UnifyEntryDutyDateOtService_3", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = reqParam.getEntryDy();
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4f20\u5165\u7684\u5206\u5f55\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"UnifyEntryDutyDateOtService_4", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            HashSet exceptionalDate = Sets.newHashSetWithExpectedSize((int)16);
            if (standardDutyDate != null) {
                exceptionalDate.add(standardDutyDate);
            }
            List<Date> allowAdjustmentOtDate = OTApplyUtil.allowAdjustmentOtDate(dynamicObject.getDate("otstartdate"), dynamicObject.getDate("otenddate"), shiftInfoListAfterFilter, exceptionalDate);
            boolean passDutyDateCheck = false;
            for (Date date : allowAdjustmentOtDate) {
                if (!HRStringUtils.equals((String)HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd"), (String)HRDateTimeUtils.format((Date)customDate, (String)"yyyy-MM-dd"))) continue;
                passDutyDateCheck = true;
                break;
            }
            if (passDutyDateCheck) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8fd4\u56de\u8be5\u81ea\u5b9a\u4e49\u52a0\u73ed\u65e5\u671f\u3002", (String)"UnifyEntryDutyDateOtService_5", (String)"wtc-wtom-business", (Object[])new Object[0]));
        }
    }

    private List<Tuple<DutyShift, Shift>> getShiftInfo(List<UnifyBillResult> unifyBillResults) {
        ArrayList<Tuple<DutyShift, Shift>> shiftInfoList = new ArrayList<Tuple<DutyShift, Shift>>(10);
        if (CollectionUtils.isEmpty(unifyBillResults)) {
            return shiftInfoList;
        }
        for (UnifyBillResult unifyBillResult : unifyBillResults) {
            for (UnifyBillEntryResult unifyBillEntryResult : unifyBillResult.getEntryResultList()) {
                shiftInfoList.addAll(unifyBillEntryResult.getDutyShiftRange());
            }
        }
        return shiftInfoList;
    }

    private void changeDutyForEntryResult(List<UnifyBillEntryResult> unifyBillEntryResults, int matchEntryIndex, Date customDutyDate) {
        if (CollectionUtils.isEmpty(unifyBillEntryResults)) {
            return;
        }
        for (UnifyBillEntryResult unifyBillEntryResult : unifyBillEntryResults) {
            if (unifyBillEntryResult.getEntryIndex() != matchEntryIndex) continue;
            List dutyInfos = unifyBillEntryResult.getDutyInfos();
            if (customDutyDate == null && CollectionUtils.isEmpty((Collection)dutyInfos)) break;
            if (customDutyDate == null && CollectionUtils.isNotEmpty((Collection)dutyInfos)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u52a0\u73ed\u65e5\u671f\u4e0d\u5141\u8bb8\u8fd4\u56de\u4e3a\u7a7a\u3002", (String)"UnifyEntryDutyDateOtService_6", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            UnifyBillDutyInfoResult dutyInfoResult = new UnifyBillDutyInfoResult(customDutyDate);
            unifyBillEntryResult.setDutyInfos((List)Lists.newArrayList((Object[])new UnifyBillDutyInfoResult[]{dutyInfoResult}));
            unifyBillEntryResult.setBillDutyDateErrorEnum(null);
        }
    }

    private List<OtDutyDateParam> getCustomParam(List<UnifyBillResult> unifyBillResults) {
        ArrayList otDutyDateParams = Lists.newArrayListWithExpectedSize((int)unifyBillResults.size());
        if (CollectionUtils.isEmpty(unifyBillResults) || CollectionUtils.isEmpty(this.operatingDyList)) {
            return otDutyDateParams;
        }
        for (UnifyBillResult unifyBillResult : unifyBillResults) {
            long billId = unifyBillResult.getBillId();
            for (UnifyBillEntryResult unifyBillEntryResult : unifyBillResult.getEntryResultList()) {
                DynamicObjectCollection entryColl;
                int entryIndex = unifyBillEntryResult.getEntryIndex();
                DynamicObject matchDy = null;
                for (DynamicObject dynamicObject : this.operatingDyList) {
                    if (dynamicObject.getLong("id") != billId) continue;
                    matchDy = dynamicObject;
                }
                if (matchDy == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u52a0\u73ed\u65e5\u671f\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u52a0\u73ed\u5355\u4fe1\u606f\u3002", (String)"UnifyEntryDutyDateOtService_7", (String)"wtc-wtom-business", (Object[])new Object[0]));
                }
                String entity = matchDy.getDataEntityType().getName();
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entity);
                DynamicObject newObject = serviceHelper.generateEmptyDynamicObject();
                DynamicObjectUtils.copy((DynamicObject)matchDy, (DynamicObject)newObject);
                newObject.set("id", (Object)matchDy.getLong("id"));
                Date standardDutyDate = null;
                List dutyInfos = unifyBillEntryResult.getDutyInfos();
                if (!CollectionUtils.isEmpty((Collection)dutyInfos)) {
                    standardDutyDate = ((UnifyBillDutyInfoResult)dutyInfos.get(0)).getDutyDate();
                }
                if ((entryColl = newObject.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode())).size() < entryIndex + 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u52a0\u73ed\u65e5\u671f\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u52a0\u73ed\u5355\u5206\u5f55\u4fe1\u606f\u3002", (String)"UnifyEntryDutyDateOtService_8", (String)"wtc-wtom-business", (Object[])new Object[0]));
                }
                OtDutyDateParam reqParam = new OtDutyDateParam(newObject, (DynamicObject)entryColl.get(entryIndex), entryIndex, standardDutyDate);
                otDutyDateParams.add(reqParam);
            }
        }
        return otDutyDateParams;
    }

    private void getOtIntervalDutyDate(List<OtDutyDateParam> otDutyDateParam) {
        WTCPluginProxy plugin = WTCPluginProxyFactory.create(OtDutyDateExtPlugin.class, (String)"kd.sdk.wtc.wtom.business.OtDutyDateExtPlugin");
        if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
            plugin.invokeReplace(service -> {
                OnMatchOtDutyDateEvent onMatchOtDutyDateEvent = new OnMatchOtDutyDateEvent();
                onMatchOtDutyDateEvent.setOtDutyDateParams(otDutyDateParam);
                service.onMatchOtDutyDate(onMatchOtDutyDateEvent);
            });
        }
    }
}

