/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.unifybill.matchcore.entry;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.web.applybill.callchain.UnifyCallChainService;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillDutyInfoResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtom.business.unifybill.callchain.OtUnifyCallChainService;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.business.unifybill.operatecore.OTApplyBillOperator;
import kd.wtc.wtom.common.model.otapply.OTBillServiceResultDutyInfo;

public class UnifyEntryFlxOtService
extends AbstractUnifyEntryService<Map<Date, Boolean>> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryFlxOtService.class);

    public UnifyEntryFlxOtService(OTApplyBillOperator operator) {
        super((WtcAbstractUnityBillOperator)operator);
    }

    public OTApplyBillOperator getOperator() {
        return (OTApplyBillOperator)super.getOperator();
    }

    protected void matchProcess() {
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                this.setFlxOtTOEntryInfo(billServiceEntryResult);
            }
        }
    }

    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchFlxOtResult;
    }

    protected UnifyCallChainService choseCallChainService() {
        return new OtUnifyCallChainService(this.getOperator());
    }

    protected Map<Date, Boolean> getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        List matchResult = UnifyBillCommonHelper.matchOneBillDutyDateInfo((long)attFileBoId, (Date)dutyDateQueryStartTime, (Date)dutyDateQueryEndTime, null, (List)this.getBillInfoContext().getBillResult());
        HashMap result = Maps.newHashMapWithExpectedSize((int)matchResult.size());
        for (UnifyBillDutyInfoResult dutyInfo : matchResult) {
            result.put(dutyInfo.getDutyDate(), ((OTBillServiceResultDutyInfo)dutyInfo.getExpandInfo()).getCheckFlxOtResult());
        }
        return result;
    }

    protected Map<Date, Boolean> getResult(long billId, int entryIndex) {
        List matchResult = UnifyBillCommonHelper.matchDutyInfoByBillIdAndIndex((long)billId, (int)entryIndex, (List)this.getBillInfoContext().getBillResult());
        HashMap result = Maps.newHashMapWithExpectedSize((int)matchResult.size());
        for (UnifyBillDutyInfoResult dutyInfo : matchResult) {
            result.put(dutyInfo.getDutyDate(), ((OTBillServiceResultDutyInfo)dutyInfo.getExpandInfo()).getCheckFlxOtResult());
        }
        return result;
    }

    private void setFlxOtTOEntryInfo(UnifyBillEntryResult billServiceEntryResult) {
        Date startTime = billServiceEntryResult.getDutyDateQueryStartTime();
        Date endTime = billServiceEntryResult.getDutyDateQueryEndTime();
        for (UnifyBillDutyInfoResult dutyInfo : billServiceEntryResult.getDutyInfos()) {
            OTBillServiceResultDutyInfo otBillServiceResultDutyInfo = OtUnifyBillCommonHelper.getOTDutyDateCheckInfo(dutyInfo);
            otBillServiceResultDutyInfo.setCheckFlxOtResult(Boolean.TRUE);
            DynamicObject baseSetDy = dutyInfo.getMatchBaseSet();
            DutyShift dutyShift = dutyInfo.getDutyShift();
            Shift shift = dutyInfo.getShift();
            otBillServiceResultDutyInfo.setCheckFlxOtResult(Boolean.valueOf(OtUnifyBillCommonHelper.checkFlx(startTime, endTime, baseSetDy, dutyShift, shift)));
        }
    }
}

