/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.unifybill.matchcore.entry;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.business.web.applybill.callchain.UnifyCallChainService;
import kd.wtc.wtbs.business.web.applybill.commonhelper.UnifyBillCommonHelper;
import kd.wtc.wtbs.business.web.applybill.matchcore.entry.AbstractUnifyEntryService;
import kd.wtc.wtbs.business.web.applybill.operatecore.WtcAbstractUnityBillOperator;
import kd.wtc.wtbs.common.enums.bill.UnifyCallChainEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillEntryResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillResult;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.wtte.common.enums.OutWorkType;
import kd.wtc.wtom.business.unifybill.callchain.OtUnifyCallChainService;
import kd.wtc.wtom.business.unifybill.commonhelper.OtUnifyBillCommonHelper;
import kd.wtc.wtom.business.unifybill.operatecore.OTApplyBillOperator;
import kd.wtc.wtom.common.model.otapply.OTBillServiceEntryResult;

public class UnifyEntryInShiftService
extends AbstractUnifyEntryService<Boolean> {
    private static final Log LOG = LogFactory.getLog(UnifyEntryInShiftService.class);

    public UnifyEntryInShiftService(OTApplyBillOperator operator) {
        super((WtcAbstractUnityBillOperator)operator);
    }

    public OTApplyBillOperator getOperator() {
        return (OTApplyBillOperator)super.getOperator();
    }

    protected void matchProcess() {
        for (UnifyBillResult serviceResult : this.getBillInfoContext().getBillResult()) {
            for (UnifyBillEntryResult billServiceEntryResult : serviceResult.getEntryResultList()) {
                this.setInShiftToEntryInfo(billServiceEntryResult);
            }
        }
    }

    protected UnifyCallChainEnum defineUnifyCallChainEnum() {
        return UnifyCallChainEnum.matchInShiftOt;
    }

    protected UnifyCallChainService choseCallChainService() {
        return new OtUnifyCallChainService(this.getOperator());
    }

    protected Boolean getResult(long attFileBoId, Date dutyDateQueryStartTime, Date dutyDateQueryEndTime) {
        UnifyBillEntryResult matchResult = UnifyBillCommonHelper.matchEntryInfo((long)attFileBoId, (Date)dutyDateQueryStartTime, (Date)dutyDateQueryEndTime, (List)this.getBillInfoContext().getBillResult());
        if (matchResult == null) {
            return Boolean.FALSE;
        }
        return OtUnifyBillCommonHelper.getOTBillEntryInfo(matchResult).getCheckInShiftOt();
    }

    protected Boolean getResult(long billId, int entryIndex) {
        UnifyBillEntryResult matchResult = UnifyBillCommonHelper.matchEntryInfo((long)billId, (int)entryIndex, (List)this.getBillInfoContext().getBillResult());
        if (matchResult == null) {
            return Boolean.FALSE;
        }
        return OtUnifyBillCommonHelper.getOTBillEntryInfo(matchResult).getCheckInShiftOt();
    }

    private void setInShiftToEntryInfo(UnifyBillEntryResult billServiceEntryResult) {
        Date startTime = billServiceEntryResult.getDutyDateQueryStartTime();
        Date endTime = billServiceEntryResult.getDutyDateQueryEndTime();
        OTBillServiceEntryResult otBillServiceEntryResult = OtUnifyBillCommonHelper.getOTBillEntryInfo(billServiceEntryResult);
        otBillServiceEntryResult.setCheckInShiftOt(Boolean.TRUE);
        for (Tuple dutyShiftShiftTuple : billServiceEntryResult.getDutyShiftRange()) {
            DutyShift dutyShift = (DutyShift)dutyShiftShiftTuple.item1;
            Shift shift = (Shift)dutyShiftShiftTuple.item2;
            if (shift == null || dutyShift == null) {
                otBillServiceEntryResult.setCheckInShiftOt(Boolean.TRUE);
                continue;
            }
            if (shift.isOff()) {
                otBillServiceEntryResult.setCheckInShiftOt(Boolean.TRUE);
                continue;
            }
            List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime = OtUnifyBillCommonHelper.getShiftDetailAbsoluteTime(dutyShift, shift);
            LOG.info("UnifyEntryInShiftService.setInShiftToEntryInfo shiftDetailAbsoluteTime={}", (Object)JSON.toJSONString(shiftDetailAbsoluteTime));
            if (shiftDetailAbsoluteTime.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u73ed\u6b21\u4fe1\u606f\u3002", (String)"UnifyEntryInShiftService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
            }
            if (!this.otNotInAttendTime(shiftDetailAbsoluteTime, startTime, endTime)) {
                otBillServiceEntryResult.setCheckInShiftOt(Boolean.FALSE);
                return;
            }
            otBillServiceEntryResult.setCheckInShiftOt(Boolean.TRUE);
        }
    }

    private boolean otNotInAttendTime(List<Tuples.Tuple3<String, Date, Date>> shiftDetailAbsoluteTime, Date otStartTime, Date otEndTime) {
        ArrayList unVerifyTypeCodeList = Lists.newArrayList((Object[])new String[]{OutWorkType.BREAK.code, OutWorkType.OT.code});
        Set needVerifyTime = shiftDetailAbsoluteTime.stream().filter(sa -> !unVerifyTypeCodeList.contains(sa.item1) && this.inTimeBucketNotEquals((Date)sa.item2, (Date)sa.item3, otStartTime, otEndTime)).collect(Collectors.toSet());
        return CollectionUtils.isEmpty(needVerifyTime);
    }

    private boolean inTimeBucketNotEquals(Date startTime, Date endTime, Date verifyStartTime, Date verifyEndTime) {
        return WTCDateUtils.betweenDayNotEquals((Date)verifyStartTime, (Date)startTime, (Date)endTime) || WTCDateUtils.betweenDayNotEquals((Date)verifyEndTime, (Date)startTime, (Date)endTime) || WTCDateUtils.betweenDayNotEquals((Date)startTime, (Date)verifyStartTime, (Date)verifyEndTime) || WTCDateUtils.betweenDayNotEquals((Date)endTime, (Date)verifyStartTime, (Date)verifyEndTime) || startTime.getTime() == verifyStartTime.getTime() && endTime.getTime() == verifyEndTime.getTime();
    }
}

