/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.view;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.model.bill.BillCheckResult;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtom.business.OTBillHelper;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.common.constants.OTCheckTypeEnum;

public class OtBillListCommonService {
    public void beforeDoOperationOfChange(BeforeDoOperationEventArgs args, IFormView formView) {
        HashSet ps = new HashSet();
        HashSet longs = new HashSet();
        ListSelectedRowCollection listSelectedDatas = args.getListSelectedData();
        listSelectedDatas.forEach(row -> {
            long id = (Long)row.getPrimaryKeyValue();
            longs.add(id);
            ps.add(row);
        });
        if (longs.size() > 1) {
            formView.showTipNotification(OTKdStringHelper.chooseOne());
            args.setCancel(true);
            return;
        }
        ListSelectedRow row2 = (ListSelectedRow)ps.iterator().next();
        String billStatus = row2.getBillStatus();
        if (!HRStringUtils.equals((String)"C", (String)billStatus)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u3002", (String)"OtBillListCommonService_0", (String)"wtc-wtom-business", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
        long id = (Long)row2.getPrimaryKeyValue();
        DynamicObject dynamicObject = helper.queryOne((Object)id);
        if (dynamicObject.getBoolean("ischange")) {
            formView.showTipNotification(OTKdStringHelper.onlyOne());
            args.setCancel(true);
            return;
        }
        UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
        String formId = HRStringUtils.equals((String)dynamicObject.getString("applytyperadio"), (String)"0") ? "wtom_otbillself" : "wtom_overtimeapplybill";
        unifyBillApplyAttr.setAttFileF7AuthAppId(formView.getFormShowParameter().getAppId());
        unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
        unifyBillApplyAttr.setAttFileF7AuthEntity(formId);
        OTBillHelper billHelper = new OTBillHelper(new DynamicObject[]{dynamicObject}, unifyBillApplyAttr);
        DynamicObjectCollection scEntry = dynamicObject.getDynamicObjectCollection("scentry");
        String resMsg = OTKdStringHelper.frozen();
        for (int index = 0; index < scEntry.size(); ++index) {
            BillCheckResult billCheckResult = billHelper.checkEntry(OTCheckTypeEnum.FROZEN, dynamicObject, index, resMsg);
            if (billCheckResult.isVerifyResult()) continue;
            this.spec(billCheckResult, formView);
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection sdEntry = dynamicObject.getDynamicObjectCollection("sdentry");
        for (int index = 0; index < sdEntry.size(); ++index) {
            BillCheckResult billCheckResult = billHelper.checkEntry(OTCheckTypeEnum.FROZEN, dynamicObject, index, resMsg);
            if (billCheckResult.isVerifyResult()) continue;
            args.setCancel(true);
            this.spec(billCheckResult, formView);
            return;
        }
        ListView listView = (ListView)formView;
        if (HRStringUtils.equals((String)"wtom_overtimeapplybill", (String)listView.getBillFormId()) && BillUnifyService.verifyAttFileContainsCurrentUser((DynamicObject[])new DynamicObject[]{dynamicObject}, (IFormView)formView)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u4e3a\u4ed6\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u672c\u4eba\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"OtBillListCommonService_1", (String)"wtc-wtom-business", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)"wtom_otbillself", (String)listView.getBillFormId()) && dynamicObject.getBoolean("applytyperadio")) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u53ef\u5728\u672c\u4eba\u7533\u8bf7\u9875\u9762\u53d8\u66f4\u4ed6\u4eba\u4e3a\u6211\u7533\u8bf7\u7684\u5355\u636e\u3002", (String)"OtBillListCommonService_2", (String)"wtc-wtom-business", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void spec(BillCheckResult billCheckResult, IFormView formView) {
        List msgList = billCheckResult.getMsg();
        if (!msgList.isEmpty()) {
            String msg = (String)msgList.get(0);
            formView.showTipNotification(msg);
        }
    }
}

