/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtom.business.web;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtom.business.common.OtRuleCalInfo;
import kd.sdk.wtc.wtom.business.common.OtRuleQuery;
import kd.sdk.wtc.wtom.business.common.OtRuleResp;
import kd.sdk.wtc.wtom.business.common.OtStandardDutyDateQuery;
import kd.sdk.wtc.wtom.business.common.OtStandardDutyDateResp;
import kd.wtc.wtbd.common.enums.ot.OtCompentEnum;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.rulecondition.RuleConditionRetrieval;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillDateRangeDto;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionBillMatchService;
import kd.wtc.wtbs.business.rulecontrol.ConditionValidateService;
import kd.wtc.wtbs.business.util.ApplyUtil;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.billservice.attfile.BillAttFileService;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.model.TimeInterval;
import kd.wtc.wtbs.common.model.evaluation.DutyShift;
import kd.wtc.wtbs.common.model.evaluation.DutyShiftResponse;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtom.business.OTApplyBillAssemblyResultService;
import kd.wtc.wtom.business.OTKdStringHelper;
import kd.wtc.wtom.business.sdk.OTApplySdkHelper;
import kd.wtc.wtom.common.constants.OtApplyTypeEnum;

public class OTApplyBillCommonService {
    private static final Log LOG = LogFactory.getLog(OTApplyBillCommonService.class);
    private static OTApplyBillCommonService otCommonService;

    public static OTApplyBillCommonService getInstance() {
        if (otCommonService == null) {
            otCommonService = new OTApplyBillCommonService();
        }
        return otCommonService;
    }

    public void preOpenFormOfSetCaption(BillShowParameter billShowParameter) {
        Object pkId = billShowParameter.getPkId();
        if (pkId != null) {
            String caption;
            String formId = billShowParameter.getFormId();
            if (HRStringUtils.equals((String)"wtom_overtimeapplybill", (String)formId)) {
                caption = OTKdStringHelper.forOther();
            } else if (HRStringUtils.equals((String)"wtom_otbillchange", (String)formId)) {
                caption = OTKdStringHelper.forOtherChange();
            } else if (HRStringUtils.equals((String)"wtom_otbillself", (String)formId)) {
                caption = OTKdStringHelper.self();
            } else if (HRStringUtils.equals((String)"wtom_otselfbillchange", (String)formId)) {
                caption = OTKdStringHelper.selfChange();
            } else {
                return;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtom_overtimeapplybill");
            DynamicObject dy = helper.queryOne(pkId);
            DynamicObject attFile = dy.getDynamicObject("attfile");
            if (attFile != null) {
                caption = caption + "-" + attFile.getLocaleString("name");
            }
            billShowParameter.setCaption(caption);
        }
    }

    public String noEffStr() {
        return "0h";
    }

    public void setComType(IDataModel model, String entityKey, String comKey) {
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObjectCollection scEntity = dataEntity.getDynamicObjectCollection(entityKey);
        if (scEntity == null || scEntity.isEmpty()) {
            return;
        }
        int index = 0;
        for (DynamicObject sc : scEntity) {
            DynamicObject comType = sc.getDynamicObject(comKey);
            if (comType == null) {
                model.setValue(comKey, (Object)OtCompentEnum.EMPTY.getPkId(), index);
            }
            ++index;
        }
    }

    public LocalDate selectedEntryTime(DynamicObject billDy, int index) {
        if (billDy == null || index < 0) {
            return null;
        }
        String otApplyType = billDy.getString("otapplytype");
        DynamicObject attFileIdDy = billDy.getDynamicObject("attfile");
        long attFileId = attFileIdDy == null ? 0L : attFileIdDy.getLong("id");
        LocalDate result = null;
        if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SD.getNum())) {
            DynamicObjectCollection entryColl = billDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SD.getCode());
            if (entryColl.size() < index + 1) {
                return null;
            }
            Date start = ((DynamicObject)entryColl.get(index)).getDate("otstartdate");
            Date end = ((DynamicObject)entryColl.get(index)).getDate("otenddate");
            if (start == null || end == null || start.after(end)) {
                return null;
            }
            OTApplySdkHelper sdkHelper = new OTApplySdkHelper();
            OtStandardDutyDateQuery query = new OtStandardDutyDateQuery();
            query.setAttFileBoId(attFileId);
            query.setOtStartTime(start);
            query.setOtEndTime(end);
            List<OtStandardDutyDateResp> otStandardDutyDateResps = sdkHelper.fillOTDutyDateInfo(Lists.newArrayList((Object[])new OtStandardDutyDateQuery[]{query}));
            if (WTCCollections.isEmpty(otStandardDutyDateResps)) {
                return null;
            }
            if (otStandardDutyDateResps.get(0).getDutyDate() == null) {
                return null;
            }
            return WTCDateUtils.toLocalDate((Date)otStandardDutyDateResps.get(0).getDutyDate());
        }
        if (HRStringUtils.equals((String)otApplyType, (String)OtApplyTypeEnum.OT_SC.getNum())) {
            DynamicObjectCollection entryColl = billDy.getDynamicObjectCollection(OtApplyTypeEnum.OT_SC.getCode());
            if (entryColl.size() < index + 1) {
                return null;
            }
            Date dutyDate = ((DynamicObject)entryColl.get(index)).getDate("otdate");
            if (dutyDate != null) {
                result = WTCDateUtils.toLocalDate((Date)dutyDate);
            }
        }
        return result;
    }

    public QFilter selectOtTypeByDate(List<OtRuleResp> ruleResps, long orgId) {
        if (WTCCollections.isEmpty(ruleResps)) {
            return new QFilter("id", "!=", (Object)0L);
        }
        HashSet<Long> otTypeIds = new HashSet<Long>(16);
        for (OtRuleResp ruleResp : ruleResps) {
            List otRuleCalInfoParams = ruleResp.getOtRuleCalInfoParams();
            if (WTCCollections.isEmpty((Collection)otRuleCalInfoParams)) continue;
            for (OtRuleCalInfo otRuleCalInfoParam : otRuleCalInfoParams) {
                Long otType;
                DynamicObject ruleEntryCalDy = otRuleCalInfoParam.getRuleEntryCalDy();
                if (ruleEntryCalDy == null || (otType = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)ruleEntryCalDy, (String)"ottype")) == null || otType.equals(0L)) continue;
                otTypeIds.add(otType);
            }
        }
        QFilter first = new QFilter("id", "!=", (Object)0L);
        if (!WTCCollections.isEmpty(otTypeIds)) {
            first.and(new QFilter("id", "in", otTypeIds));
        } else {
            first.and(new QFilter("id", "=", (Object)0L));
        }
        first.and(WTCHisServiceHelper.statusValidQFilter());
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtbd_ottype", (Long)orgId);
        return first.and(baseDataFilter);
    }

    public List<OtRuleResp> getOtMatchRule(DynamicObject otBillDy, int queryIndex, Set<LocalDate> dates, long attFileBoId) {
        if (WTCCollections.isEmpty(dates)) {
            return Collections.emptyList();
        }
        OTApplySdkHelper helper = new OTApplySdkHelper();
        ArrayList<OtRuleQuery> queries = new ArrayList<OtRuleQuery>(10);
        for (LocalDate date : dates) {
            OtRuleQuery query = new OtRuleQuery(attFileBoId, WTCDateUtils.toDate((LocalDate)date), null);
            query.setOtBillDy(otBillDy);
            query.setEntryIndex(queryIndex);
            queries.add(query);
        }
        LOG.info("OTApplyBillCommonService_getOtMatchRule queries.size = {}", (Object)queries.size());
        return helper.fillOTRuleInfo(queries);
    }

    public boolean setTypeAfterChoseDate(IFormView billView, Integer changeIndex) {
        if (billView == null || changeIndex == -1) {
            return false;
        }
        Map<String, String> entryInfo = OTApplyBillAssemblyResultService.getEntryInfo(billView.getModel().getDataEntity(true));
        String type = entryInfo.get("OT_TYPE_NAME");
        Object value = billView.getModel().getValue(type, changeIndex.intValue());
        if (value != null) {
            return false;
        }
        LocalDate localDate = OTApplyBillCommonService.getInstance().selectedEntryTime(billView.getModel().getDataEntity(true), changeIndex);
        LOG.info("OTApplyBillCommonService_setTypeAfterChoseDate localDate =  {}", (Object)localDate);
        if (localDate != null) {
            DynamicObject attFileIdDy = (DynamicObject)billView.getModel().getValue("attfile");
            long attFileId = attFileIdDy == null ? 0L : attFileIdDy.getLong("id");
            DynamicObject orgDy = (DynamicObject)billView.getModel().getValue("org");
            long orgId = orgDy == null ? 0L : orgDy.getLong("id");
            List<OtRuleResp> otMatchRule = OTApplyBillCommonService.getInstance().getOtMatchRule(billView.getModel().getDataEntity(true), changeIndex, Sets.newHashSet((Object[])new LocalDate[]{localDate}), attFileId);
            if (WTCCollections.isEmpty(otMatchRule)) {
                return false;
            }
            OtRuleResp resp = otMatchRule.get(0);
            HRBaseServiceHelper ottypeDao = new HRBaseServiceHelper("wtbd_ottype");
            QFilter qFilter = OTApplyBillCommonService.getInstance().selectOtTypeByDate(otMatchRule, orgId);
            DynamicObject[] otTypeDyArr = ottypeDao.query("id,modifytime", new QFilter[]{qFilter});
            if (otTypeDyArr == null || otTypeDyArr.length == 0) {
                return false;
            }
            LOG.info("OTApplyBillCommonService_setTypeAfterChoseDate otTypeDyArr.length = {}", (Object)otTypeDyArr.length);
            DynamicObject matchTypeDy = this.matchDateRange(resp, billView, changeIndex, localDate, otTypeDyArr);
            LOG.info("OTApplyBillCommonService_matchDateRange matchTypeDy == null? :{}", (Object)(matchTypeDy == null ? 1 : 0));
            if (matchTypeDy == null) {
                return false;
            }
            LOG.info("OTApplyBillCommonService_matchDateRange matchTypeDy.id = {}", (Object)matchTypeDy.getLong("id"));
            billView.getModel().setValue(type, (Object)matchTypeDy, changeIndex.intValue());
            return true;
        }
        return false;
    }

    private DynamicObject matchDateRange(OtRuleResp resp, IFormView billView, Integer changeIndex, LocalDate localDate, DynamicObject[] otTypeDyArr) {
        DutyShiftResponse shiftResp;
        if (otTypeDyArr.length == 0) {
            return null;
        }
        Map idAndOtTypeDys = Arrays.stream(otTypeDyArr).collect(Collectors.toMap(otTypeDy -> otTypeDy.getLong("id"), Function.identity(), (o1, o2) -> o1));
        long attFileBoId = 0L;
        DynamicObject attFileBoDy = (DynamicObject)billView.getModel().getValue("attfile");
        if (attFileBoDy != null) {
            attFileBoId = attFileBoDy.getLong("id");
        }
        if ((shiftResp = ApplyUtil.getShift((List)Lists.newArrayList((Object[])new Long[]{attFileBoId}), (Date)WTCDateUtils.toDate((LocalDate)localDate), (Date)WTCDateUtils.toDate((LocalDate)localDate))) == null) {
            return null;
        }
        Optional currShiftHis = shiftResp.getCurrShiftHis(Long.valueOf(attFileBoId), WTCDateUtils.toDate((LocalDate)localDate));
        Optional dutyShiftOptional = shiftResp.getDutyShift(Long.valueOf(attFileBoId), WTCDateUtils.toDate((LocalDate)localDate));
        if (!currShiftHis.isPresent() || !dutyShiftOptional.isPresent()) {
            return null;
        }
        Shift shift = (Shift)currShiftHis.get();
        DutyShift dutyShift = (DutyShift)dutyShiftOptional.get();
        ArrayList<DynamicObject> calDysArr = new ArrayList<DynamicObject>(10);
        List otRuleCalInfoParamsList = resp.getOtRuleCalInfoParams();
        for (OtRuleCalInfo otRuleCalInfoParam : otRuleCalInfoParamsList) {
            DynamicObject ruleEntryCalDy = otRuleCalInfoParam.getRuleEntryCalDy();
            if (ruleEntryCalDy == null) continue;
            calDysArr.add(ruleEntryCalDy);
        }
        if (WTCCollections.isEmpty(calDysArr)) {
            return null;
        }
        List<RuleConditionBillDateRangeDto> dateRangeDtos = this.handleRuleCondition(calDysArr, dutyShift, shift, WTCDateUtils.toDate((LocalDate)localDate), billView.getModel().getDataEntity(true), changeIndex);
        List ruleConditionRetrievals = RuleConditionBillMatchService.billDateRangeMatch(dateRangeDtos);
        Map collect = ruleConditionRetrievals.stream().collect(Collectors.toMap(RuleConditionRetrieval::getDimensionKey, Function.identity(), (o1, o2) -> o1));
        ArrayList<DynamicObject> matchCalDy = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : calDysArr) {
            RuleConditionRetrieval ruleConditionRetrieval = (RuleConditionRetrieval)collect.get(dynamicObject.getLong("id") + "");
            if (ruleConditionRetrieval == null || !ruleConditionRetrieval.isMatchResult()) continue;
            matchCalDy.add(dynamicObject);
        }
        LOG.info("OTApplyBillCommonService_matchDateRange otTypeDyArr.length = {}", (Object)otTypeDyArr.length);
        if (LOG.isDebugEnabled()) {
            LOG.info("OTApplyBillCommonService_matchDateRange calDysArr.id = {}", calDysArr.stream().map(c -> c.getLong("id")).collect(Collectors.toList()));
            LOG.info("OTApplyBillCommonService_matchDateRange matchCalDy.id = {}", matchCalDy.stream().map(c -> c.getLong("id")).collect(Collectors.toList()));
            LOG.info("OTApplyBillCommonService_matchDateRange idAndOtTypeDys.id = {}", idAndOtTypeDys.keySet());
        }
        for (DynamicObject calDy : calDysArr) {
            for (DynamicObject match : matchCalDy) {
                boolean matchOrgAndStatus;
                boolean matchDateRangeAndLimit = calDy.getLong("id") == match.getLong("id");
                if (!matchDateRangeAndLimit) continue;
                boolean bl = matchOrgAndStatus = idAndOtTypeDys.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)match, (String)"ottype")) != null;
                if (!matchOrgAndStatus) continue;
                return (DynamicObject)idAndOtTypeDys.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)match, (String)"ottype"));
            }
        }
        return null;
    }

    private List<RuleConditionBillDateRangeDto> handleRuleCondition(List<DynamicObject> calDyArr, DutyShift dutyShift, Shift shift, Date date, DynamicObject billDy, int checkIndex) {
        List versionDyList;
        Map allAttFileVersion;
        ArrayList attFileVersionInBo;
        if (WTCCollections.isEmpty(calDyArr)) {
            return Collections.emptyList();
        }
        ArrayList<RuleConditionBillDateRangeDto> ruleRangeDtos = new ArrayList<RuleConditionBillDateRangeDto>(10);
        BillAttFileService attFileService = new BillAttFileService();
        long attFileBoId = 0L;
        DynamicObject attFileBoDy = billDy.getDynamicObject("attfile");
        if (attFileBoDy != null) {
            attFileBoId = attFileBoDy.getLong("id");
        }
        if ((attFileVersionInBo = (ArrayList)(allAttFileVersion = attFileService.getAllAttFileVersion((Set)Sets.newHashSet((Object[])new Long[]{attFileBoId}))).get(attFileBoId)) == null) {
            attFileVersionInBo = new ArrayList(10);
        }
        if (WTCCollections.isEmpty(versionDyList = attFileVersionInBo.stream().filter(at -> !at.getBoolean("iscurrentversion")).collect(Collectors.toList()))) {
            return Collections.emptyList();
        }
        Date startTime = null;
        Date endTime = null;
        Map<String, String> entryInfoByType = OTApplyBillAssemblyResultService.getEntryInfo(billDy);
        String entryName = entryInfoByType.get("ENTRY_NAME");
        String startTimeName = entryInfoByType.get("START_TIME_NAME");
        String endTimeName = entryInfoByType.get("END_TIME_NAME");
        DynamicObjectCollection entryColl = billDy.getDynamicObjectCollection(entryName);
        if (entryColl.size() >= checkIndex + 1) {
            DynamicObject entryDy = (DynamicObject)entryColl.get(checkIndex);
            startTime = entryDy.getDate(startTimeName);
            endTime = entryDy.getDate(endTimeName);
        }
        if (startTime == null || endTime == null) {
            startTime = date;
            endTime = date;
        }
        LOG.info("OTApplyBillCommonService_handleRuleCondition startTime = {},endTime= {}", (Object)startTime, (Object)endTime);
        DynamicObject attFileVersionByDate = attFileService.getAttFileVersionByDate(versionDyList, date);
        for (DynamicObject calDy : calDyArr) {
            RuleConditionBillDateRangeDto dateRangeDto = new RuleConditionBillDateRangeDto();
            String condition = calDy.getString("daterangecondition");
            dateRangeDto.setCondition(condition);
            dateRangeDto.setAccessDto(ConditionValidateService.getRuleConditionInfo((String)condition));
            TimeInterval timeInterval = OTApplyBillAssemblyResultService.getTimeInterval(dutyShift, shift, startTime, endTime);
            dateRangeDto.setTimeInterval(timeInterval);
            dateRangeDto.setDutyDate(date);
            dateRangeDto.setBillDy(billDy);
            String entryKey = OTApplyBillAssemblyResultService.getEntryInfo(billDy).get("ENTRY_NAME");
            dateRangeDto.setEntryKey(entryKey);
            dateRangeDto.setIndex(checkIndex);
            String billEntrySeqKey = calDy.getLong("id") + "";
            dateRangeDto.setDimensionKey(billEntrySeqKey);
            dateRangeDto.setBillBusType(UnifyBillEnum.OT.name());
            dateRangeDto.setAttFileV(attFileVersionByDate);
            ruleRangeDtos.add(dateRangeDto);
        }
        return ruleRangeDtos;
    }
}

