/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.abnormal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.personfilter.PersonFilterServiceImpl;
import kd.wtc.wtbs.business.personfilter.utils.JudgeConditionService;
import kd.wtc.wtbs.business.web.attitem.AttItemFilterHelper;
import kd.wtc.wtbs.common.predata.wtbs.PreInterfaceRegister;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtbs.wtbd.common.attitem.AttItmeDataTypeEnum;
import kd.wtc.wtp.common.ex.ExPushRuleConstants;

public class ExPushRulePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
ExPushRuleConstants {
    private static final Log logger = LogFactory.getLog(JudgeConditionService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit attendEdit = (BasedataEdit)this.getView().getControl("attenditem");
        attendEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit msgEdit = (BasedataEdit)this.getView().getControl("msgtemplate");
        msgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recipientPlugin = (BasedataEdit)this.getView().getControl("recipientplugin");
        recipientPlugin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataRange = (BasedataEdit)this.getView().getControl("datarange");
        dataRange.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        String selectIdStr;
        super.beforeBindData(eventObject);
        long id = this.getView().getModel().getDataEntity().getLong("id");
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue() && this.getView().getParentView() != null && id == 0L && HRStringUtils.isNotEmpty((String)(selectIdStr = this.getView().getParentView().getPageCache().get("select_id")))) {
            id = Long.parseLong(selectIdStr);
        }
        this.setPersonRange(id);
        this.setDataRangeFlex();
        DynamicObject tplScene = this.getModel().getDataEntity().getDynamicObject("tplscene");
        if (tplScene != null) {
            this.getView().getPageCache().put("tplscene", String.valueOf(tplScene.getLong("id")));
        } else {
            this.getView().getPageCache().put("tplscene", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("pussetentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            String recipient = dynamicObject.getString("recipient");
            boolean containsOther = recipient != null && recipient.contains(",C,");
            this.getView().setEnable(Boolean.valueOf(containsOther), i, new String[]{"recipientplugin"});
        }
    }

    public void afterCopyData(EventObject eventObject) {
        super.afterCopyData(eventObject);
        BaseModel source = (BaseModel)eventObject.getSource();
        DynamicObject dataEntity = source.getDataEntity();
        Object exDataId = dataEntity.get("exdataid");
        if (exDataId == null) {
            return;
        }
        this.getPageCache().put("exdataid", exDataId.toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String entityId = beforeF7SelectEvent.getProperty().getName();
        if ("attenditem".equals(entityId)) {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setMultiSelect(false);
            QFilter qFilter = AttItemFilterHelper.dataTypeFilter(Collections.singletonList(AttItmeDataTypeEnum.DUTATION.typeVal)).and(AttItemFilterHelper.issaveQFilter((boolean)true)).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type}));
            this.addFilterParam(beforeF7SelectEvent, "messetentity", "attenditem", qFilter);
        } else if ("msgtemplate".equals(entityId)) {
            String tplScene = this.getView().getPageCache().get("tplscene");
            QFilter qFilter = tplScene == null ? new QFilter("msgscenevalue.fbasedataid", "=", (Object)0L) : new QFilter("msgscenevalue.fbasedataid", "=", (Object)Long.valueOf(tplScene));
            this.addFilterParam(beforeF7SelectEvent, "pussetentity", "msgtemplate", qFilter);
        } else if ("recipientplugin".equals(entityId)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setMultiSelect(false);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("interface", "=", (Object)PreInterfaceRegister.PD_EXPUSHRECIPIENTSERVICE));
        } else if ("datarange".equals(entityId)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setMultiSelect(false);
            beforeF7SelectEvent.addCustomQFilter(new QFilter("interface", "=", (Object)PreInterfaceRegister.PD_EXPUSHDATARANGE));
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String name;
        super.propertyChanged(propertyChangedArgs);
        switch (name = propertyChangedArgs.getProperty().getName()) {
            case "pushdatarange": {
                this.setDataRangeFlex();
                break;
            }
            case "tplscene": {
                this.getView().getModel().deleteEntryData("pussetentity");
                int[] createNewEntryRowIndex = this.getView().getModel().batchCreateNewEntryRow("pussetentity", 1);
                DynamicObject tplScene = this.getModel().getDataEntity().getDynamicObject("tplscene");
                if (tplScene != null) {
                    this.getView().getPageCache().put("tplscene", String.valueOf(tplScene.getLong("id")));
                } else {
                    this.getView().getPageCache().put("tplscene", null);
                }
                for (int newEntryRowIndex : createNewEntryRowIndex) {
                    this.getView().setEnable(Boolean.FALSE, newEntryRowIndex, new String[]{"recipientplugin"});
                }
                break;
            }
            case "recipient": {
                this.handleChangeRecipient(propertyChangedArgs);
                break;
            }
        }
    }

    private void handleChangeRecipient(PropertyChangedArgs propertyChangedArgs) {
        if (propertyChangedArgs.getChangeSet() == null || propertyChangedArgs.getChangeSet().length <= 0) {
            return;
        }
        String newValue = (String)propertyChangedArgs.getChangeSet()[0].getNewValue();
        int index = propertyChangedArgs.getChangeSet()[0].getRowIndex();
        boolean containsOther = newValue != null && newValue.contains(",C,");
        this.getView().setEnable(Boolean.valueOf(containsOther), index, new String[]{"recipientplugin"});
        if (!containsOther) {
            this.getModel().setValue("recipientplugin", null, index);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        List<String> operate = Arrays.asList("save", "submit", "submitandaudit");
        if (!operate.contains(operateKey)) {
            return;
        }
        DynamicObjectCollection mesColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("messetentity");
        if (mesColl.size() == 0 || ((DynamicObject)mesColl.get(0)).get("attenditem") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6d88\u606f\u8bbe\u7f6e\u201d\u3002", (String)"ExPushRulePlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List<Object> fieldNames = new ArrayList(4);
        Object pushDataRange = this.getModel().getDataEntity().get("pushdatarange");
        if ("A".equals(pushDataRange)) {
            fieldNames = Arrays.asList("startmonth", "startdays", "endmonth", "enddays");
        } else if ("B".equals(pushDataRange)) {
            fieldNames = Arrays.asList("startweektype", "startweek", "endweektype", "endweek");
        }
        for (String fieldName : fieldNames) {
            Object fieldValue = this.getModel().getDataEntity().get(fieldName);
            if (fieldValue != null && !StringUtils.isEmpty((String)fieldValue.toString())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9009\u62e9\u65e5\u671f\u201d\u5b57\u6bb5\u586b\u5199\u4e0d\u5b8c\u6574\u3002", (String)"ExPushRulePlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection pusObjColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("pussetentity");
        if (pusObjColl.size() == 0 || ((DynamicObject)pusObjColl.get(0)).get("msgtemplate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6d88\u606f\u6a21\u677f\u201d\u3002", (String)"ExPushRulePlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.checkDate(pushDataRange)) {
            args.setCancel(true);
            return;
        }
        String childPageId = this.getPageCache().get("childpageid");
        IFormView childView = this.getView().getView(childPageId);
        TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
        String value = targetCondition.getValue();
        if (value != null) {
            if (value.contains("is_or_isSub")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"ExPushRulePlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)value, RuleConditionInfo.class);
            List conditionExpressList = accessDto.getConditionExpressList();
            if (conditionExpressList.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u5458\u8303\u56f4\u201d\u3002", (String)"ExPushRulePlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4eba\u5458\u8303\u56f4\u201d\u3002", (String)"ExPushRulePlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Map stringObjectMap = JudgeConditionService.checkConfigJson((String)value);
        if (!stringObjectMap.isEmpty() && !((Boolean)stringObjectMap.get("isSucess")).booleanValue()) {
            this.getView().showTipNotification(stringObjectMap.get("errorMsg").toString());
            args.setCancel(true);
            return;
        }
    }

    private boolean checkDate(Object pushDataRange) {
        if ("A".equals(pushDataRange)) {
            Object startMonthStr = this.getModel().getDataEntity().get("startmonth");
            Object endMonthStr = this.getModel().getDataEntity().get("endmonth");
            if ("B".equals(startMonthStr) && "A".equals(endMonthStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ExPushRulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return true;
            }
            if ("A".equals(startMonthStr) && "B".equals(endMonthStr)) {
                return false;
            }
            Object startDaysStr = this.getModel().getDataEntity().get("startdays");
            Object endDaysStr = this.getModel().getDataEntity().get("enddays");
            int startDays = Integer.parseInt(startDaysStr.toString());
            int endDays = Integer.parseInt(endDaysStr.toString());
            if (endDays < startDays) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ExPushRulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if ("B".equals(pushDataRange)) {
            Object startWeekTypeStr = this.getModel().getDataEntity().get("startweektype");
            Object endWeekTypeStr = this.getModel().getDataEntity().get("endweektype");
            if ("B".equals(startWeekTypeStr) && "A".equals(endWeekTypeStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ExPushRulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return true;
            }
            if ("A".equals(startWeekTypeStr) && "B".equals(endWeekTypeStr)) {
                return false;
            }
            Object startWeekStr = this.getModel().getDataEntity().get("startweek");
            Object endWeekStr = this.getModel().getDataEntity().get("endweek");
            int startWeek = Integer.parseInt(startWeekStr.toString());
            int endWeek = Integer.parseInt(endWeekStr.toString());
            if (startWeek == 1) {
                startWeek = 16;
            }
            if (endWeek == 1) {
                endWeek = 16;
            }
            if (endWeek < startWeek) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ExPushRulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void setDataRangeFlex() {
        List<String> monthNotMust = Arrays.asList("startmonth", "startdays", "endmonth", "enddays", "startweektype", "startweek", "endweektype", "endweek", "stepdays", "datarange");
        this.setFieldMustInput(monthNotMust, false);
        Object pushDataRange = this.getModel().getDataEntity().get("pushdatarange");
        if ("A".equals(pushDataRange)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmonth", "flexweek", "flexdays", "flexdatarange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexmonth"});
        } else if ("B".equals(pushDataRange)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmonth", "flexweek", "flexdays", "flexdatarange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexweek"});
        } else if ("C".equals(pushDataRange)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmonth", "flexweek", "flexdays", "flexdatarange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdays"});
            List<String> monthMust = Collections.singletonList("stepdays");
            this.setFieldMustInput(monthMust, true);
        } else if ("D".equals(pushDataRange)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmonth", "flexweek", "flexdays", "flexdatarange"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdatarange"});
            List<String> monthMust = Collections.singletonList("datarange");
            this.setFieldMustInput(monthMust, true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexmonth", "flexweek", "flexdays", "flexdatarange"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        List<String> operate = Arrays.asList("save", "submit", "submitandaudit");
        List<String> otherOperate = Arrays.asList("unsubmit", "unaudit");
        if (operate.contains(operateKey)) {
            boolean isSuccess = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if (!isSuccess) {
                return;
            }
            String childPageId = this.getPageCache().get("childpageid");
            IFormView childView = this.getView().getView(childPageId);
            TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
            String value = targetCondition.getValue();
            Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
            if (value != null) {
                PersonFilterServiceImpl.getInstance().updateConfig("wtp_expushrule", value, pkValue);
                HRBaseServiceHelper exPushHelper = new HRBaseServiceHelper("wtp_expushrule");
                long id = this.getModel().getDataEntity().getLong("id");
                QFilter qFilter = new QFilter("id", "=", (Object)id);
                DynamicObject configDyn = exPushHelper.loadDynamicObject(new QFilter[]{qFilter, qFilter});
                configDyn.set("exdataid", (Object)id);
                exPushHelper.updateOne(configDyn);
            }
            this.getView().updateView();
        }
        if ("pusnewentry".equals(operateKey)) {
            int size = this.getModel().getEntryEntity("pussetentity").size();
            if (size == 0) {
                this.getView().setEnable(Boolean.FALSE, size, new String[]{"recipientplugin"});
            } else {
                this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"recipientplugin"});
            }
        }
        if (otherOperate.contains(operateKey)) {
            this.getView().updateView();
        }
    }

    private void setPersonRange(long id) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_perfilterconfig");
        QFilter qFilter = new QFilter("metanumber", "=", (Object)"wtp_expushrule");
        QFilter filter = new QFilter("basedataid", "=", (Object)id);
        DynamicObject conditions = hrBaseServiceHelper.queryOne("conditions", new QFilter[]{qFilter, filter});
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        formShowParameter.setFormId("wtbd_personfilter");
        formShowParameter.getOpenStyle().setTargetKey("flexperscope");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (!"A".equals(this.getModel().getDataEntity().get("status"))) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("childpageid", pageId);
        if (Objects.nonNull(conditions)) {
            IFormView childView = this.getView().getView(pageId);
            TargetCondition targetCondition = (TargetCondition)childView.getControl("targetconditionap");
            targetCondition.setValue(conditions.getString("conditions"));
        }
    }

    private void addFilterParam(BeforeF7SelectEvent beforeF7SelectEvent, String entityName, String baseName, QFilter filter) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
        if (null == entryEntity) {
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List<Long> itemParam = this.filterParamToList(entryEntity, baseName);
        QFilter qFilter = new QFilter("id", "not in", itemParam);
        qFilter.and(filter);
        formShowParameter.getListFilterParameter().setFilter(qFilter);
    }

    public List<Long> filterParamToList(DynamicObjectCollection entryEntity, String paramName) {
        List<Long> idList = entryEntity.stream().map(dynamicObject -> {
            DynamicObject course = dynamicObject.getDynamicObject(paramName);
            if (course != null) {
                return course.getLong("id");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return idList;
    }

    private void setFieldMustInput(List<String> mustInputFieldList, boolean flag) {
        for (String field : mustInputFieldList) {
            Control control = this.getView().getControl(field);
            if (!(control instanceof FieldEdit)) continue;
            FieldEdit fieldEdit = (FieldEdit)control;
            fieldEdit.setMustInput(flag);
        }
    }
}

