/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.accountsteps;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCHisService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.common.constants.WTCCommonConstants;
import kd.wtc.wtbs.common.enums.AttOperEnum;
import kd.wtc.wtbs.common.enums.WTCCommonMessages;
import kd.wtc.wtbs.common.predata.wtp.PreDataAccountStageType;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtbs.formplugin.web.prompt.PromptCache;
import kd.wtc.wtp.constants.account.AccountConstants;
import kd.wtc.wtp.formplugin.web.vo.PhaseVo;
import kd.wtc.wtp.formplugin.web.vo.RequestVO;
import kd.wtc.wtp.formplugin.web.vo.StepVo;

public class AccountPlanEdit
extends HRDataBaseEdit
implements AccountConstants {
    private static final Log LOGGER = LogFactory.getLog(AccountPlanEdit.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_accountplan");
    private static final String FS_BASEINFO = "fs_baseinfo";
    private static final String CONFIRMSHOW = "confirmShow";

    private void addVisibleBaseInfo() {
        Container container = (Container)this.getControl(FS_BASEINFO);
        ArrayList collapseFields = Lists.newArrayListWithExpectedSize((int)16);
        HashMap ctl = Maps.newHashMapWithExpectedSize((int)16);
        collapseFields.add("createorg");
        collapseFields.add("name");
        ctl.put("cf", collapseFields);
        this.getView().updateControlMetadata(container.getKey(), (Map)ctl);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Container container = (Container)this.getControl(FS_BASEINFO);
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        this.addVisibleBaseInfo();
        this.showAccountMode();
        this.setAccountModeDisEnable();
        if (HRStringUtils.equals((String)option, (String)"insertdata_his")) {
            this.initDateEnter(container);
        } else {
            switch (status) {
                case ADDNEW: {
                    this.initDateEnter(container);
                    break;
                }
                case VIEW: {
                    DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                    this.initCustomControl((List<DynamicObject>)collection, this.getPageStatus());
                    container.setCollapse(true);
                    break;
                }
                case EDIT: {
                    DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
                    this.initCustomControl((List<DynamicObject>)collection, this.getPageStatus());
                    container.setCollapse(this.getPageStatus() == 1);
                    break;
                }
            }
        }
        boolean isSyspreset = this.getModel().getDataEntity().getBoolean("issyspreset");
        if (isSyspreset) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modifyhis"});
        }
    }

    private void setAccountModeDisEnable() {
        boolean isEnable;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean bl = isEnable = !OperationStatus.ADDNEW.equals((Object)status) || "fromHisAction".equals(fromPage) || "revise".equals(fromPage);
        if (isEnable) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"accountmode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"accountmode"});
        }
        String hisAction = String.valueOf(customParams.get("his_action"));
        if ("open_insert_data_page".equals(hisAction) || "open_insert_new_data_page".equals(hisAction)) {
            Object boid = customParams.get("boid");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getView().getFormShowParameter().getFormId());
            DynamicObject accountDy = helper.queryOriginalOne("accountmode", new QFilter("boid", "=", boid));
            this.getModel().setValue("accountmode", (Object)accountDy.getString("accountmode"));
        }
    }

    private void initDateEnter(Container container) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            DynamicObject dynamicObject = this.getDefaultPlanData();
            if (dynamicObject != null) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
                this.initCustomControl((List<DynamicObject>)collection, this.getPageStatus());
            } else {
                this.setCustomControl(this.getPageStatus(), new ArrayList<PhaseVo>());
            }
        } else {
            this.initCustomControl((List<DynamicObject>)entryEntity, this.getPageStatus());
        }
        container.setCollapse(false);
    }

    private DynamicObject getDefaultPlanData() {
        String accountType = this.getModel().getDataEntity().getString("accounttype");
        String accountMode = this.getModel().getDataEntity().getString("accountmode");
        QFilter[] qFilters = new QFilter[2];
        qFilters[0] = new QFilter("issyspreset", "=", (Object)Boolean.TRUE);
        long planId = AccountPlanUtil.queryDefaultPlanId();
        if (HRStringUtils.equals((String)accountType, (String)"C")) {
            planId = AccountPlanUtil.queryQuotaDefaultPlanId();
            if (HRStringUtils.equals((String)accountMode, (String)"B")) {
                planId = AccountPlanUtil.queryQuotaDefaultDeductPlanId();
            }
        }
        qFilters[1] = new QFilter("id", "=", (Object)planId);
        return serviceHelper.loadDynamicObject(qFilters);
    }

    private void initCustomControl(List<DynamicObject> dynCollection, int viewType) {
        if (CollectionUtils.isEmpty(dynCollection)) {
            return;
        }
        ArrayList phases = Lists.newArrayListWithExpectedSize((int)16);
        String acountType = this.getModel().getDataEntity().getString("accounttype");
        boolean isElastictityOpen = WTCGrayscaleUtils.isElastictityOpen();
        for (DynamicObject dyn : dynCollection) {
            DynamicObjectCollection dynCollect = dyn.getDynamicObjectCollection("subentryentity");
            PhaseVo phaseVo = new PhaseVo();
            phaseVo.setPhase(dyn.getString("phasenamelang"));
            phaseVo.setPhaseNameLang(dyn.get("phasenamelang"));
            phaseVo.setPhasenumber(dyn.getString("phasetype.number"));
            phaseVo.setPhaseId(dyn.getLong("phasetype.id"));
            phaseVo.setDel(dyn.getBoolean("del"));
            phaseVo.setMove(dyn.getBoolean("move"));
            if (dyn.getLong("phasetype.id") == PreDataAccountStageType.PD_1070_S.longValue() && !dyn.getBoolean("del")) {
                phaseVo.setEdit(Boolean.FALSE);
            } else {
                phaseVo.setEdit(Boolean.TRUE);
            }
            phaseVo.setPhaseResultDeal(dyn.getString("phaseresultdeal"));
            phaseVo.setNoReturnHandler(dyn.getString("noreturnhandler"));
            ArrayList<StepVo> steps = new ArrayList<StepVo>();
            for (DynamicObject subDyn : dynCollect) {
                if (subDyn.getDynamicObject("stepid") == null) continue;
                StepVo stepVo = new StepVo();
                if (!subDyn.getString("stepid.accounttype").contains(acountType) || !isElastictityOpen && WTCGrayscaleUtils.ELASTIC_SET.contains(subDyn.getLong("stepid.id"))) continue;
                stepVo.setId(subDyn.getLong("stepid.id"));
                stepVo.setDel(subDyn.getBoolean("stepdel"));
                stepVo.setMove(subDyn.getBoolean("stepmove"));
                stepVo.setStep(subDyn.getString("stepid.name"));
                stepVo.setSyspreset(subDyn.getBoolean("stepid.issyspreset"));
                stepVo.setIndex(subDyn.getInt("stepid.index"));
                stepVo.setBitindex(subDyn.getInt("stepid.bitindex"));
                stepVo.setStartdate(HRDateTimeUtils.format((Date)subDyn.getDate("stepid.firstbsed"), (String)"yyyy-MM-dd"));
                stepVo.setEnddate(subDyn.getDate("stepid.bsled"));
                stepVo.setResulttype(subDyn.getString("stepid.resulttype"));
                stepVo.setCalrule(subDyn.getString("stepid.calrule"));
                stepVo.setDesc(subDyn.getString("stepid.description"));
                stepVo.setNoReturnHandler(subDyn.getString("stepnoreturnhandler"));
                steps.add(stepVo);
            }
            if (CollectionUtils.isEmpty(steps)) continue;
            phaseVo.setSteps(steps);
            phases.add(phaseVo);
        }
        this.setCustomControl(viewType, phases);
    }

    private void setCustomControl(int viewType, List<PhaseVo> phases) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        response.put("event", "init");
        response.put("type", viewType);
        response.put("data", phases);
        response.put("updatedate", this.getModel().getDataEntity().getDate("modifytime"));
        response.put("updateby", this.getModel().getDataEntity().getString("modifier.name"));
        response.put("power", this.isShowHighProp(viewType));
        IFormView view = this.getView();
        PromptCache promptCache = PromptCache.get((IFormView)view);
        Map promptMap = promptCache.getPromptMap();
        String hasPrompts = "wtp_accountplancustomcontrolap";
        if (promptMap.get(hasPrompts) == null) {
            Map controlMap = WTCFormUtils.createControlMap((String[])new String[]{"wtp_accountplan"});
            ((Set)controlMap.get("wtp_accountplan")).addAll(Arrays.asList("phaseresultdeal", "noreturnhandler"));
            promptMap = WTCFormUtils.getPromptMap((IFormView)this.getView(), (Map)controlMap, null, null, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE);
            PromptCache.put((IFormView)view, (String)hasPrompts, (String)"1");
        }
        response.put("phaseresultdeal", promptMap.get("phaseresultdeal"));
        response.put("noreturnhandler", promptMap.get("noreturnhandler"));
        customcontrol.setData(response);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && closedCallBackEvent.getReturnData() instanceof Map) {
            Map response = (Map)closedCallBackEvent.getReturnData();
            CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
            customcontrol.setData((Object)response);
        }
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        String eventName = args.getEventName();
        if (HRStringUtils.equals((String)eventName, (String)"positionChange")) {
            this.clearCache();
            return;
        }
        String paramJson = args.getEventArgs();
        RequestVO requestVO = null;
        requestVO = (RequestVO)WTCSerializationUtils.fromJsonString((String)paramJson, RequestVO.class);
        if (requestVO == null) {
            return;
        }
        switch (eventName) {
            case "addphase": {
                this.clearCache();
                this.addphase(requestVO);
                break;
            }
            case "editphase": {
                this.clearCache();
                this.editphase(requestVO);
                break;
            }
            case "editsteps": {
                this.clearCache();
                this.editSteps(requestVO);
                break;
            }
            case "savedata": {
                this.saveData(requestVO, "save");
                break;
            }
            case "savedatanew": {
                this.saveData(requestVO, "saveandnew");
                break;
            }
            case "submitdata": {
                this.saveData(requestVO, "submit");
                break;
            }
            case "saveauditdata": {
                this.saveData(requestVO, "confirmchange");
                break;
            }
        }
    }

    private void clearCache() {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        pageCache.remove("sync");
        pageCache.remove("savedata");
    }

    private boolean isShowHighProp(int viewType) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"wtp", (String)"wtp_accountplan", (String)(viewType == 1 ? AttOperEnum.HIGH_QUERY.permItemId : AttOperEnum.HIGH_MODIFY.permItemId));
    }

    private void saveData(RequestVO requestVO, String operationKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        ArrayList dynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)"save", (String)operationKey) && HRStringUtils.equals((String)fromPage, (String)"revise")) {
            dynamicObjects.addAll(this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity"));
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_accountsteps");
        MainEntityType stageEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_accountstagetype");
        List<PhaseVo> data = requestVO.getData();
        this.getModel().deleteEntryData("entryentity");
        this.getModel().beginInit();
        for (int i = 0; i < data.size(); ++i) {
            PhaseVo phaseVo = data.get(i);
            Boolean phaseDel = phaseVo.getDel();
            Boolean phaseMove = phaseVo.getMove();
            Object phaseName = phaseVo.getPhaseNameLang();
            String phasenumber = phaseVo.getPhasenumber();
            List<StepVo> steps = phaseVo.getSteps();
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex("entryentity", i);
            DynamicObject entryDyn = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").addNew();
            DynamicObjectCollection collection = entryDyn.getDynamicObjectCollection("subentryentity");
            ArrayList subDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)dynamicObjects) && dynamicObjects.size() > i) {
                entryDyn.set("entryboid", ((DynamicObject)dynamicObjects.get(i)).get("entryboid"));
                subDynamicObjects = ((DynamicObject)dynamicObjects.get(i)).getDynamicObjectCollection("subentryentity");
            }
            entryDyn.set("del", (Object)phaseDel);
            entryDyn.set("move", (Object)phaseMove);
            entryDyn.set("phasenamelang", phaseName);
            entryDyn.set("phasename", (Object)phaseVo.getPhase());
            entryDyn.set("phasenumber", (Object)phasenumber);
            DynamicObject stageDynamicObject = new DynamicObject((DynamicObjectType)stageEntityType, (Object)phaseVo.getPhaseIdLong());
            entryDyn.set("phasetype", (Object)stageDynamicObject);
            entryDyn.set("phaseresultdeal", (Object)phaseVo.getPhaseResultDeal());
            entryDyn.set("noreturnhandler", (Object)phaseVo.getNoReturnHandler());
            entryDyn.set("seq", (Object)i);
            for (int j = 0; j < steps.size(); ++j) {
                StepVo stepVo = steps.get(j);
                Long id = stepVo.getIdLong();
                DynamicObject subEntryDyn = collection.addNew();
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainEntityType, (Object)id);
                if (!CollectionUtils.isEmpty((Collection)subDynamicObjects) && subDynamicObjects.size() > j) {
                    subEntryDyn.set("entryboid1", ((DynamicObject)subDynamicObjects.get(j)).get("entryboid1"));
                }
                subEntryDyn.set("stepid", (Object)dynamicObject);
                subEntryDyn.set("seq", (Object)j);
                subEntryDyn.set("stepnoreturnhandler", (Object)stepVo.getNoReturnHandler());
                subEntryDyn.set("stepmove", (Object)stepVo.getMove());
                subEntryDyn.set("stepdel", (Object)stepVo.getDel());
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        this.dealConfirm(operationKey, fromPage);
    }

    private void dealConfirm(String operationKey, String fromPage) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        String confirmChangeCache = (String)pageCache.get(CONFIRMSHOW, String.class);
        if (HRStringUtils.equals((String)"confirmchange", (String)operationKey) || HRStringUtils.equals((String)"save", (String)operationKey)) {
            if (confirmChangeCache != null) {
                pageCache.put("sync", (Object)"1");
                if (HRStringUtils.equals((String)"confirmchange", (String)operationKey)) {
                    this.getView().invokeOperation(operationKey);
                }
            }
            if (HRStringUtils.equals((String)"save", (String)operationKey)) {
                if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
                    pageCache.put("savedata", (Object)"1");
                } else {
                    this.getView().invokeOperation(operationKey);
                }
            }
        } else if (!HRStringUtils.equals((String)"submit", (String)operationKey) || !HRStringUtils.equals((String)"B", (String)this.getModel().getDataEntity().getString("status"))) {
            this.getView().invokeOperation(operationKey);
        }
    }

    private void editSteps(RequestVO requestVO) {
        Long setpid = requestVO.getStepidLong();
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("wtp_accountsteps");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setPkId((Object)setpid);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void editphase(RequestVO requestVO) {
        Integer position = requestVO.getPosition();
        String phaseName = requestVO.getPhase();
        String phaseNumber = requestVO.getPhasenumber();
        List<StepVo> steps = requestVO.getSteps();
        List<Long> othersteps = requestVO.getOtherstepsLong();
        Boolean del = requestVO.getDel();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("event", "editphase");
        param.put("position", position);
        param.put("phase", phaseName);
        param.put("phasenamelang", requestVO.getPhaseNameLang());
        param.put("phasetype.number", phaseNumber);
        param.put("phasetype.id", requestVO.getPhaseIdLong());
        param.put("steps", CollectionUtils.isEmpty(steps) ? "" : JSON.toJSONString(steps));
        param.put("othersteps", othersteps);
        List<PhaseVo> phaseVos = requestVO.getOtherPhaseList();
        if (CollectionUtils.isEmpty(phaseVos)) {
            param.put("otherphasenames", Collections.EMPTY_LIST);
        } else {
            param.put("otherphasenames", requestVO.getOtherPhaseList().stream().map(PhaseVo::getPhase).collect(Collectors.toList()));
        }
        param.put("del", del);
        param.put("move", requestVO.getMove());
        param.put("edit", requestVO.getEdit());
        param.put("phaseresultdeal", requestVO.getPhaseResultDeal());
        param.put("noreturnhandler", requestVO.getNoReturnHandler());
        this.showFormParameter(param);
    }

    private void addphase(RequestVO requestVO) {
        Integer position = requestVO.getPosition();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        List<Long> othersteps = requestVO.getOtherstepsLong();
        param.put("event", "addphase");
        param.put("position", position);
        param.put("othersteps", othersteps);
        List<PhaseVo> phaseVos = requestVO.getOtherPhaseList();
        if (CollectionUtils.isEmpty(phaseVos)) {
            param.put("otherphasenames", Collections.EMPTY_LIST);
            param.put("otherphaseids", Collections.EMPTY_LIST);
        } else {
            param.put("otherphasenames", requestVO.getOtherPhaseList().stream().map(PhaseVo::getPhase).collect(Collectors.toList()));
            param.put("otherphaseids", requestVO.getOtherPhaseList().stream().map(PhaseVo::getPhaseIdLong).collect(Collectors.toList()));
        }
        this.showFormParameter(param);
    }

    private void showFormParameter(Map<String, Object> param) {
        Object date = this.getModel().getValue("bsed");
        if (date == null) {
            this.getView().showTipNotification(WTCCommonMessages.BSED_EMPTY.load());
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("wtp_orgtreeview");
        listShowParameter.setBillFormId("wtp_accountstepsyw");
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960");
        styleCss.setHeight("580");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setLookUp(true);
        listShowParameter.setShowTitle(false);
        listShowParameter.setMultiSelect(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callBackEvent"));
        listShowParameter.setCustomParams(param);
        if (!CollectionUtils.isEmpty(param) && HRStringUtils.equals((String)((String)param.get("event")), (String)"addphase")) {
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u9636\u6bb5", (String)"AccountPlanEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
        listShowParameter.setHasRight(true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"wtp_accountsteps", (Long)this.getModel().getDataEntity().getLong("createorg.id"));
        listFilterParameter.setFilter(baseDataFilter);
        listFilterParameter.setFilter(WTCHisServiceHelper.statusValidQFilter());
        listFilterParameter.setFilter(new QFilter("firstbsed", "<=", date));
        String accountType = this.getModel().getDataEntity().getString("accounttype");
        listFilterParameter.setFilter(new QFilter("accounttype", "like", (Object)("%" + accountType + "%")));
        param.put("accounttype", this.getModel().getDataEntity().getString("accounttype"));
        listShowParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            String operateKey = ((FormOperate)args.getSource()).getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)"savedata") || HRStringUtils.equals((String)operateKey, (String)"submitdata") || HRStringUtils.equals((String)operateKey, (String)"saveauditdata") || HRStringUtils.equals((String)operateKey, (String)"savedatanew")) {
                this.triggerFont(operateKey);
            }
            if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"confirmchange")) {
                this.getModel().setDataChanged(false);
                WTCPageCache pageCache = new WTCPageCache(this.getView());
                pageCache.remove("sync");
                pageCache.remove("savedata");
            }
            if (WTCCommonConstants.opList.contains(operateKey)) {
                Container container = (Container)this.getControl(FS_BASEINFO);
                this.triggerFont("refreshStatus");
                container.setCollapse(false);
            }
        }
    }

    public void triggerFont(String operateKey) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("event", operateKey);
        if (HRStringUtils.equals((String)"refreshStatus", (String)operateKey)) {
            param.put("type", this.getPageStatus());
        }
        param.put("timestamp", System.currentTimeMillis());
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData(param);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.saveOper(args);
                break;
            }
            case "submit": 
            case "submitandaudit": {
                if (this.checkSaveValue(args)) break;
                args.setCancel(true);
                break;
            }
            case "confirmchange": {
                WTCPageCache pageCache = new WTCPageCache(this.getView());
                String confirmSaveCache = (String)pageCache.get(CONFIRMSHOW, String.class);
                String sync = (String)pageCache.get("sync", String.class);
                if (sync == null && confirmSaveCache != null && HRStringUtils.equals((String)confirmSaveCache, (String)"1")) {
                    this.getView().invokeOperation("saveauditdata");
                    args.setCancel(true);
                    break;
                }
                if (this.checkSaveValue(args)) break;
                args.setCancel(true);
                break;
            }
        }
    }

    private void saveOper(BeforeDoOperationEventArgs args) {
        WTCPageCache pageCache = new WTCPageCache(this.getView());
        String confirmSaveCache = (String)pageCache.get(CONFIRMSHOW, String.class);
        String sync = (String)pageCache.get("sync", String.class);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fromPage = String.valueOf(customParams.get("fromPage"));
        String saveData = (String)pageCache.get("savedata", String.class);
        if (sync == null && confirmSaveCache != null && HRStringUtils.equals((String)confirmSaveCache, (String)"1")) {
            this.invokeSaveData(args);
        } else if (HRStringUtils.equals((String)fromPage, (String)"revise") && saveData == null) {
            this.invokeSaveData(args);
        } else if (!this.checkSaveValue(args)) {
            args.setCancel(true);
            if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
                this.getView().getPageCache().put("hisReviseConfirm", "1");
            }
        }
    }

    private void invokeSaveData(BeforeDoOperationEventArgs args) {
        this.getView().invokeOperation("savedata");
        args.setCancel(true);
    }

    private boolean checkSaveValue(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return true;
        }
        HashSet phaseNameSet = Sets.newHashSetWithExpectedSize((int)16);
        List<DynamicObject> stepDys = this.getStepDyList(collection);
        if (CollectionUtils.isEmpty(stepDys)) {
            return true;
        }
        for (DynamicObject dyn : collection) {
            String phaseName = dyn.getString("phasenamelang");
            if (!phaseNameSet.add(phaseName)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9636\u6bb5\u201c%s\u201d\u5728\u65b9\u6848\u4e2d\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"AccountPlanEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[]{phaseName}));
                return false;
            }
            DynamicObjectCollection dynCollect = dyn.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)dynCollect)) continue;
            List<Long> stepList = dynCollect.stream().map(ob -> ob.getLong("stepid.id")).collect(Collectors.toList());
            List<DynamicObject> stepDyList = this.getTrueOrderStep(stepList, stepDys);
            HashSet stepTypeSet = Sets.newHashSetWithExpectedSize((int)16);
            if (CollectionUtils.isEmpty(stepDyList) || this.valiteStepData(args, stepTypeSet, stepDyList, phaseName)) continue;
            return false;
        }
        return true;
    }

    private boolean valiteStepData(BeforeDoOperationEventArgs args, Set<String> stepTypeSet, List<DynamicObject> stepDyList, String phaseName) {
        DynamicObject firstPrjValue = stepDyList.stream().filter(ob -> HRStringUtils.equals((String)ob.getString("resulttype"), (String)"0")).findFirst().orElse(null);
        HashSet calRuleSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dy : stepDyList) {
            if (this.getModel().getDataEntity().getDate("bsed").before(dy.getDate("firstbsed"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6b65\u9aa4\u6700\u65e9\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u6838\u7b97\u65b9\u6848\u751f\u6548\u65e5\u671f\u3002", (String)"AccountPlanEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), new Object[0]));
                args.setCancel(true);
                return false;
            }
            if (firstPrjValue == null) continue;
            String resultType = dy.getString("resulttype");
            if (HRStringUtils.equals((String)resultType, (String)"1") && stepTypeSet.contains("0")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d%2$s\u7ed3\u679c\u7c7b\u578b\u4e3a\u65f6\u95f4\u5bf9\uff0c\u4e0d\u80fd\u4f4d\u4e8e\u7ed3\u679c\u7c7b\u578b\u4e3a\u9879\u76ee\u503c\u7684\u6b65\u9aa4%3$s\u4e4b\u540e\u3002", (String)"AccountPlanEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), phaseName, dy.getString("name"), firstPrjValue.getString("name")));
                args.setCancel(true);
                return false;
            }
            String calRule = dy.getString("calrule");
            if (HRStringUtils.equals((String)calRule, (String)"0") && calRuleSet.contains("1")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u9636\u6bb5\u201c%1$s\u201d\u4e2d\u6838\u7b97\u6b65\u9aa4\u201c%2$s\u201d\u9700\u6392\u5217\u5728\u201c\u8ba1\u7b97\u89c4\u5219\u201d\u4e3a\u201c\u81ea\u5b9a\u4e49\u516c\u5f0f\u201d\u7684\u6b65\u9aa4\u4e4b\u524d\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"AccountPlanEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), phaseName, dy.getString("name"), firstPrjValue.getString("name")));
                args.setCancel(true);
                return false;
            }
            calRuleSet.add(calRule);
            stepTypeSet.add(resultType);
        }
        return true;
    }

    private List<DynamicObject> getTrueOrderStep(List<Long> stepList, List<DynamicObject> stepDys) {
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        for (Long stepId : stepList) {
            DynamicObject dy = stepDys.stream().filter(ob -> ob.getLong("id") == stepId.longValue()).findFirst().orElse(null);
            if (dy == null) continue;
            dynamicObjectList.add(dy);
        }
        return dynamicObjectList;
    }

    private Set<Long> getStepIdSet(DynamicObjectCollection collection) {
        HashSet stepIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyn : collection) {
            DynamicObjectCollection dynCollect = dyn.getDynamicObjectCollection("subentryentity");
            if (CollectionUtils.isEmpty((Collection)dynCollect)) continue;
            stepIdSet.addAll(dynCollect.stream().map(ob -> ob.getLong("stepid.id")).collect(Collectors.toSet()));
        }
        return stepIdSet;
    }

    private List<DynamicObject> getStepDyList(DynamicObjectCollection collection) {
        Set<Long> stepIdSet = this.getStepIdSet(collection);
        if (CollectionUtils.isEmpty(stepIdSet)) {
            return Collections.emptyList();
        }
        HRBaseServiceHelper stepService = new HRBaseServiceHelper("wtp_accountsteps");
        DynamicObject[] dynamicObjects = stepService.loadDynamicObjectArray(stepIdSet.toArray());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(dynamicObjects);
    }

    private int getPageStatus() {
        boolean isLock = WTCHisService.isLock((IFormView)this.getView());
        return isLock ? 1 : 0;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String controlKey = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"accounttype") || StringUtils.equals((CharSequence)controlKey, (CharSequence)"accountmode")) {
            DynamicObject dynamicObject;
            if (StringUtils.equals((CharSequence)controlKey, (CharSequence)"accounttype")) {
                this.showAccountMode();
            }
            if ((dynamicObject = this.getDefaultPlanData()) != null) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
                this.initCustomControl((List<DynamicObject>)collection, this.getPageStatus());
            } else {
                this.setCustomControl(this.getPageStatus(), new ArrayList<PhaseVo>());
            }
        }
    }

    private void showAccountMode() {
        String accountType = this.getModel().getDataEntity().getString("accounttype");
        if ("C".equals(accountType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"accountmode"});
            if (WTCStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("accountmode"))) {
                this.getModel().setValue("accountmode", (Object)"C");
            }
            ComboEdit control = (ComboEdit)this.getControl("accountmode");
            control.setMustInput(true);
        } else {
            ComboEdit control = (ComboEdit)this.getControl("accountmode");
            control.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"accountmode"});
            this.getModel().setValue("accountmode", null);
        }
    }
}

