/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.accountsteps;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.list.StandardF7FormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.constants.account.AccountConstants;
import kd.wtc.wtp.formplugin.web.vo.PhaseVo;
import kd.wtc.wtp.formplugin.web.vo.StepVo;

public class OrgTreeViewPlugin
extends StandardF7FormPlugin
implements AccountConstants,
BeforeF7SelectListener {
    private static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("wtp_accountsteps");
    private static final String KEY_OK = "btnok";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Button btn = (Button)this.getControl(KEY_OK);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
        BasedataEdit accountTypeSelect = (BasedataEdit)this.getControl("phasetype");
        accountTypeSelect.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Map customParams;
        String accountType;
        if (HRStringUtils.equals((String)"phasetype", (String)beforeF7SelectEvent.getProperty().getName()) && !HRStringUtils.isEmpty((String)(accountType = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get("accounttype")))) {
            QFilter filter = new QFilter("accounttype", "like", (Object)("%" + accountType + "%"));
            beforeF7SelectEvent.addCustomQFilter(filter);
        }
    }

    public void beforeBindData(EventObject ob) {
        super.beforeBindData(ob);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String event = (String)customParams.get("event");
        if (HRStringUtils.equals((String)event, (String)"editphase")) {
            Long phaseId = (Long)customParams.get("phasetype.id");
            this.getModel().setValue("phasetype", (Object)phaseId);
        }
    }

    public void afterBindData(EventObject evt) {
        String flag;
        super.afterBindData(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String event = (String)customParams.get("event");
        if (HRStringUtils.equals((String)event, (String)"editphase") && !HRStringUtils.equals((String)(flag = this.getPageCache().get(this.getView().getPageId())), (String)"true")) {
            Object phaseName = customParams.get("phasenamelang");
            List steps = JSON.parseArray((String)((String)customParams.get("steps")), StepVo.class);
            this.getModel().setValue("phasename", phaseName);
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
            for (StepVo stepVo : steps) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)stepVo.getIdLong());
                listSelectedRows.add((Object)listSelectedRow);
            }
            billlist.putSelectedRows(listSelectedRows);
            this.getPageCache().put(this.getView().getPageId(), "true");
            billlist.refreshData();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            if (KEY_OK.equalsIgnoreCase(btn.getKey())) {
                this.returnData(evt);
            }
            evt.setCancel(true);
        }
    }

    private void returnData(BeforeClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String event = (String)customParams.get("event");
        Integer position = (Integer)customParams.get("position");
        Boolean del = (Boolean)customParams.get("del");
        if (Objects.isNull(del)) {
            del = Boolean.TRUE;
        }
        OrmLocaleValue phaseName = (OrmLocaleValue)this.getModel().getValue("phasename");
        String phaseNumber = this.getModel().getDataEntity().getString("phasetype.number");
        Long phaseId = this.getModel().getDataEntity().getLong("phasetype.id");
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        ArrayList<Long> selectedRowsIdList = new ArrayList<Long>(selectedRows.size());
        for (ListSelectedRow item : selectedRows) {
            selectedRowsIdList.add((Long)item.getPrimaryKeyValue());
        }
        QFilter qFilter = new QFilter("id", "in", selectedRowsIdList);
        DynamicObject[] dynamicObjectList = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter});
        ArrayList<StepVo> steps = new ArrayList<StepVo>(dynamicObjectList.length);
        List stepList = JSON.parseArray((String)((String)customParams.get("steps")), StepVo.class);
        HashSet stepTypeSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Long object : selectedRowsIdList) {
            DynamicObject dynamicObject = Arrays.asList(dynamicObjectList).stream().filter(ob -> ob.getLong("id") == object.longValue()).findFirst().orElse(null);
            if (dynamicObject == null) continue;
            DynamicObject firstPrjValue = Arrays.asList(dynamicObjectList).stream().filter(ob -> HRStringUtils.equals((String)ob.getString("resulttype"), (String)"0")).findFirst().orElse(null);
            String resultType = dynamicObject.getString("resulttype");
            if (firstPrjValue != null && HRStringUtils.equals((String)resultType, (String)"1") && stepTypeSet.contains("0")) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u4e2d%2$s\u7ed3\u679c\u7c7b\u578b\u4e3a\u65f6\u95f4\u5bf9\uff0c\u4e0d\u80fd\u4f4d\u4e8e\u7ed3\u679c\u7c7b\u578b\u4e3a\u9879\u76ee\u503c\u7684\u6b65\u9aa4%3$s\u4e4b\u540e\u3002", (String)"OrgTreeViewPlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), phaseName, dynamicObject.getString("name"), firstPrjValue.getString("name")));
                return;
            }
            steps.add(this.builtStepVo(dynamicObject, stepList, event));
            stepTypeSet.add(resultType);
        }
        PhaseVo phaseVo = new PhaseVo();
        String curPhaseName = this.getModel().getDataEntity().getString("phasename");
        phaseVo.setPhase(curPhaseName);
        phaseVo.setPhaseNameLang(phaseName);
        phaseVo.setPhasenumber(phaseNumber);
        phaseVo.setPhaseId(phaseId);
        phaseVo.setDel(del);
        Boolean move = (Boolean)customParams.get("move");
        if (Objects.isNull(move)) {
            move = Boolean.TRUE;
        }
        phaseVo.setMove(move);
        this.setPhaseHighProp(phaseVo, event, customParams);
        phaseVo.setSteps(steps);
        ArrayList<PhaseVo> phases = new ArrayList<PhaseVo>(1);
        phases.add(phaseVo);
        Boolean flag = this.validateData(evt, phaseVo);
        if (flag.booleanValue()) {
            return;
        }
        HashMap<String, Object> response = new HashMap<String, Object>(16);
        response.put("event", event);
        response.put("position", position);
        response.put("data", phases);
        this.getView().returnDataToParent(response);
        this.getView().close();
    }

    private StepVo builtStepVo(DynamicObject dynamicObject, List<StepVo> stepList, String event) {
        StepVo newStepVo;
        StepVo stepVo = new StepVo();
        stepVo.setId(dynamicObject.getLong("id"));
        stepVo.setStep(dynamicObject.getString("name"));
        stepVo.setSyspreset(dynamicObject.getBoolean("issyspreset"));
        stepVo.setIndex(dynamicObject.getInt("index"));
        stepVo.setBitindex(dynamicObject.getInt("bitindex"));
        stepVo.setStartdate(HRDateTimeUtils.format((Date)dynamicObject.getDate("bsed"), (String)"yyyy-MM-dd"));
        stepVo.setEnddate(dynamicObject.getDate("bsled"));
        stepVo.setResulttype(dynamicObject.getString("resulttype"));
        stepVo.setCalrule(dynamicObject.getString("calrule"));
        StepVo stepVo2 = newStepVo = CollectionUtils.isEmpty(stepList) ? null : (StepVo)stepList.stream().filter(ob -> ob.getIdLong().longValue() == dynamicObject.getLong("id")).findFirst().orElse(null);
        if (newStepVo != null && !HRStringUtils.equals((String)event, (String)"addphase")) {
            stepVo.setMove(newStepVo.getMove());
            stepVo.setDel(newStepVo.getDel());
            stepVo.setNoReturnHandler(newStepVo.getNoReturnHandler());
        } else {
            stepVo.setMove(Boolean.TRUE);
            stepVo.setDel(Boolean.TRUE);
            stepVo.setNoReturnHandler("1");
        }
        stepVo.setDesc(dynamicObject.getString("description"));
        return stepVo;
    }

    private void setPhaseHighProp(PhaseVo phaseVo, String event, Map<String, Object> customParams) {
        if (HRStringUtils.equals((String)event, (String)"addphase")) {
            phaseVo.setPhaseResultDeal("1");
            phaseVo.setNoReturnHandler("1");
            phaseVo.setEdit(Boolean.TRUE);
        } else {
            phaseVo.setPhaseResultDeal((String)customParams.get("phaseresultdeal"));
            phaseVo.setNoReturnHandler((String)customParams.get("noreturnhandler"));
            phaseVo.setEdit((Boolean)customParams.get("edit"));
        }
    }

    private Boolean validateData(BeforeClickEvent evt, PhaseVo phaseVo) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List stepList = JSON.parseArray((String)((String)customParams.get("steps")), StepVo.class);
        List orginSteps = CollectionUtils.isEmpty((Collection)stepList) ? Collections.emptyList() : stepList.stream().map(StepVo::getIdLong).collect(Collectors.toList());
        List<StepVo> steps = phaseVo.getSteps();
        String phase = phaseVo.getPhase();
        if (HRStringUtils.isEmpty((String)phase)) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9636\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTreeViewPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        List otherPhaseNames = (List)customParams.get("otherphasenames");
        if (!CollectionUtils.isEmpty((Collection)otherPhaseNames) && otherPhaseNames.contains(phase)) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9636\u6bb5\u4e0e\u65b9\u6848\u4e2d\u5176\u4ed6\u9636\u6bb5\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u91cd\u8bd5\u3002", (String)"OrgTreeViewPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        if (CollectionUtils.isEmpty(steps)) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"OrgTreeViewPlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return Boolean.TRUE;
        }
        List newStepIds = steps.stream().map(StepVo::getIdLong).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(orginSteps)) {
            DynamicObject[] dynamicObjectList;
            QFilter qFilter = new QFilter("id", "in", orginSteps);
            for (DynamicObject dynamicObject : dynamicObjectList = SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{qFilter})) {
                StepVo stepVo = stepList.stream().filter(ob -> ob.getIdLong().longValue() == dynamicObject.getLong("id")).findFirst().orElse(null);
                if (stepVo == null || stepVo.getDel().booleanValue() || newStepIds.contains(dynamicObject.getLong("id"))) continue;
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b65\u9aa4: %s,\u4e0d\u53ef\u5220\u9664", (String)"OrgTreeViewPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

