/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.container.Container;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.common.predata.wtp.PreDataAttendRule;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.ruleenging.RulePreviewUtil;

public class AttCalculrulePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String KEY_LIMITFLEX = "limitflex";
    private static final Log LOG = LogFactory.getLog(AttCalculrulePlugin.class);

    public void beforeBindData(EventObject event) {
        JSONObject model = (JSONObject)this.getView().getFormShowParameter().getCustomParam("model");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.nonNull(model)) {
            if (!OperationStatus.ADDNEW.equals((Object)status)) {
                this.getModel().setValue("calculatename", model.get((Object)"calculatename"));
            }
            this.getModel().setValue("org", (Object)this.getBaseDataId(model, "createorg"));
            this.getModel().setValue("attendconfig", (Object)this.getBaseDataId(model, "attendconfig"));
            this.getModel().setValue("daterangedesc", model.get((Object)"daterangedesc"));
            this.getModel().setValue("limitscopedesc", model.get((Object)"limitscopedesc"));
            this.getModel().setValue("attendancetime", (Object)this.getBaseDataId(model, "attendancetime"));
            this.getModel().setValue("attendanceday", (Object)this.getBaseDataId(model, "attendanceday"));
            this.getModel().setValue("daterangecondition", model.get((Object)"daterangecondition"));
            this.getModel().setValue("limitscopecondition", model.get((Object)"limitscopecondition"));
            TargetCondition daterangeconditionap = (TargetCondition)this.getView().getControl("daterangeconditionap");
            daterangeconditionap.setValue((String)this.getModel().getValue("daterangecondition"));
            TargetCondition limitscopeconditionap = (TargetCondition)this.getView().getControl("limitscopeconditionap");
            limitscopeconditionap.setValue((String)this.getModel().getValue("limitscopecondition"));
            JSONArray jsonArray = model.getJSONArray("attcustimes");
            this.initEntryEntity(jsonArray);
        } else {
            this.getModel().setValue("attendancetime", (Object)PreDataAttendRule.PD_AT_1010);
            this.getModel().setValue("attendanceday", (Object)PreDataAttendRule.PD_AT_1030);
        }
        this.refreshEntry();
    }

    public void afterBindData(EventObject e) {
        AccessDto accessDto;
        List conditionList;
        super.afterBindData(e);
        boolean collapse = true;
        Container infoContainer = (Container)this.getView().getControl(KEY_LIMITFLEX);
        String limitConditionJson = (String)this.getModel().getValue("limitscopecondition");
        if (HRStringUtils.isNotEmpty((String)limitConditionJson) && !CollectionUtils.isEmpty((Collection)(conditionList = (accessDto = (AccessDto)SerializationUtils.fromJsonString((String)limitConditionJson, AccessDto.class)).getConditionList()))) {
            collapse = false;
        }
        infoContainer.setCollapse(collapse);
    }

    private void initEntryEntity(JSONArray jsonArray) {
        this.getModel().deleteEntryData("entryentity");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Long attcustimeid = jsonObject.getJSONObject("fbasedataid").getLong("id");
            this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("attcustime", (Object)attcustimeid, i);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        Date ruleDate;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if ("ruledate".equals(name) && (ruleDate = (Date)this.getModel().getValue("ruledate")) != null) {
            ((TargetCondition)this.getView().getControl("limitscopeconditionap")).setDate(HRDateTimeUtils.format((Date)ruleDate, (String)"yyyy-MM-dd"));
            this.getModel().setValue("ruledate", null);
        }
        if ("attcustime".equals(name)) {
            this.refreshEntry();
        }
    }

    private void refreshEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        int i = 0;
        for (DynamicObject entry : entryEntity) {
            DynamicObject dynamicObject = entry.getDynamicObject("attcustime");
            if (Objects.nonNull(dynamicObject)) {
                DynamicObject attitem = dynamicObject.getDynamicObject("attitem");
                this.getModel().setValue("attitem", (Object)attitem, i);
            }
            ++i;
        }
    }

    private Long getBaseDataId(JSONObject model, String key) {
        JSONObject object = model.getJSONObject(key);
        return object == null ? null : object.getLong("id");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if ("save".equals(((AbstractOperate)args.getSource()).getOperateKey())) {
            this.validateNameDistinct(args);
            this.validateAttItemDistinct(args);
            this.validateDateRangeDistinct(args);
            this.saveConditonJson(args);
        }
    }

    private void validateDateRangeDistinct(BeforeDoOperationEventArgs args) {
        String daterangecondition = ((TargetCondition)this.getView().getControl("daterangeconditionap")).getValue();
        DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("attendruleentity");
        Integer rowindex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
        DateRangeServiceImpl iDateRangeService = new DateRangeServiceImpl();
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (rowindex != null && rowindex == i) continue;
                String existCondition = ((DynamicObject)entryEntity.get(i)).getString("daterangecondition");
                ArrayList<String> existConditions = new ArrayList<String>(4);
                existConditions.add(existCondition);
                if (!iDateRangeService.isContentDateRange(existConditions, daterangecondition).booleanValue()) continue;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u65e5\u671f\u8303\u56f4\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"AttCalculrulePlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void saveConditonJson(BeforeDoOperationEventArgs args) {
        String conditionPreviewStr;
        RuleValidateInfo info;
        String daterangecondition = ((TargetCondition)this.getView().getControl("daterangeconditionap")).getValue();
        String limitscopecondition = ((TargetCondition)this.getView().getControl("limitscopeconditionap")).getValue();
        LOG.info("AttCalculrulePlugin_saveConditonJson daterangecondition = {}", (Object)daterangecondition);
        LOG.info("AttCalculrulePlugin_saveConditonJson limitscopecondition = {}", (Object)limitscopecondition);
        String dateRangeFix = ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\uff1a", (String)"AttCalculrulePlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        String limitFix = ResManager.loadKDString((String)"\u9650\u5b9a\u6761\u4ef6\uff1a", (String)"AttCalculrulePlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        if (HRStringUtils.isNotEmpty((String)daterangecondition) && daterangecondition.contains("is_or_isSub") || HRStringUtils.isNotEmpty((String)limitscopecondition) && limitscopecondition.contains("is_or_isSub")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"ExPushRulePlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!HRStringUtils.isEmpty((String)daterangecondition)) {
            info = RuleValidateUtil.validCondition((String)daterangecondition, (boolean)false);
            if (info.isSuccess()) {
                conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)daterangecondition);
                this.getModel().setValue("daterangedesc", (Object)conditionPreviewStr);
                this.getModel().setValue("daterangecondition", (Object)daterangecondition);
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(dateRangeFix + String.join((CharSequence)",", info.getMsgList()));
            }
        } else {
            this.getModel().setValue("daterangedesc", (Object)"");
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u8303\u56f4\u3002", (String)"AttCalculrulePlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.isEmpty((String)limitscopecondition)) {
            info = RuleValidateUtil.validCondition((String)limitscopecondition, (boolean)true);
            if (info.isSuccess()) {
                conditionPreviewStr = RulePreviewUtil.getConditionPreviewStr((String)limitscopecondition);
                this.getModel().setValue("limitscopedesc", (Object)conditionPreviewStr);
                this.getModel().setValue("limitscopecondition", (Object)limitscopecondition);
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(limitFix + String.join((CharSequence)",", info.getMsgList()));
            }
        } else {
            this.getModel().setValue("limitscopedesc", (Object)"");
        }
    }

    private void validateAttItemDistinct(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            Map<String, List<DynamicObject>> collect = entryEntity.stream().filter(e -> Objects.nonNull(e.getDynamicObject("attcustime"))).collect(Collectors.groupingBy(e -> e.getString("attcustime.attitem.name")));
            Iterator<Map.Entry<String, List<DynamicObject>>> iterator = collect.entrySet().iterator();
            String distinctType = "";
            while (iterator.hasNext()) {
                Map.Entry<String, List<DynamicObject>> next = iterator.next();
                if (next.getValue().size() <= 1) continue;
                if (HRStringUtils.isNotEmpty((String)distinctType)) {
                    distinctType = WTCStringUtils.joinStr((String[])new String[]{distinctType, ",", next.getKey()});
                    continue;
                }
                distinctType = WTCStringUtils.joinStr((String[])new String[]{distinctType, next.getKey()});
            }
            if (HRStringUtils.isNotEmpty((String)distinctType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7684\u51fa\u52e4\u9879\u76ee\uff08%s\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AttCalculrulePlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[]{distinctType}));
                args.setCancel(true);
            }
        }
    }

    private void validateNameDistinct(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entryEntity = this.getView().getParentView().getModel().getEntryEntity("attendruleentity");
        String calculatename = this.getModel().getDataEntity().getLocaleString("calculatename").getLocaleValue();
        Integer rowindex = (Integer)this.getView().getFormShowParameter().getCustomParam("rowindex");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                String existName;
                if (rowindex != null && rowindex == i || !HRStringUtils.equals((String)(existName = ((DynamicObject)entryEntity.get(i)).getLocaleString("calculatename").getLocaleValue()), (String)calculatename)) continue;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u3002", (String)"AttCalculrulePlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "save".equals(operateKey)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        ((BasedataEdit)this.getControl("attendconfig")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("attendancetime")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("attendanceday")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("attcustime")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((EntryGrid)this.getControl("entryentity")).addHyperClickListener((HyperLinkClickListener)this);
        ((BasedataEdit)this.getControl("attcustimef7")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("bsed");
        Date date = WTCDateUtils.str2Date((String)customParam, null);
        switch (name) {
            case "attendconfig": 
            case "attendancetime": 
            case "attendanceday": {
                this.addBsedQfilter(date, beforeF7SelectEvent);
                break;
            }
            case "attcustimef7": {
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.setMultiSelect(true);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "attcustimef7"));
            }
            case "attcustime": {
                this.addBsedQfilter(date, beforeF7SelectEvent);
                this.addDistinctQfilter(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void addDistinctQfilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            Set idSet = entryEntity.stream().filter(entry -> Objects.nonNull(entry.getDynamicObject("attcustime"))).map(dy -> dy.getLong("attcustime.id")).collect(Collectors.toSet());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", idSet));
        }
    }

    private void addBsedQfilter(Date date, BeforeF7SelectEvent beforeF7SelectEvent) {
        if (date != null) {
            QFilter qFilter = new QFilter("firstbsed", "<=", (Object)date);
            Long org = (Long)this.getView().getParentView().getModel().getDataEntity().getDynamicObject("createorg").getPkValue();
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setUseOrgId(org.longValue());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"newentryap")) {
            BasedataEdit control = (BasedataEdit)this.getControl("attcustimef7");
            control.click();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"attcustimef7")) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                return;
            }
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            tableValueSetter.addField("attcustime", primaryKeyValues);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
            model.endInit();
            this.refreshEntry();
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String name = args.getFieldName();
        if ("attcustime".equals(name)) {
            Integer rowIndex = args.getRowIndex();
            BasedataEdit control = (BasedataEdit)this.getControl("attcustime");
            HashMap<String, Integer> requestMap = new HashMap<String, Integer>();
            requestMap.put("rowKey", rowIndex);
            control.viewDetail(requestMap);
        }
    }
}

