/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.web.attitem.AttItemFilterHelper;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtbs.wtbd.common.attitem.AttItemItemType;
import kd.wtc.wtp.common.attend.AttConfigRes;
import kd.wtc.wtp.formplugin.utils.WTPMultiLangUtils;
import kd.wtc.wtp.formplugin.web.attconfig.utils.AttConfigEditUtils;
import kd.wtc.wtp.formplugin.web.attconfig.utils.AttConfigPageCache;
import kd.wtc.wtp.formplugin.web.attconfig.utils.ConditionPanelUtils;

public class AttCusTimeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void afterBindData(EventObject object) {
        super.afterBindData(object);
        ConditionPanelUtils.deleteAllConditions(this.getView());
        DynamicObjectCollection col = this.getModel().getEntryEntity("condentity");
        if (col != null && !col.isEmpty() && ((DynamicObject)col.get(0)).getDynamicObject("existatt") != null) {
            for (DynamicObject dy : col) {
                HashMap params = Maps.newHashMapWithExpectedSize((int)2);
                params.put("existatt", dy.getDynamicObject("existatt").getPkValue());
                params.put("nocountatt", dy.getDynamicObject("nocountatt").getPkValue());
                ConditionPanelUtils.addConditionRow(this.getView(), params);
            }
        }
        String hisVersion = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        Long id = (Long)this.getModel().getValue("id");
        if (id != null && id != 0L || HRStringUtils.isNotEmpty((String)hisVersion)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attitem"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IFormView view = this.getView();
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (WTCFormUtils.isSave((BeforeDoOperationEventArgs)args)) {
            AttConfigEditUtils.saveAttCusTime(view, args);
        }
        switch (key) {
            case "newentry": {
                if (this.getModel().getValue("attitem") != null) break;
                args.setCancel(true);
                view.showTipNotification(AttConfigRes.ATTITEM_EMPTY.load());
                WTCFormUtils.showFieldEmptyWarning((IFormView)this.getView(), (String[])new String[]{"attitem"});
                break;
            }
            case "deleteentry": {
                String items = this.getSelectedItemsInConditions();
                if (!StringUtils.isNotBlank((CharSequence)items)) break;
                args.setCancel(true);
                view.showTipNotification(String.format(Locale.ROOT, AttConfigRes.PLEASE_DEL_COND.load(), items));
                break;
            }
            case "deletecon": {
                ConditionPanelUtils.deleteCondition(view);
                break;
            }
            case "addentry": {
                this.showAddEntryF7();
                break;
            }
        }
        switch (key) {
            case "submit": 
            case "confirmchange": {
                AttConfigPageCache.get(view).getConditionMap().keySet().forEach(pageId -> {
                    IFormView row = view.getView(pageId);
                    row.setVisible(Boolean.FALSE, new String[]{"deletecon"});
                    view.sendFormAction(row);
                });
                break;
            }
            case "unsubmit": {
                AttConfigPageCache.get(view).getConditionMap().keySet().forEach(pageId -> {
                    IFormView row = view.getView(pageId);
                    row.setVisible(Boolean.TRUE, new String[]{"deletecon"});
                    view.sendFormAction(row);
                });
                break;
            }
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"addcondition"});
        ((BasedataEdit)this.getControl("attitem")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((BasedataEdit)this.getControl("attitemcus")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((EntryGrid)this.getControl("attcustimeattentity")).addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("addcondition".equals(key)) {
            DynamicObject attItem = (DynamicObject)this.getModel().getValue("attitem");
            if (attItem == null) {
                this.getView().showTipNotification(AttConfigRes.ATTITEM_EMPTY.load());
                WTCFormUtils.showFieldEmptyWarning((IFormView)this.getView(), (String[])new String[]{"attitem"});
                return;
            }
            ConditionPanelUtils.addConditionRow(this.getView(), null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        Date date = this.getModel().getDataEntity().getDate("bsed");
        switch (key) {
            case "attitem": {
                if (date == null) {
                    this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_7"));
                    event.setCancel(true);
                } else {
                    this.addBsedQfilter(date, event);
                }
                event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u51fa\u52e4\u9879\u76ee", (String)"AttCusTimeEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                ArrayList<String> items = new ArrayList<String>();
                if (!this.getChosenAttItemCusIds().isEmpty()) {
                    items.add(AttConfigRes.ATTCUSTIME.load());
                }
                if (!ConditionPanelUtils.getChosenConditionIds(this.getView()).isEmpty()) {
                    items.add(AttConfigRes.COND.load());
                }
                if (items.isEmpty()) break;
                this.getView().showTipNotification(String.format(Locale.ROOT, AttConfigRes.PLEASE_DEL.load(), String.join((CharSequence)AttConfigRes.IDEOGRAPHIC_COMMA.load(), items)));
                event.setCancel(true);
                this.getView().updateView("attitem");
                return;
            }
            case "attitemcus": {
                QFilter filter;
                if (date == null) {
                    this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_7"));
                    event.setCancel(true);
                } else {
                    this.addBsedQfilter(date, event);
                }
                if ("click".equals(event.getSourceMethod())) {
                    event.setCancel(true);
                    this.showAddEntryF7();
                    break;
                }
                if (!"getLookUpList".equals(event.getSourceMethod()) || (filter = this.getQFilterForF7()) == null) break;
                filter.and(new QFilter("id", "not in", this.getChosenAttItemCusIds()));
                event.addCustomQFilter(filter);
                break;
            }
        }
    }

    private void addBsedQfilter(Date date, BeforeF7SelectEvent beforeF7SelectEvent) {
        if (date != null) {
            QFilter qFilter = new QFilter("firstbsed", "<=", (Object)date);
            Long org = (Long)this.getView().getModel().getDataEntity().getDynamicObject("createorg").getPkValue();
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setUseOrgId(org.longValue());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if ("attitemnumber".equals(event.getFieldName())) {
            Object id = ((DynamicObject)this.getModel().getEntryEntity("attcustimeattentity").get(event.getRowIndex())).getDynamicObject("attitemcus").getPkValue();
            WTCFormUtils.showDetailView((IFormView)this.getView(), (String)"wtbd_attitem", (Object)id);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        Object oldValue;
        String key = event.getProperty().getName();
        if (event.getChangeSet() == null || event.getChangeSet().length <= 0) {
            return;
        }
        if ("useorg".equals(key)) {
            ConditionPanelUtils.deleteAllConditions(this.getView());
        }
        if ("bsed".equals(key) && (oldValue = event.getChangeSet()[0].getOldValue()) != null) {
            Date oldDate = (Date)oldValue;
            Date newEffStartDate = this.getModel().getDataEntity().getDate("bsed");
            if (newEffStartDate != null && newEffStartDate.before(oldDate)) {
                this.getModel().deleteEntryData("attcustimeattentity");
                this.getModel().setValue("attitem", null);
                ConditionPanelUtils.deleteAllConditions(this.getView());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        WTCFormUtils.addEntryClosedCallBack((IFormView)this.getView(), (String)"attitemcus", (ClosedCallBackEvent)event);
    }

    private List<Long> getChosenAttItemCusIds() {
        return WTCFormUtils.getChosenIds((IDataModel)this.getModel(), (String)"attcustimeattentity", (String)"attitemcus");
    }

    private String getSelectedItemsInConditions() {
        List<Long> conIds = ConditionPanelUtils.getChosenConditionIds(this.getView());
        DynamicObjectCollection entity = this.getModel().getEntryEntity("attcustimeattentity");
        return Arrays.stream(((EntryGrid)this.getControl("attcustimeattentity")).getSelectRows()).mapToObj(id -> ((DynamicObject)entity.get(id)).getDynamicObject("attitemcus")).filter(dy -> dy != null && conIds.contains(dy.getLong("id"))).map(dy -> dy.getString("name")).collect(Collectors.joining(AttConfigRes.IDEOGRAPHIC_COMMA.load()));
    }

    private void showAddEntryF7() {
        ListShowParameter parameter = WTCFormUtils.getListShowParameterAddEntry((AbstractFormPlugin)this, (String)"attitemcus", null, null);
        Long org = (Long)this.getView().getModel().getDataEntity().getDynamicObject("createorg").getPkValue();
        parameter.setUseOrgId(org.longValue());
        QFilter filter = this.getQFilterForF7();
        if (filter != null) {
            parameter.getListFilterParameter().setFilter(filter);
            parameter.setCustomParam("isorginattitem", (Object)Boolean.TRUE);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private QFilter getQFilterForF7() {
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (date == null) {
            this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_7"));
            return null;
        }
        DynamicObject attItem = (DynamicObject)this.getModel().getValue("attitem");
        if (HRObjectUtils.isEmpty((Object)attItem)) {
            this.getView().showTipNotification(AttConfigRes.ATTITEM_EMPTY.load());
            WTCFormUtils.showFieldEmptyWarning((IFormView)this.getView(), (String[])new String[]{"attitem"});
            return null;
        }
        String items = this.getSelectedItemsInConditions();
        if (StringUtils.isNotBlank((CharSequence)items)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, AttConfigRes.PLEASE_DEL_COND.load(), items));
            return null;
        }
        List<Long> ids = Collections.singletonList(attItem.getLong("id"));
        QFilter qFilter = new QFilter("datatype", "=", attItem.get("datatype")).and(new QFilter("id", "not in", ids)).and(new QFilter("firstbsed", "<=", (Object)date));
        qFilter.and(AttItemFilterHelper.issaveQFilter((boolean)true).and(AttItemFilterHelper.itemtypeQFilter((String[])new String[]{AttItemItemType.DETAIL_ITEM.type, AttItemItemType.DETAIL_SUM_ITEM.type})).or(AttItemFilterHelper.issaveQFilter((boolean)false)));
        return qFilter;
    }
}

