/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.property.DecimalProp;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.predata.wtbs.PreInterfaceRegister;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class AttendConfigEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        String shiftConditionJson = this.getModel().getDataEntity().getString("shiftconditionjson_tag");
        if (StringUtils.isNotBlank((CharSequence)shiftConditionJson)) {
            ((TargetCondition)this.getControl("shiftcondition")).setValue(shiftConditionJson);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setMustInput();
        WTCFormUtils.lockCondition((IFormView)this.getView(), (String)"shiftcondition");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        DynamicObject entity = this.getModel().getDataEntity();
        if (WTCFormUtils.isSave((String)evt.getOperationKey()) && ("A".equals(entity.getString("attenddays")) || "A".equals(entity.getString("attenddaysse")) || "B".equals(entity.getString("attenddaysse")))) {
            String shiftConditionJson = ((TargetCondition)this.getView().getControl("shiftcondition")).getValue();
            if (HRStringUtils.isNotEmpty((String)shiftConditionJson) && shiftConditionJson.contains("is_or_isSub")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"ExPushRulePlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            RuleValidateInfo result = RuleValidateUtil.validCondition((String)shiftConditionJson, (boolean)false);
            if (!result.isSuccess()) {
                this.getView().showTipNotification(String.join((CharSequence)",", result.getMsgList()));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (WTCFormUtils.isSave((BeforeDoOperationEventArgs)args)) {
            String shiftConditionJson = ((TargetCondition)this.getView().getControl("shiftcondition")).getValue();
            this.getModel().setValue("shiftconditionjson_tag", (Object)shiftConditionJson);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        WTCFormUtils.lockCondition((IFormView)this.getView(), (String)"shiftcondition");
        if (args.getSource() instanceof SaveAndNew && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            TargetCondition condition = (TargetCondition)this.getControl("shiftcondition");
            condition.clear();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        this.setMustInput();
    }

    private void setMustInput() {
        IDataModel model = this.getModel();
        model.getDataEntity().beginInit();
        ((FieldEdit)this.getControl("fixdays")).setMustInput("B".equals(model.getValue("attenddays")));
        ((FieldEdit)this.getControl("fixdaysse")).setMustInput("C".equals(model.getValue("attenddaysse")));
        ((FieldEdit)this.getControl("customplugin")).setMustInput("D".equals(model.getValue("attenddaysse")));
        if (BigDecimal.ZERO.compareTo(model.getDataEntity().getBigDecimal("fixdays")) == 0) {
            model.setValue("fixdays", ((DecimalProp)((FieldEdit)this.getControl("fixdays")).getProperty()).getDefValue());
        }
        if (BigDecimal.ZERO.compareTo(model.getDataEntity().getBigDecimal("fixdaysse")) == 0) {
            model.setValue("fixdaysse", ((DecimalProp)((FieldEdit)this.getControl("fixdaysse")).getProperty()).getDefValue());
        }
        model.getDataEntity().endInit();
        this.getView().updateView("fixdays");
        this.getView().updateView("fixdaysse");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit customPlugin = (BasedataEdit)this.getView().getControl("customplugin");
        customPlugin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"customplugin")) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("interface", "=", (Object)PreInterfaceRegister.PD_IATTEND_CONFIG_ENTRY_AND_EXIT_SERVICE));
        }
    }
}

