/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.predata.wtbd.PreDataAttItem;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.formplugin.utils.WTPMultiLangUtils;
import kd.wtc.wtp.formplugin.web.filter.WTPValidate;

public class AttendRuleEdit
extends HRDataBaseEdit
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void afterBindData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String hisAction = (String)customParams.get("his_action");
        boolean isNewVersion = HRStringUtils.equals((String)"open_insert_new_data_page", (String)hisAction);
        if (isNewVersion) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData("attendruleentity");
            model.endInit();
            this.getView().updateView("attendruleentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (date == null && ("attendconfigrule".equals(propertyName) || "originalattitemrule".equals(propertyName) || "actualattitemrule".equals(propertyName) || "attendancetimerule".equals(propertyName) || "attendancedayrule".equals(propertyName))) {
            this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_7"));
            evt.setCancel(true);
        } else {
            this.addBsedQfilter(date, evt);
        }
    }

    private void addBsedQfilter(Date date, BeforeF7SelectEvent beforeF7SelectEvent) {
        if (date != null) {
            QFilter qFilter = new QFilter("firstbsed", "<=", (Object)date);
            Long org = (Long)this.getView().getModel().getDataEntity().getDynamicObject("createorg").getPkValue();
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setUseOrgId(org.longValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (WTPValidate.validateSave(operateKey)) {
            this.validateBsed(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"addrow")) {
            args.setCancel(true);
            if (date == null) {
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_1"));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("wtp_attcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addrow"));
            formShowParameter.setCustomParam("bsed", (Object)date);
            String orgId = String.valueOf(this.getModel().getDataEntity().getDynamicObject("createorg").getPkValue());
            formShowParameter.setCustomParam("createorg", (Object)orgId);
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"copyrow")) {
            args.setCancel(true);
            if (date == null) {
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_3"));
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("attendruleentity");
            int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
            if (ObjectUtils.isEmpty((Object)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AttendRuleEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u590d\u5236\u3002", (String)"AttendRuleEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            int entryCurrentRowIndex = selectedRows[0];
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("attendruleentity").get(entryCurrentRowIndex);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setFormId("wtp_attcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            formShowParameter.setCustomParam("bsed", (Object)this.getModel().getDataEntity().getDate("bsed"));
            this.getView().showForm(formShowParameter);
        } else if (HRStringUtils.equals((String)operateKey, (String)"editrow")) {
            args.setCancel(true);
            if (date == null) {
                this.getView().showTipNotification(WTPMultiLangUtils.loadKDString("\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", "AttendRuleEdit_7"));
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("attendruleentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("attendruleentity").get(entryCurrentRowIndex);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setFormId("wtp_attcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "editrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            formShowParameter.setCustomParam("rowindex", (Object)entryCurrentRowIndex);
            formShowParameter.setCustomParam("bsed", (Object)this.getModel().getDataEntity().getDate("bsed"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void validateBsed(BeforeDoOperationEventArgs args) {
        HashMap<String, String> checkBsedMap = new HashMap<String, String>();
        checkBsedMap.put("attendconfigrule", ResManager.loadKDString((String)"\u5e94\u51fa\u52e4\u914d\u7f6e", (String)"AttendRuleEdit_9", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        checkBsedMap.put("originalattitemrule", ResManager.loadKDString((String)"\u539f\u59cb\u5b9e\u9645\u51fa\u52e4\u65f6\u957f", (String)"AttendRuleEdit_10", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        checkBsedMap.put("actualattitemrule", ResManager.loadKDString((String)"\u5b9e\u9645\u51fa\u52e4\u65f6\u957f", (String)"AttendRuleEdit_11", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        checkBsedMap.put("attendancetimerule", ResManager.loadKDString((String)"\u5e94\u51fa\u52e4\u65f6\u957f", (String)"AttendRuleEdit_12", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        checkBsedMap.put("attendancedayrule", ResManager.loadKDString((String)"\u5e94\u51fa\u52e4\u5929\u6570", (String)"AttendRuleEdit_13", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
        String validateString = this.checkBsed(checkBsedMap, args);
        if (WTCStringUtils.isNotEmpty((String)validateString)) {
            this.getView().showTipNotification(validateString);
            return;
        }
        StringBuilder str = new StringBuilder();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("attendruleentity");
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("attcustimes");
            for (DynamicObject multDy : dynamicObjectCollection) {
                Date attcustimeBsed = multDy.getDynamicObject("fbasedataid").getDate("firstbsed");
                str.append(this.validateOneBsed(attcustimeBsed, ResManager.loadKDString((String)"\u65f6\u957f\u914d\u7f6e", (String)"AttendRuleEdit_14", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), args));
                if (!HRStringUtils.isNotEmpty((String)str.toString())) continue;
                this.getView().showTipNotification(str.toString());
                return;
            }
        }
    }

    private String checkBsed(Map<String, String> checkBsedMap, BeforeDoOperationEventArgs args) {
        String res = "";
        for (Map.Entry<String, String> entry : checkBsedMap.entrySet()) {
            Date attendconfigBsed = this.getModel().getDataEntity().getDate(entry.getKey() + "." + "firstbsed");
            res = this.validateOneBsed(attendconfigBsed, entry.getValue(), args);
            if (!WTCStringUtils.isNotEmpty((String)res)) continue;
            return res;
        }
        return "";
    }

    private String validateOneBsed(Date bsed, String str, BeforeDoOperationEventArgs args) {
        StringBuilder resStr = new StringBuilder();
        Date date = this.getModel().getDataEntity().getDate("bsed");
        if (Objects.isNull(bsed)) {
            args.setCancel(true);
            String tip = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6%s\u6700\u65e9\u751f\u6548\u65e5\u671f", (String)"AttendRuleEdit_18", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            throw new KDBizException(String.format(tip, str));
        }
        if (date.compareTo(bsed) < 0) {
            args.setCancel(true);
            resStr.append(str);
            resStr.append(ResManager.loadKDString((String)"\u5e94\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"AttendRuleEdit_15", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return resStr.toString();
        }
        return "";
    }

    public void beforeBindData(EventObject event) {
        if (Objects.isNull(this.getModel().getValue("originalattitemrule"))) {
            this.getModel().setValue("originalattitemrule", (Object)PreDataAttItem.PD_AT_1020);
        }
        if (Objects.isNull(this.getModel().getValue("actualattitemrule"))) {
            this.getModel().setValue("actualattitemrule", (Object)PreDataAttItem.PD_AT_1040);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addBeforeF7SelectListener(Arrays.asList("attendconfigrule", "originalattitemrule", "actualattitemrule", "attendancetimerule", "attendancedayrule"));
        ((EntryGrid)this.getControl("attendruleentity")).addHyperClickListener((HyperLinkClickListener)this);
    }

    private void addBeforeF7SelectListener(List<String> str) {
        for (String key : str) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        boolean flag;
        super.closedCallBack(evt);
        DynamicObject returnData = (DynamicObject)evt.getReturnData();
        String actionId = evt.getActionId();
        boolean bl = flag = ("addrow".equals(actionId) || "editrow".equals(actionId)) && returnData != null;
        if (flag) {
            int row = "addrow".equals(actionId) ? this.getModel().createNewEntryRow("attendruleentity") : this.getModel().getEntryCurrentRowIndex("attendruleentity");
            this.insertOrUpdateEntry(returnData, row);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs args) {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"AttendRuleEdit_16", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("attendruleentity");
        for (DynamicObject entryDy : entries) {
            DataEntityState dataEntityState = entryDy.getDataEntityState();
            DataEntityPropertyCollection properties = entryDy.getDataEntityType().getProperties();
            for (int i = 0; i < properties.size(); ++i) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
                String name = iDataEntityProperty.getName();
                if (!HRStringUtils.equals((String)name, (String)"daterangecondition") && !HRStringUtils.equals((String)name, (String)"limitscopecondition")) continue;
                dataEntityState.setBizChanged(i, false);
            }
        }
        super.beforeClosed(event);
    }

    private void insertOrUpdateEntry(DynamicObject returnData, int row) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("attendruleentity");
        this.getModel().setValue("daterangecondition", returnData.get("daterangecondition"), row);
        this.getModel().setValue("limitscopecondition", returnData.get("limitscopecondition"), row);
        this.compareAndSetForString(entries, returnData, row, "limitscopedesc");
        this.compareAndSetForString(entries, returnData, row, "daterangedesc");
        this.compareAndSetForLocalVal(entries, returnData, row, "calculatename");
        MulBasedataProp prop = (MulBasedataProp)this.getModel().getEntryEntity("attendruleentity").getDynamicObjectType().getProperty("attcustimes");
        DynamicObjectCollection entryentity = returnData.getDynamicObjectCollection("entryentity");
        MulBasedataDynamicObjectCollection dynamicObjectCollection = new MulBasedataDynamicObjectCollection();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject dyObj = new DynamicObject(prop.getDynamicCollectionItemPropertyType());
            DynamicObject entry = (DynamicObject)entryentity.get(i);
            DynamicObject type = entry.getDynamicObject("attcustime");
            if (Objects.isNull(type)) continue;
            dyObj.set("fbasedataid_id", type.getPkValue());
            dyObj.set("fbasedataid", (Object)type);
            dynamicObjectCollection.add(dyObj);
        }
        if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getModel().setValue("attcustimes", (Object)dynamicObjectCollection, row);
        } else {
            this.getModel().setValue("attcustimes", null, row);
        }
    }

    private void compareAndSetForString(DynamicObjectCollection entries, DynamicObject returnData, int row, String fieldKey) {
        String newVal = (String)returnData.get(fieldKey);
        if (entries != null && entries.size() > row) {
            DynamicObject entryDy = (DynamicObject)entries.get(row);
            String oriVal = entryDy.getString(fieldKey);
            if (!HRStringUtils.equals((String)newVal, (String)oriVal)) {
                this.getModel().setValue(fieldKey, (Object)newVal, row);
            }
        } else {
            this.getModel().setValue(fieldKey, (Object)newVal, row);
        }
    }

    private void compareAndSetForLocalVal(DynamicObjectCollection entries, DynamicObject returnData, int row, String fieldKey) {
        OrmLocaleValue ormLocaleValue = (OrmLocaleValue)returnData.get(fieldKey);
        boolean hasChange = false;
        if (entries != null && entries.size() > row) {
            DynamicObject entryDy = (DynamicObject)entries.get(row);
            ILocaleString oriVal = entryDy.getLocaleString(fieldKey);
            hasChange = !HRStringUtils.equals((String)ormLocaleValue.getLocaleValue_en(), (String)oriVal.getLocaleValue_en()) || !HRStringUtils.equals((String)ormLocaleValue.getLocaleValue_zh_TW(), (String)oriVal.getLocaleValue_zh_TW()) || !HRStringUtils.equals((String)ormLocaleValue.getLocaleValue_zh_CN(), (String)oriVal.getLocaleValue_zh_CN());
        } else {
            hasChange = true;
        }
        if (hasChange) {
            this.getModel().setValue(fieldKey, (Object)ormLocaleValue, row);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String name = args.getFieldName();
        if ("calculatename".equals(name)) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("attendruleentity").get(args.getRowIndex());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.setFormId("wtp_attcalculrule");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewrow"));
            formShowParameter.setCustomParam("model", (Object)dynamicObject);
            this.getView().showForm(formShowParameter);
        }
    }
}

