/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig.utils;

import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;
import kd.wtc.wtp.common.attend.AttConfigRes;
import kd.wtc.wtp.formplugin.web.attconfig.utils.AttConfigPageCache;
import kd.wtc.wtp.formplugin.web.attconfig.utils.ConditionPanelUtils;

public class AttConfigEditUtils {
    private AttConfigEditUtils() {
    }

    public static void showForm(IFormView view, String formId, Object pkId, ShowType showType, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(formId);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(showType);
        parameter.setStatus(status);
        view.showForm((FormShowParameter)parameter);
    }

    public static void saveAttCusTime(IFormView view, BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dyc = view.getModel().getEntryEntity("attcustimeattentity");
        if (dyc.stream().noneMatch(dy -> StringUtils.isBlank((CharSequence)dy.getString("calcmethod"))) && dyc.stream().noneMatch(dy -> "0".equals(dy.getString("calcmethod")))) {
            args.setCancel(true);
            view.showTipNotification(AttConfigRes.AT_LEAST_ONE_PLUS.load());
            return;
        }
        if (ConditionPanelUtils.isAnyConditionEmpty(view)) {
            args.setCancel(true);
            view.showTipNotification(AttConfigRes.COND_EMPTY.load());
            Map<String, String> conditionMap = AttConfigPageCache.get(view).getConditionMap();
            for (String pageId : conditionMap.keySet()) {
                IFormView condView = view.getView(pageId);
                WTCFormUtils.showFieldEmptyWarning((IFormView)condView, (String[])new String[]{"existatt", "nocountatt"});
                view.sendFormAction(condView);
            }
            return;
        }
        Map<String, String> map = AttConfigPageCache.get(view).getConditionMap();
        view.getModel().deleteEntryData("condentity");
        if (!map.isEmpty()) {
            view.getModel().batchCreateNewEntryRow("condentity", map.size());
            int index = 0;
            for (String pageId : map.keySet()) {
                DynamicObject dataEntity = view.getView(pageId).getModel().getDataEntity();
                long id1 = dataEntity.getLong(String.join((CharSequence)".", "existatt", "id"));
                long id2 = dataEntity.getLong(String.join((CharSequence)".", "nocountatt", "id"));
                view.getModel().setValue("existatt", (Object)id1, index);
                view.getModel().setValue("nocountatt", (Object)id2, index);
                ++index;
            }
        }
    }
}

