/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;

public class AttConfigPageCache {
    public static final String KEY_ATTCUSTIME = "attcustime";
    private Map<String, String> conditionMap;
    private Integer num;

    public Map<String, String> getConditionMap() {
        if (this.conditionMap == null) {
            this.conditionMap = new LinkedHashMap<String, String>();
        }
        return this.conditionMap;
    }

    public void setConditionMap(Map<String, String> conditionMap) {
        this.conditionMap = conditionMap;
    }

    public Integer getNum() {
        if (this.num == null) {
            this.num = 0;
        }
        return this.num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public static AttConfigPageCache get(IFormView view) {
        String cacheStr = view.getPageCache().get(KEY_ATTCUSTIME);
        return cacheStr == null ? new AttConfigPageCache() : (AttConfigPageCache)SerializationUtils.fromJsonString((String)cacheStr, AttConfigPageCache.class);
    }

    public static String getContainerKey(IFormView view, String pageId) {
        return AttConfigPageCache.get(view).getConditionMap().get(pageId);
    }

    public static int getAndAddNum(IFormView view) {
        AttConfigPageCache cache = AttConfigPageCache.get(view);
        int num = cache.getNum();
        cache.setNum(num + 1);
        AttConfigPageCache.put(view, cache);
        return num;
    }

    public static void put(IFormView view, AttConfigPageCache cache) {
        view.getPageCache().put(KEY_ATTCUSTIME, SerializationUtils.toJsonString((Object)cache));
    }

    public static void put(IFormView view, String pageId, String containerKey) {
        AttConfigPageCache cache = AttConfigPageCache.get(view);
        cache.getConditionMap().put(pageId, containerKey);
        AttConfigPageCache.put(view, cache);
    }

    public static void removePageId(IFormView view, String pageId) {
        AttConfigPageCache cache = AttConfigPageCache.get(view);
        cache.getConditionMap().remove(pageId);
        AttConfigPageCache.put(view, cache);
    }

    public static void clearConditionMap(IFormView view) {
        AttConfigPageCache cache = AttConfigPageCache.get(view);
        cache.setConditionMap(null);
        AttConfigPageCache.put(view, cache);
    }
}

