/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attconfig.utils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.wtc.wtp.formplugin.web.attconfig.utils.AttConfigPageCache;

public class ConditionPanelUtils {
    public static final String KEY_DYNAMICPANEL = "dynamicpanel";
    public static final String KEY_CONDITIONPANEL = "conditionpanel";
    public static final String KEY_CONDENTITY = "condentity";
    public static final String KEY_EXISTATT = "existatt";
    public static final String KEY_NOCOUNTATT = "nocountatt";
    public static final String OP_DELETECON = "deletecon";

    private ConditionPanelUtils() {
    }

    public static void addConditionRow(IFormView view, Map<String, Object> customParams) {
        String dpKey = KEY_DYNAMICPANEL + AttConfigPageCache.getAndAddNum(view);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(dpKey);
        Margin margin = new Margin();
        margin.setBottom("8px");
        Style style = new Style();
        style.setMargin(margin);
        flexPanelAp.setStyle(style);
        Container container = (Container)view.getControl(KEY_CONDITIONPANEL);
        container.addControls(Collections.singletonList(flexPanelAp.createControl()));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wtp_conditionrow");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(dpKey);
        parameter.setStatus(view.getFormShowParameter().getStatus());
        parameter.setCustomParams(customParams);
        view.showForm(parameter);
        AttConfigPageCache.put(view, parameter.getPageId(), dpKey);
    }

    public static void deleteCondition(IFormView view) {
        Container container = (Container)view.getControl(KEY_CONDITIONPANEL);
        String pageId = view.getReturnData().toString();
        String key = AttConfigPageCache.getContainerKey(view, pageId);
        container.deleteControls(new String[]{key});
        AttConfigPageCache.removePageId(view, pageId);
    }

    public static void deleteAllConditions(IFormView view) {
        Container container = (Container)view.getControl(KEY_CONDITIONPANEL);
        container.deleteControls(AttConfigPageCache.get(view).getConditionMap().values().toArray(new String[0]));
        AttConfigPageCache.clearConditionMap(view);
    }

    public static List<Long> getChosenConditionIds(IFormView view) {
        return AttConfigPageCache.get(view).getConditionMap().keySet().stream().flatMap(pageId -> {
            DynamicObject dataEntity = view.getView(pageId).getModel().getDataEntity();
            DynamicObject dy1 = dataEntity.getDynamicObject(KEY_EXISTATT);
            DynamicObject dy2 = dataEntity.getDynamicObject(KEY_NOCOUNTATT);
            return Stream.of(dy1, dy2);
        }).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static boolean isAnyConditionEmpty(IFormView view) {
        return AttConfigPageCache.get(view).getConditionMap().keySet().stream().anyMatch(pageId -> {
            DynamicObject dataEntity = view.getView(pageId).getModel().getDataEntity();
            return dataEntity.getDynamicObject(KEY_EXISTATT) == null || dataEntity.getDynamicObject(KEY_NOCOUNTATT) == null;
        });
    }
}

