/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attendperson;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrModel;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.ContrWorkLoc;
import kd.wtc.wtbs.business.model.attendperson.EmpEntRel;
import kd.wtc.wtbs.business.model.attendperson.PerTsProp;
import kd.wtc.wtbs.business.model.attendperson.TrialPeriod;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class AttendPersonDetailEdit
extends HRDynamicFormBasePlugin {
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = (Map)formShowParameter.getCustomParam("customvariables");
        if (customParams != null) {
            Object filePk = customParams.get("attfileid");
            Object depEmpJobIdObj = customParams.get("empposorgrel");
            DynamicObject fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("empposorgrel,empposorgrel.id, usablestatus, managingscope", filePk);
            if (fileDy != null) {
                depEmpJobIdObj = fileDy.get("empposorgrel.id");
                this.getPageCache().put("usablestatus", fileDy.getString("usablestatus"));
            }
            if (depEmpJobIdObj != null) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_depempjob");
                DynamicObject depempjobDy = serviceHelper.loadSingle(depEmpJobIdObj);
                long personId = depempjobDy.getLong("attperson.id");
                long managescopeId = depempjobDy.getLong("cmpemp.id");
                this.hideFlexByPermission(depEmpJobIdObj, personId, managescopeId);
                this.initData(personId, fileDy);
            }
        }
    }

    private void initData(long personId, DynamicObject fileDy) {
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        long empPosorgrel = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileDy, (String)"empposorgrel");
        this.getModel().setValue("empposorgrelhr", (Object)empPosorgrel);
        AttendPersonCurrResult currentAttPerson = AttendPersonServiceImpl.getInstance().getCurrentAttPerson(Collections.singletonList(personId));
        List models = currentAttPerson.getAttendPersonCurrModels();
        if (CollectionUtils.isNotEmpty((Collection)models)) {
            CmpEmp cmpEmp;
            List cmpEmpList;
            TrialPeriod trialPeriod;
            ContrWorkLoc contrWorkLoc;
            EmpEntRel empEntRel;
            AttendPersonCurrModel currModel = (AttendPersonCurrModel)models.get(0);
            PerTsProp perTsProp = currModel.getPerTsProp();
            if (perTsProp != null) {
                this.getModel().setValue("pertsprophr", (Object)perTsProp.getBid());
            }
            if ((empEntRel = currModel.getEmpEntRel()) != null) {
                this.getModel().setValue("empentrelhr", (Object)empEntRel.getBid());
            }
            if ((contrWorkLoc = currModel.getContrWorkLoc()) != null) {
                this.getModel().setValue("contrworklochr", (Object)contrWorkLoc.getBid());
            }
            if ((trialPeriod = currModel.getTrialPeriod()) != null) {
                this.getModel().setValue("trialperiodhr", (Object)trialPeriod.getBid());
            }
            if (CollectionUtils.isNotEmpty((Collection)(cmpEmpList = currModel.getCmpEmpList())) && (cmpEmp = (CmpEmp)cmpEmpList.stream().filter(Objects::nonNull).max(Comparator.comparing(CmpEmp::getStartDate)).orElse(null)) != null) {
                this.getModel().setValue("managescopehr", (Object)cmpEmp.getBid());
            }
        }
        this.initFertilityInfoData(personId, hrpimService);
    }

    private void initFertilityInfoData(long personId, HRPIMServiceImpl hrpimService) {
        List fertilityInfo = hrpimService.listBatchPersonAttachs(Collections.singletonList(personId), null, "hrpi_fertilityinfo");
        Map<Long, List<Map>> allFertilityInfoToMap = fertilityInfo.stream().filter(info -> info.get("person_id") != null).collect(Collectors.groupingBy(info -> (Long)info.get("person_id")));
        List<Map> maps = allFertilityInfoToMap.get(personId);
        if (maps == null) {
            maps = Collections.singletonList(Maps.newHashMapWithExpectedSize((int)1));
        } else {
            maps.sort(Comparator.comparing(map -> map.get("birthday") == null ? WTCDateUtils.getMinEndDate() : (Date)map.get("birthday"), Comparator.reverseOrder()));
        }
        Container mainFlex = (Container)this.getControl("fs_baseinfo2");
        ArrayList flexList = Lists.newArrayListWithCapacity((int)10);
        for (int i = 0; i < maps.size(); ++i) {
            FlexPanelAp container = this.createFlexPanelAp(i);
            flexList.add(container.createControl());
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wtp_attendpersonfertility");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("cardcontentflex" + i);
            parameter.setCustomParam("fertilitydata", (Object)JSON.toJSONString((Object)maps.get(i)));
            parameter.setCustomParam("index", (Object)(i + 1));
            this.getView().showForm(parameter);
        }
        mainFlex.addControls((List)flexList);
    }

    private FlexPanelAp createFlexPanelAp(int num) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("cardcontentflex" + num);
        flexPanelAp.setDirection("row");
        flexPanelAp.setAlignItems("center");
        flexPanelAp.setShrink(0);
        return flexPanelAp;
    }

    private void hideFlexByPermission(Object depEmpJobIdObj, long personId, long managescopeId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean hasPersonPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_attendperson", (String)"47150e89000000ac");
        if (!hasPersonPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo1", "fs_baseinfo11", "fs_baseinfo12", "fs_baseinfo", "fs_baseinfo2"});
        } else {
            this.getModel().setValue("attendperson", (Object)personId);
        }
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_depempjob", (String)"47150e89000000ac");
        if (!hasPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo1211"});
        } else {
            this.getModel().setValue("depempjob", depEmpJobIdObj);
        }
        boolean mHasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_managescope", (String)"47150e89000000ac");
        if (!mHasPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo121"});
        } else {
            this.getModel().setValue("managescope", (Object)managescopeId);
        }
        boolean hasOtherInfoPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_attperotherinfo", (String)"47150e89000000ac");
        if (!hasOtherInfoPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attperotherinfoflex"});
        } else {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attperotherinfo");
            QFilter qFilter = new QFilter("person", "=", (Object)personId);
            DynamicObject attPersonOtherInfoDy = helper.queryOriginalOne("qtfirsteffectdate", qFilter);
            if (attPersonOtherInfoDy != null) {
                this.getModel().setValue("qtfirsteffectdate", attPersonOtherInfoDy.get("qtfirsteffectdate"));
            }
        }
    }
}

