/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.util.WTCOrgUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.predata.hbss.PreDataOtClassify;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileCoreDataService;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileBaseAdjustPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AttFileBaseAdjustPlugin.class);
    private static final String FLAG_ORG = "org";
    public static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl(FLAG_ORG);
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button button = (Button)this.getView().getControl(BTN_OK);
        button.addClickListener((ClickListener)this);
        BasedataEdit positionBaseDataEdit = (BasedataEdit)this.getView().getControl("position");
        if (!HRObjectUtils.isEmpty((Object)positionBaseDataEdit)) {
            positionBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit depEmpBaseDataEdit = (BasedataEdit)this.getView().getControl("depempf7");
        depEmpBaseDataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            DynamicObject fileDy;
            Object selectAttFileVersionId = customParams.get("selectattfileversionid");
            if (selectAttFileVersionId != null && (fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("org, person, employee, bsed, bsled, id, boid", selectAttFileVersionId)) != null) {
                this.getModel().setValue("person", fileDy.get("person"));
                this.getModel().setValue("employee", fileDy.get("employee"));
                this.getModel().setValue("startdate", (Object)fileDy.getDate("bsed"));
                this.getModel().setValue("enddate", (Object)fileDy.getDate("bsled"));
                this.getPageCache().put("attfileid", String.valueOf(fileDy.getLong("boid")));
                this.getPageCache().put("attfilevid", String.valueOf(fileDy.getLong("id")));
            }
            boolean isReviseOrg = selectAttFileVersionId == null;
            this.getView().setVisible(Boolean.valueOf(isReviseOrg), new String[]{FLAG_ORG, "orgtipsflex"});
            this.getView().setVisible(Boolean.valueOf(!isReviseOrg), new String[]{"position", "adminorgtipsflex"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Long boId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_boid");
        String name = evt.getProperty().getName();
        if (FLAG_ORG.equals(name)) {
            HashSet filterIdSet = Sets.newHashSetWithExpectedSize((int)16);
            AttFileQueryServiceImpl instance = AttFileQueryServiceImpl.getInstance();
            DynamicObject dy = instance.queryOneAttFile("org.id", (Object)boId);
            if (null != dy) {
                Long orgId = dy.getLong("org.id");
                filterIdSet.add(orgId);
            }
            List allPermOrgs = WTCOrgUtils.getAllPermOrgs((String)"wtp_attfilebase", (String)"wtam");
            if (!CollectionUtils.isEmpty((Collection)filterIdSet)) {
                QFilter filter = new QFilter("id", "not in", (Object)filterIdSet);
                filter.and(new QFilter("id", "in", (Object)allPermOrgs));
                evt.addCustomQFilter(filter);
            }
        } else if (HRStringUtils.equals((String)"position", (String)name) && "click".equals(evt.getSourceMethod()) && !evt.isCancel()) {
            evt.setCancel(true);
            BasedataEdit depempF7BaseDataEdit = (BasedataEdit)this.getView().getControl("depempf7");
            depempF7BaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            depempF7BaseDataEdit.click();
        } else if (HRStringUtils.equals((String)"depempf7", (String)name) && "click".equals(evt.getSourceMethod())) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            long personId = dataEntity.getLong("person.id");
            if (personId == 0L) {
                return;
            }
            QFilter personEqual = new QFilter("person", "=", (Object)personId);
            if (dataEntity.getLong("employee.id") != 0L) {
                QFilter employeeEqual = new QFilter("employee", "=", (Object)dataEntity.getLong("employee.id"));
                personEqual.and(employeeEqual);
            }
            personEqual.and(new QFilter("otclassify", "=", (Object)PreDataOtClassify.OTCLASSIFY_ADMINORG));
            QFilter dataRuleForBdProp = HRAuthService.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), "wtam", "wtp_attfilebase", "depemp", "47150e89000000ac", null);
            personEqual.and(dataRuleForBdProp);
            QFilter dateQFilter = new QFilter("hrpi_empposorgrel.startdate", "<=", (Object)this.getModel().getDataEntity().getDate("startdate"));
            dateQFilter.and(new QFilter("hrpi_empposorgrel.enddate", ">=", (Object)this.getModel().getDataEntity().getDate("enddate")));
            personEqual.and(dateQFilter);
            evt.addCustomQFilter(personEqual);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        FileSaveDto fileSaveDto;
        Map dtoMap;
        long personId = this.getModel().getDataEntity().getLong("person.id");
        long employeeId = this.getModel().getDataEntity().getLong("employee.id");
        ListSelectedRow listSelectedRow = afterF7SelectEvent.getListSelectedRow();
        Object depEmpId = listSelectedRow.getPrimaryKeyValue();
        List allEmpPosOrgRelDys = HRPIMServiceImpl.getInstance().listIntersectBusinessInfo("hrpi_empposorgrel", "id,person,depemp,startdate,enddate,isprimary", WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), Collections.singletonList(personId), Collections.singletonList(employeeId), null);
        List primaryEmpPosOrgRelDys = allEmpPosOrgRelDys.stream().filter(dy -> dy.getBoolean("isprimary") && ((Long)depEmpId).longValue() == dy.getLong("depemp.id")).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(primaryEmpPosOrgRelDys) && WTCCollections.isNotEmpty((Map)(dtoMap = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds(Collections.singletonList((Long)((DynamicObject)primaryEmpPosOrgRelDys.get(0)).getPkValue())))) && (fileSaveDto = (FileSaveDto)dtoMap.get(depEmpId)) != null) {
            Map map = this.getPageCache().getAll();
            fileSaveDto.setId(Long.valueOf((String)map.get("attfilevid")));
            fileSaveDto.setBoId(Long.valueOf((String)map.get("attfileid")));
            IPageCache pageCache = this.getPageCache();
            pageCache.put("fileCoreDataVo", SerializationUtils.toJsonString((Object)fileSaveDto));
            this.getModel().setValue("position", (Object)fileSaveDto.getPositionId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (BTN_OK.equals(key) && !this.checkAuth()) {
            args.setCancel(true);
            return;
        }
        Long boId = (Long)this.getView().getFormShowParameter().getCustomParam("cache_boid");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put(String.valueOf(boId), String.valueOf(boId));
        formOperate.getOption().getVariables().putAll(map);
        formOperate.getOption().setVariableValue("op_org_variables", String.valueOf(boId));
        Object customParam = this.getView().getFormShowParameter().getCustomParam("selectattfileversionid");
        if (customParam != null) {
            this.checkAdminOrgBsedBeforeFileVersionBsed(args, formOperate);
        }
    }

    private void checkAdminOrgBsedBeforeFileVersionBsed(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        if (this.getModel().getDataEntity().get("position") == null) {
            this.getView().showErrorNotification(AttFileKDString.getPositionEmptyTips());
            args.setCancel(true);
            return;
        }
        Object selectAttFileVersionId = this.getView().getFormShowParameter().getCustomParam("selectattfileversionid");
        if (selectAttFileVersionId != null) {
            formOperate.getOption().setVariableValue("isReviseOrg", "false");
            formOperate.getOption().setVariableValue("selectattfileversionid", String.valueOf(selectAttFileVersionId));
            DynamicObject existsFileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("bsed, bsled", selectAttFileVersionId);
            if (existsFileDy != null) {
                Date bsed = existsFileDy.getDate("bsed");
                String fileCoreDataVoStr = this.getPageCache().get("fileCoreDataVo");
                if (HRStringUtils.isNotEmpty((String)fileCoreDataVoStr)) {
                    FileSaveDto fileSaveDto = (FileSaveDto)SerializationUtils.fromJsonString((String)fileCoreDataVoStr, FileSaveDto.class);
                    Date adminOrgBsed = fileSaveDto.getEmpStartDate();
                    if (bsed != null && adminOrgBsed != null && adminOrgBsed.compareTo(bsed) > 0) {
                        this.getView().showTipNotification(AttFileKDString.getAdminOrgReviseStartDateTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsed)));
                        args.setCancel(true);
                        return;
                    }
                    Date bsled = existsFileDy.getDate("bsed");
                    Date empEndDate = fileSaveDto.getEmpEndDate();
                    if (bsled != null && empEndDate != null && empEndDate.compareTo(bsled) < 0) {
                        this.getView().showTipNotification(AttFileKDString.getAdminOrgReviseEndDateDateTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsled)));
                        args.setCancel(true);
                        return;
                    }
                }
            }
            formOperate.getOption().setVariableValue("fileCoreDataVo", this.getPageCache().get("fileCoreDataVo"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "btnok": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                AttFileServiceImpl attFileService = AttFileServiceImpl.getInstance();
                Long attFileIdLong = (Long)this.getView().getFormShowParameter().getCustomParam("cache_boid");
                HRBaseServiceHelper fileService = new HRBaseServiceHelper("wtp_attfilebase");
                DynamicObject file = fileService.queryOriginalOne("empposorgrel.id", (Object)attFileIdLong);
                IFormView view = this.getView().getParentView().getParentView().getParentView();
                if (null != file) {
                    attFileService.openFileHeader(view, Long.valueOf(file.getLong("empposorgrel.id")), attFileIdLong, "personheader");
                }
                this.getView().sendFormAction(view);
                this.getView().getParentView().updateView();
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkAuth() {
        String cacheType = (String)this.getView().getFormShowParameter().getCustomParam("cache_type");
        String appId = this.getView().getFormShowParameter().getAppId();
        switch (cacheType) {
            case "revisefile": {
                boolean hasPerm1 = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_attfilebase", (String)"0NXNH9TN69JH");
                LOG.info("\u4fee\u8ba2\u662f\u5426\u6709\u6743\u9650:{}", (Object)hasPerm1);
                if (!hasPerm1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u201c\u4fee\u8ba2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileBaseAdjustPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    return false;
                }
                return true;
            }
            case "adjust": {
                boolean hasPerm2 = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"wtp_attfilebaseadjust", (String)"0A3J+YT5CUD4");
                LOG.info("\u8c03\u6574\u662f\u5426\u6709\u6743\u9650:{}", (Object)hasPerm2);
                if (!hasPerm2) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8003\u52e4\u6863\u6848\u201d\u7684\u201c\u8c03\u6574\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileBaseAdjustPlugin_8", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

