/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.predata.hbss.PreDataBizType;
import kd.wtc.wtbs.common.predata.hbss.PreDataObjectType;
import kd.wtc.wtbs.common.predata.hbss.PreDataOtClassify;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCPageCache;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileCoreDataService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.coordination.helper.CoordinationHelper;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.model.file.FileCoreDataVo;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileBaseCoreDataEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AttFileConstants {
    private static Log LOGGER = LogFactory.getLog(AttFileBaseCoreDataEdit.class);

    public void registerListener(EventObject evt) {
        String formId;
        super.registerListener(evt);
        BasedataEdit positionBaseDataEdit = (BasedataEdit)this.getView().getControl("position");
        if (!HRObjectUtils.isEmpty((Object)positionBaseDataEdit)) {
            positionBaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (HRStringUtils.isNotEmpty((String)(formId = this.getView().getFormShowParameter().getFormId())) && formId.startsWith("wtp_attfilemodify")) {
            for (IDataEntityProperty property : this.getModel().getDataEntity().getDataEntityType().getProperties()) {
                Control control = this.getView().getControl(property.getName());
                if (!(control instanceof BasedataEdit)) continue;
                ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        long personId = this.getModel().getDataEntity().getLong("person.id");
        if (0L != personId) {
            long employee = this.getModel().getDataEntity().getLong("employee.id");
            this.initPersonAndDepempIdMap(personId, employee);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperateOption option = source.getOption();
        if ("save".equals(operateKey)) {
            Object confirmResult;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (dataEntity.getDynamicObject("empposorgrel") == null) {
                long personId = this.getModel().getDataEntity().getLong("person.id");
                FileCoreDataVo cacheFileCoreDataVo = this.getCacheFileCoreDataVo();
                Long depempId = (Long)cacheFileCoreDataVo.getPersonToDepempIdMap().get(personId);
                FileSaveDto fileSaveDto = (FileSaveDto)cacheFileCoreDataVo.getDepempToFileCoreDataVo().get(depempId);
                if (fileSaveDto != null) {
                    HRBaseServiceHelper affiliateAdminOrgHelper = new HRBaseServiceHelper("wtp_depempjob");
                    DynamicObject dy = affiliateAdminOrgHelper.generateEmptyDynamicObject();
                    dy.set("id", (Object)fileSaveDto.getEmpPosOrgRelId());
                    this.getModel().getDataEntity().set("empposorgrel", (Object)dy);
                }
            }
            if ("confirmresult".equals(confirmResult = this.getView().getFormShowParameter().getCustomParam("confirmresult"))) {
                this.getView().getFormShowParameter().setCustomParam("confirmresult", null);
                option.setVariableValue("fileCoreDataVo", new WTCPageCache(this.getView()).get("fileCoreDataVo"));
                return;
            }
            AttFileCheckService checkInstance = AttFileCheckService.getInstance();
            Map msgSetMap = checkInstance.checkAddAttFile(this.getCacheFileCoreDataVo().getDepempToFileCoreDataVo(), Collections.singletonList(this.getModel().getDataEntity()), true);
            Set collectMsg = msgSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(collectMsg) && collectMsg.size() == 1 && collectMsg.contains("showNewConfirm")) {
                Date startDate = this.getModel().getDataEntity().getDate("startdate");
                String preDayStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)HRDateTimeUtils.addDay((Date)startDate, (long)-1L));
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u8be5\u4eba\u5458\u5728\u5176\u4ed6\u8003\u52e4\u7ec4\u7ec7\u5df2\u5b58\u5728\u6863\u6848\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u7ec8\u6b62\u8be5\u6863\u6848\uff0c\u5e76\u8d4b\u4e88\u7ed3\u675f\u65e5\u671f{0}\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AttFileBaseCoreDataEdit_3", (String)"wtc-wtp-formplugin", (Object[])new Object[]{preDayStr});
                this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("savefile", (IFormPlugin)this), null, String.valueOf(this.getView().getModel().getValue("person_id")));
            }
            option.setVariableValue("fileCoreDataVo", new WTCPageCache(this.getView()).get("fileCoreDataVo"));
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        IDataEntityProperty property = propertyChangedArgs.getProperty();
        String name = property.getName();
        AttFileHelper.setIsManaged((String)name, (IDataModel)this.getModel());
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject fileDataEntity = this.getModel().getDataEntity();
        switch (name) {
            case "selectperson": {
                if (!CertService.checkEfftive((ChangeData)changeData, (IFormView)this.getView(), (IDataModel)this.getModel())) break;
                if (this.getView().getPageCache().get("selectperson") != null) {
                    this.getView().getPageCache().remove("selectperson");
                    break;
                }
                this.personChangeTips(changeData);
                break;
            }
            case "depempf7": {
                DynamicObject dynamicObject = fileDataEntity.getDynamicObject("depempf7");
                long depempId = dynamicObject.getLong("id");
                this.initFileDyAndUpdateView(fileDataEntity, depempId, true);
                break;
            }
            case "startdate": {
                Date startDate = fileDataEntity.getDate("startdate");
                Date bsedDate = fileDataEntity.getDate("bsed");
                if (startDate == null || bsedDate == null || startDate.getTime() == bsedDate.getTime()) break;
                this.getModel().setValue("bsed", (Object)startDate);
                break;
            }
        }
        this.getView().getPageCache().remove("adminorg");
    }

    private void personDataChange(DynamicObject fileDataEntity, long oldValue) {
        DynamicObject selectPersonDy = fileDataEntity.getDynamicObject("selectperson");
        if (selectPersonDy != null) {
            boolean checkFlag;
            long personId = selectPersonDy.getLong("person_id");
            long employeeId = selectPersonDy.getLong("id");
            this.initPersonAndDepempIdMap(personId, employeeId);
            Long depempId = (Long)this.getCacheFileCoreDataVo().getPersonToDepempIdMap().get(personId);
            String personNumber = fileDataEntity.getString("person.number");
            if (HRStringUtils.isEmpty((String)personNumber) && fileDataEntity.getDynamicObject("selectperson") != null) {
                personNumber = fileDataEntity.getDynamicObject("selectperson").getString("person.number");
            }
            boolean bl = checkFlag = HRStringUtils.isNotEmpty((String)personNumber) && Boolean.TRUE.equals(this.getView().getModel().getValue("saveschedule"));
            if (checkFlag && this.getView().getControl("card") != null) {
                this.getModel().setValue("card", (Object)personNumber);
            }
            this.initFileDyAndUpdateView(fileDataEntity, depempId, oldValue, false, false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageResult = messageBoxClosedEvent.getResult();
        if ("selectperson".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageResult)) {
                this.personDataChange(this.getModel().getDataEntity(), Long.parseLong(messageBoxClosedEvent.getCustomVaule()));
            } else {
                this.reSetAttPersonId(Long.parseLong(messageBoxClosedEvent.getCustomVaule()));
                this.getView().updateView();
            }
        } else if ("savefile".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageResult)) {
            this.getView().getFormShowParameter().setCustomParam("confirmresult", (Object)"confirmresult");
            this.getView().invokeOperation("save");
        } else if ("changeToFirstEmp".equals(callBackId)) {
            Long depempId;
            DynamicObject fileDataEntity = this.getModel().getDataEntity();
            if (MessageBoxResult.Yes.equals((Object)messageResult)) {
                FileCoreDataVo fileCoreDataVo = (FileCoreDataVo)new WTCPageCache(this.getView()).get("fileCoreDataVo", FileCoreDataVo.class);
                depempId = (Long)((Map)fileCoreDataVo.getDepempList().get(0)).get("depemp.id");
                HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_depemp");
                DynamicObject dy = helper.generateEmptyDynamicObject();
                dy.set("id", (Object)depempId);
                fileDataEntity.set("depempf7", (Object)dy);
            } else {
                DynamicObject dynamicObject = fileDataEntity.getDynamicObject("depempf7");
                depempId = dynamicObject.getLong("id");
            }
            this.initFileDyAndUpdateView(fileDataEntity, depempId, false);
        }
    }

    private void personChangeTips(ChangeData changeData) {
        if (changeData.getNewValue() != null) {
            if (changeData.getOldValue() != null) {
                String msg = ResManager.loadKDString((String)"\u66f4\u6539\u4eba\u5458\uff0c\u4f1a\u91cd\u65b0\u8d4b\u503c\u201c\u5c97\u4f4d\u201d\u3001\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3001\u201c\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u201d\u3001\u201c\u6863\u6848\u5f00\u59cb\u65e5\u671f\u201d\u53ca\u201c\u6302\u9760\u884c\u653f\u7ec4\u7ec7\u201d\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"AttFileBaseCoreDataEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                DynamicObject oldDy = (DynamicObject)changeData.getOldValue();
                this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("selectperson", (IFormPlugin)this), null, oldDy.getString("id"));
            } else {
                this.personDataChange(this.getModel().getDataEntity(), 0L);
            }
        }
    }

    private void initFileDyAndUpdateView(DynamicObject fileDataEntity, Long depempId, boolean validateDepemp) {
        this.initFileDyAndUpdateView(fileDataEntity, depempId, null, true, validateDepemp);
    }

    private void initFileDyAndUpdateView(DynamicObject fileDataEntity, Long depempId, Long oldValue, boolean isDepEmpChange, boolean validateDepemp) {
        FileSaveDto fileSaveDto;
        long employeeId;
        if (depempId == null || 0L == depempId) {
            if (oldValue != null) {
                this.reSetAttPersonId(oldValue);
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4eba\u5458\u6216\u5c97\u4f4d\u3002", (String)"AttFileBaseCoreDataEdit_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        FileCoreDataVo cacheFileCoreDataVo = this.getCacheFileCoreDataVo();
        long l = employeeId = this.getModel().getDataEntityType().getProperties().containsKey((Object)"selectperson") ? WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileDataEntity, (String)"selectperson") : WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileDataEntity, (String)"employee");
        if (isDepEmpChange && validateDepemp && !this.validateEmpIsFirst(employeeId, depempId)) {
            return;
        }
        if (!isDepEmpChange && !this.isAttFileAlreadyExists(employeeId)) {
            List depEmpList = cacheFileCoreDataVo.getDepempList();
            depempId = (Long)WTCCollectionIndexUtil.getEleFromList((List)depEmpList, (int)0).map(ele -> ele.get("depemp.id")).filter(tempDepEmpId -> tempDepEmpId instanceof Long).orElse(depempId);
        }
        if ((fileSaveDto = (FileSaveDto)cacheFileCoreDataVo.getDepempToFileCoreDataVo().get(depempId)) == null) {
            if (oldValue != null) {
                this.reSetAttPersonId(oldValue);
            }
            LOGGER.info("initFileDyAndUpdateView getFileSaveDto is null");
            return;
        }
        AttFileCoreDataService.getInstance().initFileByFileSaveDto(fileSaveDto, fileDataEntity, this.getModel());
        String formId = this.getView().getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"wtp_attfilebase", (String)formId)) {
            this.setOrgByEmpPosOrgRel(fileSaveDto);
        }
        this.getView().updateView();
        AttFileCheckService checkInstance = AttFileCheckService.getInstance();
        checkInstance.setOperateCheck(Boolean.FALSE);
        Map msgSetMap = checkInstance.checkAddAttFile(cacheFileCoreDataVo.getDepempToFileCoreDataVo(), Collections.singletonList(fileDataEntity), true);
        this.showFileErrMsg(msgSetMap);
    }

    private void setOrgByEmpPosOrgRel(FileSaveDto fileSaveDto) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org");
        Long orgId = this.getOrgIdByEmpPosOrgRel(fileSaveDto.getAdminOrgId());
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("org", null);
            return;
        }
        HasPermOrgResult allPermOrgs = WTCBizDataPermissionServiceImpl.getInstance().getAllPermOrgs("wtam", "wtp_attfilebase");
        if (allPermOrgs.hasAllOrgPerm() || allPermOrgs.getHasPermOrgs().contains(orgId)) {
            DynamicObject bosOrgDy = helper.generateEmptyDynamicObject();
            bosOrgDy.set("id", (Object)orgId);
            this.getModel().setValue("org", (Object)bosOrgDy);
        } else {
            DynamicObject dy = helper.queryOne("name", (Object)orgId);
            if (dy != null) {
                String tips = ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u83b7\u53d6\u5230\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u201c%s\u201d\uff0c\u56e0\u65e0\u6743\u9650\u65e0\u6cd5\u586b\u5165", (String)"AttFileBaseCoreDataEdit_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tips, dy.getString("name")));
            }
        }
    }

    private Long getOrgIdByEmpPosOrgRel(Long adminOrgId) {
        Set<Long> attMgrSet = Collections.singleton(PreDataBizType.PD_104010L);
        HashMap newOrgIdBusinessTypeMap = Maps.newHashMapWithExpectedSize((int)1);
        newOrgIdBusinessTypeMap.put(adminOrgId, attMgrSet);
        List newStrategyMap = CoordinationHelper.getInstance().invokeHRMPIHRCSStrategyService((Map)newOrgIdBusinessTypeMap, PreDataObjectType.PD_1010L);
        if (WTCCollections.isEmpty((Collection)newStrategyMap) || newStrategyMap.size() > 1) {
            return null;
        }
        Long orgId = (Long)((Map)newStrategyMap.get(0)).get("hrBuId");
        if (orgId == null || orgId == 0L) {
            return null;
        }
        return orgId;
    }

    private boolean validateEmpIsFirst(long employeeId, Long depempId) {
        FileCoreDataVo fileCoreDataVo = (FileCoreDataVo)new WTCPageCache(this.getView()).get("fileCoreDataVo", FileCoreDataVo.class);
        List depempList = fileCoreDataVo.getDepempList();
        if (depempList == null || depempList.size() <= 1) {
            return true;
        }
        if (this.isAttFileAlreadyExists(employeeId)) {
            return true;
        }
        Map firstDepempMap = (Map)depempList.get(0);
        if (!depempId.equals(firstDepempMap.get("depemp.id"))) {
            FileSaveDto fileSaveDto = (FileSaveDto)fileCoreDataVo.getDepempToFileCoreDataVo().get(depempId);
            String startDate = String.valueOf(firstDepempMap.get("startdate"));
            String endDate = fileCoreDataVo.getDepempList().stream().filter(map -> depempId.equals(map.get("depemp.id"))).map(map -> String.valueOf(map.get("startdate"))).findFirst().orElse("");
            try {
                startDate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.parseDate((String)endDate, (String)"yyyy-MM-dd"));
                endDate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)WTCDateUtils.getBeforeDate((Date)WTCDateUtils.parseDate((String)endDate, (String)"yyyy-MM-dd")));
            }
            catch (ParseException exception) {
                LOGGER.info("parseDate error :{}", (Object)exception);
            }
            String kdString = ResManager.loadKDString((String)"%1$s\u7684\u5165\u804c\u65e5\u671f\u4e3a%2$s\uff0c\u6267\u884c\u672c\u6b21\u65b0\u589e\u540e\uff0c\u5c06\u65e0\u6cd5\u518d\u57fa\u4e8e%3$s\u81f3%4$s\u5f00\u5c55\u8003\u52e4\u4e1a\u52a1\uff0c\u5efa\u8bae\u5207\u6362\u81f3\u7b2c1\u6bb5\u4efb\u804c\u7ecf\u5386\u7684\u5c97\u4f4d\u4fe1\u606f\uff08\u5373\u6863\u6848\u5f00\u59cb\u65e5\u671f\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff09\uff0c\u662f\u5426\u5207\u6362?", (String)"AttFileBaseCoreDataEdit_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            String tips = String.format(kdString, fileSaveDto.getPersonName(), startDate, startDate, endDate);
            this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changeToFirstEmp", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    private boolean isAttFileAlreadyExists(long employeeId) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setProperties("id");
        HashSet<Long> set = new HashSet<Long>();
        set.add(employeeId);
        attFileQueryParam.setEmpPersonSetIds(set);
        DynamicObject fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(attFileQueryParam);
        return fileDy != null;
    }

    private void showFileErrMsg(Map<Integer, Set<String>> msgSetMap) {
        if (msgSetMap != null) {
            Set collectMsg = msgSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            collectMsg.remove("showNewConfirm");
            for (String errMsg : collectMsg) {
                this.getView().showErrorNotification(errMsg);
            }
        }
    }

    private void reSetAttPersonId(Long oldValue) {
        this.getView().getPageCache().put("selectperson", "selectperson");
        this.getView().getModel().setValue("selectperson", (Object)oldValue);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter dataRuleForBdProp;
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"position", (String)name) && "click".equals(beforeF7SelectEvent.getSourceMethod()) && !beforeF7SelectEvent.isCancel()) {
            beforeF7SelectEvent.setCancel(true);
            DynamicObject selectPersonDy = this.getModel().getDataEntity().getDynamicObject("person");
            if (selectPersonDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8003\u52e4\u4eba\u5458\u3002", (String)"AttFileBaseCoreDataEdit_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                return;
            }
            BasedataEdit depempF7BaseDataEdit = (BasedataEdit)this.getView().getControl("depempf7");
            depempF7BaseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            depempF7BaseDataEdit.click();
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        String appId = formShowParameter.getAppId();
        if (HRStringUtils.equals((String)"depempf7", (String)name) && "click".equals(beforeF7SelectEvent.getSourceMethod())) {
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            long personId = dataEntity.getLong("person.id");
            if (personId == 0L) {
                return;
            }
            QFilter personEqual = new QFilter("person", "=", (Object)personId);
            if (dataEntity.getLong("employee.id") != 0L) {
                QFilter employeeEqual = new QFilter("employee", "=", (Object)dataEntity.getLong("employee.id"));
                personEqual.and(employeeEqual);
            }
            personEqual.and(new QFilter("otclassify", "=", (Object)PreDataOtClassify.OTCLASSIFY_ADMINORG));
            QFilter dataRuleForBdProp2 = HRAuthService.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), appId, formId, "depemp", "47150e89000000ac", null);
            personEqual.and(dataRuleForBdProp2);
            beforeF7SelectEvent.addCustomQFilter(personEqual);
        }
        if (!WtbsBusinessUtils.isSuperUser() && (dataRuleForBdProp = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), appId, "wtp_attfilebase", name, "47150e89000000ac", null)) != null) {
            beforeF7SelectEvent.addCustomQFilter(dataRuleForBdProp);
            if ("affiliateadminorg".equals(name)) {
                AuthorizedOrgResultWithSub authorizedAdminOrgsWithSub = HRCSMServiceImpl.getInstance().getAuthorizedAdminOrgsWithSub(Long.valueOf(RequestContext.get().getCurrUserId()), appId, "wtp_attfilebase", "47150e89000000ac", name);
                new PageCache(beforeF7SelectEvent.getFormShowParameter().getPageId()).put("perm_org_result_withsub", SerializationUtils.toJsonString((Object)authorizedAdminOrgsWithSub));
            }
        }
    }

    private void initPersonAndDepempIdMap(long personId, long employeeId) {
        List dynamicObjects = HRPIMServiceImpl.getInstance().listIntersectBusinessInfo("hrpi_empposorgrel", "id,person,depemp,startdate,enddate,isprimary", WTCHisServiceHelper.getMinEndDate(), WTCHisServiceHelper.getMaxEndDate(), Collections.singletonList(personId), Collections.singletonList(employeeId), null);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = formShowParameter.getFormId();
        String appId = formShowParameter.getAppId();
        QFilter depempQFilter = new QFilter("id", "!=", (Object)0L);
        QFilter dataRuleForBdProp = HRAuthService.getInstance().getDataRuleForBdProp(Long.valueOf(RequestContext.get().getCurrUserId()), appId, formId, "depemp", "47150e89000000ac", null);
        if (dataRuleForBdProp != null) {
            depempQFilter.and(dataRuleForBdProp);
        }
        depempQFilter.and(new QFilter("person.id", "=", (Object)personId));
        DynamicObject[] depempDyArr = HRPIMServiceImpl.getInstance().listFieldsFilterInfo("boid", depempQFilter, "hrpi_depemp");
        Set depempBoIdSet = Arrays.stream(depempDyArr).map(item -> item.getLong("boid")).collect(Collectors.toSet());
        List sortList = dynamicObjects.stream().filter(dy -> dy.getBoolean("isprimary") && depempBoIdSet.contains(dy.getLong("depemp.id"))).sorted(Comparator.comparing(d -> d.getDate("startdate"))).collect(Collectors.toList());
        FileCoreDataVo fileCoreDataVo = new FileCoreDataVo();
        fileCoreDataVo.setDepempToEmpPosOrgRelIdMap(sortList.stream().collect(Collectors.toMap(d -> d.getLong("depemp.id"), d -> d.getLong("id"), (a, b) -> a)));
        fileCoreDataVo.setPersonToDepempIdMap(sortList.stream().collect(Collectors.toMap(d -> d.getLong("person.id"), d -> d.getLong("depemp.id"), (a, b) -> b)));
        List depempList = sortList.stream().map(dy -> {
            HashMap firstDepempMap = Maps.newHashMapWithExpectedSize((int)16);
            firstDepempMap.put("depemp.id", dy.getLong("depemp.id"));
            firstDepempMap.put("startdate", WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dy.getDate("startdate")));
            firstDepempMap.put("enddate", WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)dy.getDate("enddate")));
            return firstDepempMap;
        }).collect(Collectors.toList());
        fileCoreDataVo.setDepempList(depempList);
        this.setDepempToFileCoreDataVo(fileCoreDataVo);
        WTCPageCache wtcPageCache = new WTCPageCache(this.getView());
        wtcPageCache.put("fileCoreDataVo", (Object)fileCoreDataVo);
    }

    private void setDepempToFileCoreDataVo(FileCoreDataVo fileCoreDataVo) {
        ArrayList empPosOrgRelIdList = new ArrayList(fileCoreDataVo.getDepempToEmpPosOrgRelIdMap().values());
        Map fileSaveDtoHashMap = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds(empPosOrgRelIdList);
        fileCoreDataVo.setDepempToFileCoreDataVo(fileSaveDtoHashMap);
    }

    FileCoreDataVo getCacheFileCoreDataVo() {
        WTCPageCache wtcPageCache = new WTCPageCache(this.getView());
        FileCoreDataVo fileCoreDataVo = (FileCoreDataVo)wtcPageCache.get("fileCoreDataVo", FileCoreDataVo.class);
        if (fileCoreDataVo == null) {
            return new FileCoreDataVo();
        }
        return fileCoreDataVo;
    }
}

