/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileDiscardCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.enums.FileCheckBusDataEnum;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileBaseDiscardConfirmMPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(AttFileBaseDiscardConfirmMPlugin.class);
    public static final String DISCARD_ENTRY_ENTITY = "discardentity";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Button btnOk = (Button)this.getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(DISCARD_ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"dropdown", "retract"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.getView().returnDataToParent((Object)"success");
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            Label label = (Label)source;
            String key = label.getKey();
            if ("dropdown".equals(key)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"retract"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"dropdown", "guidetipsflex"});
            } else if ("retract".equals(key)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"dropdown", "guidetipsflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"retract"});
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        this.setTabDetail();
    }

    private void setTabDetail() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        this.initDiscardPageTopTips(formShowParameter);
        this.initDiscardPageBottomTips(formShowParameter);
        this.initDiscardEntryEntity(formShowParameter);
    }

    private void initDiscardPageBottomTips(FormShowParameter formShowParameter) {
        long rollbackId = Long.parseLong((String)formShowParameter.getCustomParam("coordinationType"));
        if (rollbackId == 0L) {
            List warnMsgs = (List)formShowParameter.getCustomParam("warntext");
            StringBuilder str = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)warnMsgs)) {
                int index = 1;
                long count = warnMsgs.stream().filter("\n"::equals).count();
                for (String msg : warnMsgs) {
                    if (!"\n".equals(msg) && count >= 2L) {
                        str.append(index).append("\u3001");
                        ++index;
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"dropdown"});
                    }
                    str.append(msg);
                }
                Label label = (Label)this.getView().getControl("guidetips");
                label.setText(str.toString());
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bottomtipsflex"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bottomtipsflex"});
        }
    }

    private void initDiscardPageTopTips(FormShowParameter formShowParameter) {
        String text = null;
        String personName = (String)formShowParameter.getCustomParam("person.name");
        long rollbackId = Long.parseLong((String)formShowParameter.getCustomParam("coordinationType"));
        if (1210L == rollbackId) {
            Object customParam = formShowParameter.getCustomParam("discard_bo");
            HashSet discardFileSet = new HashSet();
            if (customParam != null) {
                discardFileSet.addAll(((JSONArray)customParam).toJavaList(Long.class));
            }
            text = AttFileHelper.getDiscardPageTopTipsByCoordination((Long)((Long)formShowParameter.getCustomParam("person.id")), (String)personName, (String)"M", discardFileSet);
        } else {
            String number = (String)formShowParameter.getCustomParam("number");
            text = AttFileKDString.discardNormalAttBase1((String)personName, (String)number);
            List warnMsgs = (List)formShowParameter.getCustomParam("toptipssupple");
            if (WTCCollections.isNotEmpty((Collection)warnMsgs)) {
                text = WTCStringUtils.joinStr((String[])new String[]{text, WTCStringUtils.join((List)warnMsgs, (String)"")});
            }
        }
        Label labelap3 = (Label)this.getView().getControl("labelap11");
        labelap3.setText(text);
    }

    private void initDiscardEntryEntity(FormShowParameter formShowParameter) {
        Map checkDataMap = (Map)formShowParameter.getCustomParam("checkDataMap");
        if (WTCCollections.isEmpty((Map)checkDataMap)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap6"});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(DISCARD_ENTRY_ENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int i = 0;
        for (FileCheckBusDataEnum value : FileCheckBusDataEnum.values()) {
            Integer size = (Integer)checkDataMap.get(value.getKey());
            if (size == null || size <= 0) continue;
            TableValueSetter tableValueSetter = vs.addRow(new Object[0]);
            tableValueSetter.set("checkbustype", (Object)value.getKey(), i);
            tableValueSetter.set("businessdatatype", (Object)value.getDescription(), i);
            tableValueSetter.set("counts", (Object)size, i);
            tableValueSetter.set("handleway", (Object)value.getHandleWay(), i);
            ++i;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(DISCARD_ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(DISCARD_ENTRY_ENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("counts".equals(fieldName)) {
            String checkBusType;
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject entryIndexDy = (DynamicObject)this.getModel().getEntryEntity(DISCARD_ENTRY_ENTITY).get(rowIndex);
            if (entryIndexDy != null && WTCStringUtils.isNotEmpty((String)(checkBusType = entryIndexDy.getString("checkbustype")))) {
                List boIdList = (List)this.getView().getFormShowParameter().getCustomParam("discard_bo");
                AttFileDiscardCheckService.getInstance().checkDataHyperLinkClick((Object)checkBusType, this.getView(), boIdList);
            }
        }
    }
}

