/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileDiscardCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileBaseDiscardList
extends HRDataBaseList {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.isLookUp()) {
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("discard".equals(opKey)) {
            if (!"btnok".equals(this.getView().getPageCache().get("discard"))) {
                this.discardOpCheck(args);
            } else {
                this.getView().getPageCache().remove("discard");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillList billListAp;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if ("discard".equals(opKey) && (billListAp = (BillList)this.getView().getControl("billlistap")) != null) {
            billListAp.clearSelection();
            billListAp.refresh();
        }
    }

    private void discardOpCheck(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        ListView view = (ListView)this.getView();
        if (listSelectedData == null || listSelectedData.size() == 0) {
            view.showTipNotification(AttFileKDString.discardNothing());
            args.setCancel(true);
            return;
        }
        if (listSelectedData.size() > 1) {
            view.showTipNotification(AttFileKDString.discardTooMuch());
            args.setCancel(true);
            return;
        }
        ListSelectedRow row = view.getCurrentSelectedRowInfo();
        if (row == null) {
            return;
        }
        Long pkId = (Long)row.getPrimaryKeyValue();
        ArrayList dataEntities = new ArrayList(AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id,boid,person,person.id,person.name,number,employee.id,usablestatus", Collections.singletonList(pkId)));
        HashMap resultMsgMap = Maps.newHashMapWithExpectedSize((int)dataEntities.size());
        HashMap topTipsMsgMap = Maps.newHashMapWithExpectedSize((int)dataEntities.size());
        List<Long> boIdList = dataEntities.stream().map(dy1 -> dy1.getLong("boid")).collect(Collectors.toList());
        for (Long boId : boIdList) {
            resultMsgMap.put(boId, new ArrayList());
            topTipsMsgMap.put(boId, new ArrayList());
        }
        AttFileDiscardCheckService.getInstance().checkAttFileDiscard(dataEntities, (Map)resultMsgMap);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)((Collection)resultMsgMap.get(boIdList.get(0))))) {
            Optional firstElement = ((List)resultMsgMap.get(boIdList.get(0))).stream().findFirst();
            firstElement.ifPresent(arg_0 -> ((ListView)view).showTipNotification(arg_0));
            args.setCancel(true);
            return;
        }
        Map boToLastBoMap = AttFileDiscardCheckService.getInstance().checkAttFileLatestDiscardAuth(dataEntities, (Map)resultMsgMap);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)((Collection)resultMsgMap.get(boIdList.get(0))))) {
            this.showMsgBox(args, view, resultMsgMap, boIdList);
            return;
        }
        AttFileDiscardCheckService.getInstance().checkAttFileVersionAuth(dataEntities, (Map)resultMsgMap);
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)((Collection)resultMsgMap.get(boIdList.get(0))))) {
            this.showMsgBox(args, view, resultMsgMap, boIdList);
            return;
        }
        Map personAttFileMap = dataEntities.stream().collect(Collectors.toMap(d -> d.getLong("boid"), Function.identity(), (a, b) -> b));
        if (boToLastBoMap != null && CollectionUtils.isNotEmpty(boToLastBoMap.values())) {
            AttFileDiscardCheckService.getInstance().samePersonOtherBoProcessNew(boToLastBoMap, personAttFileMap, (Map)resultMsgMap, (Map)topTipsMsgMap);
        }
        AttFileHelper.genShowDiscardConfirmPageByBusinessDataNew(dataEntities, (Map)resultMsgMap, boIdList, (IFormPlugin)this, (IFormView)this.getView(), (long)0L, (Map)topTipsMsgMap);
        args.setCancel(true);
    }

    private void showMsgBox(BeforeDoOperationEventArgs args, ListView view, Map<Long, List<String>> resultMsgMap, List<Long> boIdList) {
        Optional firstElement = resultMsgMap.get(boIdList.get(0)).stream().findFirst();
        firstElement.ifPresent(s -> view.showConfirm(s, MessageBoxOptions.OK));
        args.setCancel(true);
    }

    private boolean isLookUp() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("discard".equals(actionId) && "success".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().getPageCache().put("discard", "btnok");
            this.getView().invokeOperation("discard");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if ("wtp_discardconfirms".equals(event.getCallBackId()) && MessageBoxResult.Yes == result) {
            this.getView().getPageCache().put("discard", "btnok");
            this.getView().invokeOperation("discard");
        }
    }
}

