/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.web.file.AttFileBusiness;
import kd.wtc.wtbs.business.web.mservice.HRCSMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttendEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.util.WTCGrayscaleUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileHelper;

public class AttFileBaseEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String NOT_SHOW_STR = WTCStringUtils.joinStr((String[])new String[]{"firstbsed", "bsed", "bsled", "cmpemp_id", "employee_id", "depemp_id", "person_id", "enddate", "depempf7_id"});

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit personEdit = (BasedataEdit)this.getView().getControl("selectperson");
        if (!HRObjectUtils.isEmpty((Object)personEdit)) {
            personEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        AttFileHelper.addFileEntrySelectListener((IFormView)this.getView(), (BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject evt) {
        String isAttFileInited;
        super.beforeBindData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long pkId = dataEntity.getLong("id");
        if (OperationStatus.VIEW == status && 0L != pkId) {
            this.getView().close();
            AttFileBusiness.showAttFileDetailForm((IFormView)this.getView(), (IFormPlugin)this, (String)"wtp_attfilebase", (Object)pkId);
            return;
        }
        AttFileHelper.setCardIsMustInput((IDataModel)this.getModel(), (IFormView)this.getView());
        FieldEdit selectFieldEdit = (FieldEdit)this.getView().getControl("selectperson");
        FieldEdit affiliateAdminOrgFieldEdit = (FieldEdit)this.getView().getControl("affiliateadminorg");
        selectFieldEdit.setMustInput(true);
        affiliateAdminOrgFieldEdit.setMustInput(true);
        if (this.getModel().getDataEntity().getLong("employee.id") == 0L) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"depempf7"});
        }
        if (!"true".equals(isAttFileInited = this.getPageCache().get("isAttFileInited")) && OperationStatus.ADDNEW == status) {
            this.getModel().setValue("org", null);
            this.getPageCache().put("isAttFileInited", "true");
        }
        if (!WTCGrayscaleUtils.isFormulaOpen().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fm"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean saveSchedule;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) && !(saveSchedule = this.getModel().getDataEntity().getBoolean("saveschedule")) && this.getView().getControl("card") != null) {
            this.getModel().setValue("card", null);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
            String name = iDataEntityProperty.getName();
            if (!HRStringUtils.isNotEmpty((String)name) || !NOT_SHOW_STR.contains(name)) continue;
            dataEntityState.setBizChanged(i, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        IDataEntityProperty property = propertyChangedArgs.getProperty();
        String name = property.getName();
        AttFileHelper.setIsManaged((String)name, (IDataModel)this.getModel());
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        DynamicObject dataEntity = this.getModel().getDataEntity();
        switch (name) {
            case "mode": {
                AttFileHelper.setCardIsMustInput((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "card": {
                String cardStr = dataEntity.getString("card");
                long personIndexId = dataEntity.getLong("person.personindexid");
                if (!HRStringUtils.isNotEmpty((String)cardStr)) break;
                HashMap paramCard = Maps.newHashMapWithExpectedSize((int)1);
                HashMap cardMustInput = Maps.newHashMapWithExpectedSize((int)1);
                paramCard.put(cardStr, 0L);
                cardMustInput.put(cardStr, AttFileHelper.getCardIsMustInput((String)cardStr));
                HashMap cardPersonIndexIdMap = Maps.newHashMapWithExpectedSize((int)1);
                cardPersonIndexIdMap.put(cardStr, personIndexId);
                String cardMsg = AttFileHelper.checkCardPage((Map)cardPersonIndexIdMap, (Map)paramCard, (Map)cardMustInput, (boolean)true);
                if (!HRStringUtils.isNotEmpty((String)cardMsg)) break;
                this.getView().showTipNotification(cardMsg);
                break;
            }
            case "saveschedule": {
                this.fileScheduleSet();
                break;
            }
            case "org": {
                if (this.getView().getPageCache().get("org") != null) {
                    this.getView().getPageCache().remove("org");
                    break;
                }
                this.orgChangeTips(changeData);
                break;
            }
        }
        this.getView().getPageCache().remove("adminorg");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("org".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                for (AttFilePlanEnum attFilePlanEnum : AttFilePlanEnum.values()) {
                    Control control = this.getView().getControl(attFilePlanEnum.getSign());
                    if (control == null) continue;
                    this.getModel().setValue(attFilePlanEnum.getSign(), null);
                }
                for (AttFilePlanEnum attFilePlanEnum : AttFileScheduleEnum.values()) {
                    this.getModel().setValue(attFilePlanEnum.getKey(), null);
                }
                this.getModel().setValue("atttag", null);
            } else {
                this.getView().getPageCache().put("org", "org");
                this.getView().getModel().setValue("org", (Object)Long.parseLong(messageBoxClosedEvent.getCustomVaule()));
                this.getView().updateView();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        AttFileHelper.setEntryF7QFilter((BeforeF7SelectEvent)beforeF7SelectEvent, (String)name, (IFormView)this.getView(), (DynamicObject)this.getModel().getDataEntity());
        if ("selectperson".equals(name)) {
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"affiliateadminorg");
            this.getView().cacheFormShowParameter();
            QFilter dataRule = HRCSMServiceImpl.getInstance().getDataRuleForBdProp(Long.valueOf(UserServiceHelper.getCurrentUserId()), "wtam", "wtp_attfilebase", "affiliateadminorg", "47150e89000000ac", Collections.emptyMap());
            if (dataRule != null) {
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
                DynamicObject[] adminOrgDys = serviceHelper.queryOriginalArray("id", new QFilter[]{dataRule});
                if (adminOrgDys.length > 0) {
                    List adminOrgIds = Arrays.stream(adminOrgDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
                    beforeF7SelectEvent.getCustomQFilters().add(new QFilter("hrpi_empposorgrel.adminorg", "in", adminOrgIds));
                }
            }
        }
    }

    private void fileScheduleSet() {
        AttFileScheduleEnum[] values;
        boolean saveSchedule = this.getModel().getDataEntity().getBoolean("saveschedule");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String typeStr = dataEntity.getString("type");
        boolean isVaFile = FileTypeEnum.VCFILE.getFileType().equals(typeStr);
        for (AttFileScheduleEnum value : values = AttFileScheduleEnum.values()) {
            Control control;
            if (isVaFile && (AttFileScheduleEnum.CARD == value || AttFileScheduleEnum.MODE == value) || (control = this.getView().getControl(value.getKey())) == null) continue;
            this.getModel().setValue(value.getKey(), null);
            dataEntity.set(value.getKey(), null);
        }
        this.setBaseScheduleMustInput(this.getView(), saveSchedule);
    }

    private void orgChangeTips(ChangeData changeData) {
        if (changeData.getOldValue() != null && changeData.getNewValue() != null) {
            DynamicObject oldDy = (DynamicObject)changeData.getOldValue();
            String msg = ResManager.loadKDString((String)"\u66f4\u6539\u8003\u52e4\u7ec4\u7ec7\uff0c\u4f1a\u6e05\u7a7a\u201c\u8003\u52e4\u6807\u8bc6\u201d\u3001\u57fa\u7840\u65b9\u6848\u4ee5\u53ca\u89c4\u5219\u65b9\u6848\u9762\u677f\u4e2d\u7684\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"AttFileBaseEdit_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("org", (IFormPlugin)this), null, oldDy.getString("id"));
        }
    }

    private void setBaseScheduleMustInput(IFormView view, boolean mustInput) {
        for (AttFileScheduleEnum value : AttFileScheduleEnum.values()) {
            FieldEdit fieldEdit;
            if (!value.isTimeHis() || (fieldEdit = (FieldEdit)view.getControl(value.getKey())) == null) continue;
            fieldEdit.setMustInput(mustInput);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("save") && (operationResult = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            String errMsg;
            AbstractOperate source;
            IFormView parentView;
            if (operationResult.getMessage() != null && operationResult.getMessage().length() > 8 && (parentView = this.getView().getParentView()) != null) {
                parentView.showTipNotification(operationResult.getMessage());
                this.getView().sendFormAction(parentView);
            }
            if (null != (source = (AbstractOperate)afterDoOperationEventArgs.getSource()) && null != source.getOption() && !AttendEnum.LEAVE.getId().equals(this.getModel().getDataEntity().getLong("atttag.id")) && HRStringUtils.isNotEmpty((String)(errMsg = (String)source.getOption().getVariables().get("schedule_Msg")))) {
                this.getView().showTipNotification(errMsg);
            }
        }
    }
}

