/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasedataController;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.enums.FileGroupEnum;

public class AttFileBaseF7FastFilter
extends AbstractBasedataController {
    private static final String FTLIKE = "ftlike";

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        super.buildBaseDataCoreFilter(event);
        boolean isLookUp = event.getListShowParameter().isLookUp();
        if (!isLookUp) {
            return;
        }
        List qFilters = event.getListShowParameter().getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("atttag.attendstatus", "=", (Object)AttStatusEnum.ATT_NORMAL.getCode()));
        Object source = event.getSource();
        if (source instanceof BasedataEdit) {
            qFilters.add(new QFilter("usablestatus", "=", (Object)"0"));
            AttFileHelper.addOrgQFilter((List)qFilters, (FormShowParameter)event.getListShowParameter(), (IFormView)((BasedataEdit)event.getSource()).getView());
            this.resetNameQfilters(qFilters);
            DataSet finish = this.queryAttFileDataSet(event, qFilters);
            this.resetQFliters(event, qFilters, finish);
        }
    }

    private void resetNameQfilters(List<QFilter> qFilters) {
        if (CollectionUtils.isEmpty(qFilters)) {
            return;
        }
        for (QFilter qFilter : qFilters) {
            String[] strArr;
            String likeName;
            String strValue;
            Object value;
            if (null == qFilter || !FTLIKE.equals(qFilter.getCP()) || !((value = qFilter.getValue()) instanceof String) || WTCStringUtils.isEmpty((String)(strValue = (String)value)) || !(likeName = (strArr = strValue.split("#"))[0]).contains("name")) continue;
            strArr[0] = likeName.replaceAll("name", "textname").concat("#");
            String strLike = WTCStringUtils.joinStr((String[])strArr);
            qFilter.__setValue((Object)strLike);
        }
    }

    private void addOrgQFilter(BaseDataCustomControllerEvent event, List<QFilter> qFilters) {
        String billFormId = event.getListShowParameter().getBillFormId();
        String appId = FileGroupEnum.of((String)billFormId).getAppId();
        HasPermOrgResult hasPermOrgResult = WTCPermUtils.getAllPermOrgs((String)appId, (String)billFormId);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilters.add(new QFilter("org", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetQFliters(BaseDataCustomControllerEvent event, List<QFilter> qFilters, DataSet finish) {
        try {
            Iterator iterator = finish.iterator();
            ArrayList<Long> idList = new ArrayList<Long>();
            while (iterator.hasNext()) {
                idList.add(((Row)iterator.next()).getLong("id"));
            }
            qFilters.clear();
            qFilters.add(new QFilter("id", "in", idList));
            List eventQfilters = event.getQfilters();
            eventQfilters.clear();
            eventQfilters.addAll(qFilters);
        }
        finally {
            finish.close();
        }
    }

    private DataSet queryAttFileDataSet(BaseDataCustomControllerEvent event, List<QFilter> qFilters) {
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE));
        qFilters.add(new QFilter("datastatus", "in", Arrays.asList("1", "2")));
        Object attFileType = event.getListShowParameter().getCustomParam("filetype");
        if (attFileType != null) {
            qFilters.add(new QFilter("type", "=", attFileType));
        }
        return AttFileQueryHelper.queryAttFileDataSet(qFilters);
    }
}

