/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryHelper;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCPageCache;

public class AttFileBaseF7ListProvider
extends ListDataProvider {
    private static final Log log = LogFactory.getLog(AttFileBaseF7ListProvider.class);
    private Map<Long, Long> fileBoidMap;
    private WTCPageCache pageCache;
    private int rowNum;

    AttFileBaseF7ListProvider(WTCPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        this.queryAttFileBaseDataSet();
        DynamicObjectCollection rows = this.resetQFilter(start, limit);
        this.resetColunmData(rows);
        if (this.rowNum == 0) {
            this.rowNum = (Integer)this.pageCache.get("rowNum", Integer.class);
        }
        this.getQueryResult().setBillDataCount(this.rowNum);
        this.getQueryResult().setDataCount(this.rowNum);
        return rows;
    }

    private void resetColunmData(DynamicObjectCollection rows) {
        List attFileIdList = rows.stream().map(dy -> dy.get("id")).collect(Collectors.toList());
        List fileDys = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id, boid", attFileIdList);
        this.fileBoidMap = fileDys.stream().collect(Collectors.toMap(fileDy -> fileDy.getLong("id"), fileDy -> fileDy.getLong("boid"), (oldValue, newValue) -> oldValue));
        Set<Long> attFileBoidSet = fileDys.stream().map(fileDy -> fileDy.getLong("boid")).collect(Collectors.toSet());
        this.resetListViewHisData(rows, attFileBoidSet);
    }

    private void resetListViewHisData(DynamicObjectCollection rows, Set<Long> attFileBoidSet) {
        List qFilters = this.getQFilters();
        Date endDate = this.getEndDateAndResetQFliter(qFilters);
        qFilters.add(new QFilter("boid", "in", attFileBoidSet));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_attfilebase");
        DynamicObject[] dys = helper.queryOriginalArray("boid, id, bsled", qFilters.toArray(new QFilter[0]));
        List dynamicObjects = endDate == null ? Arrays.stream(dys).collect(Collectors.toList()) : Arrays.stream(dys).filter(dy -> dy.getDate("bsled").compareTo(endDate) >= 0).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> boidMap = dynamicObjects.stream().collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        boolean containsDescProp = false;
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            containsDescProp = ((DynamicObject)rows.get(0)).containsProperty("description");
        }
        if (containsDescProp) {
            for (DynamicObject row : rows) {
                long id = row.getLong("id");
                Long boid = this.fileBoidMap.get(id);
                List<DynamicObject> boIdDys = boidMap.get(boid);
                if (boIdDys == null || boIdDys.size() == 0) continue;
                int size = boIdDys.size();
                if (size > 1) {
                    row.set("description", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"AttFileBaseF7ListProvider_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
                    continue;
                }
                row.set("description", (Object)"");
            }
        }
    }

    private Date getEndDateAndResetQFliter(List<QFilter> qFilters) {
        Date endDate = null;
        int size = qFilters.size();
        for (int i = 0; i < size; ++i) {
            QFilter qFilter = qFilters.get(i);
            String property = qFilter.getProperty();
            if (!"bsed".equals(property)) continue;
            QFilter[] recombine = qFilter.recombine();
            if (recombine == null || recombine.length < 2) break;
            Object value = qFilter.recombine()[1].getValue();
            if (value != null) {
                endDate = (Date)value;
            }
            qFilters.set(i, qFilter.recombine()[0]);
        }
        return endDate;
    }

    private void queryAttFileBaseDataSet() {
        boolean isInvalided = this.dataCacheIsInvalided();
        List qFilters = this.getQFilters();
        String qFilterStr = qFilters.toString();
        if (!qFilterStr.equals(this.pageCache.get("qfilter", String.class)) || isInvalided) {
            this.pageCache.put("qfilter", (Object)qFilterStr);
            Algo.removeCacheDataSet((String)this.pageCache.get("cacheId"));
            DataSet finish = AttFileQueryHelper.queryAttFileDataSet((List)qFilters);
            CachedDataSet cache = finish.cache(new CacheHint());
            String cacheId = cache.getCacheId();
            this.rowNum = cache.getRowCount();
            this.pageCache.put("cacheId", (Object)cacheId);
            this.pageCache.put("rowNum", (Object)String.valueOf(this.rowNum));
        }
    }

    private boolean dataCacheIsInvalided() {
        String cacheId = (String)this.pageCache.get("cacheId", String.class);
        boolean isInvalided = false;
        try {
            Algo.getCacheDataSet((String)cacheId);
        }
        catch (Exception e) {
            log.error("\u8003\u52e4\u6863\u6848F7\u83b7\u53d6dataset\u7f13\u5b58\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0", (Throwable)e);
            isInvalided = true;
        }
        return isInvalided;
    }

    private DynamicObjectCollection resetQFilter(int start, int limit) {
        DynamicObjectCollection dynamicObjectCollection;
        List qFilters = this.getQFilters();
        ArrayList copyQFilters = new ArrayList(qFilters);
        String cacheId = (String)this.pageCache.get("cacheId", String.class);
        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
        List list = cachedDataSet.getList(start, limit);
        if (list.isEmpty()) {
            qFilters.add(new QFilter("1", "!=", (Object)1));
            dynamicObjectCollection = super.getData(start, limit);
        } else {
            List pkIds = list.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
            qFilters.clear();
            qFilters.add(new QFilter("id", "in", pkIds));
            dynamicObjectCollection = super.getData(0, limit);
        }
        qFilters.clear();
        qFilters.addAll(copyQFilters);
        return dynamicObjectCollection;
    }
}

