/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.MapUtils;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.common.constants.AttFileConstants;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileDetailPlugin
extends HRDynamicFormBasePlugin
implements AttFileConstants {
    private static final Log LOG = LogFactory.getLog(AttFileDetailPlugin.class);
    private static final String BUTTON_VIEW_ROSTER = "viewroster";
    private static final String BUTTON_VIEW_QUOTA = "viewquota";
    private static final String BUTTON_VIEW_PERPERIOD = "viewperperiod";
    private static final HRBaseServiceHelper depEmpJobPersonHelper = new HRBaseServiceHelper("wtp_depempjob");

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object fileType = formShowParameter.getCustomParam("filetype");
        if (FileTypeEnum.VCFILE.getFileType().equals(fileType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BUTTON_VIEW_ROSTER});
            this.getView().setVisible(Boolean.FALSE, new String[]{BUTTON_VIEW_PERPERIOD});
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Map customParams = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        AttFileServiceImpl attFileService = AttFileServiceImpl.getInstance();
        if (customParams.get("empposorgrel") instanceof Integer) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u6570\u636e\u5f02\u5e38\u3002", (String)"AttFileDetailPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            return;
        }
        attFileService.openFileHeader(this.getView(), (Long)customParams.get("empposorgrel"), (Long)customParams.get("attfileid"), "personheader");
        this.checkDepEmpJob(customParams);
        attFileService.openFileSchedule(this.getView(), customParams, "fileschedule");
    }

    private void checkDepEmpJob(Map<String, Object> customParams) {
        QFilter filter;
        QFilter[] filters;
        DynamicObject[] dyArray;
        Long empPosOrgRelId = (Long)customParams.get("empposorgrel");
        if (LOG.isInfoEnabled()) {
            LOG.info("kd.wtc.wtp.formplugin.web.attfile.AttFileDetailPlugin.checkDepEmpJob :{}", (Object)empPosOrgRelId);
        }
        if (null != (dyArray = depEmpJobPersonHelper.queryOriginalArray("id,datastatus,isprimary", filters = new QFilter[]{filter = new QFilter("id", "=", (Object)empPosOrgRelId)})) && dyArray.length > 0) {
            if ("-1".equals(dyArray[0].getString("datastatus"))) {
                this.getView().showErrorNotification(AttFileKDString.empPosOrgRelNotEffect());
            } else if (!dyArray[0].getBoolean("isprimary")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u7684\u4efb\u804c\u5df2\u7531\u4e3b\u4efb\u804c\u53d8\u4e3a\u975e\u4e3b\u4efb\u804c\uff0c\u8bf7\u5173\u6ce8\u4efb\u804c\u4fe1\u606f\u3002", (String)"AttFileDetailPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (HRStringUtils.equals((String)"refresh", (String)operateKey)) {
            Long attFileId;
            HRBaseServiceHelper fileService;
            DynamicObject file;
            Map customParams = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
            if (MapUtils.isNotEmpty((Map)customParams) && null != (file = (fileService = new HRBaseServiceHelper("wtp_attfilebase")).queryOriginalOne("empposorgrel.id", (Object)(attFileId = (Long)customParams.get("attfileid"))))) {
                customParams.put("empposorgrel", file.getLong("empposorgrel.id"));
            }
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        String attFileId = String.valueOf(((Map)this.getView().getFormShowParameter().getCustomParam("customvariables")).get("boid"));
        long fileId = Long.parseLong(String.valueOf(attFileId));
        switch (operateKey) {
            case "viewroster": {
                FormShowParameter rosterViewFormShowParameter = DataBaseEditService.getFormShowParameter((String)"wts_rosterview", (ShowType)ShowType.MainNewTabPage);
                rosterViewFormShowParameter.setCustomParam("attperson", (Object)fileId);
                DynamicObject dynamicObject = AttFileQueryServiceImpl.getInstance().queryOneAttFile("org.id", (Object)fileId);
                if (dynamicObject != null) {
                    rosterViewFormShowParameter.setCustomParam("org", (Object)dynamicObject.getLong("org.id"));
                }
                WtbsBusinessUtils.openTargetFormView((IFormView)this.getView(), (FormShowParameter)rosterViewFormShowParameter, (String)"wts");
                break;
            }
            case "viewperperiod": {
                HashMap subCustomParams = Maps.newHashMapWithExpectedSize((int)16);
                DynamicObject dy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("usablestatus,org,org.id", (Object)Long.valueOf(attFileId));
                if (dy != null) {
                    subCustomParams.put("usablestatus", dy.getString("usablestatus"));
                    subCustomParams.put("perAttPeriodListDefaultOrg", String.valueOf(dy.getLong("org.id")));
                }
                this.getView().showForm((FormShowParameter)PerAttPeriodDataService.getInstance().showPerAttPeriod(WTCStringUtils.joinStr((String[])new String[]{this.getView().getPageId(), "wtp_perattperiod"}), (Map)subCustomParams, (Set)Sets.newHashSet((Object[])new Long[]{fileId})));
                break;
            }
        }
    }

    private DynamicObject getDynamicObject(String queryField) {
        String attFileId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        long fileId = Long.parseLong(attFileId);
        HRBaseServiceHelper file = new HRBaseServiceHelper("wtp_attfilebase");
        return file.queryOriginalOne(queryField, (Object)fileId);
    }
}

