/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.CollectionUtils;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonOtherInfo;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonServiceImpl;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttFileExportPlugin
implements HRExportPlugin {
    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        super.beforeWriteData(args);
        List tplDataRows = args.getTplDataRows();
        Set attFileNumbers = tplDataRows.stream().flatMap(dataMap -> dataMap.values().stream().filter(map -> "number".equals(map.get("key"))).map(map -> String.valueOf(map.get("val")))).collect(Collectors.toSet());
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setSetFileNumber(attFileNumbers);
        queryParam.setBeCurrent(Boolean.TRUE);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setProperties("attperson, number");
        List dys = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)dys)) {
            Map<String, Long> fileNumberToAttPersonIdMap = dys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson"), (a, b) -> a));
            List attPersonIds = dys.stream().filter(Objects::nonNull).map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attperson")).collect(Collectors.toList());
            Map otherInfoMap = AttendPersonServiceImpl.getInstance().batchQueryAttPersonOtherInfoByPersonIds(attPersonIds);
            if (otherInfoMap != null && otherInfoMap.size() > 0) {
                for (Map tplDataRow : tplDataRows) {
                    String number = tplDataRow.values().stream().filter(map -> "number".equals(map.get("key"))).map(map -> String.valueOf(map.get("val"))).findFirst().orElse(null);
                    Long attPersonId = fileNumberToAttPersonIdMap.get(number);
                    AttendPersonOtherInfo attendPersonOtherInfo = (AttendPersonOtherInfo)otherInfoMap.get(attPersonId);
                    if (attendPersonOtherInfo == null) continue;
                    for (Map.Entry next : tplDataRow.entrySet()) {
                        Date qtFirstEffectDate;
                        Map map2 = (Map)next.getValue();
                        if (!"qtfirsteffectdate".equals(map2.get("key")) || (qtFirstEffectDate = attendPersonOtherInfo.getQtFirstEffectDate()) == null) continue;
                        map2.put("val", HRDateTimeUtils.format((Date)attendPersonOtherInfo.getQtFirstEffectDate(), (String)"yyyy-MM-dd"));
                    }
                }
            }
        }
    }
}

