/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttFileImportPlugin
extends HisBatchImportPlugin {
    private static final int IMP_BATCH_SIZE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtp.attfile.batchImportSize", Integer.valueOf(1000));

    public List<String> getDefaultLockUIs() {
        ArrayList lockList = Lists.newArrayListWithExpectedSize((int)2);
        lockList.add("radiofield1");
        lockList.add("radiofield2");
        List defaultLockUIs = super.getDefaultLockUIs();
        defaultLockUIs.addAll(lockList);
        return defaultLockUIs;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (CollectionUtils.isEmpty(billdatas)) {
            return;
        }
        HashSet numberSets = Sets.newHashSetWithExpectedSize((int)billdatas.size());
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            JSONObject person = billData.getData().getJSONObject("person");
            if (person == null) {
                this.log(billData.getStartRowIndex(), ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttFileImportPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), logger);
                iterator.remove();
                continue;
            }
            String number = person.getString("number");
            if (!HRStringUtils.isNotEmpty((String)number)) continue;
            if (numberSets.contains(number)) {
                this.log(billData.getStartRowIndex(), ResManager.loadKDString((String)"\u65b0\u589e\u5bfc\u5165\u4eba\u5458\u4e0d\u80fd\u91cd\u590d\u3002", (String)"AttFileImportPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[0]), logger);
                iterator.remove();
                continue;
            }
            numberSets.add(number);
        }
    }

    private void log(int rowIndex, String errorMsg, ImportLogger logger) {
        Map logCache = logger.getLogCache();
        if (logCache.get(rowIndex) != null) {
            ((List)logCache.get(rowIndex)).add(new ImportLogger.ImportLog(errorMsg));
            logger.setLogCache(logCache);
        } else {
            logger.log(Integer.valueOf(rowIndex), errorMsg);
        }
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return IMP_BATCH_SIZE;
    }
}

