/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.impt.common.plugin.AfterLoadEntityEventArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.business.attfile.AttFileCoreDataService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileImportUpdatePlugin
extends HRDataBaseList
implements HRImportPlugin {
    public void beforeValidate(BeforeValidateEventArgs args) {
        AttFileHelper.resetImportOpAndScheduleOrgID((List)args.getBillDatas());
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map submitOPs = args.getSubmitOPs();
        submitOPs.put("wtp_attfilebase", "file_modify");
        AttFileHelper.resetSubmitOPs((Map)submitOPs, (String)"");
        Object[] dynamicObjects = args.getDynamicObjects();
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            OperateOption operateOption;
            ArrayList queryList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            for (Object dynamicObject : dynamicObjects) {
                DynamicObject dy;
                if (!(dynamicObject instanceof DynamicObject) || !"wtp_attfilebase".equals((dy = (DynamicObject)dynamicObject).getDataEntityType().getName())) continue;
                AttFileHelper.getDepQueryParamList((List)queryList, (DynamicObject)dy);
            }
            if (WTCCollections.isEmpty((Collection)queryList)) {
                return;
            }
            Map numberDepEmpMap = HRPIMServiceImpl.getInstance().listDepEmpInfo((List)queryList);
            if (WTCCollections.isEmpty((Map)numberDepEmpMap)) {
                return;
            }
            List depEmpIdList = numberDepEmpMap.values().stream().flatMap(Collection::stream).map(d -> d.getLong("id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("depemp.id", "in", depEmpIdList);
            DynamicObject[] empOrgRelArr = HRPIMServiceImpl.getInstance().listFieldsFilterInfo("id,depemp", qFilter, "hrpi_empposorgrel");
            ArrayList empOrgRelIdList = Lists.newArrayListWithExpectedSize((int)depEmpIdList.size());
            Arrays.stream(empOrgRelArr).forEach(item -> empOrgRelIdList.add((Long)item.get("id")));
            Map fileSaveDtoMap = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds((List)empOrgRelIdList);
            Map fileSaveDtoKeyMap = fileSaveDtoMap.values().stream().collect(Collectors.toMap(d -> this.getKey(d.getPersonId(), d.getAdminOrgId(), d.getPositionId(), d.getEmployeeId()), Function.identity(), (a, b) -> a));
            ArrayList<Long> empPosOrgRelEmptyList = new ArrayList<Long>();
            for (Object dynamicObject : dynamicObjects) {
                long adminOrgId;
                long affiliateAdminOrg;
                DynamicObject dy;
                if (!(dynamicObject instanceof DynamicObject) || !"wtp_attfilebase".equals((dy = (DynamicObject)dynamicObject).getDataEntityType().getName())) continue;
                String key = this.getKey(dy.getLong("person.id"), dy.getLong("adminorg.id"), dy.getLong("position.id"), dy.getLong("employee.id"));
                if (WTCStringUtils.isNotEmpty((String)key)) {
                    if (fileSaveDtoKeyMap.get(key) != null) {
                        FileSaveDto fileSaveDto = (FileSaveDto)fileSaveDtoKeyMap.get(key);
                        if (fileSaveDto.getDepempId().longValue() != dy.getLong("depemp.id")) {
                            AttFileCoreDataService.getInstance().updateFileEmpDataByFileSaveDto(fileSaveDto, dy, null);
                        }
                    } else {
                        dy.set("empposorgrel", null);
                        empPosOrgRelEmptyList.add(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id"));
                    }
                }
                if ((affiliateAdminOrg = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy.getDynamicObject("affiliateadminorg"), (String)"id")) == (adminOrgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy.getDynamicObject("adminorg"), (String)"id"))) continue;
                dy.set("ismanaged", (Object)true);
            }
            if (CollectionUtils.isNotEmpty(empPosOrgRelEmptyList) && (operateOption = (OperateOption)args.getOperateOptions().get("wtp_attfilebase")) != null) {
                operateOption.setVariableValue("importEmpPoOrgRelFailList", ((Object)empPosOrgRelEmptyList).toString());
            }
        }
    }

    String getKey(Long personId, Long adminOrgId, Long positionId, Long employeeId) {
        return WTCStringUtils.joinStr((String[])new String[]{adminOrgId == null ? "" : String.valueOf(adminOrgId), positionId == null ? "" : String.valueOf(positionId), personId == null ? "" : String.valueOf(personId), employeeId == null ? "" : String.valueOf(employeeId)});
    }

    public void afterLoadEntity(AfterLoadEntityEventArgs args) {
        Iterator iterator = args.getListDys().iterator();
        while (iterator.hasNext()) {
            AttFileScheduleEnum[] values;
            DynamicObject[] dys = (DynamicObject[])iterator.next();
            if (dys == null || dys.length <= 0) continue;
            String mainEntityId = dys[0].getDataEntityType().getName();
            for (AttFileScheduleEnum value : values = AttFileScheduleEnum.values()) {
                if (value.isTimeHis() || !value.getPageId().equals(mainEntityId)) continue;
                iterator.remove();
            }
        }
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        args.setDatas(AttFileHelper.filterAuditedBaseData((DynamicObject[])args.getDatas()));
    }

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        List headerWriterFormats = args.getHeaderWriterFormats();
        AttFileHelper.resetExportFields((List)headerWriterFormats, (String)"");
    }

    public void afterLoadStartPage(AfterLoadStartPageEventArgs args) {
        args.setEnableSelectModelView(false);
        args.setEnableSelectModelItem(false);
    }
}

