/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.common.constants.AttFileConstants;

public class AttFileScheduleImportPlugin
extends BatchImportPlugin {
    private static final int IMP_BATCH_SIZE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtp.attfile.schdule.batchImportSize", Integer.valueOf(1000));

    public List<String> getDefaultLockUIs() {
        ArrayList lockList = Lists.newArrayListWithExpectedSize((int)2);
        lockList.add("radiofield1");
        lockList.add("radiofield2");
        List defaultLockUIs = super.getDefaultLockUIs();
        defaultLockUIs.addAll(lockList);
        return defaultLockUIs;
    }

    protected boolean isForceBatch() {
        return true;
    }

    protected int getBatchImportSize() {
        return IMP_BATCH_SIZE;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Set attFileNumberSet = billdatas.stream().map(importBillData -> String.valueOf(((JSONObject)importBillData.getData().get((Object)"attfileid")).get((Object)"number"))).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setSetFileNumber(attFileNumberSet);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        attFileQueryParam.setProperties("usablestatus, number, startdate, enddate, org.number");
        List attFileDys = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Map<String, DynamicObject> map = attFileDys.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (a, b) -> a));
        for (ImportBillData billdata : billdatas) {
            String number = String.valueOf(((JSONObject)billdata.getData().get((Object)"attfileid")).get((Object)"number"));
            DynamicObject attFileDy = map.get(number);
            if (attFileDy == null) continue;
            JSONObject data = billdata.getData();
            String billFormId = this.getBillFormId();
            if (AttFileConstants.TIME_HIS_PAGE_SET.contains(billFormId)) {
                data.put("bsed", (Object)attFileDy.getDate("startdate"));
                data.put("bsled", (Object)attFileDy.getDate("enddate"));
            }
            HashMap orgMap = Maps.newHashMapWithExpectedSize((int)16);
            orgMap.put("importprop", "number");
            orgMap.put("number", attFileDy.getString("org.number"));
            data.put("org", (Object)orgMap);
        }
    }
}

