/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.formplugin.web.attfile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.util.WTCPermUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.file.AttStatusEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.time.StopWatch;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attfile.AttFileHelper;

public class AttFileSummaryPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(AttFileSummaryPlugin.class);
    private static final int MESSAGEAP_MAX_NUM = 1;
    private static final String TITLE_INFO = "titleInfo";
    private static final String DETAIL_INFO = "detailInfo";
    private static final String SHOW_SUPER_INFO = "showSuperInfo";
    private static final String SHOW_DEP_INFO = "showdepInfo";
    private static final String HEAD_SCUL_PTURE = "headsculpture";
    private static final String NAME_TEXT = "name";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map map = (Map)formShowParameter.getCustomParam("customvariables");
        Object depEmpJobId = map.get("empposorgrel");
        if (!this.isHaveRelationEmpJobId(depEmpJobId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"messageap"});
            return;
        }
        ArrayList<String> emptyFile = new ArrayList<String>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_depempjob");
        DynamicObject depempjobDy = serviceHelper.loadSingle(depEmpJobId);
        long personId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)depempjobDy, (String)"person");
        this.showDepEmpJob(emptyFile, depempjobDy);
        this.showManageScope(depempjobDy);
        this.showPerson(emptyFile, depEmpJobId, personId);
        this.showWorkYears(personId);
        this.showAttFile(emptyFile, map.get("attfileid"));
    }

    private void showAttFile(List<String> emptyFile, Object attFileId) {
        StopWatch stopWatch = StopWatch.createStarted();
        String properties = WTCStringUtils.joinStr((String[])new String[]{"personnum", ",", AttFileQueryParam.baseProperties, ",", "cmpemp,cmpemp.id,cmpemp.startdate,cmpemp.enddate,cmpemp.sysenddate,cmpemp.managingscope,employee,employee.id,employee.empnumber,employee.startdate,employee.enddate,employee.sysenddate,depemp,depemp.id,depemp.number,depemp.bsed,depemp.startdate,depemp.enddate", ",", "empposorgrel,empposorgrel.id,empposorgrel.startdate,empposorgrel.sysenddate,empposorgrel.isprimary,empposorgrel.company.id,empposorgrel.company.number,empposorgrel.company.name,empposorgrel.adminorg.id,empposorgrel.adminorg.number,empposorgrel.adminorg.name,empposorgrel.position.id,empposorgrel.position.number,empposorgrel.position.name,empposorgrel.job.id,empposorgrel.job.number,empposorgrel.job.name,empposorgrel.posstatus.id,empposorgrel.posstatus.number,empposorgrel.posstatus.name,empposorgrel.postype.id,empposorgrel.postype.number,empposorgrel.postype.name,empposorgrel.workplace,empposorgrel.workplace.id,empposorgrel.workplace.number,empposorgrel.workplace.name,empposorgrel.contractworkplace.id,empposorgrel.contractworkplace.number,empposorgrel.contractworkplace.name", ",", "org,org.id,org.name,org.number,affiliateadminorg,affiliateadminorg.id,affiliateadminorg.number,affiliateadminorg.name,empgroup,empgroup.id,empgroup.number,empgroup.name,dependency,dependency.id,dependency.number,dependency.name,dependencytype,dependencytype.id,dependencytype.number,dependencytype.name,workplace,workplace.id,workplace.number,workplace.name,atttag.id,atttag.number,atttag.name", ",", "usablestatus"});
        AttFileQueryParam queryParam = new AttFileQueryParam(false);
        queryParam.setProperties(properties);
        queryParam.setUsableStatus((Set)Sets.newHashSet((Object[])new String[]{"0", "-1"}));
        queryParam.setqFilter(new QFilter("id", "=", attFileId));
        DynamicObject attFileInfo = AttFileQueryServiceImpl.getInstance().queryOneAttFiles(queryParam);
        if (null == attFileInfo) {
            return;
        }
        this.setValueOrEmpyList("personnumber", null, attFileInfo.getString("personnum"), emptyFile);
        if (Objects.isNull(attFileInfo)) {
            return;
        }
        stopWatch.stop();
        logger.info("showAttFile search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        this.setValueOrEmpyList("personname", null, attFileInfo.getString(NAME_TEXT), emptyFile);
        if (StringUtils.isEmpty((CharSequence)attFileInfo.getString("org.name"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"org", "labelap7", "labelap3"});
        } else {
            this.getModel().setValue("org", (Object)attFileInfo.getString("org.name"));
        }
        String orgName = attFileInfo.getString("affiliateadminorg.name");
        if (StringUtils.isEmpty((CharSequence)orgName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"affiliateadminorg", "labelap6", "labelap31"});
        } else {
            this.getModel().setValue("affiliateadminorg", (Object)orgName);
        }
        String depenName = attFileInfo.getString("dependency.name");
        if (StringUtils.isEmpty((CharSequence)depenName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dependency", "labelap1", "labelap32"});
        } else {
            this.getModel().setValue("dependency", (Object)attFileInfo.getString("dependency.name"));
        }
        String attStatus = attFileInfo.getString("atttag.attendstatus");
        String usableStatus = attFileInfo.getString("usablestatus");
        this.setSuperAndDepCharge(attFileInfo);
        if ("-1".equals(usableStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"atttagstatuss", "atttagstatusv"});
        } else if (AttStatusEnum.ATT_NORMAL.getCode().equals(attStatus)) {
            Label atttagstatus = (Label)this.getView().getControl("atttagstatusv");
            attStatus = ResManager.loadKDString((String)"\u6b63\u5e38\u8003\u52e4", (String)"AttFileSummaryPlugin_3", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            atttagstatus.setText(attStatus);
            this.getView().setVisible(Boolean.FALSE, new String[]{"atttagstatuss", "usablestatus_discard"});
        } else {
            Label atttagstatus = (Label)this.getView().getControl("atttagstatuss");
            attStatus = ResManager.loadKDString((String)"\u505c\u6b62\u8003\u52e4", (String)"AttFileSummaryPlugin_4", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            atttagstatus.setText(attStatus);
            this.getView().setVisible(Boolean.FALSE, new String[]{"atttagstatusv", "usablestatus_discard"});
        }
        if (!CollectionUtils.isEmpty(emptyFile)) {
            this.getView().setVisible(Boolean.FALSE, emptyFile.toArray(new String[0]));
        }
        stopWatch.stop();
        logger.info("showAttFile cost: " + stopWatch.getTime());
    }

    private void showWorkYears(long personId) {
        StopWatch stopWatch = StopWatch.createStarted();
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        Date date = new Date(System.currentTimeMillis());
        List list = hrpimService.listIntersectDataSocialworkageAndServicelengthInfo(date, date, (List)Lists.newArrayList((Object[])new Long[]{personId}));
        stopWatch.stop();
        logger.info("showWorkYears search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            Map workageMap = (Map)list.get(0);
            BigDecimal serviceLength = (BigDecimal)workageMap.get("servicelength");
            serviceLength = serviceLength == null ? BigDecimal.ZERO : serviceLength.setScale(1, 4);
            BigDecimal socialWorkAge = (BigDecimal)workageMap.get("socialworkage");
            BigDecimal bigDecimal = socialWorkAge = socialWorkAge == null ? BigDecimal.ZERO : socialWorkAge.setScale(1, 4);
            if (serviceLength.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"companyyears"});
            } else {
                Label companyyears = (Label)this.getView().getControl("companyyears");
                String serviceStr = ResManager.loadKDString((String)"\u53f8\u9f84%s\u5e74", (String)"AttFileSummaryPlugin_1", (String)"wtc-wtp-formplugin", (Object[])new Object[]{serviceLength});
                companyyears.setText(serviceStr);
            }
            if (socialWorkAge.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"workyears"});
            } else {
                Label workyears = (Label)this.getView().getControl("workyears");
                String workStr = ResManager.loadKDString((String)"\u793e\u4f1a\u5de5\u9f84%s\u5e74", (String)"AttFileSummaryPlugin_2", (String)"wtc-wtp-formplugin", (Object[])new Object[]{socialWorkAge});
                workyears.setText(workStr);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"workyears", "companyyears"});
        }
        stopWatch.stop();
        logger.info("showWorkYears cost: " + stopWatch.getTime());
    }

    private void showPerson(List<String> emptyFile, Object depEmpJobId, long personId) {
        String laborrelstatus;
        StopWatch stopWatch = StopWatch.createStarted();
        HRPIMServiceImpl hrpimService = HRPIMServiceImpl.getInstance();
        HRBaseServiceHelper personService = new HRBaseServiceHelper("wtp_attendperson");
        DynamicObject personDy = personService.loadSingle((Object)personId);
        stopWatch.stop();
        logger.info("showPerson search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        String gender = personDy.getString("gender.name");
        this.setValueOrEmpyList("gender", "vectorap", gender, emptyFile);
        logger.info("\u804c\u7ea7\u4fe1\u606f\u6392\u67e5{},{}", (Object)personId, depEmpJobId);
        Map personMap = hrpimService.getPersonBaseInfo(Long.valueOf(personId));
        if (personMap != null) {
            String headsculpture = (String)personMap.get(HEAD_SCUL_PTURE);
            AttFileSummaryPlugin.setIcon(headsculpture, this.getView(), HEAD_SCUL_PTURE);
        }
        if (StringUtils.isNotBlank((CharSequence)(laborrelstatus = personDy.getString("laborrelstatus.name")))) {
            Label laborrelstatusl = (Label)this.getView().getControl("laborrelstatus");
            laborrelstatusl.setText(laborrelstatus);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"laborrelstatus"});
        }
        String laborreltype = personDy.getString("laborreltype.name");
        if (StringUtils.isNotBlank((CharSequence)laborreltype)) {
            Label laborreltypel = (Label)this.getView().getControl("laborreltype");
            laborreltypel.setText(laborreltype);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"laborreltype"});
        }
        String nationality = personDy.getString("nationality.name");
        if (StringUtils.isNotBlank((CharSequence)nationality)) {
            String subfix = ResManager.loadKDString((String)"\u56fd\u7c4d", (String)"AttFileSummaryPlugin_0", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
            Label nationalityLabel = (Label)this.getView().getControl("nationality");
            nationalityLabel.setText(nationality + subfix);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"nationality"});
        }
        stopWatch.stop();
        logger.info("showPerson cost:" + stopWatch.getTime());
    }

    private void showManageScope(DynamicObject depempjobDy) {
        StopWatch stopWatch = StopWatch.createStarted();
        long managescopeId = depempjobDy.getLong("cmpemp.id");
        HRBaseServiceHelper serviceHelperma = new HRBaseServiceHelper("wtp_managescope");
        DynamicObject managescopedy = serviceHelperma.loadSingle((Object)managescopeId);
        stopWatch.stop();
        logger.info("showManageScope search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        String managingscope = managescopedy.getString("managingscope.name");
        if (StringUtils.isEmpty((CharSequence)managingscope)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"managingscope", "labelap5", "labelap33"});
        } else {
            this.getModel().setValue("managingscope", (Object)managingscope);
        }
        stopWatch.stop();
        logger.info("showManageScope cost:" + stopWatch.getTime());
    }

    private void showDepEmpJob(List<String> emptyFile, DynamicObject depempjobDy) {
        StopWatch stopWatch = StopWatch.createStarted();
        String company = depempjobDy.getString("company.name");
        String adminorg = depempjobDy.getString("adminorg.name");
        String position = depempjobDy.getString("position.name");
        String workplace = depempjobDy.getString("workplace.name");
        this.setValueOrEmpyList("company", "vectorap1", company, emptyFile);
        this.setValueOrEmpyList("adminorg", "vectorap2", adminorg, emptyFile);
        this.setValueOrEmpyList("position", "vectorap3", position, emptyFile);
        this.setValueOrEmpyList("workplace", "vectorap4", workplace, emptyFile);
        String posstatus = depempjobDy.getString("posstatus.name");
        if (StringUtils.isNotBlank((CharSequence)posstatus)) {
            Label posstatusl = (Label)this.getView().getControl("posstatus");
            posstatusl.setText(posstatus);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"posstatus"});
        }
        String postype = depempjobDy.getString("postype.name");
        if (StringUtils.isNotBlank((CharSequence)postype)) {
            Label postypel = (Label)this.getView().getControl("postype");
            postypel.setText(postype);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"postype"});
        }
        stopWatch.stop();
        logger.info("showDepEmpJob cost:" + stopWatch.getTime());
    }

    private void setValueOrEmpyList(String fileName, String laleName, String value, List<String> emptyFile) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            this.getModel().setValue(fileName, (Object)value);
        } else {
            if (laleName != null) {
                emptyFile.add(laleName);
            }
            emptyFile.add(fileName);
        }
    }

    public static void setIcon(String iconUrl, IFormView formView, String fieldKey) {
        ImageAp portrait = new ImageAp();
        portrait.setKey(fieldKey);
        if (StringUtils.isNotBlank((CharSequence)iconUrl) && !"/images/pc/emotion/default_person_82_82.png".equals(iconUrl)) {
            String url = !HRStringUtils.isEmpty((String)iconUrl) && !HRStringUtils.startsWithIgnoreCase((String)iconUrl, (String)"http") ? UrlService.getImageFullUrl((String)iconUrl.trim()) : iconUrl;
            portrait.setImageKey(url);
        } else {
            portrait.setImageKey("/images/pc/emotion/default_person_82_82.png");
        }
        formView.updateControlMetadata(portrait.getKey(), portrait.createControl());
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if ("labelap4".equalsIgnoreCase(control.getKey())) {
            String caption;
            Map customVariablesMap = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
            long attFileId = (Long)customVariablesMap.get("attfileid");
            boolean noPermission = WTCPermUtils.noDataPermission((long)attFileId, (String)"wtp_attfilebase", (String)"wtam", (IFormView)this.getView(), null);
            if (noPermission) {
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("wtp_leaderlist");
            ArrayList<JSONObject> infoList = new ArrayList<JSONObject>();
            String depStr = this.getView().getPageCache().get(SHOW_DEP_INFO);
            String superStr = this.getView().getPageCache().get(SHOW_SUPER_INFO);
            if (!HRStringUtils.isEmpty((String)depStr) && !HRStringUtils.isEmpty((String)superStr)) {
                caption = ResManager.loadKDString((String)"\u66f4\u591a\u4fe1\u606f", (String)"AttFileSummaryPlugin_5", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                infoList.add(JSON.parseObject((String)superStr));
                infoList.add(JSON.parseObject((String)depStr));
            } else {
                caption = HRStringUtils.isEmpty((String)depStr) ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"AttFileSummaryPlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"AttFileSummaryPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
                JSONObject object = HRStringUtils.isEmpty((String)depStr) ? JSON.parseObject((String)superStr) : JSON.parseObject((String)depStr);
                infoList.add(object);
            }
            formShowParameter.setCaption(caption);
            formShowParameter.setCustomParam("allInfo", (Object)JSON.toJSONString(infoList));
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"labelap4"});
    }

    private boolean isHaveRelationEmpJobId(Object depEmpJobId) {
        Long jobId = depEmpJobId instanceof Integer ? Long.valueOf(((Integer)depEmpJobId).longValue()) : (Long)depEmpJobId;
        return depEmpJobId != null && 0L != jobId;
    }

    private void setSuperAndDepCharge(DynamicObject attFileInfo) {
        boolean depEmpty;
        Long depId = attFileInfo.getLong("depemp.id");
        Long adminOrgId = attFileInfo.getLong("empposorgrel.adminorg.id");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Map dirSuperInfoMap = AttFileHelper.getDirectSuperiorByDepempId(Collections.singletonList(depId));
        stopWatch.stop();
        logger.info("getDirectSuperiorByDepempId search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        List depChargeInfoList = AttFileHelper.getMainChargeByOrg(Collections.singletonList(adminOrgId));
        stopWatch.stop();
        logger.info("getMainChargeByOrg search cost: " + stopWatch.getTime());
        stopWatch.reset();
        stopWatch.start();
        AtomicInteger infoSize = new AtomicInteger(0);
        boolean supEmpty = this.setSuper(depId, dirSuperInfoMap, infoSize);
        if (!supEmpty) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"superap"});
        }
        if (!(depEmpty = this.setDepCharge(depChargeInfoList, infoSize))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"depchargeap"});
        }
        if (!supEmpty && !depEmpty) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"messageap"});
        }
        if (infoSize.get() <= 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"moreap"});
        }
        stopWatch.stop();
        logger.info("setSuperAndDepCharge search cost: " + stopWatch.getTime());
    }

    private boolean setDepCharge(List<Map<String, Object>> depChargeInfoList, AtomicInteger infoSize) {
        boolean supEmpty = false;
        if (CollectionUtils.isEmpty(depChargeInfoList)) {
            return false;
        }
        JSONObject superObject = new JSONObject();
        String title = ResManager.loadKDString((String)"\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"AttFileSummaryPlugin_7", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        superObject.put(TITLE_INFO, (Object)title);
        ArrayList infoList = Lists.newArrayListWithExpectedSize((int)16);
        int idx = 0;
        for (Map<String, Object> demMap : depChargeInfoList) {
            String nameText = (String)demMap.get(NAME_TEXT);
            if (HRStringUtils.isEmpty((String)nameText)) continue;
            infoSize.incrementAndGet();
            String headPic = (String)demMap.get(HEAD_SCUL_PTURE);
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            JSONObject infoObject = new JSONObject();
            infoObject.put(HEAD_SCUL_PTURE, (Object)headPic);
            infoObject.put(NAME_TEXT, (Object)nameText);
            infoList.add(infoObject);
            if (idx >= 1) continue;
            ImageAp image = this.getImageAp("depimg", ++idx, headPic);
            this.getView().updateControlMetadata(image.getKey(), image.createControl());
            this.getModel().setValue("depname" + idx, (Object)nameText);
            supEmpty = true;
        }
        superObject.put(DETAIL_INFO, (Object)infoList);
        if (!CollectionUtils.isEmpty((Collection)infoList)) {
            this.getView().getPageCache().put(SHOW_DEP_INFO, JSON.toJSONString((Object)superObject));
        }
        if (idx < 1) {
            ArrayList<String> list = new ArrayList<String>(16);
            for (int index = idx + 1; index <= 1; ++index) {
                String str = "flexdep" + index;
                list.add(str);
            }
            this.getView().setVisible(Boolean.FALSE, list.toArray(new String[0]));
        }
        return supEmpty;
    }

    private ImageAp getImageAp(String keyPer, int index, String url) {
        ImageAp image = new ImageAp();
        image.setKey(keyPer + index);
        image.setFontSize(0);
        image.setImageKey(url);
        return image;
    }

    private boolean setSuper(Long depId, Map<Long, List<Map<String, Object>>> dirSuperInfoMap, AtomicInteger infoSize) {
        boolean supEmpty = false;
        if (CollectionUtils.isEmpty(dirSuperInfoMap)) {
            return false;
        }
        int idx = 0;
        List<Map<String, Object>> superList = dirSuperInfoMap.get(depId);
        if (CollectionUtils.isEmpty(superList)) {
            return false;
        }
        JSONObject superObject = new JSONObject();
        String title = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"AttFileSummaryPlugin_6", (String)"wtc-wtp-formplugin", (Object[])new Object[0]);
        superObject.put(TITLE_INFO, (Object)title);
        ArrayList infoList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map<String, Object> supMap : superList) {
            String nameText = (String)supMap.get("superior.name");
            if (HRStringUtils.isEmpty((String)nameText)) continue;
            supEmpty = true;
            infoSize.getAndIncrement();
            String headPic = (String)supMap.get("superior.headsculpture");
            headPic = HRStringUtils.isEmpty((String)headPic) ? "/images/pc/emotion/default_person_82_82.png" : ("/images/pc/emotion/default_person_82_82.png".equals(headPic) ? headPic : HRImageUrlUtil.getImageFullUrl((String)headPic));
            JSONObject infoObject = new JSONObject();
            infoObject.put(HEAD_SCUL_PTURE, (Object)headPic);
            infoObject.put(NAME_TEXT, (Object)nameText);
            infoList.add(infoObject);
            if (idx > 1) continue;
            ImageAp image = this.getImageAp("superimg", ++idx, headPic);
            this.getView().updateControlMetadata(image.getKey(), image.createControl());
            this.getModel().setValue("supername" + idx, (Object)nameText);
        }
        superObject.put(DETAIL_INFO, (Object)infoList);
        if (!CollectionUtils.isEmpty((Collection)infoList)) {
            this.getView().getPageCache().put(SHOW_SUPER_INFO, JSON.toJSONString((Object)superObject));
        }
        if (idx < 1) {
            ArrayList<String> list = new ArrayList<String>(16);
            for (int index = idx + 1; index <= 1; ++index) {
                String str = "flexsuper" + index;
                list.add(str);
            }
            this.getView().setVisible(Boolean.FALSE, list.toArray(new String[0]));
        }
        return supEmpty;
    }
}

